<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('es', array (
  'validators' => 
  array (
    'This value should be false.' => 'Este valor debería ser falso.',
    'This value should be true.' => 'Este valor debería ser verdadero.',
    'This value should be of type {{ type }}.' => 'Este valor debería ser de tipo {{ type }}.',
    'This value should be blank.' => 'Este valor debería estar vacío.',
    'The value you selected is not a valid choice.' => 'El valor seleccionado no es una opción válida.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Debe seleccionar al menos {{ limit }} opción.|Debe seleccionar al menos {{ limit }} opciones.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Debe seleccionar como máximo {{ limit }} opción.|Debe seleccionar como máximo {{ limit }} opciones.',
    'One or more of the given values is invalid.' => 'Uno o más de los valores indicados no son válidos.',
    'This field was not expected.' => 'Este campo no se esperaba.',
    'This field is missing.' => 'Este campo está desaparecido.',
    'This value is not a valid date.' => 'Este valor no es una fecha válida.',
    'This value is not a valid datetime.' => 'Este valor no es una fecha y hora válidas.',
    'This value is not a valid email address.' => 'Este valor no es una dirección de email válida.',
    'The file could not be found.' => 'No se pudo encontrar el archivo.',
    'The file is not readable.' => 'No se puede leer el archivo.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'El archivo es demasiado grande ({{ size }} {{ suffix }}). El tamaño máximo permitido es {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'El tipo mime del archivo no es válido ({{ type }}). Los tipos mime válidos son {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Este valor debería ser {{ limit }} o menos.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Este valor es demasiado largo. Debería tener {{ limit }} carácter o menos.|Este valor es demasiado largo. Debería tener {{ limit }} caracteres o menos.',
    'This value should be {{ limit }} or more.' => 'Este valor debería ser {{ limit }} o más.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Este valor es demasiado corto. Debería tener {{ limit }} carácter o más.|Este valor es demasiado corto. Debería tener {{ limit }} caracteres o más.',
    'This value should not be blank.' => 'Este valor no debería estar vacío.',
    'This value should not be null.' => 'Este valor no debería ser nulo.',
    'This value should be null.' => 'Este valor debería ser nulo.',
    'This value is not valid.' => 'Este valor no es válido.',
    'This value is not a valid time.' => 'Este valor no es una hora válida.',
    'This value is not a valid URL.' => 'Este valor no es una URL válida.',
    'The two values should be equal.' => 'Los dos valores deberían ser iguales.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'El archivo es demasiado grande. El tamaño máximo permitido es {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'El archivo es demasiado grande.',
    'The file could not be uploaded.' => 'No se pudo subir el archivo.',
    'This value should be a valid number.' => 'Este valor debería ser un número válido.',
    'This file is not a valid image.' => 'El archivo no es una imagen válida.',
    'This is not a valid IP address.' => 'Esto no es una dirección IP válida.',
    'This value is not a valid language.' => 'Este valor no es un idioma válido.',
    'This value is not a valid locale.' => 'Este valor no es una localización válida.',
    'This value is not a valid country.' => 'Este valor no es un país válido.',
    'This value is already used.' => 'Este valor ya se ha utilizado.',
    'The size of the image could not be detected.' => 'No se pudo determinar el tamaño de la imagen.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'El ancho de la imagen es demasiado grande ({{ width }}px). El ancho máximo permitido es de {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'El ancho de la imagen es demasiado pequeño ({{ width }}px). El ancho mínimo requerido es {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'La altura de la imagen es demasiado grande ({{ height }}px). La altura máxima permitida es de {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'La altura de la imagen es demasiado pequeña ({{ height }}px). La altura mínima requerida es de {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Este valor debería ser la contraseña actual del usuario.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Este valor debería tener exactamente {{ limit }} carácter.|Este valor debería tener exactamente {{ limit }} caracteres.',
    'The file was only partially uploaded.' => 'El archivo fue sólo subido parcialmente.',
    'No file was uploaded.' => 'Ningún archivo fue subido.',
    'No temporary folder was configured in php.ini.' => 'Ninguna carpeta temporal fue configurada en php.ini o la carpeta configurada no existe.',
    'Cannot write temporary file to disk.' => 'No se pudo escribir el archivo temporal en el disco.',
    'A PHP extension caused the upload to fail.' => 'Una extensión de PHP hizo que la subida fallara.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Esta colección debe contener {{ limit }} elemento o más.|Esta colección debe contener {{ limit }} elementos o más.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Esta colección debe contener {{ limit }} elemento o menos.|Esta colección debe contener {{ limit }} elementos o menos.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Esta colección debe contener exactamente {{ limit }} elemento.|Esta colección debe contener exactamente {{ limit }} elementos.',
    'Invalid card number.' => 'Número de tarjeta inválido.',
    'Unsupported card type or invalid card number.' => 'Tipo de tarjeta no soportado o número de tarjeta inválido.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Esto no es un International Bank Account Number (IBAN) válido.',
    'This value is not a valid ISBN-10.' => 'Este valor no es un ISBN-10 válido.',
    'This value is not a valid ISBN-13.' => 'Este valor no es un ISBN-13 válido.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Este valor no es ni un ISBN-10 válido ni un ISBN-13 válido.',
    'This value is not a valid ISSN.' => 'Este valor no es un ISSN válido.',
    'This value is not a valid currency.' => 'Este valor no es una divisa válida.',
    'This value should be equal to {{ compared_value }}.' => 'Este valor debería ser igual que {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Este valor debería ser mayor que {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Este valor debería ser mayor o igual que {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor debería ser idéntico a {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Este valor debería ser menor que {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Este valor debería ser menor o igual que {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Este valor debería ser distinto de {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor no debería ser idéntico a {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'La proporción de la imagen es demasiado grande ({{ ratio }}). La máxima proporción permitida es {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'La proporción de la imagen es demasiado pequeña ({{ ratio }}). La mínima proporción permitida es {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'La imagen es cuadrada ({{ width }}x{{ height }}px). Las imágenes cuadradas no están permitidas.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'La imagen está orientada horizontalmente ({{ width }}x{{ height }}px). Las imágenes orientadas horizontalmente no están permitidas.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'La imagen está orientada verticalmente ({{ width }}x{{ height }}px). Las imágenes orientadas verticalmente no están permitidas.',
    'An empty file is not allowed.' => 'No está permitido un archivo vacío.',
    'The host could not be resolved.' => 'No se puede resolver el host.',
    'This value does not match the expected {{ charset }} charset.' => 'La codificación de caracteres para este valor debería ser {{ charset }}.',
    'This is not a valid Business Identifier Code (BIC).' => 'No es un Código de Identificación Bancaria (BIC) válido.',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'Este valor no es un UUID válido.',
    'This value should be a multiple of {{ compared_value }}.' => 'Este valor debería ser múltiplo de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Este Código de Identificación Bancaria (BIC) no está asociado con el IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Este valor debería ser un JSON válido.',
    'This collection should contain only unique elements.' => 'Esta colección debería tener exclusivamente elementos únicos.',
    'This value should be positive.' => 'Este valor debería ser positivo.',
    'This value should be either positive or zero.' => 'Este valor debería ser positivo o igual a cero.',
    'This value should be negative.' => 'Este valor debería ser negativo.',
    'This value should be either negative or zero.' => 'Este valor debería ser negativo o igual a cero.',
    'This value is not a valid timezone.' => 'Este valor no es una zona horaria válida.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Esta contraseña no se puede utilizar porque está incluida en un listado de contraseñas públicas obtenido gracias a fallos de seguridad de otros sitios y aplicaciones. Por favor utilice otra contraseña.',
    'This value should be between {{ min }} and {{ max }}.' => 'Este valor debería estar entre {{ min }} y {{ max }}.',
    'This value is not a valid hostname.' => 'Este valor no es un nombre de host válido.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'El número de elementos en esta colección debería ser múltiplo de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Este valor debería satisfacer al menos una de las siguientes restricciones:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Cada elemento de esta colección debería satisfacer su propio conjunto de restricciones.',
    'This form should not contain extra fields.' => 'Este formulario no debería contener campos adicionales.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'El archivo subido es demasiado grande. Por favor, suba un archivo más pequeño.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'El token CSRF no es válido. Por favor, pruebe a enviar nuevamente el formulario.',
    'fos_user.username.already_used' => 'El nombre de usuario ya está en uso.',
    'fos_user.username.blank' => 'Por favor, ingrese un nombre de usuario.',
    'fos_user.username.short' => 'El nombre de usuario es demasiado corto.',
    'fos_user.username.long' => 'El nombre de usuario es demasiado largo.',
    'fos_user.email.already_used' => 'El correo electrónico ya está en uso.',
    'fos_user.email.blank' => 'Ingrese un correo electrónico.',
    'fos_user.email.short' => 'El correo electrónico es demasiado corto.',
    'fos_user.email.long' => 'El correo electrónico es demasiado largo.',
    'fos_user.email.invalid' => 'El correo electrónico no es válido.',
    'fos_user.password.blank' => 'Porfavor ingrese una contraseña.',
    'fos_user.password.short' => 'La contraseña es demasiado corta.',
    'fos_user.password.mismatch' => 'Las contraseñas ingresadas no coinciden.',
    'fos_user.new_password.blank' => 'Por favor, ingrese una nueva contraseña.',
    'fos_user.new_password.short' => 'La nueva contraseña es demasiado corta.',
    'fos_user.current_password.invalid' => 'La contraseña ingresada no es válida.',
    'fos_user.group.blank' => 'Por favor, ingrese un nombre.',
    'fos_user.group.short' => 'El nombre es demasiado corto.',
    'fos_user.group.long' => 'El nombre es demasiado largo.',
    'fos_group.name.already_used' => 'El nombre ya está en uso.',
    'This value is not a valid captcha.' => 'El valor del captcha no es válido.',
    'Please enter a message' => 'Por favor ingrese un mensaje',
    'Please enter a permalink' => 'Por favor ingrese un enlace permanente',
    'Please enter an id' => 'Por favor ingrese una identificación',
    'Please provide a valid url' => 'Proporcione una URL válida',
    'The file should be an image' => 'El archivo debe ser una imagen',
    'The message is too short|The message is too short' => 'El mensaje es demasiado corto|El mensaje es demasiado corto',
    'The password fields must match.' => 'Los campos de la contraseña deben coincidir.',
    'You must set the default locale at least for the translation fields' => 'Debe establecer la configuración regional predeterminada al menos para los campos de traducción',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Ocurrió un error de autenticación.',
    'Authentication credentials could not be found.' => 'No se encontraron las credenciales de autenticación.',
    'Authentication request could not be processed due to a system problem.' => 'La solicitud de autenticación no se pudo procesar debido a un problema del sistema.',
    'Invalid credentials.' => 'Credenciales no válidas.',
    'Cookie has already been used by someone else.' => 'La cookie ya ha sido usada por otra persona.',
    'Not privileged to request the resource.' => 'No tiene privilegios para solicitar el recurso.',
    'Invalid CSRF token.' => 'Token CSRF no válido.',
    'No authentication provider found to support the authentication token.' => 'No se encontró un proveedor de autenticación que soporte el token de autenticación.',
    'No session available, it either timed out or cookies are not enabled.' => 'No hay ninguna sesión disponible, ha expirado o las cookies no están habilitados.',
    'No token could be found.' => 'No se encontró ningún token.',
    'Username could not be found.' => 'No se encontró el nombre de usuario.',
    'Account has expired.' => 'La cuenta ha expirado.',
    'Credentials have expired.' => 'Las credenciales han expirado.',
    'Account is disabled.' => 'La cuenta está deshabilitada.',
    'Account is locked.' => 'La cuenta está bloqueada.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Anterior',
    'label_next' => 'Siguiente',
  ),
  'VichUploaderBundle' => 
  array (
    'download' => 'Descargar',
    'form.label.delete' => '¿Eliminar?',
  ),
  'FOSUserBundle' => 
  array (
    'group.edit.submit' => 'Actualizar grupo',
    'group.show.name' => 'Nombre de grupo',
    'group.new.submit' => 'Crear grupo',
    'group.flash.updated' => 'El grupo ha sido actualizado.',
    'group.flash.created' => 'El grupo ha sido creado.',
    'group.flash.deleted' => 'El grupo ha sido borrado.',
    'security.login.username' => 'Nombre de usuario',
    'security.login.password' => 'Contraseña',
    'security.login.remember_me' => 'Recuérdame',
    'security.login.submit' => 'Entrar',
    'profile.show.username' => 'Nombre de usuario',
    'profile.show.email' => 'Email',
    'profile.edit.submit' => 'Actualizar usuario',
    'profile.flash.updated' => 'El perfil ha sido actualizado.',
    'change_password.submit' => 'Cambia la contraseña',
    'change_password.flash.success' => 'La contraseña se ha cambiado con éxito.',
    'registration.check_email' => 'Se ha enviado un correo electrónico a %email%. Contiene un enlace de activación en el que debe hacer clic para activar su cuenta.',
    'registration.confirmed' => 'Felicidades %username%, su cuenta ahora está activada.',
    'registration.back' => 'Volver a la página de origen.',
    'registration.submit' => 'Registrar',
    'registration.flash.user_created' => 'El usuario se ha creado satisfactoriamente.',
    'registration.email.subject' => '¡Bienvenido %username%!',
    'registration.email.message' => '¡Hola, %username%!

                    Para finalizar la activación de su cuenta, haga clic en el siguiente enlace %confirmationUrl%

                    Este enlace solo se puede utilizar una vez para validar su cuenta.

                    Saludos,
                    el equipo.',
    'resetting.check_email' => 'Un correo electronico ha sido enviado. Contiene un enlace en el que debe hacer clic para restablecer su contraseña.
                    Nota: Solo puede solicitar una nueva contraseña una vez dentro de %tokenLifetime% horas.

                    Si no recibe un correo electrónico, revise su carpeta de correo no deseado o vuelva a intentarlo.',
    'resetting.request.username' => 'Nombre de usuario o dirección de correo electrónico',
    'resetting.request.submit' => 'Restablecer la contraseña',
    'resetting.reset.submit' => 'Cambia la contraseña',
    'resetting.flash.success' => 'La contraseña se ha cambiado con éxito.',
    'resetting.email.subject' => 'Restablecer la contraseña',
    'resetting.email.message' => '¡Hola, %username%!

                    Para restablecer su contraseña, visite %confirmationUrl%

                    Saludos,
                    el equipo.',
    'layout.logout' => 'Salir',
    'layout.login' => 'Entrar',
    'layout.register' => 'Registrar',
    'layout.logged_in_as' => 'Identificado como %username%',
    'form.group_name' => 'Nombre de grupo',
    'form.username' => 'Nombre de usuario',
    'form.email' => 'Email',
    'form.current_password' => 'Contraseña actual',
    'form.password' => 'Contraseña',
    'form.password_confirmation' => 'Repita la contraseña',
    'form.new_password' => 'Nueva contraseña',
    'form.new_password_confirmation' => 'Repita la contraseña',
    'Password' => 'Contraseña',
    'Privacy policy' => 'Política de privacidad',
    'Terms of service' => 'Términos de servicio',
    'Welcome' => 'Bienvenidos',
  ),
  'HWIOAuthBundle' => 
  array (
    'header.connecting' => 'Conectando',
    'header.success' => 'Cuenta \'%name%\' conectada con éxito!',
    'header.register' => 'Registrarse con la cuenta \'%name%\'',
    'header.registration_success' => 'Se ha registrado y conectado la cuenta \'%username%\' con éxito!',
    'connect.confirm.cancel' => 'Cancelar',
    'connect.confirm.submit' => 'Conectar cuenta',
    'connect.confirm.text' => '¿Está seguro de que desea conectar su cuenta de %service% \'%name%\' con su cuenta actual?',
    'connect.registration.cancel' => 'Cancelar',
    'connect.registration.submit' => 'Registrar cuenta',
  ),
  'time' => 
  array (
    'diff.ago.year' => 'hace 1 año|hace %count% años',
    'diff.ago.month' => 'hace 1 mes|hace %count% meses',
    'diff.ago.day' => 'hace 1 día|hace %count% días',
    'diff.ago.hour' => 'hace 1 hora|hace %count% horas',
    'diff.ago.minute' => 'hace 1 minuto|hace %count% minutos',
    'diff.ago.second' => 'hace 1 segundo|hace %count% segundos',
    'diff.empty' => 'ahora',
    'diff.in.second' => 'en 1 segundo|en %count% segundos',
    'diff.in.hour' => 'en 1 hora|en %count% horas',
    'diff.in.minute' => 'en 1 minuto|en %count% minutos',
    'diff.in.day' => 'en 1 día|en %count% días',
    'diff.in.month' => 'en 1 mes|en %count% meses',
    'diff.in.year' => 'en 1 año|en %count% años',
  ),
  'FOSCommentBundle' => 
  array (
    'fos_comment_comment_new_headline_first' => 'Titular',
    'fos_comment_comment_new_headline' => 'Titular',
    'fos_comment_comment_new_submit' => 'Enviar',
    'fos_comment_comment_new_cancel' => 'Cancelar',
    'fos_comment_comment_edit_submit' => 'Enviar',
    'fos_comment_comment_edit_cancel' => 'Cancelar',
    'fos_comment_comment_reply_reply_to' => 'Respuesta',
    'fos_comment_comment_reply_cancel' => 'Cancelar',
    'fos_comment_comment_show_by' => 'Por',
    'fos_comment_comment_show_voteup' => 'Me gusta',
    'fos_comment_comment_show_votedown' => 'No me gusta',
    'fos_comment_comment_show_reply' => 'Mostrar respuesta',
    'fos_comment_comment_vote_score' => 'Puntuación de voto',
    'fos_comment_comment_tree_load_more' => 'Cargar más respuestas',
    'fos_comment_thread_close' => 'Cerrar hilo',
    'fos_comment_thread_open' => 'Abrir hilo',
    'fos_comment_thread_comment_count' => 'Recuento de comentarios',
    'fos_comment_comment_edit' => 'Editar',
    'fos_comment_comment_delete' => 'Eliminar',
    'fos_comment_comment_undelete' => 'Recuperar',
    'fos_comment_comment_deleted' => 'Eliminado',
    'fos_comment_rss_feed' => 'Feed RSS',
  ),
  'messages' => 
  array (
    'coresphere_console.headline.index' => 'Consola',
    'coresphere_console.working_directory' => 'Directorio de trabajo',
    'coresphere_console.environment' => 'Entorno',
    'coresphere_console.welcome_message' => 'Escriba %command% para obtener una lista de los comandos.',
    'coresphere_console.loading' => 'Cargando...',
    'coresphere_console.suggestion_head' => 'Quieres decir:',
    'coresphere_console.empty_response' => 'Terminado!',
    '%cartElementsCount% event(s) currently in cart' => '%cartElementsCount% evento(s) actualmente en el carrito',
    '%mins% left before tickets are released' => 'Quedan %mins% antes de que se publiquen las entradas',
    '%resultsCount% attendee(s) found' => '%resultsCount% asistente(s) encontrado(s)',
    '%resultsCount% event date(s) found' => '%resultsCount% fecha(s) del evento encontradas',
    '%resultsCount% event(s)' => '%resultsCount% evento(s)',
    '%resultsCount% event(s) currently on sale' => '%resultsCount% evento(s) actualmente en venta',
    '%resultsCount% event(s) found' => '%resultsCount% evento(s) encontrado(s)',
    '%resultsCount% post(s) found' => '%resultsCount% publicación(s) encontradas',
    '%resultsCount% result(s) found' => '%resultsCount% resultado(s) encontrado(s)',
    '%resultsCount% reviews(s) found' => '%resultsCount% opiniones encontradas',
    '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets' => '%tickets% ticket(s) todavía están reservados para usted, espere hasta que la reserva caduque en %expirationDate% para comprar más entradas',
    '%websiteName% is undergoing a scheduled maintenance.' => '%websiteName% está en mantenimiento programado.',
    1 => '1',
    '1 star' => '1 star',
    10 => '10',
    11 => '11',
    12 => '12',
    13 => '13',
    14 => '14',
    15 => '15',
    2 => '2',
    '2 stars' => '2 estrellas',
    3 => '3',
    '3 stars' => '3 estrellas',
    4 => '4',
    '4 stars' => '4 estrellas',
    5 => '5',
    '5 stars' => '5 estrellas',
    6 => '6',
    7 => '7',
    8 => '8',
    9 => '9',
    'A payout can not be requested on a free event date' => 'No se puede solicitar un pago en una fecha de evento gratuita',
    'A payout is already requested for this event date' => 'Ya se solicitó un pago para esta fecha de evento',
    'About the organizer' => 'Sobre el organizador',
    'About us' => 'Sobre nosotros',
    'Absatz' => 'Absatz',
    'Access denied' => 'Acceso denegado',
    'Access granted' => 'Acceso permitido',
    'Access is denied. You may not have the appropriate permissions to access this resource.' => 'Acceso denegado. Es posible que no tenga los permisos adecuados para acceder a este recurso.',
    'Account' => 'Cuenta',
    'Account information' => 'Información de la cuenta',
    'Account settings' => 'Configuraciones de la cuenta',
    'Account status' => 'Estado de la cuenta',
    'Actions' => 'Comportamiento',
    'Active attendees' => 'Asistentes activos',
    'Active organizers' => 'Organizadores activos',
    'Add a blog post' => 'Agregar una publicación de blog',
    'Add a help center article' => 'Agregar un artículo del centro de ayuda',
    'Add a new amenity' => 'Agregar una nueva amenidad',
    'Add a new audience' => 'Agregar una nueva audiencia',
    'Add a new blog post' => 'Agregar una nueva publicación de blog',
    'Add a new blog post category' => 'Agregar una nueva categoría de publicación de blog',
    'Add a new category' => 'Agregar una nueva categoría',
    'Add a new country' => 'Agregar un nuevo país',
    'Add a new currency' => 'Agregar una nueva moneda',
    'Add a new event' => 'Agregar un evento nuevo',
    'Add a new help center article' => 'Agregar un nuevo artículo del centro de ayuda',
    'Add a new help center category' => 'Agregar una nueva categoría del centro de ayuda',
    'Add a new language' => 'Agregar un nuevo idioma',
    'Add a new page' => 'Agregar una nueva página',
    'Add a new payment gateway' => 'Agregar una nueva pasarela de pago',
    'Add a new point of sale' => 'Agregar un nuevo punto de venta',
    'Add a new scanner' => 'Agregar un nuevo escáner',
    'Add a new venue' => 'Agregar un nuevo lugar',
    'Add a new venue type' => 'Agregar un nuevo tipo de lugar',
    'Add events to your favorites by clicking the heart button' => 'Agrega eventos a tus favoritos haciendo clic en el botón del corazón',
    'Add other images that represent your event to be displayed as a gallery' => 'Agregue otras imágenes que representen su evento para mostrarlas como una galería',
    'Add to calendar' => 'Añadir al calendario',
    'Add to cart' => 'Añadir al carrito',
    'Add to favorites' => 'Agregar a los favoritos',
    'Add your review' => 'Añadir tu reseña',
    'Add your review for %eventname%' => 'Agregue su opinión sobre %eventname%',
    'Added to favorites by' => 'Añadido a favoritos po',
    'Additional note' => 'Nota adicional',
    'Address' => 'Localización',
    'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment' => 'Después de editar un mensaje de traducción, vaya a la página de la Consola y ejecute el siguiente comando: cache:clear --env=prod para aplicar los cambios en el entorno de producción',
    'All' => 'Todas',
    'All categories' => 'Todas las categorias',
    'All event dates for an organizer' => 'Todas las fechas del evento para un organizador',
    'All orders for an organizer' => 'Todos los pedidos para un organizador',
    'All payout requests for an organizer' => 'Todas las solicitudes de pago para un organizador',
    'Allow Paypal as a payout method for the organizers to receive their revenue' => 'Permita que Paypal sea un método de pago para que los organizadores reciban sus ingresos',
    'Allow Stripe as a payout method for the organizers to receive their revenue' => 'Permitir Stripe como método de pago para que los organizadores reciban sus ingresos',
    'Allow attendees to leave reviews' => 'Permitir a los asistentes dejar comentarios',
    'Allow tap to check in on the scanner app' => 'Permita que toque para registrarse en la aplicación del escáner',
    'Already have an account?' => '¿Ya tienes una cuenta?',
    'Alternative date and time format' => 'Formato alternativo de fecha y hora',
    'Amenities' => 'Comodidades',
    'Amount' => 'Cantidad',
    'An error has occured' => 'Se ha producido un error',
    'An error has occured while processing your request' => 'Ha ocurrido un error al procesar su solicitud',
    'An error might occur if the command execution time reaches your PHP max_execution_time directive' => 'Puede ocurrir un error si el tiempo de ejecución del comando alcanza su directiva PHP max_execution_time',
    'Anweisungen' => 'Anweisungen',
    'Anything' => 'Cualquier cosa',
    'Anytime' => 'En cualquier momento',
    'Anywhere' => 'En cualquier sitio',
    'App Debugging' => 'Depuración de aplicaciones',
    'App Environment' => 'Entorno de la aplicación',
    'App Secret' => 'App secreta',
    'Application layout' => 'Diseño de la aplicación',
    'Application theme' => 'Tema de la aplicación',
    'Approve' => 'Aprobar',
    'Approved' => 'Aprobado',
    'Are you ready to take your' => '¿Estás listo para llevar tu',
    'Article details' => 'Detalles del artículo',
    'Articles' => 'Artículos',
    'Articles count' => 'Cantidad de artículos',
    'Artists' => 'Artistas',
    'Assigned events' => 'Eventos asignados',
    'Attendance' => 'Asistencia',
    'Attendee' => 'Asistente',
    'Attendee / POS' => 'Asistente / punto de venta',
    'Attendee Name / Email' => 'Nombre / correo electrónico del asistente',
    'Attendee Registration' => 'Registro de asistentes',
    'Attendee information' => 'Información de los asistentes',
    'Attendee name or email, ticket reference, order reference' => 'Nombre o correo electrónico del asistente, referencia de entrada, referencia de pedido',
    'Attendee status' => 'Estado del asistente',
    'Attendee tickets' => 'Entradas para asistentes',
    'Attendees' => 'Asistentes',
    'Attendees Check In' => 'Registro de asistentes',
    'Attendees check-in' => 'Registro de asistentes',
    'Attendees list' => 'Lista de asistentes',
    'Attendees reviews' => 'Opiniones de los asistentes',
    'Attendees summary' => 'Resumen de los asistentes',
    'Audience' => 'Audiencia',
    'Audiences' => 'Audiencias',
    'Authentification Pages' => 'Páginas de autenticación',
    'Authorized' => 'Autorizado',
    'Automatically canceled before deletion' => 'Cancelado automáticamente antes de la eliminación',
    'Availability' => 'Disponibilidad',
    'Available languages' => 'Idiomas Disponibles',
    'Availibility' => 'Disponibilidad',
    'Avatar' => 'Avatar',
    'Awaiting payment' => 'En espera de pago',
    'Beschreibung' => 'Beschreibung',
    'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button' => 'Además de la función de escaneo de código qr, la cuenta del escáner podrá registrar a los asistentes usando una lista y un botón',
    'Best regards, the %website_name% team' => 'Saludos cordiales, el equipo de %website_name%',
    'Billing information' => 'Datos de facturación',
    'Birthdate' => 'Fecha de nacimiento',
    'Blog' => 'Blog',
    'Blog Pages' => 'Páginas de Blog',
    'Blog page' => 'Página del blog',
    'Blog post' => 'Entrada en el blog',
    'Blog posts count' => 'Las publicaciones del blog cuentan',
    'Blog settings' => 'Configuración del blog',
    'Bought on' => 'Comprado en',
    'Bought tickets' => 'Entradas compradas',
    'Browse events' => 'Explorar eventos',
    'Buy more tickets' => 'Compra más entradas',
    'Buy tickets' => 'Comprar entradas',
    'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.' => 'Al hacer clic en enviar, se enviará un correo electrónico a la dirección de correo electrónico elegida. Asegúrese de guardar la configuración que se probará antes de realizar la prueba.',
    'By clicking the Sign Up button, I agree to' => 'Al hacer clic en el botón Registrarse, acepto',
    'CCY' => 'CCY',
    'Cancel' => 'Cancelar',
    'Canceled' => 'Cancelado',
    'Captured' => 'Capturado',
    'Cart' => 'Carro',
    'Cart elements' => 'Elementos del carrito',
    'Cash / Check / Bank Transfer / Other' => 'Efectivo / Cheque / Transferencia Bancaria / Otra',
    'Cash / Check / Offline' => 'Efectivo / Cheque / Fuera de línea',
    'Categories' => 'Categorías',
    'Categories page' => 'Página de categorías',
    'Category' => 'Categoría',
    'Ccy' => 'Ccy',
    'Change password' => 'Cambia la contraseña',
    'Check In' => 'Registrarse',
    'Check In Attendees for this event date' => 'Registrar asistentes para esta fecha del evento',
    'Check your email inbox' => 'Revise su bandeja de entrada de correo electrónico',
    'Checked In At' => 'Registrado en',
    'Checked In Only' => 'Solo registrado',
    'Checkout' => 'Revisa',
    'Checkout settings' => 'Configuración de pago',
    'Choose a payment gateway' => 'Elija una pasarela de pago',
    'Choose the link destination page' => 'Elija la página de destino del enlace',
    'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )' => 'Elija la imagen correcta para representar su evento (recomendamos usar al menos una imagen de 1200x600px (proporción 2: 1))',
    'City' => 'Ciudad',
    'Clear the application cache for the development environment' => 'Limpiar la caché de la aplicación para el entorno de desarrollo',
    'Clear the application cache for the production environment' => 'Borrar la caché de la aplicación para el entorno de producción',
    'Click here' => 'haga clic aquí',
    'Click on a date to view tickets' => 'Haga clic en una fecha para ver las entradas',
    'Close' => 'Cerca',
    'Compact' => 'Compacto',
    'Confirm account' => 'Confirmar cuenta',
    'Confirm payment and place order' => 'Confirmar pago y realizar pedido',
    'Confirm payout request' => 'Confirmar solicitud de pago',
    'Contact' => 'Contacto',
    'Contact & Social media' => 'Contacto y redes sociales',
    'Contact Us' => 'Contacta con nosotros',
    'Contact address' => 'Dirección de contacto',
    'Contact email' => 'Email de contacto',
    'Contact email address' => 'Correo electrónico de contacto',
    'Contact fax' => 'Fax de contacto',
    'Contact information' => 'Información del contacto',
    'Contact phone' => 'Teléfono de contacto',
    'Contact phone number' => 'Teléfono de contacto',
    'Contact the attendee' => 'Contactar al asistente',
    'Contact the organizer' => 'Contacta con el organizador',
    'Contact us' => 'Contacta con nosotros',
    'Contenido' => 'Contenido',
    'Content' => 'Content',
    'Contente' => 'Contente',
    'Contenu' => 'Contenu',
    'Cookie policy' => 'Cookie policy',
    'Cookie policy page slug' => 'Política de cookies página slug',
    'Copyright' => 'Derechos de autor',
    'Count' => 'Contar',
    'Countries' => 'Países',
    'Country' => 'País',
    'Country code' => 'Código de país',
    'Cover photo' => 'Foto de cubierta',
    'Cover picture' => 'Imagen de portada',
    'Create Account' => 'Crear una cuenta',
    'Create event' => 'Crear evento',
    'Create my event' => 'Crear mi evento',
    'Created by organizer' => 'Creado por el organizador',
    'Creation date' => 'Fecha de creación',
    'Creation date / Last login' => 'Fecha de creación / último inicio de sesión',
    'Credit or debit card' => 'Tarjeta de crédito o débito',
    'Currency' => 'Moneda',
    'Currency symbol' => 'Símbolo de moneda',
    'Currency symbol position' => 'Posición del símbolo de moneda',
    'Currently in cart' => 'Actualmente en carrito',
    'Custom css' => 'CSS personalizado',
    'Custom hero' => 'Héroe personalizado',
    'Custom hero background image' => 'Imagen de fondo de héroe personalizada',
    'Custom hero title and paragraph translation' => 'Traducción personalizada de títulos y párrafos de héroes',
    'Custom link' => 'Vínculo personalizado',
    'Dark' => 'Oscuro',
    'Dark blue' => 'Azul oscuro',
    'Dashboard' => 'Tablero',
    'Dashboard Pages' => 'Páginas del tablero',
    'Date' => 'Fecha',
    'Date and time format' => 'Formato de fecha y hora',
    'Date only format' => 'Formato de solo fecha',
    'Dates' => 'Fechas',
    'Default language' => 'Idioma predeterminado',
    'Delete' => 'Eliminar',
    'Delete permanently' => 'Borrar permanentemente',
    'Deleted' => 'Eliminado',
    'Deletion date' => 'Fecha de borrado',
    'Descripción' => 'Descripción',
    'Description' => 'Descripción',
    'Descrição' => 'Descrição',
    'Details' => 'Detalles',
    'Development' => 'Desarrollo',
    'Development environment is used for development purposes only' => 'El entorno de desarrollo se utiliza solo con fines de desarrollo',
    'Disable' => 'Inhabilitar',
    'Disabled' => 'Discapacitado',
    'Disabled only' => 'Solo discapacitados',
    'Display itinerary bicycling' => 'Mostrar itinerario en bicicleta',
    'Display itinerary driving' => 'Mostrar itinerario de conducción',
    'Display itinerary on public transportation' => 'Mostrar itinerario en transporte público',
    'Display itinerary walking' => 'Mostrar itinerario caminando',
    'Display top 4 featured categories (footer section menu only)' => 'Mostrar las 4 categorías destacadas principales (solo en el menú de la sección de pie de página)',
    'Disqus comments' => 'Comentarios de Disqus',
    'Disqus subdomain' => 'Subdominio Disqus',
    'Draft' => 'Sequía',
    'Draft only' => 'Solo borrador',
    'Early bird, General admission, VIP...' => 'Reserva anticipada, Entrada general, VIP .',
    'Edit' => 'Editar',
    'Edit the menu' => 'Editar el menú',
    'Edit your organizer profile' => 'Edita tu perfil de organizador',
    'Editing the title after the event is saved won\'t change the event url' => 'Editar el título después de guardar el evento no cambiará la URL del evento.',
    'Elapsed only' => 'Solo transcurrido',
    'Elements' => 'Elementos',
    'Email' => 'Dirección de correo electrónico',
    'Email address' => 'Dirección de correo electrónico',
    'Empty cart' => 'Carro vacio',
    'En cabeza' => 'En cabeza',
    'En-tête' => 'En-tête',
    'Enable' => 'Habilitar',
    'Enable Facebook Social Login' => 'Habilitar el inicio de sesión social de Facebook',
    'Enable Google Repatcha' => 'Habilitar Google Recaptcha',
    'Enable Google Social Login' => 'Habilitar el inicio de sesión social de Google',
    'Enable comments' => 'Habilitar comentarios',
    'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file' => 'Habilite el modo de mantenimiento para mostrar una página de mantenimiento para todos los usuarios, excepto para los usuarios a los que se les otorgó el rol ROLE_ADMINISTRATOR, si perdió su sesión, puede editar el parámetro MAINTENANCE_MODE directamente en el archivo .env',
    'Enable newsletter' => 'Habilitar boletín',
    'Enable reviews' => 'Habilitar revisiones',
    'Enable sales for this event date ?' => '¿Habilitar ventas para esta fecha de evento?',
    'Enable sales for this ticket ?' => '¿Habilitar ventas para este entrada?',
    'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request' => 'Habilite para mostrar trazas de pila en páginas de error o si los archivos de caché deben reconstruirse dinámicamente en cada solicitud',
    'Enabled' => 'Habilitado',
    'Enabled only' => 'Solo habilitado',
    'Enabling sales for an event date does not affect the tickets individual sale status' => 'Habilitar las ventas para una fecha de evento no afecta el estado de venta individual de las entradas',
    'Encryption' => 'Cifrado',
    'End date' => 'Fecha final',
    'Ends On' => 'Termina el',
    'Enlarge' => 'Agrandar',
    'Enter the chosen primary color code (i.e #ffffff)' => 'Ingrese el código de color primario elegido (es decir, #ffffff)',
    'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)' => 'Ingrese el nombre del sitio web elegido sin espacios ni caracteres en mayúscula (para fines de SEO)',
    'Enter the email address to be reached for inquiries' => 'Ingrese la dirección de correo electrónico para ser contactado para consultas',
    'Enter the full website url' => 'Ingrese la URL completa del sitio web',
    'Enter the list of artists that will perform in your event (press Enter after each entry)' => 'Ingrese la lista de artistas que actuarán en su evento (presione Enter después de cada entrada)',
    'Enter the phone number to be called for inquiries' => 'Ingrese el número de teléfono al que se llamará para consultas',
    'Enter the website url without http nor https' => 'Ingrese la URL del sitio web sin http o https',
    'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Ingrese la URL del sitio web sin http ni https, asegúrese de cambiar este parámetro también en el archivo .env en la carpeta raíz del proyecto, ya que se requiere en algún paquete externo',
    'Error' => 'Error',
    'Event' => 'Evento',
    'Event / Ticket' => 'Evento / Entrada',
    'Event Categories' => 'Categorías de eventos',
    'Event already started' => 'El evento ya comenzó',
    'Event categories' => 'Categorías de eventos',
    'Event date' => 'Fecha del evento',
    'Event date is disabled' => 'La fecha del evento está deshabilitada',
    'Event dates' => 'Fechas de eventos',
    'Event details' => 'Detalles del evento',
    'Event is not published' => 'El evento no está publicado',
    'Event list' => 'Lista de eventos',
    'Event ticket' => 'Entrada de evento',
    'Event ticket is disabled' => 'La entrada del evento está deshabilitada',
    'Event tickets' => 'Entradas para eventos',
    'Event views' => 'Vistas de eventos',
    'Events' => 'Eventos',
    'Events Pages' => 'Páginas de eventos',
    'Events RSS feed' => 'RSS de eventos',
    'Events added' => 'Eventos agregados',
    'Events count' => 'Recuento de eventos',
    'Events in %countryname%' => 'Eventos en %countryname%',
    'Events list' => 'Lista de eventos',
    'Events list page' => 'Página de lista de eventos',
    'Events list page settings' => 'Configuración de la página de lista de eventos',
    'Events on sale' => 'Eventos a la venta',
    'Events page' => 'Página de eventos',
    'Events slider' => 'Control deslizante de eventos',
    'Events summary' => 'Resumen de eventos',
    'Execute Symfony commands' => 'Ejecutar comandos de Symfony',
    'Execute command' => 'Ejecutar comando',
    'Execute this command after editing a file in the application source code or after modifying a string in the translations files' => 'Ejecute este comando después de editar un archivo en el código fuente de la aplicación o después de modificar una cadena en los archivos de traducción.',
    'Execute this command if you are in the development mode and the modifications you applied in the application did take effect' => 'Ejecute este comando si está en el modo de desarrollo y las modificaciones que aplicó en la aplicación entraron en vigor',
    'Export attendees list to a PDF file' => 'Exportar la lista de asistentes a un archivo PDF',
    'Export current orders to a CSV file' => 'Exportar pedidos actuales a un archivo CSV',
    'Export current orders to an Excel file' => 'Exportar pedidos actuales a un archivo de Excel',
    'External link' => 'Enlace externo',
    'FAQ' => 'Preguntas más frecuentes',
    'Facebook' => 'Facebook',
    'Facebook Id' => 'Facebook Id',
    'Facebook Secret' => 'Secreto de Facebook',
    'Facebook app id' => 'Facebook app id',
    'Facebook comments' => 'Comentarios de Facebook',
    'Facebook profile picture' => 'Foto de perfil de Facebook',
    'Facebook url' => 'Facebook url',
    'Failed' => 'Fallido',
    'Favicon' => 'Favicon',
    'Favorites' => 'Favoritos',
    'Fax' => 'Fax',
    'Featured' => 'Destacados',
    'Featured categories' => 'Categorías Destacadas',
    'Featured only' => 'Solo destacado',
    'Featured order' => 'Orden destacado',
    'Fees' => 'Tarifa',
    'First Name' => 'Primer nombre',
    'First name' => 'Primer nombre',
    'Flag' => 'Bandera',
    'Fluid' => 'Fluido',
    'Follow' => 'Seguir',
    'Followed by' => 'Seguido por',
    'Followers' => 'Seguidores',
    'Following' => 'Siguiendo',
    'Food and beverage' => 'Alimentos y bebidas',
    'Food and beverage details' => 'Detalles de alimentos y bebidas',
    'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it' => 'Para \'Efectivo / Cheque / Transferencia bancaria / Otro\', el pedido permanecerá en el estado \'En espera de pago\' hasta que el organizador o el administrador lo apruebe',
    'Forbidden' => 'Prohibido',
    'Forgot your password ?' => 'Olvidaste tu contraseña ?',
    'Free' => 'Gratis',
    'Free events only' => 'Solo eventos gratuitos',
    'From date' => 'Partir de la fecha',
    'Full name' => 'Nombre completo',
    'GDPR compliance' => 'Cumplimiento de GDPR',
    'Gallery' => 'Galería',
    'Gallery image' => 'Imagen de la galería',
    'Gdpr compliance page slug' => 'Slug de página de cumplimiento de gdpr',
    'Gender' => 'Género',
    'General information' => 'Información general',
    'Generation date' => 'Fecha de generación',
    'Global payment settings' => 'Configuración de pago global',
    'Gmail' => 'Gmail',
    'Go back' => 'Regresa',
    'Go to the Pages section in the settings to add a new page' => 'Vaya a la sección Páginas en la configuración para agregar una nueva página',
    'Go to the documentation to get help about getting a list id' => 'Vaya a la documentación para obtener ayuda sobre cómo obtener una identificación de lista',
    'Go to the documentation to get help about getting an api key' => 'Vaya a la documentación para obtener ayuda sobre cómo obtener una clave de API',
    'Go to the documentation to get help about getting an app ID' => 'Vaya a la documentación para obtener ayuda sobre cómo obtener un ID de aplicación',
    'Go to the documentation to get help about setting up Disqus' => 'Vaya a la documentación para obtener ayuda sobre cómo configurar Disqus',
    'Google Id' => 'Google Id',
    'Google Maps' => 'Google Maps',
    'Google Maps Api Key' => 'Google Maps Api Key',
    'Google Maps settings' => 'Configuración de mapas de Google',
    'Google Plus' => 'Google Plus',
    'Google Recaptcha' => 'Google Recaptcha',
    'Google Recaptcha settings' => 'Configuración de Google Recaptcha',
    'Google Secret' => 'Google Secret',
    'Google analytics Tracking ID' => 'Google analytics Tracking ID',
    'Google plus' => 'Google plus',
    'Green' => 'Verde',
    'Gross Sales' => 'Ventas brutas',
    'Gross sales' => 'Ventas brutas',
    'Gross sales by channel' => 'Ventas brutas por canal',
    'Gross sales per Point of sale' => 'Ventas brutas por punto de venta',
    'Guests' => 'Invitados',
    'Header' => 'Encabezamiento',
    'Header text' => 'Texto de cabecera',
    'Help Center Article' => 'Artículo del Centro de ayuda',
    'Help Center Category' => 'Categoría del Centro de ayuda',
    'Help Center Pages' => 'Páginas del Centro de ayuda',
    'Help Center page' => 'Página del Centro de ayuda',
    'Help center' => 'Centro de ayuda',
    'Here are the details' => 'Aquí están los detalles',
    'Hey' => 'Hola',
    'Hidden' => 'Oculto',
    'Hidden only' => 'Solo oculto',
    'Hide' => 'Esconder',
    'Hide from public directory' => 'Ocultar del directorio público',
    'Hide slider' => 'Ocultar control deslizante',
    'Homepage' => 'Página principal',
    'Homepage settings' => 'Configuración de la página de inicio',
    'Host' => 'Anfitrión',
    'How can we help?' => '¿Cómo podemos ayudar?',
    'Icon' => 'Icono',
    'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M' => 'Si tiene un video de Youtube que representa su evento, agréguelo en el formato estándar: https://www.youtube.com/watch?v=FzG4uDgje3M',
    'If you need to send the confirmation email to a different email address, you can change it before submitting' => 'Si necesita enviar el correo electrónico de confirmación a una dirección de correo electrónico diferente, puede cambiarlo antes de enviarlo.',
    'If your event has a dedicated website, enter its url here' => 'Si su evento tiene un sitio web dedicado, ingrese su URL aquí',
    'If your event is a movie for example, select the available subtitles' => 'Si su evento es una película, por ejemplo, seleccione los subtítulos disponibles',
    'If your event is a movie for example, select the year of release' => 'Si su evento es una película, por ejemplo, seleccione el año de lanzamiento.',
    'Image' => 'Imagen',
    'Images' => 'Imagenes',
    'Images gallery' => 'Galería de imágenes',
    'Impersonate' => 'Iniciar sesión como',
    'In' => 'En',
    'In deinen Gedanken' => 'In deinen Gedanken',
    'Information not provided' => 'Información no proporcionada',
    'Information provided' => 'Información proporcionada',
    'Inhalt' => 'Inhalt',
    'Instagram' => 'Instagram',
    'Instagram url' => 'URL de Instagram',
    'Instrucciones' => 'Instrucciones',
    'Instructions' => 'Instrucciones',
    'Instruções' => 'Instruções',
    'Invalid credentials' => 'Credenciales no válidas',
    'Is featured' => 'Es destacado',
    'Is featured on the homepage slider?' => '¿Aparece en el control deslizante de la página de inicio?',
    'Is this event date online ?' => '¿Está la fecha del evento en línea?',
    'Is this ticket free ?' => '¿Este entrada es gratis?',
    'Keyword' => 'Palabra clave',
    'Language' => 'Idioma',
    'Language code' => 'Código de lenguaje',
    'Languages' => 'Idiomas',
    'Last Name' => 'Apellido',
    'Last login' => 'Último acceso',
    'Last name' => 'Apellido',
    'Last updated' => 'Última actualización',
    'Lastest blog posts' => 'Últimas publicaciones de blog',
    'Layout settings' => 'Opciones de diseño',
    'Layout, parameters and SEO' => 'Diseño, parámetros y SEO',
    'Leave a review' => 'Dejar un comentario',
    'Leave api key empty to disable google maps project wide' => 'Deje la clave api vacía para deshabilitar el proyecto de Google Maps en todo el proyecto',
    'Leave the password empty to keep the old one' => 'Deje la contraseña vacía para mantener la anterior',
    'Left' => 'Izquierdo',
    'Let the other attendee know more details about your experience' => 'Deja que el otro asistente conozca más detalles sobre tu experiencia.',
    'Light blue' => 'Azul claro',
    'Link' => 'Enlace',
    'Link Text' => 'Link Text',
    'Link text' => 'Texto del enlace',
    'LinkedIn' => 'LinkedIn',
    'Linkedin' => 'Linkedin',
    'List on public directory' => 'Incluido en el directorio público',
    'Listed on directory' => 'Incluido en el directorio',
    'Listed on the directory' => 'Incluido en el directorio',
    'Local events only' => 'Solo eventos locales',
    'Location' => 'Ubicación',
    'Locked (Payout request approved)' => 'Bloqueado (solicitud de pago aprobada)',
    'Locked (Payout request pending)' => 'Bloqueado (solicitud de pago pendiente)',
    'Login' => 'Iniciar sesión',
    'Logo' => 'Logo',
    'Looking for' => 'Buscando',
    'Mail server' => 'Servidor de correo',
    'Mail server settings' => 'Configuración del servidor de correo',
    'Mail server test email' => 'Prueba del servidor de correo',
    'Mailchimp app id' => 'Mailchimp app id',
    'Mailchimp list id' => 'Mailchimp list id',
    'Main blog post image' => 'Imagen de la publicación principal del blog',
    'Main categories' => 'Categorías principales',
    'Main event image' => 'Imagen del evento principal',
    'Main image' => 'Imagen principal',
    'Maintenance mode' => 'Modo de mantenimiento',
    'Maintenance mode custom message' => 'Mensaje personalizado del modo de mantenimiento',
    'Make sure that the added payment gateways are configured to support this currency' => 'Asegúrese de que las pasarelas de pago agregadas estén configuradas para admitir esta moneda',
    'Make sure that the currency setting of your payout method matches the one currently used which is %currency%' => 'Asegúrese de que la configuración de moneda de su método de pago coincida con la que se usa actualmente, que es %currency%',
    'Make sure to select organizers who have added a cover photo' => 'Asegúrese de seleccionar organizadores que hayan agregado una foto de portada',
    'Make sure to select right category to let the users find it quickly' => 'Asegúrese de seleccionar la categoría correcta para que los usuarios la encuentren rápidamente',
    'Manage amenities' => 'Administrar servicios',
    'Manage attendees' => 'Gestionar asistentes',
    'Manage audiences' => 'Administrar audiencias',
    'Manage blog post categories' => 'Administrar categorías de publicaciones de blog',
    'Manage blog posts' => 'Administrar publicaciones de blog',
    'Manage categories' => 'Gestionar categorías',
    'Manage countries' => 'Gestionar países',
    'Manage currencies' => 'Administrar monedas',
    'Manage event' => 'Gestionar evento',
    'Manage events' => 'Gestionar eventos',
    'Manage help center articles' => 'Administrar artículos del centro de ayuda',
    'Manage help center categories' => 'Administrar categorías del centro de ayuda',
    'Manage languages' => 'Gestionar idiomas',
    'Manage menus' => 'Administrar menús',
    'Manage orders' => 'Gestionar pedidos',
    'Manage pages' => 'Administrar páginas',
    'Manage reviews' => 'Administrar reseñas',
    'Manage users' => 'Administrar usuarios',
    'Manage venues' => 'Administrar lugares',
    'Manage venues types' => 'Administrar tipos de lugares',
    'Mark as featured' => 'Marcar como destacado',
    'Mark as not featured' => 'Marcar como no destacado',
    'Max' => 'Max',
    'Member since' => 'Miembro desde',
    'Menu elements' => 'Elementos del menú',
    'Menu name' => 'Menu name',
    'Menus' => 'Menús',
    'Menus settings' => 'Configuración de menús',
    'Menüname' => 'Menüname',
    'Message' => 'Mensaje',
    'Method Not Supported' => 'Método no admitido',
    'Min' => 'Min',
    'More details' => 'Más detalles',
    'More information' => 'Más información',
    'Mots clés' => 'Mots clés',
    'My cart' => 'Mi carrito',
    'My events' => 'Mis eventos',
    'My favorites' => 'Mis favoritos',
    'My orders' => 'Mis ordenes',
    'My organizer profile' => 'Mi perfil de organizador',
    'My points of sale' => 'Mis puntos de venta',
    'My review' => 'Mi reseña',
    'My reviews' => 'Mis críticas',
    'My scanners' => 'Mis escáneres',
    'My tickets' => 'Mis entradas',
    'My venues' => 'Mis lugares',
    'N/A' => 'N/A',
    'Na sua mente' => 'Na sua mente',
    'Name' => 'Nombre',
    'Name / Username' => 'Nombre / nombre de usuario',
    'Neighborhoods' => 'Barrios',
    'Net sales' => 'Las ventas netas',
    'Net sales until' => 'Ventas netas hasta',
    'New' => 'Nuevo',
    'New message regarding the order' => 'Nuevo mensaje sobre el pedido',
    'New payout request' => 'Nueva solicitud de pago',
    'New quote request' => 'Nueva solicitud de cotización',
    'Newsletter' => 'Boletin informativo',
    'Newsletter settings' => 'Configuración del boletín',
    'Next month' => 'Próximo mes',
    'Next week' => 'La próxima semana',
    'No' => 'No',
    'No amenites found' => 'No se encontraron amenidades',
    'No articles found' => 'No se encontraron artículos',
    'No attendees found' => 'No se encontraron asistentes',
    'No audiences found' => 'No se encontraron públicos',
    'No blog post categories found' => 'No se encontraron categorías de publicaciones de blog',
    'No blog posts found' => 'No se encontraron publicaciones de blog',
    'No categories found' => 'No se encontraron categorías',
    'No countries found' => 'No se encontraron países',
    'No currencies found' => 'No se encontraron monedas',
    'No event dates found' => 'No se encontraron fechas de eventos',
    'No events found' => 'No se encontraron eventos',
    'No events on sale' => 'No hay eventos a la venta',
    'No events on sale for now' => 'No hay eventos a la venta por ahora',
    'No languages found' => 'No se encontraron idiomas',
    'No link, display featured categories dropdown on hover (header menu only)' => 'Sin enlace, muestra el menú desplegable de categorías destacadas al pasar el mouse (solo menú de encabezado)',
    'No menus found' => 'No se encontraron menús',
    'No orders found' => 'No se encontraron pedidos',
    'No orders found to be included in the report' => 'No se encontraron pedidos para ser incluidos en el informe',
    'No pages found' => 'No se encontraron páginas',
    'No past events found' => 'No se encontraron eventos pasados',
    'No payment gateways are currently enabled' => 'Actualmente no hay pasarelas de pago habilitadas',
    'No payment gateways found' => 'No se encontraron pasarelas de pago',
    'No payout requests found' => 'No se encontraron solicitudes de pago',
    'No points of sale found' => 'No se encontraron puntos de venta',
    'No reply email address' => 'Sin dirección de correo electrónico de respuesta',
    'No review found' => 'No se encontró ninguna reseña',
    'No reviews found' => 'No se encontraron comentarios',
    'No sales yet' => 'Sin ventas todavía',
    'No scanners found' => 'No se encontraron escáneres',
    'No ticket on sale' => 'No hay entrada a la venta',
    'No tickets selected to add to cart' => 'No se seleccionaron entradas para agregar al carrito',
    'No users found' => 'No se encontraron usuarios',
    'No venue types found' => 'No se encontraron tipos de lugares',
    'No venues found' => 'No se encontraron lugares',
    'Nom' => 'Nom',
    'Nom du menu' => 'Nom du menu',
    'Nombre' => 'Nombre',
    'Nombre du menú' => 'Nombre du menú',
    'Nome' => 'Nome',
    'Nome do menu' => 'Nome do menu',
    'None' => 'Ninguno',
    'Not Checked In Only' => 'No registrado solamente',
    'Not a member yet ?' => 'No eres miembro todavía ?',
    'Not elapsed only' => 'No transcurrido solo',
    'Not featured' => 'No destacado',
    'Not listed on the directory' => 'No incluido en el directorio',
    'Note' => 'Nota',
    'Number of blog posts per page' => 'Número de publicaciones de blog por página',
    'Number of blog posts to show' => 'Número de publicaciones de blog para mostrar',
    'Number of events per page' => 'Número de eventos por página',
    'Number of events to show' => 'Número de eventos para mostrar',
    'Number of featured categories to show' => 'Número de categorías destacadas para mostrar',
    'Number of guests' => 'Número de invitados',
    'Number of seconds before the reserved tickets are released if the order is still awaiting payment' => 'Número de segundos antes de que se liberen los entradas reservados si el pedido aún está pendiente de pago',
    'Number of tickets' => 'Numero de tickets',
    'OR' => 'O',
    'On sale' => 'En venta',
    'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed' => 'Una vez enviada la solicitud de pago, la fecha del evento se bloqueará y las ventas se suspenderán para la fecha específica del evento. Si lo desea, puede esperar hasta la fecha de inicio del evento antes de solicitar el pago. Puede cancelar la solicitud de pago en cualquier momento antes de que se procese',
    'Online' => 'En línea',
    'Online events only' => 'Solo eventos en línea',
    'Optional attendee information' => 'Información opcional para asistentes',
    'Optionally add a cover photo to showcase your organizer activities' => 'Opcionalmente, agregue una foto de portada para mostrar las actividades de su organizador',
    'Orange' => 'Naranja',
    'Order' => 'Orden',
    'Order =' => 'Orden en la lista',
    'Order = ' => 'Orden en la lista = ',
    'Order Date' => 'Fecha de orden',
    'Order confirmation' => 'Confirmación del pedido',
    'Order date' => 'Fecha de orden',
    'Order details' => 'Detalles del pedido',
    'Order of appearance' => 'Orden de aparición',
    'Order payment details' => 'Detalles de pago del pedido',
    'Order reference' => 'Pedir Referencia',
    'Order status' => 'Estado de la orden',
    'Order summary' => 'Resumen de pedido',
    'Order total' => 'Total del pedido',
    'Orders' => 'Pedidos',
    'Orders placed' => 'Pedidos realizados',
    'Orders summary' => 'Resumen de pedidos',
    'Organizer' => 'Organizador',
    'Organizer / Event / Date / Ticket' => 'Organizador / Evento / Fecha / Entrada',
    'Organizer Profile' => 'Perfil del organizador',
    'Organizer Registration' => 'Registro de organizador',
    'Organizer information' => 'Información del organizador',
    'Organizer is disabled' => 'El organizador está deshabilitado',
    'Organizer logo' => 'Logotipo del organizador',
    'Organizer name' => 'Nombre del organizador',
    'Organizer profile' => 'Perfil de organizador',
    'Organizer revenue from %website_name%' => 'Ingresos del organizador de %website_name%',
    'Organizers' => 'Organizadores',
    'Organizers Pages' => 'Páginas de organizadores',
    'Organizers slider' => 'Control deslizante de organizadores',
    'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry' => 'Organizadores, asistentes, este centro de soporte está destinado a responder rápidamente a sus preguntas, si aún no encuentra las respuestas, comuníquese con nosotros, estaremos encantados de recibir su consulta.',
    'Other events by %organizername%' => 'Otros eventos de %organizername%',
    'PERMANENTLY' => 'PERMANENTEMENTE',
    'POS' => 'Punto de venta',
    'Page content' => 'Contenido de página',
    'Page not found' => 'Página no encontrada',
    'Pages' => 'Páginas',
    'Paid' => 'Pagado',
    'Paid orders' => 'Pedidos pagados',
    'Palabras clave' => 'Palabras clave',
    'Palavras-chave' => 'Palavras-chave',
    'Paragraph' => 'Párrafo',
    'Paragraphe' => 'Paragraphe',
    'Parágrafo' => 'Parágrafo',
    'Password' => 'Contraseña',
    'Password Resetting' => 'Restablecimiento de contraseña',
    'Past events' => 'Eventos pasados',
    'Pay now' => 'Pagar ahora',
    'Payment' => 'Pago',
    'Payment details' => 'Detalles del pago',
    'Payment gateways' => 'Via de pago',
    'Payment method' => 'Método de pago',
    'Payment of tickets purchased on %website_name%' => 'Pago de entradas comprados en %website_name%',
    'Payment settings' => 'Configuración de pago',
    'Payments and Fees' => 'Pagos y tarifas',
    'Payout already requested' => 'Pago ya solicitado',
    'Payout method' => 'Método de pago',
    'Payout methods' => 'Métodos de pago',
    'Payout request' => 'Solicitud de pago',
    'Payout request details' => 'Detalles de la solicitud de pago',
    'Payout request notification' => 'Notificación de solicitud de pago',
    'Payout request payment details' => 'Detalles del pago de la solicitud de pago',
    'Payout requests' => 'Solicitudes de pago',
    'Payouts' => 'Pagos',
    'Paypal Client Id' => 'Paypal Client Id',
    'Paypal Client Secret' => 'Paypal Client Secret',
    'Paypal Express Checkout' => 'Paypal Express Checkout',
    'Pending' => 'Pendiente',
    'Pending payout requests' => 'Solicitudes de pago pendientes',
    'Percentage cut' => 'Corte porcentual',
    'Phone' => 'Teléfono',
    'Phone number' => 'Número de teléfono',
    'Photos' => 'Fotos',
    'Pick a date' => 'Selecciona una fecha',
    'Pink' => 'Rosado',
    'Please choose a 200x200 minimum image size as it is required by Facebook' => 'Elija un tamaño de imagen mínimo de 200x200 como lo requiere Facebook',
    'Please choose a 200x50 image size to ensure compatibility with the website design' => 'Elija un tamaño de imagen de 200 x 50 para garantizar la compatibilidad con el diseño del sitio web.',
    'Please click on the following link to check the status of your request' => 'Haga clic en el siguiente enlace para verificar el estado de su solicitud',
    'Please confirm your account by clicking the link below' => 'Confirme su cuenta haciendo clic en el enlace a continuación',
    'Please enter the selected payment gateway details' => 'Ingrese los detalles de la pasarela de pago seleccionada',
    'Please enter your payout method details' => 'Ingrese los detalles de su método de pago',
    'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Asegúrese de cambiar este parámetro también en el archivo .env en la carpeta raíz del proyecto, ya que se requiere en algún paquete externo',
    'Please refer to this following list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217' => 'Consulte la siguiente lista y utilice la columna Código: https://en.wikipedia.org/wiki/ISO_4217',
    'Please set a payout method before submitting a payout request' => 'Establezca un método de pago antes de enviar una solicitud de pago',
    'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor' => 'Espere unos segundos si la interfaz de traducción se congela al cargar la página, o edite los archivos en la carpeta traducciones / en la raíz del proyecto directamente en su editor de texto favorito',
    'Point of sale' => 'Punto de venta',
    'Point of sale information' => 'Información de punto de venta',
    'Point of sales' => 'Puntos de venta',
    'Points of sale' => 'Puntos de venta',
    'Popular' => 'Popular',
    'Popularity' => 'Popularidad',
    'Port' => 'Puerto',
    'Position' => 'Posición',
    'Postal code' => 'Código postal',
    'Posts' => 'Publicaciones',
    'Price' => 'Precio',
    'Pricing' => 'Precios',
    'Primary color code' => 'Código de color primario',
    'Print tickets' => 'Imprimir tickets',
    'Privacy policy' => 'Política de privacidad',
    'Privacy policy page slug' => 'Política de privacidad página slug',
    'Processed' => 'Procesada',
    'Processed at' => 'Procesado en',
    'Processing date' => 'Fecha de procesamiento',
    'Production' => 'Producción',
    'Profile picture' => 'Foto de perfil',
    'Profile views' => 'Visitas al perfil',
    'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string' => 'Formato de fecha y hora de todo el proyecto, siga este enlace para obtener una lista de caracteres admitidos: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string',
    'Promotional price' => 'Precio promocional',
    'Publicly show attendees' => 'Mostrar públicamente a los asistentes',
    'Publish' => 'Publicar',
    'Published events' => 'Eventos publicados',
    'Published only' => 'Solo publicado',
    'Purple' => 'Morado',
    'Párrafo' => 'Párrafo',
    'Quantity' => 'Cantidad',
    'Rating' => 'Clasificación',
    'Read time in minutes' => 'Leer el tiempo en minutos',
    'Recent orders' => 'Órdenes recientes',
    'Red' => 'Rojo',
    'Reference' => 'Referencia',
    'Register' => 'Registrarse',
    'Register attendees' => 'Registrar asistentes',
    'Registered using Facebook' => 'Registrado usando Facebook',
    'Registered using Google' => 'Registrado usando Google',
    'Registration date' => 'Fecha de Registro',
    'Related posts' => 'Artículos Relacionados',
    'Remove' => 'Eliminar',
    'Remove from favorites' => 'Quitar de favoritos',
    'Repeat password' => 'Repite la contraseña',
    'Reports' => 'Informes',
    'Request a quote' => 'Solicitar presupuesto',
    'Request date' => 'Fecha de solicitud',
    'Request payout' => 'Solicitud de Pago',
    'Requested at' => 'Solicitado en',
    'Resend confirmation email' => 'Reenviar correo electrónico de confirmación',
    'Reset' => 'Reiniciar',
    'Reset your password' => 'Restablecer su contraseña',
    'Response' => 'Respuesta',
    'Restore' => 'Restaurar',
    'Review date' => 'Fecha de revisión',
    'Review(s)' => 'Reseñas',
    'Reviews' => 'Reseñas',
    'Reviews for %eventname%' => 'Reseñas de %eventname%',
    'Right' => 'Derecho',
    'Role' => 'Papel',
    'SEO keywords' => 'Palabras clave SEO',
    'SMTP' => 'SMTP',
    'SSL' => 'SSL',
    'SSL must be activated on your hosting server in order to use Mailchimp' => 'SSL debe estar activado en su servidor de alojamiento para poder utilizar Mailchimp',
    'Sale didn\'t start yet' => 'La oferta aún no ha comenzado',
    'Sale ended' => 'Venta finalizada',
    'Sale ends On' => 'La oferta termina el',
    'Sale starts On' => 'La oferta comienza el',
    'Sales' => 'Ventas',
    'Sales channel' => 'Canal de ventas',
    'Sales end' => 'Fin de ventas',
    'Sales end date' => 'Fecha de finalización de ventas',
    'Sales end in' => 'Las ventas terminan en',
    'Sales ended' => 'Ventas terminadas',
    'Sales ended on' => 'Las ventas finalizaron el',
    'Sales start date' => 'Fecha de inicio de ventas',
    'Sales start in' => 'Las ventas comienzan en',
    'Sales started' => 'Ventas iniciadas',
    'Sales started on' => 'Las ventas comenzaron en',
    'Sandbox' => 'Sandbox',
    'Save' => 'Salvar',
    'Save order' => 'Guardar orden',
    'Scanned tickets' => 'Entradas escaneadas',
    'Scanner' => 'Escáner',
    'Scanner App' => 'Aplicación de escáner',
    'Scanner App settings' => 'Configuración de la aplicación del escáner',
    'Scanner information' => 'Información del escáner',
    'Scanners' => 'Escáneres',
    'Schlüsselwörter' => 'Schlüsselwörter',
    'Search' => 'Buscar',
    'Search blog' => 'Blog de búsqueda',
    'Search blog posts' => 'Buscar publicaciones de blog',
    'Search for answers' => 'Buscar respuestas',
    'Search for events' => 'Buscar eventos',
    'Search help center' => 'Buscar en el centro de ayuda',
    'Search in reviews' => 'Buscar en reseñas',
    'Seated' => 'Sentado',
    'Seated guests' => 'Invitados sentados',
    'Seated guests number' => 'Número de invitados sentados',
    'Secret key' => 'Llave secreta',
    'See all' => 'Ver todo',
    'See all %reviewscount% reviews' => 'Ver todos los %reviewscount% reviews',
    'See all events on sale' => 'Ver todos los eventos en oferta',
    'See more articles' => 'Ver más artículos',
    'Select a payout method' => 'Seleccione un método de pago',
    'Select a specific event date' => 'Seleccione una fecha de evento específica',
    'Select a specific event ticket' => 'Seleccione un entrada de evento específico',
    'Select an option' => 'Seleccione una opción',
    'Select parent of \'Point of sale\' or \'Scanner\'' => 'Seleccione el padre de \'Punto de venta\' o \'Escáner\'',
    'Select the audience types that are targeted in your event' => 'Seleccione los tipos de audiencia a los que se dirige su evento',
    'Select the categories that represent your events types' => 'Seleccione las categorías que representan sus tipos de eventos',
    'Select the country that your event represents (ie: A movie\'s country of production)' => 'Seleccione el país que representa su evento (es decir, el país de producción de una película)',
    'Select the languages that will be spoken in your event' => 'Seleccione los idiomas que se hablarán en su evento',
    'Select the parent category to add a sub category' => 'Seleccione la categoría principal para agregar una subcategoría',
    'Send' => 'Enviar',
    'Send us an email' => 'Envianos un email',
    'Sendmail' => 'Sendmail',
    'Set' => 'Definir',
    'Set a new password' => 'Establecer una nueva contraseña',
    'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)' => 'Establezca un precio menor que el precio original para indicar una promoción (este precio será el precio de VENTA)',
    'Set the display order for the featured categories' => 'Establecer el orden de visualización de las categorías destacadas',
    'Set the number of tickets that an attendee can buy for this ticket type' => 'Establecer la cantidad de entradas que un asistente puede comprar para este tipo de entrada',
    'Set your %payoutMethodName% payout method' => 'Establezca su método de pago %payoutMethodName%',
    'Settings' => 'Configuraciones',
    'Share' => 'Compartir',
    'Show' => 'Mostrar',
    'Show RSS feed button' => 'Mostrar botón de fuente RSS',
    'Show a map at the bottom of your organizer profile page containing the venues you added' => 'Muestre un mapa en la parte inferior de la página de perfil de su organizador que contiene los lugares que agregó',
    'Show audience filter' => 'Mostrar filtro de audiencia',
    'Show calendar button' => 'Mostrar botón de calendario',
    'Show category filter' => 'Mostrar filtro de categoría',
    'Show date filter' => 'Mostrar filtro de fecha',
    'Show event date stats on the scanner app' => 'Mostrar estadísticas de la fecha del evento en la aplicación del escáner',
    'Show event dates and tickets' => 'Mostrar fechas de eventos y entradas',
    'Show events calendar' => 'Mostrar calendario de eventos',
    'Show events on map' => 'Mostrar eventos en el mapa',
    'Show followers' => 'Mostrar seguidores',
    'Show location filter' => 'Mostrar filtro de ubicación',
    'Show map button' => 'Mostrar botón de mapa',
    'Show reviews' => 'Mostrar reseñas',
    'Show the GDPR compliance page link' => 'Mostrar el enlace de la página de cumplimiento de GDPR',
    'Show the attendees number and list in the event page' => 'Muestre el número de asistentes y la lista en la página del evento.',
    'Show the back to top button' => 'Mostrar el botón volver al principio',
    'Show the call to action block' => 'Mostrar el bloque de llamada a la acción',
    'Show the cookie policy bar at the bottom' => 'Muestra la barra de política de cookies en la parte inferior.',
    'Show the cookie policy page link' => 'Mostrar el enlace a la página de la política de cookies',
    'Show the homepage hero seach box' => 'Mostrar el cuadro de búsqueda de héroe de la página de inicio',
    'Show the map along with the address on the venue page and event page' => 'Muestre el mapa junto con la dirección en la página del lugar y la página del evento',
    'Show the number and list of people that follow you' => 'Muestre el número y la lista de personas que lo siguen',
    'Show the privacy policy page link' => 'Mostrar el enlace de la página de política de privacidad',
    'Show the quote form on the venue page' => 'Muestre el formulario de cotización en la página del lugar',
    'Show the reviews that you received for your events' => 'Muestra las reseñas que recibiste de tus eventos.',
    'Show the search box' => 'Mostrar el cuadro de búsqueda',
    'Show the terms of service page link' => 'Mostrar el enlace de la página de términos de servicio',
    'Show ticket price filter' => 'Mostrar filtro de precio de entrada',
    'Show tickets left count on cart modal' => 'Mostrar entradas restantes contar en modal de carrito',
    'Show venues map' => 'Mostrar mapa de sedes',
    'Sign in' => 'Registrarse',
    'Sign in via Facebook' => 'Iniciar sesión a través de Facebook',
    'Sign in via Google' => 'Iniciar sesión a través de Google',
    'Sign out' => 'Desconectar',
    'Sign up' => 'Regístrate',
    'Sign up via Facebook' => 'Regístrate a través de Facebook',
    'Sign up via Google' => 'Regístrate a través de Google',
    'Similar events' => 'Eventos similares',
    'Site key' => 'Site key',
    'Sitemap' => 'Mapa del sitio',
    'Slug' => 'Babosa',
    'Social Login' => 'Inicio de sesión social',
    'Social Login settings' => 'Configuración de inicio de sesión social',
    'Social media share image' => 'Compartir imagen en redes sociales',
    'Sold out' => 'Agotado',
    'Sort by' => 'Ordenar por',
    'Standing' => 'En pie',
    'Standing guests' => 'Invitados de pie',
    'Standing guests number' => 'Número de invitados de pie',
    'Start date' => 'Fecha de inicio',
    'Starts On' => 'Comienza en',
    'State' => 'Estado',
    'State / City' => 'Ciudad estado',
    'Static Pages' => 'Páginas estáticas',
    'Statistics' => 'Estadísticas',
    'Status' => 'Estado',
    'Still in cart' => 'Todavía en el carro',
    'Street' => 'Calle',
    'Street 2' => 'Calle 2',
    'Street address' => 'Calle',
    'Street address 2' => 'Calle 2',
    'Stripe Checkout' => 'Stripe Checkout',
    'Stripe Checkout (credit cards)' => 'Stripe Checkout (credit cards)',
    'Stripe payout' => 'Pagar de Stripe',
    'Stripe publishable key' => 'Stripe publishable key',
    'Stripe secret key' => 'Stripe secret key',
    'Subject' => 'Sujeto',
    'Submit payment' => 'Enviar pago',
    'Subscribe' => 'Suscribir',
    'Subscribe to our newsletter' => 'Suscríbete a nuestro boletín',
    'Subtitles' => 'Subtítulos',
    'Subtotal' => 'Total parcial',
    'Successfully executed the command' => 'Ejecutó con éxito el comando',
    'Support for' => 'Apoyo para',
    'Suspended' => 'Suspendido',
    'Symbol' => 'Símbolo',
    'TLS' => 'TLS',
    'TSL' => 'TSL',
    'Tags' => 'Etiquetas',
    'Take your events to the next level' => 'Lleva tus eventos al siguiente nivel',
    'Tell your attendees more about this ticket type' => 'Cuéntele a sus asistentes más sobre este tipo de entrada',
    'Terms of service' => 'Términos de servicio',
    'Terms of service page slug' => 'Términos de servicio página slug',
    'Test the mail server configuration' => 'Pruebe la configuración del servidor de correo',
    'Texte du lien' => 'Texte du lien',
    'Texto del enlace' => 'Texto del enlace',
    'Texto do link' => 'Texto do link',
    'The amenity can not be deleted because it is linked with one or more venues' => 'Términos de servicio página slug',
    'The amenity can not be found' => 'No se puede encontrar la amenidad',
    'The amenity has been deleted' => 'La amenidad ha sido eliminada',
    'The amenity has been disabled' => 'El servicio ha sido deshabilitado',
    'The amenity has been succesfully restored' => 'El servicio se ha restaurado con éxito',
    'The amenity has been successfully created' => 'La amenidad se ha creado con éxito',
    'The amenity has been successfully updated' => 'El equipamiento se ha actualizado correctamente',
    'The amenity is hidden' => 'La amenidad esta escondida',
    'The amenity is visible' => 'La amenidad es visible',
    'The article can not be found' => 'No se puede encontrar el artículo',
    'The article has been deleted' => 'El artículo ha sido eliminado',
    'The article has been disabled' => 'El artículo ha sido deshabilitado',
    'The article has been succesfully restored' => 'El artículo se ha restaurado correctamente.',
    'The article has been successfully created' => 'El artículo ha sido creado con éxito.',
    'The article has been successfully updated' => 'El artículo se ha actualizado correctamente.',
    'The article is featured' => 'El artículo aparece',
    'The article is hidden' => 'El articulo esta oculto',
    'The article is not featured anymore' => 'El artículo ya no aparece',
    'The article is visible' => 'El artículo es visible',
    'The article not be found' => 'El artículo no se encuentra',
    'The audience can not be deleted because it is linked with one or more events' => 'La audiencia no se puede eliminar porque está vinculada a uno o más eventos',
    'The audience can not be found' => 'No se puede encontrar la audiencia',
    'The audience has been deleted' => 'La audiencia ha sido eliminada',
    'The audience has been disabled' => 'La audiencia ha sido deshabilitada',
    'The audience has been succesfully restored' => 'La audiencia se ha restaurado correctamente',
    'The audience has been successfully created' => 'La audiencia se ha creado con éxito',
    'The audience has been successfully updated' => 'La audiencia se ha actualizado correctamente',
    'The audience is hidden' => 'La audiencia esta escondida',
    'The audience is visible' => 'La audiencia es visible',
    'The blog post can not be found' => 'No se puede encontrar la publicación del blog',
    'The blog post category can not be deleted because it is linked with one or more blog posts' => 'La categoría de publicación de blog no se puede eliminar porque está vinculada a una o más publicaciones de blog.',
    'The blog post category can not be found' => 'No se puede encontrar la categoría de publicación de blog',
    'The blog post category has been deleted' => 'Se eliminó la categoría de la publicación del blog.',
    'The blog post category has been disabled' => 'La categoría de publicación de blog ha sido inhabilitada.',
    'The blog post category has been succesfully restored' => 'La categoría de la publicación de blog se ha restaurado correctamente',
    'The blog post category has been successfully created' => 'La categoría de publicación de blog se ha creado correctamente',
    'The blog post category has been successfully updated' => 'La categoría de la publicación del blog se ha actualizado correctamente.',
    'The blog post category is hidden' => 'La categoría de la publicación del blog está oculta',
    'The blog post category is visible' => 'La categoría de la publicación del blog es visible',
    'The blog post has been deleted' => 'La publicación del blog ha sido eliminada.',
    'The blog post has been disabled' => 'La publicación del blog ha sido inhabilitada.',
    'The blog post has been succesfully restored' => 'La publicación del blog se ha restaurado correctamente.',
    'The blog post has been successfully created' => 'La publicación del blog se ha creado correctamente',
    'The blog post has been successfully updated' => 'La publicación del blog se ha actualizado correctamente',
    'The blog post is hidden' => 'La publicación del blog está oculta',
    'The blog post is visible' => 'La publicación del blog es visible',
    'The blog post not be found' => 'No se encuentra la publicación del blog',
    'The category can not be deleted because it is linked with one or more events' => 'La categoría no se puede eliminar porque está vinculada con uno o más eventos',
    'The category can not be deleted because it is linked with one or more help center articles' => 'La categoría no se puede eliminar porque está vinculada con uno o más artículos del centro de ayuda.',
    'The category can not be found' => 'No se puede encontrar la categoría',
    'The category has been deleted' => 'La categoría ha sido eliminada',
    'The category has been disabled' => 'La categoría ha sido deshabilitada',
    'The category has been succesfully restored' => 'La categoría se ha restaurado correctamente',
    'The category has been successfully created' => 'La categoría se ha creado correctamente',
    'The category has been successfully updated' => 'La categoría se ha actualizado correctamente',
    'The category is featured and is shown in the homepage categories' => 'La categoría aparece y se muestra en las categorías de la página de inicio',
    'The category is hidden' => 'La categoría está oculta',
    'The category is not featured anymore and is removed from the homepage categories' => 'La categoría ya no aparece y se elimina de las categorías de la página de inicio',
    'The category is visible' => 'La categoría es visible',
    'The category not be found' => 'No se encuentra la categoría',
    'The confirmation email has been resent to' => 'El correo electrónico de confirmación ha sido reenviado a',
    'The country can not be deleted because it is linked with one or more events' => 'El país no se puede eliminar porque está vinculado a uno o más eventos',
    'The country can not be found' => 'El país no se puede encontrar',
    'The country has been deleted' => 'El país ha sido eliminado',
    'The country has been disabled' => 'El país ha sido deshabilitado',
    'The country has been succesfully restored' => 'El país ha sido restaurado con éxito',
    'The country has been successfully created' => 'El país ha sido creado con éxito',
    'The country has been successfully updated' => 'El país se ha actualizado correctamente',
    'The country is hidden' => 'El pais esta escondido',
    'The country is visible' => 'El pais es visible',
    'The currency can not be found' => 'No se puede encontrar la moneda',
    'The currency has been deleted' => 'La moneda ha sido eliminada',
    'The currency has been successfully created' => 'La moneda se ha creado correctamente',
    'The currency has been successfully updated' => 'La moneda se ha actualizado correctamente',
    'The default locale must be selected in the available languages' => 'La configuración regional predeterminada debe seleccionarse en los idiomas disponibles',
    'The email could not be sent' => 'No se pudo enviar el correo electrónico',
    'The event can not be deleted because it has one or more orders' => 'El evento no se puede eliminar porque tiene uno o más pedidos',
    'The event can not be found' => 'No se puede encontrar el evento',
    'The event date can not be found' => 'No se puede encontrar la fecha del evento',
    'The event date stats (sales and attendance) will be visible on the scanner app' => 'Las estadísticas de la fecha del evento (ventas y asistencia) serán visibles en la aplicación del escáner',
    'The event has been added to your favorites' => 'El evento ha sido agregado a tus favoritos',
    'The event has been deleted' => 'El evento ha sido eliminado',
    'The event has been deleted permanently' => 'El evento se ha eliminado de forma permanente',
    'The event has been published and will figure in the search results' => 'El evento ha sido publicado y figurará en los resultados de búsqueda.',
    'The event has been removed from your favorites' => 'El evento ha sido eliminado de tus favoritos',
    'The event has been succesfully restored' => 'El evento se ha restaurado correctamente',
    'The event has been successfully created' => 'El evento se ha creado con éxito',
    'The event has been successfully updated' => 'El evento se ha actualizado correctamente',
    'The event has been unpublished and will not be included in the search results' => 'El evento no se ha publicado y no se incluirá en los resultados de búsqueda',
    'The event not be found' => 'El evento no se encuentra',
    'The event ticket can not be found' => 'No se puede encontrar el entrada del evento',
    'The fields preceded with a red * are mandatory' => 'Los campos precedidos de un * rojo son obligatorios',
    'The form contains invalid data' => 'El formulario contiene datos no válidos',
    'The homepage settings could not be loaded' => 'No se pudo cargar la configuración de la página de inicio',
    'The language can not be deleted because it is linked with one or more events' => 'El idioma no se puede eliminar porque está vinculado con uno o más eventos',
    'The language can not be found' => 'No se puede encontrar el idioma',
    'The language has been deleted' => 'El idioma ha sido eliminado',
    'The language has been disabled' => 'El idioma ha sido deshabilitado',
    'The language has been succesfully restored' => 'El idioma se ha restaurado correctamente',
    'The language has been successfully created' => 'El idioma se ha creado correctamente',
    'The language has been successfully updated' => 'El idioma se ha actualizado correctamente',
    'The language is hidden' => 'El idioma esta escondido',
    'The language is visible' => 'El idioma es visible',
    'The layout settings could not be loaded' => 'No se pudo cargar la configuración de diseño',
    'The menu can not be found' => 'No se encuentra el menú',
    'The menu has been successfully updated' => 'El menú se ha actualizado correctamente',
    'The order can not be found' => 'No se puede encontrar el pedido',
    'The order has been deleted' => 'El pedido ha sido eliminado',
    'The order has been permanently canceled' => 'El pedido ha sido cancelado de forma permanente',
    'The order has been permanently deleted' => 'El pedido se ha eliminado de forma permanente',
    'The order has been soft deleted, restore it before canceling it' => 'El pedido se ha eliminado temporalmente, restaure antes de cancelarlo',
    'The order has been succesfully restored' => 'El orden se ha restaurado correctamente',
    'The order has been successfully validated' => 'El pedido ha sido validado con éxito',
    'The order status must be paid or awaiting payment' => 'El estado del pedido debe estar pagado o en espera de pago.',
    'The organizer can not be found' => 'El organizador no se puede encontrar',
    'The organizer not be found' => 'El organizador no se encuentra',
    'The organizer revenue from this event date is currently zero' => 'Los ingresos del organizador de esta fecha de evento son actualmente cero',
    'The page can not be found' => 'La página no se puede encontrar',
    'The page has been deleted' => 'La página ha sido eliminada',
    'The page has been successfully created' => 'La página se ha creado correctamente',
    'The page has been successfully updated' => 'La página se ha actualizado correctamente',
    'The payment can not be found' => 'No se puede encontrar el pago',
    'The payment gateway can not be found' => 'No se encuentra la pasarela de pago',
    'The payment gateway has been successfully created' => 'La pasarela de pago se ha creado con éxito',
    'The payment gateway has been successfully updated' => 'La pasarela de pago se ha actualizado correctamente',
    'The payout method can not be found' => 'No se puede encontrar el método de pago',
    'The payout method has been successfully created' => 'El método de pago se ha creado correctamente',
    'The payout method has been successfully updated' => 'El método de pago se ha actualizado correctamente',
    'The payout method is unset' => 'El método de pago no está configurado',
    'The payout request can not be canceled because it is already processed' => 'La solicitud de pago no se puede cancelar porque ya está procesada',
    'The payout request can not be found' => 'No se puede encontrar la solicitud de pago',
    'The payout request can not be processed at this moment' => 'La solicitud de pago no se puede procesar en este momento',
    'The payout request has been already processed' => 'La solicitud de pago ya se procesó',
    'The payout request has been deleted' => 'Se eliminó la solicitud de pago',
    'The payout request has been permanently canceled' => 'La solicitud de pago se canceló de forma permanente',
    'The payout request has been permanently deleted' => 'La solicitud de pago se eliminó de forma permanente',
    'The payout request has been soft deleted, restore it before canceling it' => 'La solicitud de pago se ha eliminado temporalmente, restaure antes de cancelarla',
    'The payout request has been succesfully restored' => 'La solicitud de pago se ha restablecido correctamente.',
    'The payout request has been successfully processed' => 'La solicitud de pago se ha procesado correctamente',
    'The payout request has been successfully submitted, you will be notified by email once it is processed' => 'La solicitud de pago se ha enviado correctamente, se le notificará por correo electrónico una vez que se procese',
    'The point of sale can not be found' => 'No se puede encontrar el punto de venta',
    'The point of sale has been deleted' => 'Se ha eliminado el punto de venta',
    'The point of sale has been disabled' => 'El punto de venta ha sido deshabilitado',
    'The point of sale has been enabled' => 'Se ha habilitado el punto de venta',
    'The point of sale has been permenently deleted' => 'El punto de venta se ha eliminado definitivamente',
    'The point of sale has been successfully created' => 'El punto de venta se ha creado con éxito',
    'The point of sale has been successfully updated' => 'El punto de venta se ha actualizado correctamente',
    'The request method is known by the server but is not supported by the target resource' => 'El servidor conoce el método de solicitud, pero el recurso de destino no lo admite',
    'The requested page couldn\'t be located. Checkout for any URL misspelling or' => 'No se pudo localizar la página solicitada. Compruebe si hay errores ortográficos en la URL o',
    'The review can not be found' => 'No se puede encontrar la reseña',
    'The review has been deleted' => 'La reseña ha sido eliminada',
    'The review has been deleted permanently' => 'La reseña se ha eliminado de forma permanente',
    'The review has been enabled' => 'La revisión ha sido habilitada',
    'The review has been hidden' => 'La reseña se ha ocultado',
    'The review has been succesfully restored' => 'La revisión se ha restaurado correctamente',
    'The scanner account is disabled by the organizer' => 'La cuenta del escáner está inhabilitada por el organizador',
    'The scanner can not be found' => 'No se puede encontrar el escáner',
    'The scanner has been disabled' => 'El escáner ha sido desactivado',
    'The scanner has been enabled' => 'El escáner ha sido habilitado',
    'The scanner has been permenently deleted' => 'El escáner se ha eliminado de forma permanente',
    'The scanner has been successfully created' => 'El escáner se ha creado correctamente',
    'The scanner has been successfully updated' => 'El escáner se ha actualizado correctamente',
    'The settings have been updated' => 'La configuración se ha actualizado',
    'The space' => 'El espacio',
    'The test email has been sent, please check the inbox of' => 'El correo electrónico de prueba ha sido enviado, por favor revise la bandeja de entrada de',
    'The ticket can not be found' => 'No se puede encontrar el entrada',
    'The ticket has already been scanned' => 'El ticket ya ha sido escaneado',
    'The ticket has been successfully scanned' => 'El ticket ha sido escaneado con éxito',
    'The ticket is not valid for this event date' => 'El entrada no es válido para esta fecha de evento',
    'The ticket was already scanned at' => 'El entrada ya fue escaneado en',
    'The tickets has been successfully added to your cart' => 'Las entradas se han añadido correctamente a su carrito.',
    'The user can not be found' => 'El usuario no se puede encontrar',
    'The user cart has been emptied' => 'El carrito de usuario se ha vaciado',
    'The user has been deleted' => 'El usuario ha sido eliminado',
    'The user has been disabled' => 'El usuario ha sido deshabilitado',
    'The user has been enabled' => 'El usuario ha sido habilitado',
    'The user has been permanently deleted' => 'El usuario ha sido eliminado de forma permanente',
    'The user has been succesfully restored' => 'El usuario ha sido restaurado con éxito',
    'The username already exists' => 'El nombre de usuario ya existe',
    'The venue can not be deleted because it is linked with one or more events' => 'El lugar no se puede eliminar porque está vinculado a uno o más eventos',
    'The venue can not be found' => 'No se puede encontrar el lugar',
    'The venue has been deleted' => 'El lugar ha sido eliminado',
    'The venue has been disabled' => 'El lugar ha sido deshabilitado',
    'The venue has been succesfully restored' => 'El lugar ha sido restaurado con éxito',
    'The venue has been successfully created' => 'El lugar ha sido creado con éxito',
    'The venue has been successfully updated' => 'El lugar se ha actualizado correctamente',
    'The venue is hidden' => 'El lugar está escondido',
    'The venue is hidden from the public venues directory' => 'El lugar está oculto en el directorio de lugares públicos',
    'The venue is listed on the public venues directory' => 'El lugar figura en el directorio de lugares públicos',
    'The venue is visible' => 'El lugar es visible',
    'The venue type can not be deleted because it is linked with one or more venues' => 'El tipo de lugar no se puede eliminar porque está vinculado con uno o más lugares',
    'The venue type can not be found' => 'No se puede encontrar el tipo de lugar',
    'The venue type has been deleted' => 'Se ha eliminado el tipo de lugar',
    'The venue type has been disabled' => 'El tipo de lugar ha sido deshabilitado',
    'The venue type has been succesfully restored' => 'El tipo de lugar se ha restaurado correctamente',
    'The venue type has been successfully created' => 'El tipo de lugar se ha creado correctamente',
    'The venue type has been successfully updated' => 'El tipo de lugar se ha actualizado correctamente',
    'The venue type is hidden' => 'El tipo de lugar está oculto',
    'The venue type is visible' => 'El tipo de lugar es visible',
    'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above' => 'Esta dirección de correo electrónico se utilizará como remitente de todos los correos electrónicos enviados por la plataforma, en casi todos los casos, es el mismo que el nombre de usuario anterior',
    'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form' => 'Esta dirección de correo electrónico se utilizará para recibir las solicitudes de cotización, asegúrese de mencionarla si desea mostrar el formulario de cotización.',
    'This email address will receive the contact form messages' => 'Esta dirección de correo electrónico recibirá los mensajes del formulario de contacto.',
    'This email is sent as a confirmation of your order' => 'Este correo electrónico se envía como confirmación de su pedido',
    'This email is sent to test the configuration of the mail server settings.' => 'Este correo electrónico se envía para probar la configuración del servidor de correo.',
    'This event date is locked because a payout request has been submitted' => 'La fecha de este evento está bloqueada porque se envió una solicitud de pago',
    'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders' => 'Esta tarifa se agregará al precio de venta de entradas que se compran en un punto de venta, se pone 0 para deshabilitar las tarifas adicionales para los entradas que se compran en un punto de venta, no aplica para entradas gratis, se aplicará a futuros pedidos',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders' => 'Esta tarifa se agregará al precio de venta de entradas que se compran en línea, coloque 0 para deshabilitar las tarifas adicionales para entradas que se compran en línea, no aplica para entradas gratis, se aplicará a pedidos futuros',
    'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations' => 'Esta es una cadena que debe ser única para su aplicación y se usa comúnmente para agregar más entropía a las operaciones relacionadas con la seguridad',
    'This link can only be used once to validate your account' => 'Este enlace solo se puede utilizar una vez para validar su cuenta',
    'This month' => 'Este mes',
    'This payout method is currently disabled' => 'Este método de pago está actualmente inhabilitado',
    'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders' => 'Este porcentaje se deducirá de cada entrada vendido en un punto de venta, previa solicitud de pago del organizador, este porcentaje se tomará de cada entrada vendido en un punto de venta, se aplicará a pedidos futuros',
    'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders' => 'Este porcentaje se deducirá de cada entrada vendido en línea, previa solicitud de pago del organizador, este porcentaje se tomará de cada entrada vendido en línea, se aplicará a pedidos futuros',
    'This ticket was scanned at %scanDate%' => 'Este entrada fue escaneado en %scanDate%',
    'This week' => 'Esta semana',
    'This weekend' => 'Este fin de semana',
    'Ticket' => 'Entrada',
    'Ticket description' => 'Descripción del ticket',
    'Ticket fee (Online)' => 'Tarifa de entrada (en línea)',
    'Ticket fee (Point Of Sale)' => 'Tarifa de entrada (punto de venta)',
    'Ticket fees' => 'Tarifas de entradas',
    'Ticket name' => 'Nombre del ticket',
    'Ticket price' => 'Precio de la entrada',
    'Ticket price percentage cut (Online)' => 'Reducción del porcentaje del precio de la entrada (en línea)',
    'Ticket price percentage cut (Point of sale)' => 'Reducción del porcentaje del precio de la entrada (punto de venta)',
    'Ticket type' => 'Tipo de entrada',
    'Tickets' => 'Entradas',
    'Tickets left' => 'Boletas restantes',
    'Tickets per attendee' => 'Entradas por asistente',
    'Tickets sales' => 'Venta de entradas',
    'Tickets sales by date' => 'Venta de entradas por fecha',
    'Tickets sales this month' => 'Venta de entradas este mes',
    'Tickets sold' => 'Entradas vendidas',
    'Tickets sold Per Point of sale' => 'Entradas vendidas por punto de venta',
    'Tickets sold by channel' => 'Entradas vendidas por canal',
    'Tickets types' => 'Tipos de tickets',
    'Timeleft' => 'Tiempo restante',
    'Timezone' => 'Zona horaria',
    'Titel' => 'Titel',
    'Title' => 'Título',
    'Titre' => 'Titre',
    'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)' => 'Para ayudar a los asistentes a encontrar su evento rápidamente, ingrese algunas palabras clave que identifiquen su evento (presione Enter después de cada entrada)',
    'To reset your password, click on the following button and follow the instructions' => 'Para restablecer su contraseña, haga clic en el siguiente botón y siga las instrucciones',
    'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event' => 'Para enviar una nueva solicitud de pago para una fecha de evento, vaya a la página Mis eventos y haga clic en el enlace Solicitar pago junto al evento.',
    'Today' => 'Hoy',
    'Toggle display the event date details' => 'Alternar mostrar los detalles de la fecha del evento',
    'Toggle display the search filters' => 'Alternar mostrar los filtros de búsqueda',
    'Tomorrow' => 'Mañana',
    'Total' => 'Total',
    'Total attendees' => 'Total de asistentes',
    'Total attendees check-in' => 'Registro total de asistentes',
    'Total gross sales' => 'Ventas brutas totales',
    'Total orders' => 'Pedidos totales',
    'Total sales' => 'Ventas totales',
    'Total tickets sales' => 'Ventas totales de entradas',
    'Translation' => 'Traducción',
    'Translations' => 'Traducciones',
    'Transport' => 'Transporte',
    'Twitter' => 'Twitter',
    'Twitter url' => 'URL de Twitter',
    'Type' => 'Tipo',
    'Título' => 'Título',
    'Unfollow' => 'Dejar de seguir',
    'Unknown' => 'Desconocido',
    'Until date' => 'Hasta la fecha',
    'Upcoming events' => 'Próximos Eventos',
    'Update cart' => 'Actualización de la compra',
    'Update date' => 'Fecha de actualización',
    'Update the amenity' => 'Actualizar la amenidad',
    'Update the audience' => 'Actualizar la audiencia',
    'Update the blog post' => 'Actualizar la publicación del blog',
    'Update the blog post category' => 'Actualizar la categoría de la publicación del blog',
    'Update the category' => 'Actualizar la categoría',
    'Update the country' => 'Actualizar el país',
    'Update the currency' => 'Actualizar la moneda',
    'Update the event' => 'Actualizar el evento',
    'Update the help center article' => 'Actualizar el artículo del centro de ayuda',
    'Update the help center category' => 'Actualizar la categoría del centro de ayuda',
    'Update the language' => 'Actualizar el idioma',
    'Update the lapagenguage' => 'Actualizar el idioma de idioma',
    'Update the payment gateway' => 'Actualizar la pasarela de pago',
    'Update the point of sale' => 'Actualizar el punto de venta',
    'Update the scanner' => 'Actualizar el escáner',
    'Update the venue' => 'Actualizar el lugar',
    'Update the venue type' => 'Actualizar el tipo de lugar',
    'Update your %payoutMethodName% payout method' => 'Actualice su método de pago %payoutMethodName%',
    'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string' => 'Usado en algunos casos específicos, siga este enlace para obtener una lista de caracteres admitidos: https://www.php.net/manual/en/datetime.format.php . Asegúrese de mantener las comillas dobles "" alrededor de la cadena de formato.',
    'User information' => 'Informacion del usuario',
    'Username' => 'Nombre de usuario',
    'Users' => 'Usuarios',
    'Users summary' => 'Resumen de usuarios',
    'Uset' => 'Desarmado',
    'Validate' => 'Validar',
    'Venue' => 'Lugar de eventos',
    'Venue / Location' => 'Lugar / Ubicación',
    'Venue image' => 'Imagen del lugar',
    'Venue name...' => 'Nombre del lugar...',
    'Venue page' => 'Página del lugar',
    'Venue page settings' => 'Configuración de la página del lugar',
    'Venue type' => 'Tipo de lugar',
    'Venue types' => 'Tipos de lugares',
    'Venues' => 'Lugares',
    'Venues Pages' => 'Páginas de lugares',
    'Venues count' => 'Los lugares cuentan',
    'Venues page' => 'Página de lugares',
    'Video' => 'Vídeo',
    'View cart' => 'Ver carrito',
    'View detailed statistics' => 'Ver estadísticas detalladas',
    'View details' => 'Ver detalles',
    'View event' => 'Ver evento',
    'View organizer' => 'Ver organizador',
    'View stats' => 'Ver estadísticas',
    'Views' => 'Puntos de vista',
    'Visible' => 'Visible',
    'Visible only' => 'Solo visible',
    'We recommend a 48x48 image size' => 'Recomendamos un tamaño de imagen de 48 x 48',
    'We will be back shortly.' => 'Nosotros volveremos en breve.',
    'Website' => 'Sitio web',
    'Website name' => 'Nombre del Sitio Web',
    'Website root url' => 'URL raíz del sitio web',
    'Website slug' => 'Babosa del sitio web',
    'Website url' => 'URL del sitio web',
    'Welcome' => 'Bienvenidos',
    'What to show in the homepage hero ?' => '¿Qué mostrar en el héroe de la página de inicio?',
    'When' => 'Cuando',
    'Where' => 'Dónde',
    'Will be show in the homepage, the explore menu item dropdown and in the footer' => 'Se mostrará en la página de inicio, el menú desplegable de elementos de exploración y en el pie de página.',
    'Year' => 'Año',
    'Yellow' => 'Amarillo',
    'Yes' => 'Si',
    'You are about to approve the payout request' => 'Estás a punto de aprobar la solicitud de pago',
    'You are about to cancel this order (this action cannot be undone)' => 'Está a punto de cancelar este pedido (esta acción no se puede deshacer)',
    'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked' => 'Está a punto de cancelar esta solicitud de pago (esta acción no se puede deshacer), la fecha del evento relacionada con esta solicitud de pago se desbloqueará',
    'You are about to delete the amenity PERMANENTLY' => 'Estás a punto de eliminar la amenidad PERMANENTEMENTE',
    'You are about to delete the article PERMANENTLY' => 'Estás a punto de eliminar el artículo PERMANENTEMENTE',
    'You are about to delete the audience PERMANENTLY' => 'Estás a punto de eliminar la audiencia PERMANENTEMENTE',
    'You are about to delete the blog post PERMANENTLY' => 'Estás a punto de eliminar la publicación del blog PERMANENTEMENTE',
    'You are about to delete the blog post category PERMANENTLY' => 'Estás a punto de eliminar la categoría de la publicación del blog PERMANENTEMENTE',
    'You are about to delete the category PERMANENTLY' => 'Estás a punto de eliminar la categoría PERMANENTEMENTE',
    'You are about to delete the country PERMANENTLY' => 'Estás a punto de eliminar el país PERMANENTEMENTE',
    'You are about to delete the currency PERMANENTLY' => 'Estás a punto de eliminar la moneda PERMANENTEMENTE',
    'You are about to delete the event and all its related information PERMANENTLY' => 'Estás a punto de eliminar el evento y toda su información relacionada de forma PERMANENTE',
    'You are about to delete the language PERMANENTLY' => 'Estás a punto de eliminar el idioma PERMANENTEMENTE',
    'You are about to delete the order and all its related information (payment details, tickets...)' => 'Estás a punto de eliminar el pedido y toda su información relacionada (datos de pago, tickets ...)',
    'You are about to delete the page PERMANENTLY' => 'Estás a punto de eliminar la página PERMANENTEMENTE',
    'You are about to delete the payout request and all its related information' => 'Está a punto de eliminar la solicitud de pago y toda su información relacionada.',
    'You are about to delete the point of sale' => 'Estás a punto de eliminar el punto de venta',
    'You are about to delete the point of sale PERMANENTLY' => 'Estás a punto de eliminar el punto de venta PERMANENTEMENTE',
    'You are about to delete the review PERMANENTLY' => 'Estás a punto de eliminar la reseña PERMANENTEMENTE',
    'You are about to delete the scanner' => 'Está a punto de eliminar el escáner',
    'You are about to delete the scanner PERMANENTLY' => 'Está a punto de eliminar el escáner PERMANENTEMENTE',
    'You are about to delete the user and all its related information (orders, events...) PERMANENTLY' => 'Estás a punto de eliminar al usuario y toda su información relacionada (pedidos, eventos ...) PERMANENTEMENTE',
    'You are about to delete the venue PERMANENTLY' => 'Estás a punto de eliminar el lugar PERMANENTEMENTE',
    'You are about to delete the venue type PERMANENTLY' => 'Está a punto de eliminar el tipo de lugar de forma PERMANENTE',
    'You are about to empty your cart' => 'Estás a punto de vaciar tu carrito',
    'You are about to validate this order, generate the tickets and send a confirmation email to the attendee' => 'Está a punto de validar este pedido, generar los boletos y enviar un correo electrónico de confirmación al asistente',
    'You are connected as "%username%' => 'Estas conectado como "%username%',
    'You are following this organizer' => 'Estas siguiendo a este organizador',
    'You are going to this event' => 'Vas a este evento',
    'You are logged in as:' => 'Has iniciado sesión como:',
    'You are no longer following this organizer' => 'Vas a este evento',
    'You are not following any organizer' => 'No estas siguiendo a ningún organizador',
    'You can introduce the event details in multiple locales' => 'Puede introducir los detalles del evento en varios lugares',
    'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help' => '¿No encontró respuesta a su consulta? Háganos saber y estaremos encantados de brindarle más ayuda.',
    'You don\'t have permission to access this resource' => 'No tienes permiso para acceder a este recurso',
    'You have added %tickets% ticket(s) to your cart' => 'Ha añadido %tickets% ticket(s) a su carrito',
    'You have already bought %tickets% ticket(s)' => 'Ya has comprado %tickets% entrada',
    'You have received a new quote request for the venue' => 'Ha recibido una nueva solicitud de cotización para el lugar',
    'You have successfully subscribed to our newsletter' => 'Te has suscrito con éxito a nuestro boletín',
    'You must choose an event and set the status to paid in order to export attendees list to a PDF file' => 'Debe elegir un evento y establecer el estado en pagado para exportar la lista de asistentes a un archivo PDF',
    'You must choose an event in order to export the attendees list' => 'Debes elegir un evento para exportar la lista de asistentes.',
    'You must review your cart before proceeding to checkout' => 'Debe revisar su carrito antes de proceder con el pago.',
    'You must set the status to paid in order to export the attendees list' => 'Debe establecer el estado en pagado para exportar la lista de asistentes',
    'You must specify at least one language' => 'Debes especificar al menos un idioma',
    'You order is empty' => 'Tu pedido esta vacio',
    'Your account settings have been updated' => 'La configuración de su cuenta se ha actualizado',
    'Your cart has been automatically updated because one or more event\'s quotas has changed' => 'Su carrito se actualizó automáticamente porque se modificó la cuota de uno o más eventos',
    'Your cart has been automatically updated because one or more events are no longer on sale' => 'Su carrito se ha actualizado automáticamente porque uno o más eventos ya no están en oferta',
    'Your cart has been emptied' => 'Tu carrito se ha vaciado',
    'Your cart has been updated' => 'Su carrito se ha actualizado',
    'Your cart is empty' => 'Tu carrito esta vacío',
    'Your email' => 'Tu correo electrónico',
    'Your message has been successfully sent' => 'Su mensaje ha sido enviado con éxito',
    'Your order has been automatically canceled because one or more event\'s quotas has changed' => 'Tu pedido se canceló automáticamente porque se modificaron las cuotas de uno o más eventos.',
    'Your order has been automatically canceled because one or more events are no longer on sale' => 'Tu pedido se canceló automáticamente porque uno o más eventos ya no están a la venta',
    'Your order has been automatically canceled because your ticket reservations has been released' => 'Su pedido ha sido cancelado automáticamente porque sus reservas de entradas han sido liberadas.',
    'Your order has been successfully placed, please proceed to the payment as explained in the instructions' => 'Su pedido ha sido realizado con éxito, por favor proceda al pago como se explica en las instrucciones',
    'Your organizer profile has been successfully updated' => 'Su perfil de organizador se ha actualizado correctamente',
    'Your payment could not be processed at this time' => 'Su pago no se pudo procesar en este momento',
    'Your payment has been successfully processed' => 'Su pago ha sido procesado con éxito',
    'Your payment operation was canceled' => 'Tu operación de pago fue cancelada',
    'Your payout request has been processed' => 'Su solicitud de pago ha sido procesada',
    'Your quote request has been successfully sent' => 'Su solicitud de cotización ha sido enviada con éxito',
    'Your rating (out of 5 stars)' => 'Tu calificación (de 5 estrellas)',
    'Your registration has been successfully processed' => 'Su registro ha sido procesado con éxito',
    'Your review has been successfully saved' => 'Tu reseña se ha guardado correctamente',
    'Your review headline' => 'Título de tu reseña',
    'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away' => 'Sus entradas no se reservan hasta el momento del pago, la cantidad que desea comprar podría no estar disponible si no procede al pago de inmediato',
    'Your tickets bought from' => 'Tus entradas compradas en',
    'Youtube' => 'Youtube',
    'Youtube url' => 'URL de Youtube',
    'Youtube video' => 'video de Youtube',
    'Youtube video url' => 'URL del video de Youtube',
    'Zip / Postal code' => 'Código postal',
    'and' => 'y',
    'asc' => 'asc',
    'checked In' => 'registrado',
    'created at' => 'Creado en',
    'desc' => 'desc',
    'event to the next level ?' => 'evento al siguiente nivel?',
    'for' => 'para',
    'form.label.delete' => 'form.label.Eliminar',
    'form.password' => 'contraseña',
    'form.password_confirmation' => 'confirmación de contraseña',
    'image(s)' => 'imagen(s)',
    'left' => 'Izquierdo',
    'left before tickets are released' => 'dejado antes de que se liberen las entradas',
    'min read' => 'lectura mínima',
    'my points of sale' => 'mis puntos de venta',
    'my scanners' => 'mis escáneres',
    'my venues' => 'mis lugares',
    'orders summary' => 'resumen de pedidos',
    'out of 5 stars' => 'de 5 estrellas',
    'placed on' => 'colocado en',
    'return to the homepage' => 'Vuelve a la página inicial',
    'review' => 'Revisión',
    'right' => 'derecho',
    'ticket' => 'entrada',
    'ticket(s)' => 'Entradas',
    'ticket(s) sold' => 'billete(s) vendido',
    'tickets' => 'Entradas',
    'tickets found in your cart' => 'entradas encontrados en su carrito',
    'tickets left' => 'boletas restantes',
    'tickets per attendee' => 'entradas por asistente',
    'to edit your profile' => 'para editar tu perfil',
    'to manage this event' => 'para gestionar este evento',
    'to manage your event' => 'para gestionar tu evento',
    'to preview your profile' => 'para obtener una vista previa de su perfil',
    'to return to your dashboard' => 'para volver a su tablero',
    'user(s)' => 'usuarios',
    'view(s)' => 'puntos de vista',
    'views' => 'puntos de vista',
    'your payout request has been processed' => 'su solicitud de pago ha sido procesada',
    'your tickets are ready to go!' => '¡Tus entradas están listos para usar!',
    'اسم' => 'اسم',
    'اسم القائمة' => 'اسم القائمة',
    'التفاصيل' => 'التفاصيل',
    'العلامات' => 'العلامات',
    'الكلمات الرئيسية' => 'الكلمات الرئيسية',
    'تعليمات' => 'تعليمات',
    'عنوان' => 'عنوان',
    'فقرة' => 'فقرة',
    'محتوى' => 'محتوى',
    'نص الرابط' => 'نص الرابط',
    'نص العنوان' => 'نص العنوان',
  ),
  'javascript' => 
  array (
    'Add' => 'Añadir',
    'Add a new event date' => 'Agregar una nueva fecha de evento',
    'Add a new ticket' => 'Agregar un boleto nuevo',
    'An error has occured' => 'Se ha producido un error',
    'April' => 'Abril',
    'August' => 'Agosto',
    'Cancel' => 'Cancelar',
    'Close' => 'Cerca',
    'Confirm' => 'Confirmar',
    'Confirmation required' => 'Confirmación requerida',
    'Day' => 'Día',
    'December' => 'Diciembre',
    'Duplicate this event date' => 'Duplica la fecha de este evento',
    'Duplicate this ticket' => 'Duplica este ticket',
    'Email address' => 'Dirección de correo electrónico',
    'February' => 'Febrero',
    'Insert at least 3 characters' => 'Inserta al menos 3 caracteres',
    'January' => 'Enero',
    'July' => 'Julio',
    'June' => 'Junio',
    'Load more' => 'Carga más',
    'Loading...' => 'Cargando...',
    'Mail server test email' => 'Prueba del servidor de correo',
    'Make sure to enter a valid email address' => 'Asegúrese de ingresar una dirección de correo electrónico válida',
    'March' => 'Marzo',
    'May' => 'Mayo',
    'Message' => 'Mensaje',
    'Month' => 'Mes',
    'Move down' => 'Mover hacia abajo',
    'Move up' => 'Ascender',
    'No results found' => 'No se han encontrado resultados',
    'Note' => 'Nota',
    'November' => 'Noviembre',
    'October' => 'Octubre',
    'Please select the tickets quantity for this order' => 'Seleccione la cantidad de boletos para este pedido',
    'Please select the tickets quantity you want to buy' => 'Seleccione la cantidad de entradas que desea comprar',
    'Read more' => 'Lee mas',
    'Remove' => 'Eliminar',
    'Remove this event date' => 'Eliminar esta fecha de evento',
    'Remove this ticket' => 'Quitar este ticket',
    'Return to cart' => 'Volver al carrito',
    'Searching ...' => 'Buscando ...',
    'Select an option' => 'Seleccione una opción',
    'Send' => 'Enviar',
    'September' => 'Septiembre',
    'Stick' => 'Palo',
    'The email address is not valid' => 'La dirección de correo electrónico no es válida',
    'The tickets have been released' => 'Las entradas han sido liberadas',
    'This feature is disabled in demo mode' => 'Esta función está desactivada en el modo de demostración',
    'Time\'s up' => 'Se acabó el tiempo',
    'Today' => 'Hoy dia',
    'Unstick' => 'Despegar',
    'Week' => 'Semana',
    'days' => 'dias',
    'days.Fri' => 'Vie',
    'days.Mon' => 'Lun',
    'days.Sat' => 'Sáb',
    'days.Sun' => 'Dom',
    'days.Thu' => 'Jue',
    'days.Tue' => 'Mar',
    'days.Wed' => 'Mié',
    'hr' => 'hora',
    'min' => 'min',
    'sec' => 'seg',
    'weeks' => 'sem',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'fos_user.username.already_used' => 'The username is already used.',
    'fos_user.username.blank' => 'Please enter a username.',
    'fos_user.username.short' => 'The username is too short.',
    'fos_user.username.long' => 'The username is too long.',
    'fos_user.email.already_used' => 'The email is already used.',
    'fos_user.email.blank' => 'Please enter an email.',
    'fos_user.email.short' => 'The email is too short.',
    'fos_user.email.long' => 'The email is too long.',
    'fos_user.email.invalid' => 'The email is not valid.',
    'fos_user.password.blank' => 'Please enter a password.',
    'fos_user.password.short' => 'The password is too short.',
    'fos_user.password.mismatch' => 'The entered passwords don\'t match.',
    'fos_user.new_password.blank' => 'Please enter a new password.',
    'fos_user.new_password.short' => 'The new password is too short.',
    'fos_user.current_password.invalid' => 'The entered password is invalid.',
    'fos_user.group.blank' => 'Please enter a name.',
    'fos_user.group.short' => 'The name is too short.',
    'fos_user.group.long' => 'The name is too long.',
    'fos_group.name.already_used' => 'The name is already used.',
    'This value is not a valid captcha.' => 'This value is not a valid captcha.',
    'The captcha was not resolved on the right domain.' => 'The captcha was not resolved on the right domain.',
    'validator.credit_card.invalidDate' => 'This value should be a valid date.',
    'Please enter a message' => 'Please enter a message',
    'Please enter a permalink' => 'Please enter a permalink',
    'Please enter an id' => 'Please enter an id',
    'Please provide a valid url' => 'Please provide a valid url',
    'The file should be an image' => 'The file should be an image',
    'The message is too short|The message is too short' => 'The message is too short|The message is too short',
    'The password fields must match.' => 'The password fields must match.',
    'You must set the default locale at least for the translation fields' => 'You must set the default locale at least for the translation fields',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
  ),
  'VichUploaderBundle' => 
  array (
    'download' => 'Download',
    'form.label.delete' => 'Delete?',
  ),
  'FOSUserBundle' => 
  array (
    'group.edit.submit' => 'Update group',
    'group.show.name' => 'Group name',
    'group.new.submit' => 'Create group',
    'group.flash.updated' => 'The group has been updated.',
    'group.flash.created' => 'The group has been created.',
    'group.flash.deleted' => 'The group has been deleted.',
    'security.login.username' => 'Username',
    'security.login.password' => 'Password',
    'security.login.remember_me' => 'Remember me',
    'security.login.submit' => 'Log in',
    'profile.show.username' => 'Username',
    'profile.show.email' => 'Email',
    'profile.edit.submit' => 'Update',
    'profile.flash.updated' => 'The profile has been updated.',
    'change_password.submit' => 'Change password',
    'change_password.flash.success' => 'The password has been changed.',
    'registration.check_email' => 'An email has been sent to %email%. It contains an activation link you must click to activate your account.
',
    'registration.confirmed' => 'Congrats %username%, your account is now activated.',
    'registration.back' => 'Back to the originating page.',
    'registration.submit' => 'Register',
    'registration.flash.user_created' => 'The user has been created successfully.',
    'registration.email.subject' => 'Welcome %username%!',
    'registration.email.message' => 'Hello %username%!

To finish activating your account - please click on the following link %confirmationUrl%

This link can only be used once to validate your account.

Regards,
the Team.
',
    'resetting.check_email' => 'An email has been sent. It contains a link you must click to reset your password.
Note: You can only request a new password once within %tokenLifetime% hours.

If you don\'t get an email check your spam folder or try again.
',
    'resetting.request.username' => 'Username or email address',
    'resetting.request.submit' => 'Reset password',
    'resetting.reset.submit' => 'Change password',
    'resetting.flash.success' => 'The password has been reset successfully.',
    'resetting.email.subject' => 'Reset Password',
    'resetting.email.message' => 'Hello %username%!

To reset your password - please visit %confirmationUrl%

Regards,
the Team.
',
    'layout.logout' => 'Log out',
    'layout.login' => 'Log in',
    'layout.register' => 'Register',
    'layout.logged_in_as' => 'Logged in as %username%',
    'form.group_name' => 'Group name',
    'form.username' => 'Username',
    'form.email' => 'Email',
    'form.current_password' => 'Current password',
    'form.password' => 'Password',
    'form.password_confirmation' => 'Repeat password',
    'form.new_password' => 'New password',
    'form.new_password_confirmation' => 'Repeat new password',
    'Password' => 'Password',
    'Privacy policy' => 'Privacy policy',
    'Terms of service' => 'Terms of service',
    'Welcome' => 'Welcome',
  ),
  'HWIOAuthBundle' => 
  array (
    'header.connecting' => 'Connecting',
    'header.success' => 'Successfully connected the account "%name%"!',
    'header.register' => 'Register with the account "%name%"',
    'header.registration_success' => 'Successfully registered and connected the account "%username%"!',
    'connect.confirm.cancel' => 'Cancel',
    'connect.confirm.submit' => 'Connect account',
    'connect.confirm.text' => 'Are you sure that you want to connect your %service% account "%name%" to your current account?',
    'connect.registration.cancel' => 'Cancel',
    'connect.registration.submit' => 'Register account',
  ),
  'time' => 
  array (
    'diff.ago.year' => '1 year ago|%count% years ago',
    'diff.ago.month' => '1 month ago|%count% months ago',
    'diff.ago.day' => '1 day ago|%count% days ago',
    'diff.ago.hour' => '1 hour ago|%count% hours ago',
    'diff.ago.minute' => '1 minute ago|%count% minutes ago',
    'diff.ago.second' => '1 second ago|%count% seconds ago',
    'diff.empty' => 'now',
    'diff.in.second' => 'in 1 second|in %count% seconds',
    'diff.in.hour' => 'in 1 hour|in %count% hours',
    'diff.in.minute' => 'in 1 minute|in %count% minutes',
    'diff.in.day' => 'in 1 day|in %count% days',
    'diff.in.month' => 'in 1 month|in %count% months',
    'diff.in.year' => 'in 1 year|in %count% years',
  ),
  'FOSCommentBundle' => 
  array (
    'fos_comment_comment_new_headline_first' => 'You are the first to comment !',
    'fos_comment_comment_new_headline' => 'Add a new comment',
    'fos_comment_comment_new_submit' => 'Save',
    'fos_comment_comment_new_cancel' => 'Cancel',
    'fos_comment_comment_edit_submit' => 'Save',
    'fos_comment_comment_edit_cancel' => 'Cancel',
    'fos_comment_comment_reply_reply_to' => 'Reply',
    'fos_comment_comment_reply_cancel' => 'Cancel',
    'fos_comment_comment_show_by' => 'By',
    'fos_comment_comment_show_voteup' => 'Vote up',
    'fos_comment_comment_show_votedown' => 'Vote down',
    'fos_comment_comment_show_reply' => 'Reply',
    'fos_comment_comment_vote_score' => 'Vote',
    'fos_comment_comment_tree_load_more' => 'Load More Replies',
    'fos_comment_rss_feed' => 'RSS Feed',
    'fos_comment_thread_close' => 'Close thread',
    'fos_comment_thread_open' => 'Open thread',
    'fos_comment_thread_comment_count' => 'Comments',
    'fos_comment_comment_edit' => 'Edit',
    'fos_comment_comment_delete' => 'Delete',
    'fos_comment_comment_undelete' => 'Comment undeleted',
    'fos_comment_comment_deleted' => 'Comment deleted',
  ),
  'PayumBundle' => 
  array (
    'form.credit_card.holder' => 'Holder Name',
    'form.credit_card.expire_at' => 'Expiration Date',
    'form.credit_card.number' => 'Card Number',
    'form.credit_card.security_code' => 'Security (CVV) Code',
    'form.choice.paypal_express_checkout' => 'Paypal Express Checkout',
  ),
  'messages' => 
  array (
    'coresphere_console.headline.index' => 'Console',
    'coresphere_console.working_directory' => 'Working directory',
    'coresphere_console.environment' => 'Environment',
    'coresphere_console.welcome_message' => 'Type %command% to get a list of all commands.',
    'coresphere_console.loading' => 'Loading...',
    'coresphere_console.suggestion_head' => 'Did you mean:',
    'coresphere_console.empty_response' => 'Complete!',
    '%cartElementsCount% event(s) currently in cart' => '%cartElementsCount% event(s) currently in cart',
    '%mins% left before tickets are released' => '%mins% left before tickets are released',
    '%resultsCount% attendee(s) found' => '%resultsCount% attendee(s) found',
    '%resultsCount% event date(s) found' => '%resultsCount% event date(s) found',
    '%resultsCount% event(s)' => '%resultsCount% event(s)',
    '%resultsCount% event(s) currently on sale' => '%resultsCount% event(s) currently on sale',
    '%resultsCount% event(s) found' => '%resultsCount% event(s) found',
    '%resultsCount% post(s) found' => '%resultsCount% post(s) found',
    '%resultsCount% result(s) found' => '%resultsCount% result(s) found',
    '%resultsCount% results found' => '%resultsCount% results found',
    '%resultsCount% reviews(s) found' => '%resultsCount% reviews(s) found',
    '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets' => '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets',
    '%websiteName% is undergoing a scheduled maintenance.' => '%websiteName% is undergoing a scheduled maintenance.',
    1 => '1',
    '1 star' => '1 star',
    10 => '10',
    11 => '11',
    12 => '12',
    13 => '13',
    14 => '14',
    15 => '15',
    2 => '2',
    '2 stars' => '2 stars',
    3 => '3',
    '3 stars' => '3 stars',
    4 => '4',
    '4 stars' => '4 stars',
    5 => '5',
    '5 stars' => '5 stars',
    6 => '6',
    7 => '7',
    8 => '8',
    9 => '9',
    'A payout can not be requested on a free event date' => 'A payout can not be requested on a free event date',
    'A payout can only be requested after at least one online successful sale' => 'A payout can only be requested after at least one online successful sale',
    'A payout is already requested for this event date' => 'A payout is already requested for this event date',
    'About the organizer' => 'About the organizer',
    'About us' => 'About us',
    'Absatz' => 'Absatz',
    'Access denied' => 'Access denied',
    'Access granted' => 'Access granted',
    'Access is denied. You may not have the appropriate permissions to access this resource.' => 'Access is denied. You may not have the appropriate permissions to access this resource.',
    'Account' => 'Account',
    'Account information' => 'Account information',
    'Account settings' => 'Account settings',
    'Account status' => 'Account status',
    'Actions' => 'Actions',
    'Active attendees' => 'Active attendees',
    'Active organizers' => 'Active organizers',
    'Add a blog post' => 'Add a blog post',
    'Add a help center article' => 'Add a help center article',
    'Add a new amenity' => 'Add a new amenity',
    'Add a new audience' => 'Add a new audience',
    'Add a new blog post' => 'Add a new blog post',
    'Add a new blog post category' => 'Add a new blog post category',
    'Add a new category' => 'Add a new category',
    'Add a new country' => 'Add a new country',
    'Add a new currency' => 'Add a new currency',
    'Add a new event' => 'Add a new event',
    'Add a new help center article' => 'Add a new help center article',
    'Add a new help center category' => 'Add a new help center category',
    'Add a new language' => 'Add a new language',
    'Add a new page' => 'Add a new page',
    'Add a new payment gateway' => 'Add a new payment gateway',
    'Add a new point of sale' => 'Add a new point of sale',
    'Add a new scanner' => 'Add a new scanner',
    'Add a new venue' => 'Add a new venue',
    'Add a new venue type' => 'Add a new venue type',
    'Add events to your favorites by clicking the heart button' => 'Add events to your favorites by clicking the heart button',
    'Add other images that represent your event to be displayed as a gallery' => 'Add other images that represent your event to be displayed as a gallery',
    'Add to calendar' => 'Add to calendar',
    'Add to cart' => 'Add to cart',
    'Add to favorites' => 'Add to favorites',
    'Add your review' => 'Add your review',
    'Add your review for %eventname%' => 'Add your review for %eventname%',
    'Added to favorites by' => 'Added to favorites by',
    'Additional note' => 'Additional note',
    'Address' => 'Address',
    'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment' => 'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment',
    'All' => 'All',
    'All categories' => 'All categories',
    'All event dates for an organizer' => 'All event dates for an organizer',
    'All orders for an organizer' => 'All orders for an organizer',
    'All payout requests for an organizer' => 'All payout requests for an organizer',
    'Allow Paypal as a payout method for the organizers to receive their revenue' => 'Allow Paypal as a payout method for the organizers to receive their revenue',
    'Allow Stripe as a payout method for the organizers to receive their revenue' => 'Allow Stripe as a payout method for the organizers to receive their revenue',
    'Allow attendees to leave reviews' => 'Allow attendees to leave reviews',
    'Allow tap to check in on the scanner app' => 'Allow tap to check in on the scanner app',
    'Already have an account?' => 'Already have an account?',
    'Alternative date and time format' => 'Alternative date and time format',
    'Amenities' => 'Amenities',
    'Amount' => 'Amount',
    'An error has occured' => 'An error has occured',
    'An error has occured while processing your request' => 'An error has occured while processing your request',
    'An error might occur if the command execution time reaches your PHP max_execution_time directive' => 'An error might occur if the command execution time reaches your PHP max_execution_time directive',
    'Anweisungen' => 'Anweisungen',
    'Anything' => 'Anything',
    'Anytime' => 'Anytime',
    'Anywhere' => 'Anywhere',
    'App Debugging' => 'App Debugging',
    'App Environment' => 'App Environment',
    'App Secret' => 'App Secret',
    'Application layout' => 'Application layout',
    'Application theme' => 'Application theme',
    'Approve' => 'Approve',
    'Approved' => 'Approved',
    'Are you ready to take your' => 'Are you ready to take your',
    'Article details' => 'Article details',
    'Articles' => 'Articles',
    'Articles count' => 'Articles count',
    'Artists' => 'Artists',
    'Assigned events' => 'Assigned events',
    'Attendance' => 'Attendance',
    'Attendee' => 'Attendee',
    'Attendee / POS' => 'Attendee / POS',
    'Attendee Name / Email' => 'Attendee Name / Email',
    'Attendee Registration' => 'Attendee Registration',
    'Attendee information' => 'Attendee information',
    'Attendee name or email, ticket reference, order reference' => 'Attendee name or email, ticket reference, order reference',
    'Attendee status' => 'Attendee status',
    'Attendee tickets' => 'Attendee tickets',
    'Attendees' => 'Attendees',
    'Attendees Check In' => 'Attendees Check In',
    'Attendees check-in' => 'Attendees check-in',
    'Attendees list' => 'Attendees list',
    'Attendees reviews' => 'Attendees reviews',
    'Attendees summary' => 'Attendees summary',
    'Audience' => 'Audience',
    'Audiences' => 'Audiences',
    'Authentification Pages' => 'Authentication Pages',
    'Authorized' => 'Authorized',
    'Automatically canceled before deletion' => 'Automatically canceled before deletion',
    'Availability' => 'Availability',
    'Available languages' => 'Available languages',
    'Availibility' => 'Availibility',
    'Avatar' => 'Avatar',
    'Awaiting payment' => 'Awaiting payment',
    'Beschreibung' => 'Beschreibung',
    'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button' => 'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button',
    'Best regards, the %website_name% team' => 'Best regards, the %website_name% team',
    'Billing information' => 'Billing information',
    'Birthdate' => 'Birthdate',
    'Blog' => 'Blog',
    'Blog Pages' => 'Blog Pages',
    'Blog page' => 'Blog page',
    'Blog post' => 'Blog post',
    'Blog posts count' => 'Blog posts count',
    'Blog settings' => 'Blog settings',
    'Bought on' => 'Bought on',
    'Bought tickets' => 'Bought tickets',
    'Browse events' => 'Browse events',
    'Buy more tickets' => 'Buy more tickets',
    'Buy tickets' => 'Buy tickets',
    'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.' => 'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.',
    'By clicking the Sign Up button, I agree to' => 'By clicking the Sign Up button, I agree to',
    'CCY' => 'CCY',
    'Cancel' => 'Cancel',
    'Canceled' => 'Canceled',
    'Captured' => 'Captured',
    'Cart' => 'Cart',
    'Cart elements' => 'Cart elements',
    'Cash / Check / Bank Transfer / Other' => 'Cash / Check / Bank Transfer / Other',
    'Cash / Check / Offline' => 'Cash / Check / Offline',
    'Categories' => 'Categories',
    'Categories page' => 'Categories page',
    'Category' => 'Category',
    'Ccy' => 'Ccy',
    'Change password' => 'Change password',
    'Check In' => 'Check In',
    'Check In Attendees for this event date' => 'Check In Attendees for this event date',
    'Check your email inbox' => 'Check your email inbox',
    'Checked In At' => 'Checked In At',
    'Checked In Only' => 'Checked In Only',
    'Checkout' => 'Checkout',
    'Checkout settings' => 'Checkout settings',
    'Choose a new image to replace the old one' => 'Choose a new image to replace the old one',
    'Choose a payment gateway' => 'Choose a payment gateway',
    'Choose the link destination page' => 'Choose the link destination page',
    'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )' => 'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )',
    'City' => 'City',
    'Clear the application cache for the development environment' => 'Clear the application cache for the development environment',
    'Clear the application cache for the production environment' => 'Clear the application cache for the production environment',
    'Click here' => 'Click here',
    'Click on a date to view tickets' => 'Click on a date to view tickets',
    'Close' => 'Close',
    'Compact' => 'Compact',
    'Configuration' => 'Configuration',
    'Confirm' => 'Confirm',
    'Confirm account' => 'Confirm account',
    'Confirm payment and place order' => 'Confirm payment and place order',
    'Confirm payout request' => 'Confirm payout request',
    'Confirmation required' => 'Confirmation required',
    'Console' => 'Console',
    'Contact' => 'Contact',
    'Contact & Social media' => 'Contact & Social media',
    'Contact Us' => 'Contact Us',
    'Contact address' => 'Contact address',
    'Contact email' => 'Contact email',
    'Contact email address' => 'Contact email address',
    'Contact fax' => 'Contact fax',
    'Contact information' => 'Contact information',
    'Contact phone' => 'Contact phone',
    'Contact phone number' => 'Contact phone number',
    'Contact the attendee' => 'Contact the attendee',
    'Contact the organizer' => 'Contact the organizer',
    'Contact us' => 'Contact us',
    'Contenido' => 'Contenido',
    'Content' => 'Content',
    'Contente' => 'Contente',
    'Contenu' => 'Contenu',
    'Cookie policy' => 'Cookie policy',
    'Cookie policy page slug' => 'Cookie policy page slug',
    'Copyright' => 'Copyright',
    'Count' => 'Count',
    'Countries' => 'Countries',
    'Country' => 'Country',
    'Country code' => 'Country code',
    'Cover photo' => 'Cover photo',
    'Cover picture' => 'Cover picture',
    'Create Account' => 'Create Account',
    'Create an account' => 'Create an account',
    'Create event' => 'Create event',
    'Create my event' => 'Create my event',
    'Created by organizer' => 'Created by organizer',
    'Creation date' => 'Creation date',
    'Creation date / Last login' => 'Creation date / Last login',
    'Credit or debit card' => 'Credit or debit card',
    'Currency' => 'Currency',
    'Currency symbol' => 'Currency symbol',
    'Currency symbol position' => 'Currency symbol position',
    'Currently in cart' => 'Currently in cart',
    'Custom css' => 'Custom css',
    'Custom hero' => 'Custom hero',
    'Custom hero background image' => 'Custom hero background image',
    'Custom hero title and paragraph translation' => 'Custom hero title and paragraph translation',
    'Custom link' => 'Custom link',
    'Dark' => 'Dark',
    'Dark blue' => 'Dark blue',
    'Dashboard' => 'Dashboard',
    'Dashboard Pages' => 'Dashboard Pages',
    'Date' => 'Date',
    'Date and time format' => 'Date and time format',
    'Date only format' => 'Date only format',
    'Dates' => 'Dates',
    'Default language' => 'Default language',
    'Delete' => 'Delete',
    'Delete permanently' => 'Delete permanently',
    'Deleted' => 'Deleted',
    'Deletion date' => 'Deletion date',
    'Descripción' => 'Descripción',
    'Description' => 'Description',
    'Descrição' => 'Descrição',
    'Details' => 'Details',
    'Development' => 'Development',
    'Development environment is used for development purposes only' => 'Development environment is used for development purposes only',
    'Disable' => 'Disable',
    'Disabled' => 'Disabled',
    'Disabled only' => 'Disabled only',
    'Display itinerary bicycling' => 'Display itinerary bicycling',
    'Display itinerary driving' => 'Display itinerary driving',
    'Display itinerary on public transportation' => 'Display itinerary on public transportation',
    'Display itinerary walking' => 'Display itinerary walking',
    'Display top 4 featured categories (footer section menu only)' => 'Display top 4 featured categories (footer section menu only)',
    'Disqus comments' => 'Disqus comments',
    'Disqus subdomain' => 'Disqus subdomain',
    'Draft' => 'Draft',
    'Draft only' => 'Draft only',
    'Early bird, General admission, VIP...' => 'Early bird, General admission, VIP...',
    'Edit' => 'Edit',
    'Edit the menu' => 'Edit the menu',
    'Edit your organizer profile' => 'Edit your organizer profile',
    'Editing the title after the event is saved won\'t change the event url' => 'Editing the title after the event is saved won\'t change the event url',
    'Elapsed only' => 'Elapsed only',
    'Elements' => 'Elements',
    'Email' => 'Email',
    'Email address' => 'Email address',
    'Empty cart' => 'Empty cart',
    'En cabeza' => 'En cabeza',
    'En-tête' => 'En-tête',
    'Enable' => 'Enable',
    'Enable Facebook Social Login' => 'Enable Facebook Social Login',
    'Enable Google Repatcha' => 'Enable Google Repatcha',
    'Enable Google Social Login' => 'Enable Google Social Login',
    'Enable comments' => 'Enable comments',
    'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file' => 'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file',
    'Enable newsletter' => 'Enable newsletter',
    'Enable reviews' => 'Enable reviews',
    'Enable sales for this event date ?' => 'Enable sales for this event date ?',
    'Enable sales for this ticket ?' => 'Enable sales for this ticket ?',
    'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request' => 'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request',
    'Enabled' => 'Enabled',
    'Enabled only' => 'Enabled only',
    'Enabling sales for an event date does not affect the tickets individual sale status' => 'Enabling sales for an event date does not affect the tickets individual sale status',
    'Encryption' => 'Encryption',
    'End date' => 'End date',
    'Ends On' => 'Ends On',
    'Enlarge' => 'Enlarge',
    'Enter the chosen primary color code (i.e #ffffff)' => 'Enter the chosen primary color code (i.e #ffffff)',
    'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)' => 'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)',
    'Enter the email address to be reached for inquiries' => 'Enter the email address to be reached for inquiries',
    'Enter the full website url' => 'Enter the full website url',
    'Enter the list of artists that will perform in your event (press Enter after each entry)' => 'Enter the list of artists that will perform in your event (press Enter after each entry)',
    'Enter the phone number to be called for inquiries' => 'Enter the phone number to be called for inquiries',
    'Enter the website url without http nor https' => 'Enter the website url without http nor https',
    'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle',
    'Error' => 'Error',
    'Etiquetas' => 'Etiquetas',
    'Event' => 'Event',
    'Event / Ticket' => 'Event / Ticket',
    'Event Categories' => 'Event Categories',
    'Event already started' => 'Event already started',
    'Event categories' => 'Event categories',
    'Event date' => 'Event date',
    'Event date is disabled' => 'Event date is disabled',
    'Event date status' => 'Event date status',
    'Event dates' => 'Event dates',
    'Event details' => 'Event details',
    'Event is not published' => 'Event is not published',
    'Event list' => 'Event list',
    'Event ticket' => 'Event ticket',
    'Event ticket is disabled' => 'Event ticket is disabled',
    'Event ticket status' => 'Event ticket status',
    'Event tickets' => 'Event tickets',
    'Event views' => 'Event views',
    'Events' => 'Events',
    'Events Pages' => 'Events Pages',
    'Events RSS feed' => 'Events RSS feed',
    'Events added' => 'Events added',
    'Events count' => 'Events count',
    'Events in %countryname%' => 'Events in %countryname%',
    'Events list' => 'Events list',
    'Events list page' => 'Events list page',
    'Events list page settings' => 'Events list page settings',
    'Events on sale' => 'Events on sale',
    'Events page' => 'Events page',
    'Events slider' => 'Events slider',
    'Events summary' => 'Events summary',
    'Execute Symfony commands' => 'Execute Symfony commands',
    'Execute command' => 'Execute command',
    'Execute this command after editing a file in the application source code or after modifying a string in the translations files' => 'Execute this command after editing a file in the application source code or after modifying a string in the translations files',
    'Execute this command if you are in the development mode and the modifications you applied in the application did take effect' => 'Execute this command if you are in the development mode and the modifications you applied in the application did take effect',
    'Explore' => 'Explore',
    'Explore events' => 'Explore events',
    'Export attendees list to a PDF file' => 'Export attendees list to a PDF file',
    'Export current orders to a CSV file' => 'Export current orders to a CSV file',
    'Export current orders to an Excel file' => 'Export current orders to an Excel file',
    'External link' => 'External link',
    'FAQ' => 'FAQ',
    'Facebook' => 'Facebook',
    'Facebook Id' => 'Facebook Id',
    'Facebook Secret' => 'Facebook Secret',
    'Facebook app id' => 'Facebook app id',
    'Facebook comments' => 'Facebook comments',
    'Facebook profile picture' => 'Facebook profile picture',
    'Facebook url' => 'Facebook url',
    'Failed' => 'Failed',
    'Favicon' => 'Favicon',
    'Favorites' => 'Favorites',
    'Fax' => 'Fax',
    'Featured' => 'Featured',
    'Featured categories' => 'Featured categories',
    'Featured only' => 'Featured only',
    'Featured order' => 'Featured order',
    'Fees' => 'Fees',
    'Fees & Taxes' => 'Fees & Taxes',
    'First Name' => 'First Name',
    'First name' => 'First name',
    'Flag' => 'Flag',
    'Fluid' => 'Fluid',
    'Follow' => 'Follow',
    'Followed by' => 'Followed by',
    'Followers' => 'Followers',
    'Following' => 'Following',
    'Food and beverage' => 'Food and beverage',
    'Food and beverage details' => 'Food and beverage details',
    'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it' => 'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it',
    'Forbidden' => 'Forbidden',
    'Forgot your password ?' => 'Forgot your password ?',
    'Free' => 'Free',
    'Free events only' => 'Free events only',
    'From date' => 'From date',
    'Full name' => 'Full name',
    'GDPR compliance' => 'GDPR compliance',
    'Gallery' => 'Gallery',
    'Gallery image' => 'Gallery image',
    'Gdpr compliance page slug' => 'Gdpr compliance page slug',
    'Gender' => 'Gender',
    'General information' => 'General information',
    'Generation date' => 'Generation date',
    'Global payment settings' => 'Global payment settings',
    'Gmail' => 'Gmail',
    'Go back' => 'Go back',
    'Go to the Pages section in the settings to add a new page' => 'Go to the Pages section in the settings to add a new page',
    'Go to the documentation to get help about getting a list id' => 'Go to the documentation to get help about getting a list id',
    'Go to the documentation to get help about getting an api key' => 'Go to the documentation to get help about getting an api key',
    'Go to the documentation to get help about getting an app ID' => 'Go to the documentation to get help about getting an app ID',
    'Go to the documentation to get help about setting up Disqus' => 'Go to the documentation to get help about setting up Disqus',
    'Google Id' => 'Google Id',
    'Google Maps' => 'Google Maps',
    'Google Maps Api Key' => 'Google Maps Api Key',
    'Google Maps settings' => 'Google Maps settings',
    'Google Plus' => 'Google Plus',
    'Google Recaptcha' => 'Google Recaptcha',
    'Google Recaptcha settings' => 'Google Recaptcha settings',
    'Google Secret' => 'Google Secret',
    'Google analytics Tracking ID' => 'Google analytics Tracking ID',
    'Google analytics code' => 'Google analytics code',
    'Google plus' => 'Google plus',
    'Green' => 'Green',
    'Gross Sales' => 'Gross Sales',
    'Gross sales' => 'Gross sales',
    'Gross sales by channel' => 'Gross sales by channel',
    'Gross sales per Point of sale' => 'Gross sales per Point of sale',
    'Guests' => 'Guests',
    'Header' => 'Header',
    'Header text' => 'Header text',
    'Help Center Article' => 'Help Center Article',
    'Help Center Category' => 'Help Center Category',
    'Help Center Pages' => 'Help Center Pages',
    'Help Center page' => 'Help Center page',
    'Help center' => 'Help center',
    'Here are the details' => 'Here are the details',
    'Hey' => 'Hey',
    'Hidden' => 'Hidden',
    'Hidden only' => 'Hidden only',
    'Hide' => 'Hide',
    'Hide from public directory' => 'Hide from public directory',
    'Hide slider' => 'Hide slider',
    'Home' => 'Home',
    'Homepage' => 'Homepage',
    'Homepage content settings' => 'Homepage content settings',
    'Homepage hero settings' => 'Homepage hero settings',
    'Homepage settings' => 'Homepage settings',
    'Host' => 'Host',
    'How can we help?' => 'How can we help?',
    'How it works' => 'How it works',
    'Icon' => 'Icon',
    'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M' => 'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M',
    'If you need to send the confirmation email to a different email address, you can change it before submitting' => 'If you need to send the confirmation email to a different email address, you can change it before submitting',
    'If your event has a dedicated website, enter its url here' => 'If your event has a dedicated website, enter its url here',
    'If your event is a movie for example, select the available subtitles' => 'If your event is a movie for example, select the available subtitles',
    'If your event is a movie for example, select the year of release' => 'If your event is a movie for example, select the year of release',
    'Image' => 'Image',
    'Images' => 'Images',
    'Images gallery' => 'Images gallery',
    'Impersonate' => 'Impersonate',
    'In' => 'In',
    'In deinen Gedanken' => 'In deinen Gedanken',
    'Information not provided' => 'Information not provided',
    'Information provided' => 'Information provided',
    'Inhalt' => 'Inhalt',
    'Insert at least 3 characters' => 'Insert at least 3 characters',
    'Instagram' => 'Instagram',
    'Instagram url' => 'Instagram url',
    'Instrucciones' => 'Instrucciones',
    'Instructions' => 'Instructions',
    'Instruções' => 'Instruções',
    'Invalid credentials' => 'Invalid credentials',
    'Is featured' => 'Is featured',
    'Is featured on the homepage slider?' => 'Is featured on the homepage slider?',
    'Is this event date online ?' => 'Is this event date online ?',
    'Is this ticket free ?' => 'Is this ticket free ?',
    'It wasn\'t possible to retrieve information about the provided IP' => 'It wasn\'t possible to retrieve information about the provided IP',
    'Keyword' => 'Keyword',
    'Language' => 'Language',
    'Language code' => 'Language code',
    'Languages' => 'Languages',
    'Last Name' => 'Last Name',
    'Last login' => 'Last login',
    'Last name' => 'Last name',
    'Last updated' => 'Last updated',
    'Lastest blog posts' => 'Lastest blog posts',
    'Layout settings' => 'Layout settings',
    'Layout, parameters and SEO' => 'Layout, parameters and SEO',
    'Leave a review' => 'Leave a review',
    'Leave api key empty to disable google maps project wide' => 'Leave api key empty to disable google maps project wide',
    'Leave the password empty to keep the old one' => 'Leave the password empty to keep the old one',
    'Left' => 'Left',
    'Let the other attendee know more details about your experience' => 'Let the other attendee know more details about your experience',
    'Light blue' => 'Light blue',
    'Link' => 'Link',
    'Link Text' => 'Link Text',
    'Link text' => 'Link text',
    'LinkedIn' => 'LinkedIn',
    'Linkedin' => 'Linkedin',
    'List on public directory' => 'List on public directory',
    'Listed on directory' => 'Listed on directory',
    'Listed on the directory' => 'Listed on the directory',
    'Load more' => 'Load more',
    'Loading...' => 'Loading...',
    'Local events only' => 'Local events only',
    'Location' => 'Location',
    'Locked (Payout request approved)' => 'Locked (Payout request approved)',
    'Locked (Payout request pending)' => 'Locked (Payout request pending)',
    'Login' => 'Login',
    'Logo' => 'Logo',
    'Looking for' => 'Looking for',
    'Mail server' => 'Mail server',
    'Mail server settings' => 'Mail server settings',
    'Mail server test email' => 'Mail server test email',
    'Mailchimp app id' => 'Mailchimp app id',
    'Mailchimp list id' => 'Mailchimp list id',
    'Main blog post image' => 'Main blog post image',
    'Main categories' => 'Main categories',
    'Main event image' => 'Main event image',
    'Main image' => 'Main image',
    'Maintenance mode' => 'Maintenance mode',
    'Maintenance mode custom message' => 'Maintenance mode custom message',
    'Make sure that the added payment gateways are configured to support this currency' => 'Make sure that the added payment gateways are configured to support this currency',
    'Make sure that the currency setting of your payout method matches the one currently used which is %currency%' => 'Make sure that the currency setting of your payout method matches the one currently used which is %currency%',
    'Make sure to enter a valid email address' => 'Make sure to enter a valid email address',
    'Make sure to select organizers who have added a cover photo' => 'Make sure to select organizers who have added a cover photo',
    'Make sure to select right category to let the users find it quickly' => 'Make sure to select right category to let the users find it quickly',
    'Manage amenities' => 'Manage amenities',
    'Manage articles' => 'Manage articles',
    'Manage attendees' => 'Manage attendees',
    'Manage audiences' => 'Manage audiences',
    'Manage blog' => 'Manage blog',
    'Manage blog post categories' => 'Manage blog post categories',
    'Manage blog posts' => 'Manage blog posts',
    'Manage categories' => 'Manage categories',
    'Manage countries' => 'Manage countries',
    'Manage currencies' => 'Manage currencies',
    'Manage event' => 'Manage event',
    'Manage events' => 'Manage events',
    'Manage help center' => 'Manage help center',
    'Manage help center articles' => 'Manage help center articles',
    'Manage help center categories' => 'Manage help center categories',
    'Manage languages' => 'Manage languages',
    'Manage menus' => 'Manage menus',
    'Manage orders' => 'Manage orders',
    'Manage pages' => 'Manage pages',
    'Manage posts' => 'Manage posts',
    'Manage reviews' => 'Manage reviews',
    'Manage users' => 'Manage users',
    'Manage venues' => 'Manage venues',
    'Manage venues amenities' => 'Manage venues amenities',
    'Manage venues types' => 'Manage venues types',
    'Manage website translation' => 'Manage website translation',
    'Mark as featured' => 'Mark as featured',
    'Mark as not featured' => 'Mark as not featured',
    'Max' => 'Max',
    'Member since' => 'Member since',
    'Menu elements' => 'Menu elements',
    'Menu name' => 'Menu name',
    'Menus' => 'Menus',
    'Menus settings' => 'Menus settings',
    'Menüname' => 'Menüname',
    'Message' => 'Message',
    'Message from the attendee:' => 'Message from the attendee:',
    'Method Not Supported' => 'Method Not Supported',
    'Min' => 'Min',
    'More details' => 'More details',
    'More information' => 'More information',
    'Mots clés' => 'Mots clés',
    'My Account' => 'My Account',
    'My cart' => 'My cart',
    'My events' => 'My events',
    'My favorites' => 'My favorites',
    'My orders' => 'My orders',
    'My organizer profile' => 'My organizer profile',
    'My points of sale' => 'My points of sale',
    'My review' => 'My review',
    'My reviews' => 'My reviews',
    'My scanners' => 'My scanners',
    'My tickets' => 'My tickets',
    'My venues' => 'My venues',
    'N/A' => 'N/A',
    'Na sua mente' => 'Na sua mente',
    'Name' => 'Name',
    'Name / Username' => 'Name / Username',
    'Native comments' => 'Native comments',
    'Neighborhoods' => 'Neighborhoods',
    'Net sales' => 'Net sales',
    'Net sales until' => 'Net sales until',
    'New' => 'New',
    'New message regarding the order' => 'New message regarding the order',
    'New payout request' => 'New payout request',
    'New quote request' => 'New quote request',
    'Newsletter' => 'Newsletter',
    'Newsletter settings' => 'Newsletter settings',
    'Next month' => 'Next month',
    'Next week' => 'Next week',
    'No' => 'No',
    'No amenites found' => 'No amenites found',
    'No articles found' => 'No articles found',
    'No attendees found' => 'No attendees found',
    'No audiences found' => 'No audiences found',
    'No blog post categories found' => 'No blog post categories found',
    'No blog posts found' => 'No blog posts found',
    'No categories found' => 'No categories found',
    'No countries found' => 'No countries found',
    'No currencies found' => 'No currencies found',
    'No event dates found' => 'No event dates found',
    'No events found' => 'No events found',
    'No events on sale' => 'No events on sale',
    'No events on sale for now' => 'No events on sale for now',
    'No languages found' => 'No languages found',
    'No link, display featured categories dropdown on hover (header menu only)' => 'No link, display featured categories dropdown on hover (header menu only)',
    'No menus found' => 'No menus found',
    'No orders found' => 'No orders found',
    'No orders found to be included in the report' => 'No orders found to be included in the report',
    'No pages found' => 'No pages found',
    'No past events found' => 'No past events found',
    'No payment gateways are currently enabled' => 'No payment gateways are currently enabled',
    'No payment gateways found' => 'No payment gateways found',
    'No payout requests found' => 'No payout requests found',
    'No points of sale found' => 'No points of sale found',
    'No reply email address' => 'No reply email address',
    'No results found' => 'No results found',
    'No review found' => 'No review found',
    'No reviews found' => 'No reviews found',
    'No sales yet' => 'No sales yet',
    'No scanners found' => 'No scanners found',
    'No ticket on sale' => 'No ticket on sale',
    'No tickets found' => 'No tickets found',
    'No tickets selected to add to cart' => 'No tickets selected to add to cart',
    'No users found' => 'No users found',
    'No venue types found' => 'No venue types found',
    'No venues found' => 'No venues found',
    'Nom' => 'Nom',
    'Nom du menu' => 'Nom du menu',
    'Nombre' => 'Nombre',
    'Nombre du menú' => 'Nombre du menú',
    'Nome' => 'Nome',
    'Nome do menu' => 'Nome do menu',
    'None' => 'None',
    'Not Checked In Only' => 'Not Checked In Only',
    'Not a member yet ?' => 'Not a member yet ?',
    'Not elapsed only' => 'Not elapsed only',
    'Not featured' => 'Not featured',
    'Not listed on the directory' => 'Not listed on the directory',
    'Note' => 'Note',
    'Number of blog posts per page' => 'Number of blog posts per page',
    'Number of blog posts to show' => 'Number of blog posts to show',
    'Number of events per page' => 'Number of events per page',
    'Number of events to show' => 'Number of events to show',
    'Number of featured categories to show' => 'Number of featured categories to show',
    'Number of guests' => 'Number of guests',
    'Number of seconds before the reserved tickets are released if the order is still awaiting payment' => 'Number of seconds before the reserved tickets are released if the order is still awaiting payment',
    'Number of tickets' => 'Number of tickets',
    'OR' => 'OR',
    'On sale' => 'On sale',
    'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed' => 'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed',
    'Online' => 'Online',
    'Online events only' => 'Online events only',
    'Optional attendee information' => 'Optional attendee information',
    'Optionally add a cover photo to showcase your organizer activities' => 'Optionally add a cover photo to showcase your organizer activities',
    'Orange' => 'Orange',
    'Order' => 'Order',
    'Order =' => 'Order',
    'Order = ' => 'Order = ',
    'Order Date' => 'Order Date',
    'Order confirmation' => 'Order confirmation',
    'Order date' => 'Order date',
    'Order details' => 'Order details',
    'Order of appearance' => 'Order of appearance',
    'Order payment details' => 'Order payment details',
    'Order reference' => 'Order reference',
    'Order status' => 'Order status',
    'Order summary' => 'Order summary',
    'Order total' => 'Order total',
    'Orders' => 'Orders',
    'Orders placed' => 'Orders placed',
    'Orders summary' => 'Orders summary',
    'Organizer' => 'Organizer',
    'Organizer / Event / Date / Ticket' => 'Organizer / Event / Date / Ticket',
    'Organizer Profile' => 'Organizer Profile',
    'Organizer Registration' => 'Organizer Registration',
    'Organizer information' => 'Organizer information',
    'Organizer is disabled' => 'Organizer is disabled',
    'Organizer logo' => 'Organizer logo',
    'Organizer name' => 'Organizer name',
    'Organizer profile' => 'Organizer profile',
    'Organizer revenue from %website_name%' => 'Organizer revenue from %website_name%',
    'Organizers' => 'Organizers',
    'Organizers Pages' => 'Organizers Pages',
    'Organizers slider' => 'Organizers slider',
    'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry' => 'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry',
    'Other events by %organizername%' => 'Other events by %organizername%',
    'PERMANENTLY' => 'PERMANENTLY',
    'POS' => 'POS',
    'Page content' => 'Page content',
    'Page not found' => 'Page not found',
    'Pages' => 'Pages',
    'Paid' => 'Paid',
    'Paid orders' => 'Paid orders',
    'Palabras clave' => 'Palabras clave',
    'Palavras-chave' => 'Palavras-chave',
    'Paragraph' => 'Paragraph',
    'Paragraphe' => 'Paragraphe',
    'Parent' => 'Parent',
    'Parent category' => 'Parent category',
    'Parágrafo' => 'Parágrafo',
    'Password' => 'Password',
    'Password Resetting' => 'Password Resetting',
    'Past events' => 'Past events',
    'Past tickets' => 'Past tickets',
    'Pay now' => 'Pay now',
    'Payment' => 'Payment',
    'Payment details' => 'Payment details',
    'Payment gateways' => 'Payment gateways',
    'Payment method' => 'Payment method',
    'Payment of tickets purchased on %website_name%' => 'Payment of tickets purchased on %website_name%',
    'Payment settings' => 'Payment settings',
    'Payments and Fees' => 'Payments and Fees',
    'Payout already requested' => 'Payout already requested',
    'Payout method' => 'Payout method',
    'Payout methods' => 'Payout methods',
    'Payout request' => 'Payout request',
    'Payout request details' => 'Payout request details',
    'Payout request notification' => 'Payout request notification',
    'Payout request payment details' => 'Payout request payment details',
    'Payout requests' => 'Payout requests',
    'Payouts' => 'Payouts',
    'Paypal Client Id' => 'Paypal Client Id',
    'Paypal Client Secret' => 'Paypal Client Secret',
    'Paypal Express Checkout' => 'Paypal Express Checkout',
    'Pending' => 'Pending',
    'Pending payout requests' => 'Pending payout requests',
    'Percentage cut' => 'Percentage cut',
    'Phone' => 'Phone',
    'Phone number' => 'Phone number',
    'Photos' => 'Photos',
    'Pick a date' => 'Pick a date',
    'Pink' => 'Pink',
    'Please choose a 200x200 minimum image size as it is required by Facebook' => 'Please choose a 200x200 minimum image size as it is required by Facebook',
    'Please choose a 200x50 image size to ensure compatibility with the website design' => 'Please choose a 200x50 image size to ensure compatibility with the website design',
    'Please choose a 200x50 image to ensure compatibility with the website design' => 'Please choose a 200x50 image to ensure compatibility with the website design',
    'Please click on the following link to check the status of your request' => 'Please click on the following link to check the status of your request',
    'Please confirm your account by clicking the link below' => 'Please confirm your account by clicking the link below',
    'Please enter the selected payment gateway details' => 'Please enter the selected payment gateway details',
    'Please enter the subject carefully in order get the help you need' => 'Please enter the subject carefully in order get the help you need',
    'Please enter your payout method details' => 'Please enter your payout method details',
    'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle',
    'Please refer to this following list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217' => 'Please refer to thefollowing list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217',
    'Please select the tickets quantity for this order' => 'Please select the tickets quantity for this order',
    'Please select the tickets quantity you want to buy' => 'Please select the tickets quantity you want to buy',
    'Please set a payout method before submitting a payout request' => 'Please set a payout method before submitting a payout request',
    'Please wait a few seconds if the translation interface freezes at page load' => 'Please wait a few seconds if the translation interface freezes at page load',
    'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor' => 'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor',
    'Point of sale' => 'Point of sale',
    'Point of sale information' => 'Point of sale information',
    'Point of sales' => 'Point of sales',
    'Points of sale' => 'Points of sale',
    'Popular' => 'Popular',
    'Popularity' => 'Popularity',
    'Port' => 'Port',
    'Position' => 'Position',
    'Postal code' => 'Postal code',
    'Posts' => 'Posts',
    'Price' => 'Price',
    'Pricing' => 'Pricing',
    'Pricing and fees' => 'Pricing and fees',
    'Primary color code' => 'Primary color code',
    'Print tickets' => 'Print tickets',
    'Privacy policy' => 'Privacy policy',
    'Privacy policy page slug' => 'Privacy policy page slug',
    'Processed' => 'Processed',
    'Processed at' => 'Processed at',
    'Processing date' => 'Processing date',
    'Production' => 'Production',
    'Profile picture' => 'Profile picture',
    'Profile views' => 'Profile views',
    'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string' => 'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string',
    'Promotional price' => 'Promotional price',
    'Publicly show attendees' => 'Publicly show attendees',
    'Publish' => 'Publish',
    'Published events' => 'Published events',
    'Published only' => 'Published only',
    'Purple' => 'Purple',
    'Párrafo' => 'Párrafo',
    'Quantity' => 'Quantity',
    'Rating' => 'Rating',
    'Read more' => 'Read more',
    'Read time in minutes' => 'Read time in minutes',
    'Recent orders' => 'Recent orders',
    'Red' => 'Red',
    'Reference' => 'Reference',
    'Refund' => 'Refund',
    'Refund requested' => 'Refund requested',
    'Refunded' => 'Refunded',
    'Register' => 'Register',
    'Register attendees' => 'Register attendees',
    'Registered using Facebook' => 'Registered using Facebook',
    'Registered using Google' => 'Registered using Google',
    'Registration date' => 'Registration date',
    'Related posts' => 'Related posts',
    'Remove' => 'Remove',
    'Remove from favorites' => 'Remove from favorites',
    'Repeat password' => 'Repeat password',
    'Reports' => 'Reports',
    'Request a quote' => 'Request a quote',
    'Request date' => 'Request date',
    'Request payout' => 'Request payout',
    'Requested at' => 'Requested at',
    'Resend confirmation email' => 'Resend confirmation email',
    'Reset' => 'Reset',
    'Reset your password' => 'Reset your password',
    'Response' => 'Response',
    'Restore' => 'Restore',
    'Return to cart' => 'Return to cart',
    'Review date' => 'Review date',
    'Review(s)' => 'Review(s)',
    'Reviews' => 'Reviews',
    'Reviews for %eventname%' => 'Reviews for %eventname%',
    'Right' => 'Right',
    'Role' => 'Role',
    'SEO keywords' => 'SEO keywords',
    'SMTP' => 'SMTP',
    'SSL' => 'SSL',
    'SSL must be activated on your hosting server in order to use Mailchimp' => 'SSL must be activated on your hosting server in order to use Mailchimp',
    'Sale didn\'t start yet' => 'Sale didn\'t start yet',
    'Sale ended' => 'Sale ended',
    'Sale ends On' => 'Sale ends On',
    'Sale starts On' => 'Sale starts On',
    'Sales' => 'Sales',
    'Sales channel' => 'Sales channel',
    'Sales end' => 'Sales end',
    'Sales end date' => 'Sales end date',
    'Sales end in' => 'Sales end in',
    'Sales ended' => 'Sales ended',
    'Sales ended on' => 'Sales ended on',
    'Sales start date' => 'Sales start date',
    'Sales start in' => 'Sales start in',
    'Sales started' => 'Sales started',
    'Sales started on' => 'Sales started on',
    'Sandbox' => 'Sandbox',
    'Save' => 'Save',
    'Save order' => 'Save order',
    'Scanned tickets' => 'Scanned tickets',
    'Scanner' => 'Scanner',
    'Scanner App' => 'Scanner App',
    'Scanner App settings' => 'Scanner App settings',
    'Scanner information' => 'Scanner information',
    'Scanners' => 'Scanners',
    'Schlüsselwörter' => 'Schlüsselwörter',
    'Search' => 'Search',
    'Search blog' => 'Search blog',
    'Search blog posts' => 'Search blog posts',
    'Search for answers' => 'Search for answers',
    'Search for events' => 'Search for events',
    'Search help center' => 'Search help center',
    'Search in reviews' => 'Search in reviews',
    'Searching ...' => 'Searching ...',
    'Seated' => 'Seated',
    'Seated guests' => 'Seated guests',
    'Seated guests number' => 'Seated guests number',
    'Secret key' => 'Secret key',
    'See all' => 'See all',
    'See all %reviewscount% reviews' => 'See all %reviewscount% reviews',
    'See all categories' => 'See all categories',
    'See all events on sale' => 'See all events on sale',
    'See more articles' => 'See more articles',
    'See more events' => 'See more events',
    'Select a payout method' => 'Select a payout method',
    'Select a specific event date' => 'Select a specific event date',
    'Select a specific event ticket' => 'Select a specific event ticket',
    'Select an option' => 'Select an option',
    'Select parent of \'Point of sale\' or \'Scanner\'' => 'Select parent of \'Point of sale\' or \'Scanner\'',
    'Select the audience types that are targeted in your event' => 'Select the audience types that are targeted in your event',
    'Select the categories that represent your events types' => 'Select the categories that represent your events types',
    'Select the country that your event represents (ie: A movie\'s country of production)' => 'Select the country that your event represents (ie: A movie\'s country of production)',
    'Select the languages that will be spoken in your event' => 'Select the languages that will be spoken in your event',
    'Select the parent category to add a sub category' => 'Select the parent category to add a sub category',
    'Sell tickets online' => 'Sell tickets online',
    'Send' => 'Send',
    'Send us an email' => 'Send us an email',
    'Sendmail' => 'Sendmail',
    'Set' => 'Set',
    'Set a new password' => 'Set a new password',
    'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)' => 'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)',
    'Set the display order for the featured categories' => 'Set the display order for the featured categories',
    'Set the number of tickets that an attendee can buy for this ticket type' => 'Set the number of tickets that an attendee can buy for this ticket type',
    'Set the parent category to add a subcategory' => 'Set the parent category to add a subcategory',
    'Set your %payoutMethodName% payout method' => 'Set your %payoutMethodName% payout method',
    'Settings' => 'Settings',
    'Share' => 'Share',
    'Show' => 'Show',
    'Show RSS feed button' => 'Show RSS feed button',
    'Show a map at the bottom of your organizer profile page containing the venues you added' => 'Show a map at the bottom of your organizer profile page containing the venues you added',
    'Show audience filter' => 'Show audience filter',
    'Show calendar button' => 'Show calendar button',
    'Show category filter' => 'Show category filter',
    'Show date filter' => 'Show date filter',
    'Show event date stats on the scanner app' => 'Show event date stats on the scanner app',
    'Show event dates and tickets' => 'Show event dates and tickets',
    'Show events calendar' => 'Show events calendar',
    'Show events on map' => 'Show events on map',
    'Show followers' => 'Show followers',
    'Show location filter' => 'Show location filter',
    'Show map button' => 'Show map button',
    'Show reviews' => 'Show reviews',
    'Show the GDPR compliance page link' => 'Show the GDPR compliance page link',
    'Show the attendees number and list in the event page' => 'Show the attendees number and list in the event page',
    'Show the back to top button' => 'Show the back to top button',
    'Show the call to action block' => 'Show the call to action block',
    'Show the cookie policy bar at the bottom' => 'Show the cookie policy bar at the bottom',
    'Show the cookie policy page link' => 'Show the cookie policy page link',
    'Show the homepage hero seach box' => 'Show the homepage hero seach box',
    'Show the map along with the address on the venue page and event page' => 'Show the map along with the address on the venue page and event page',
    'Show the number and list of people that follow you' => 'Show the number and list of people that follow you',
    'Show the privacy policy page link' => 'Show the privacy policy page link',
    'Show the quote form on the venue page' => 'Show the quote form on the venue page',
    'Show the reviews that you received for your events' => 'Show the reviews that you received for your events',
    'Show the search box' => 'Show the search box',
    'Show the terms of service page link' => 'Show the terms of service page link',
    'Show ticket price filter' => 'Show ticket price filter',
    'Show tickets left count on cart modal' => 'Show tickets left count on cart modal',
    'Show venues map' => 'Show venues map',
    'Sign in' => 'Sign in',
    'Sign in via Facebook' => 'Sign in via Facebook',
    'Sign in via Google' => 'Sign in via Google',
    'Sign in via Twitter' => 'Sign in via Twitter',
    'Sign out' => 'Sign out',
    'Sign up' => 'Sign up',
    'Sign up via Facebook' => 'Sign up via Facebook',
    'Sign up via Google' => 'Sign up via Google',
    'Sign up via Twitter' => 'Sign up via Twitter',
    'Similar events' => 'Similar events',
    'Site key' => 'Site key',
    'Sitemap' => 'Sitemap',
    'Slug' => 'Slug',
    'Social Login' => 'Social Login',
    'Social Login settings' => 'Social Login settings',
    'Social media share image' => 'Social media share image',
    'Sold out' => 'Sold out',
    'Sort by' => 'Sort by',
    'Standing' => 'Standing',
    'Standing guests' => 'Standing guests',
    'Standing guests number' => 'Standing guests number',
    'Start date' => 'Start date',
    'Starts On' => 'Starts On',
    'State' => 'State',
    'State / City' => 'State / City',
    'Static Pages' => 'Static Pages',
    'Static pages settings' => 'Static pages settings',
    'Statistics' => 'Statistics',
    'Status' => 'Status',
    'Stick' => 'Stick',
    'Still in cart' => 'Still in cart',
    'Street' => 'Street',
    'Street 2' => 'Street 2',
    'Street address' => 'Street address',
    'Street address 2' => 'Street address 2',
    'Stripe Checkout' => 'Stripe Checkout',
    'Stripe Checkout (credit cards)' => 'Stripe Checkout (credit cards)',
    'Stripe payout' => 'Stripe payout',
    'Stripe publishable key' => 'Stripe publishable key',
    'Stripe secret key' => 'Stripe secret key',
    'Subject' => 'Subject',
    'Submit payment' => 'Submit payment',
    'Subscribe' => 'Subscribe',
    'Subscribe to our newsletter' => 'Subscribe to our newsletter',
    'Subtitles' => 'Subtitles',
    'Subtotal' => 'Subtotal',
    'Successfully executed the command' => 'Successfully executed the command',
    'Support for' => 'Support for',
    'Suspended' => 'Suspended',
    'Symbol' => 'Symbol',
    'TLS' => 'TLS',
    'TSL' => 'TSL',
    'Tags' => 'Tags',
    'Take your events to the next level' => 'Take your events to the next level',
    'Tell your attendees more about this ticket type' => 'Tell your attendees more about this ticket type',
    'Terms of service' => 'Terms of service',
    'Terms of service page slug' => 'Terms of service page slug',
    'Test the mail server configuration' => 'Test the mail server configuration',
    'Texte du lien' => 'Texte du lien',
    'Texto del enlace' => 'Texto del enlace',
    'Texto do link' => 'Texto do link',
    'The amenity can not be deleted because it is linked with one or more venues' => 'The amenity can not be deleted because it is linked with one or more venues',
    'The amenity can not be found' => 'The amenity can not be found',
    'The amenity has been deleted' => 'The amenity has been deleted',
    'The amenity has been disabled' => 'The amenity has been disabled',
    'The amenity has been succesfully restored' => 'The amenity has been succesfully restored',
    'The amenity has been successfully created' => 'The amenity has been successfully created',
    'The amenity has been successfully updated' => 'The amenity has been successfully updated',
    'The amenity is hidden' => 'The amenity is hidden',
    'The amenity is visible' => 'The amenity is visible',
    'The article can not be found' => 'The article can not be found',
    'The article has been deleted' => 'The article has been deleted',
    'The article has been disabled' => 'The article has been disabled',
    'The article has been succesfully restored' => 'The article has been succesfully restored',
    'The article has been successfully created' => 'The article has been successfully created',
    'The article has been successfully updated' => 'The article has been successfully updated',
    'The article is featured' => 'The article is featured',
    'The article is hidden' => 'The article is hidden',
    'The article is not featured anymore' => 'The article is not featured anymore',
    'The article is visible' => 'The article is visible',
    'The article not be found' => 'The article not be found',
    'The audience can not be deleted because it is linked with one or more events' => 'The audience can not be deleted because it is linked with one or more events',
    'The audience can not be found' => 'The audience can not be found',
    'The audience has been deleted' => 'The audience has been deleted',
    'The audience has been disabled' => 'The audience has been disabled',
    'The audience has been succesfully restored' => 'The audience has been succesfully restored',
    'The audience has been successfully created' => 'The audience has been successfully created',
    'The audience has been successfully updated' => 'The audience has been successfully updated',
    'The audience is hidden' => 'The audience is hidden',
    'The audience is visible' => 'The audience is visible',
    'The blog post can not be found' => 'The blog post can not be found',
    'The blog post category can not be deleted because it is linked with one or more blog posts' => 'The blog post category can not be deleted because it is linked with one or more blog posts',
    'The blog post category can not be found' => 'The blog post category can not be found',
    'The blog post category has been deleted' => 'The blog post category has been deleted',
    'The blog post category has been disabled' => 'The blog post category has been disabled',
    'The blog post category has been succesfully restored' => 'The blog post category has been succesfully restored',
    'The blog post category has been successfully created' => 'The blog post category has been successfully created',
    'The blog post category has been successfully updated' => 'The blog post category has been successfully updated',
    'The blog post category is hidden' => 'The blog post category is hidden',
    'The blog post category is visible' => 'The blog post category is visible',
    'The blog post has been deleted' => 'The blog post has been deleted',
    'The blog post has been disabled' => 'The blog post has been disabled',
    'The blog post has been succesfully restored' => 'The blog post has been succesfully restored',
    'The blog post has been successfully created' => 'The blog post has been successfully created',
    'The blog post has been successfully updated' => 'The blog post has been successfully updated',
    'The blog post is hidden' => 'The blog post is hidden',
    'The blog post is visible' => 'The blog post is visible',
    'The blog post not be found' => 'The blog post not be found',
    'The category can not be deleted because it is linked with one or more events' => 'The category can not be deleted because it is linked with one or more events',
    'The category can not be deleted because it is linked with one or more help center articles' => 'The category can not be deleted because it is linked with one or more help center articles',
    'The category can not be found' => 'The category can not be found',
    'The category has been deleted' => 'The category has been deleted',
    'The category has been disabled' => 'The category has been disabled',
    'The category has been succesfully restored' => 'The category has been succesfully restored',
    'The category has been successfully created' => 'The category has been successfully created',
    'The category has been successfully updated' => 'The category has been successfully updated',
    'The category is featured and is shown in the homepage categories' => 'The category is featured and is shown in the homepage categories',
    'The category is hidden' => 'The category is hidden',
    'The category is not featured anymore and is removed from the homepage categories' => 'The category is not featured anymore and is removed from the homepage categories',
    'The category is visible' => 'The category is visible',
    'The category not be found' => 'The category not be found',
    'The category was not found' => 'The category was not found',
    'The confirmation email has been resent to' => 'The confirmation email has been resent to',
    'The country can not be deleted because it is linked with one or more events' => 'The country can not be deleted because it is linked with one or more events',
    'The country can not be found' => 'The country can not be found',
    'The country has been deleted' => 'The country has been deleted',
    'The country has been disabled' => 'The country has been disabled',
    'The country has been succesfully restored' => 'The country has been succesfully restored',
    'The country has been successfully created' => 'The country has been successfully created',
    'The country has been successfully updated' => 'The country has been successfully updated',
    'The country is hidden' => 'The country is hidden',
    'The country is visible' => 'The country is visible',
    'The currency can not be found' => 'The currency can not be found',
    'The currency has been deleted' => 'The currency has been deleted',
    'The currency has been successfully created' => 'The currency has been successfully created',
    'The currency has been successfully updated' => 'The currency has been successfully updated',
    'The default locale must be selected in the available languages' => 'The default locale must be selected in the available languages',
    'The email address is not valid' => 'The email address is not valid',
    'The email could not be sent' => 'The email could not be sent',
    'The event can not be deleted because it has one or more orders' => 'The event can not be deleted because it has one or more orders',
    'The event can not be found' => 'The event can not be found',
    'The event date can not be found' => 'The event date can not be found',
    'The event date stats (sales and attendance) will be visible on the scanner app' => 'The event date stats (sales and attendance) will be visible on the scanner app',
    'The event has been added to your favorites' => 'The event has been added to your favorites',
    'The event has been deleted' => 'The event has been deleted',
    'The event has been deleted permanently' => 'The event has been deleted permanently',
    'The event has been published and will figure in the search results' => 'The event has been published and will figure in the search results',
    'The event has been removed from your favorites' => 'The event has been removed from your favorites',
    'The event has been succesfully restored' => 'The event has been succesfully restored',
    'The event has been successfully created' => 'The event has been successfully created',
    'The event has been successfully updated' => 'The event has been successfully updated',
    'The event has been unpublished and will not be included in the search results' => 'The event has been unpublished and will not be included in the search results',
    'The event not be found' => 'The event not be found',
    'The event ticket can not be found' => 'The event ticket can not be found',
    'The fields preceded with a red * are mandatory' => 'The fields preceded with a red * are mandatory',
    'The form contains invalid data' => 'The form contains invalid data',
    'The homepage settings can not be loaded' => 'The homepage settings can not be loaded',
    'The homepage settings could not be loaded' => 'The homepage settings could not be loaded',
    'The language can not be deleted because it is linked with one or more events' => 'The language can not be deleted because it is linked with one or more events',
    'The language can not be found' => 'The language can not be found',
    'The language has been deleted' => 'The language has been deleted',
    'The language has been disabled' => 'The language has been disabled',
    'The language has been succesfully restored' => 'The language has been succesfully restored',
    'The language has been successfully created' => 'The language has been successfully created',
    'The language has been successfully updated' => 'The language has been successfully updated',
    'The language is hidden' => 'The language is hidden',
    'The language is visible' => 'The language is visible',
    'The layout settings could not be loaded' => 'The layout settings could not be loaded',
    'The menu can not be found' => 'The menu can not be found',
    'The menu has been successfully updated' => 'The menu has been successfully updated',
    'The order can not be found' => 'The order can not be found',
    'The order has been deleted' => 'The order has been deleted',
    'The order has been permanently canceled' => 'The order has been permanently canceled',
    'The order has been permanently deleted' => 'The order has been permanently deleted',
    'The order has been soft deleted, restore it before canceling it' => 'The order has been soft deleted, restore it before canceling it',
    'The order has been succesfully restored' => 'The order has been succesfully restored',
    'The order has been successfully validated' => 'The order has been successfully validated',
    'The order status must be paid or awaiting payment' => 'The order status must be paid or awaiting payment',
    'The organizer can not be found' => 'The organizer can not be found',
    'The organizer not be found' => 'The organizer not be found',
    'The organizer revenue from this event date is currently zero' => 'The organizer revenue from this event date is currently zero',
    'The page can not be found' => 'The page can not be found',
    'The page has been deleted' => 'The page has been deleted',
    'The page has been successfully created' => 'The page has been successfully created',
    'The page has been successfully updated' => 'The page has been successfully updated',
    'The payment can not be found' => 'The payment can not be found',
    'The payment gateway can not be found' => 'The payment gateway can not be found',
    'The payment gateway has been successfully created' => 'The payment gateway has been successfully created',
    'The payment gateway has been successfully updated' => 'The payment gateway has been successfully updated',
    'The payout method can not be found' => 'The payout method can not be found',
    'The payout method has been successfully created' => 'The payout method has been successfully created',
    'The payout method has been successfully updated' => 'The payout method has been successfully updated',
    'The payout method is unset' => 'The payout method is unset',
    'The payout request can not be canceled because it is already processed' => 'The payout request can not be canceled because it is already processed',
    'The payout request can not be found' => 'The payout request can not be found',
    'The payout request can not be processed at this moment' => 'The payout request can not be processed at this moment',
    'The payout request has been already processed' => 'The payout request has been already processed',
    'The payout request has been deleted' => 'The payout request has been deleted',
    'The payout request has been permanently canceled' => 'The payout request has been permanently canceled',
    'The payout request has been permanently deleted' => 'The payout request has been permanently deleted',
    'The payout request has been soft deleted, restore it before canceling it' => 'The payout request has been soft deleted, restore it before canceling it',
    'The payout request has been soft deleted, restore it before viewing the details' => 'The payout request has been soft deleted, restore it before viewing the details',
    'The payout request has been succesfully restored' => 'The payout request has been succesfully restored',
    'The payout request has been successfully processed' => 'The payout request has been successfully processed',
    'The payout request has been successfully submitted, you will be notified by email once it is processed' => 'The payout request has been successfully submitted, you will be notified by email once it is processed',
    'The point of sale can not be found' => 'The point of sale can not be found',
    'The point of sale has been deleted' => 'The point of sale has been deleted',
    'The point of sale has been disabled' => 'The point of sale has been disabled',
    'The point of sale has been enabled' => 'The point of sale has been enabled',
    'The point of sale has been permenently deleted' => 'The point of sale has been permenently deleted',
    'The point of sale has been successfully created' => 'The point of sale has been successfully created',
    'The point of sale has been successfully updated' => 'The point of sale has been successfully updated',
    'The refund could not been processed at this moment' => 'The refund could not been processed at this moment',
    'The refund has already been reclined' => 'The refund has already been reclined',
    'The refund has been declined' => 'The refund has been declined',
    'The refund has been successfully processed' => 'The refund has been successfully processed',
    'The refund request has already been processed or no refund has been requested' => 'The refund request has already been processed or no refund has been requested',
    'The request method is known by the server but is not supported by the target resource' => 'The request method is known by the server but is not supported by the target resource',
    'The requested page couldn\'t be located. Checkout for any URL misspelling or' => 'The requested page couldn\'t be located. Checkout for any URL misspelling or',
    'The review can not be found' => 'The review can not be found',
    'The review has been deleted' => 'The review has been deleted',
    'The review has been deleted permanently' => 'The review has been deleted permanently',
    'The review has been enabled' => 'The review has been enabled',
    'The review has been hidden' => 'The review has been hidden',
    'The review has been succesfully restored' => 'The review has been succesfully restored',
    'The scanner account is disabled by the organizer' => 'The scanner account is disabled by the organizer',
    'The scanner can not be found' => 'The scanner can not be found',
    'The scanner has been disabled' => 'The scanner has been disabled',
    'The scanner has been enabled' => 'The scanner has been enabled',
    'The scanner has been permenently deleted' => 'The scanner has been permenently deleted',
    'The scanner has been successfully created' => 'The scanner has been successfully created',
    'The scanner has been successfully updated' => 'The scanner has been successfully updated',
    'The settings have been updated' => 'The settings have been updated',
    'The space' => 'The space',
    'The test email has been sent, please check the inbox of' => 'The test email has been sent, please check the inbox of',
    'The ticket can not be found' => 'The ticket can not be found',
    'The ticket has already been scanned' => 'The ticket has already been scanned',
    'The ticket has been successfully scanned' => 'The ticket has been successfully scanned',
    'The ticket is not valid for this event date' => 'The ticket is not valid for this event date',
    'The ticket was already scanned at' => 'The ticket was already scanned at',
    'The tickets has been successfully added to your cart' => 'The tickets has been successfully added to your cart',
    'The tickets have been released' => 'The tickets have been released',
    'The user can not be found' => 'The user can not be found',
    'The user cart has been emptied' => 'The user cart has been emptied',
    'The user has been deleted' => 'The user has been deleted',
    'The user has been disabled' => 'The user has been disabled',
    'The user has been enabled' => 'The user has been enabled',
    'The user has been permanently deleted' => 'The user has been permanently deleted',
    'The user has been succesfully restored' => 'The user has been succesfully restored',
    'The username already exists' => 'The username already exists',
    'The venue can not be deleted because it is linked with one or more events' => 'The venue can not be deleted because it is linked with one or more events',
    'The venue can not be found' => 'The venue can not be found',
    'The venue has been deleted' => 'The venue has been deleted',
    'The venue has been disabled' => 'The venue has been disabled',
    'The venue has been succesfully restored' => 'The venue has been succesfully restored',
    'The venue has been successfully created' => 'The venue has been successfully created',
    'The venue has been successfully updated' => 'The venue has been successfully updated',
    'The venue is hidden' => 'The venue is hidden',
    'The venue is hidden from the public venues directory' => 'The venue is hidden from the public venues directory',
    'The venue is listed on the public venues directory' => 'The venue is listed on the public venues directory',
    'The venue is visible' => 'The venue is visible',
    'The venue type can not be deleted because it is linked with one or more venues' => 'The venue type can not be deleted because it is linked with one or more venues',
    'The venue type can not be found' => 'The venue type can not be found',
    'The venue type has been deleted' => 'The venue type has been deleted',
    'The venue type has been disabled' => 'The venue type has been disabled',
    'The venue type has been succesfully restored' => 'The venue type has been succesfully restored',
    'The venue type has been successfully created' => 'The venue type has been successfully created',
    'The venue type has been successfully updated' => 'The venue type has been successfully updated',
    'The venue type is hidden' => 'The venue type is hidden',
    'The venue type is visible' => 'The venue type is visible',
    'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above' => 'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above',
    'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form' => 'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form',
    'This email address will receive the contact form messages' => 'This email address will receive the contact form messages',
    'This email is sent as a confirmation of your order' => 'This email is sent as a confirmation of your order',
    'This email is sent to test the configuration of the mail server settings.' => 'This email is sent to test the configuration of the mail server settings.',
    'This event date is locked because a payout request has been submitted' => 'This event date is locked because a payout request has been submitted',
    'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)' => 'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)',
    'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders',
    'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations' => 'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations',
    'This link can only be used once to validate your account' => 'This link can only be used once to validate your account',
    'This month' => 'This month',
    'This order has already been refunded' => 'This order has already been refunded',
    'This order is not eligible for refund because it contains tickets from different organizers' => 'This order is not eligible for refund because it contains tickets from different organizers',
    'This order is not eligible for refund because it is not paid' => 'This order is not eligible for refund because it is not paid',
    'This payout method is currently disabled' => 'This payout method is currently disabled',
    'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders' => 'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders',
    'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders' => 'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders',
    'This ticket was scanned at %scanDate%' => 'This ticket was scanned at %scanDate%',
    'This week' => 'This week',
    'This weekend' => 'This weekend',
    'Ticket' => 'Ticket',
    'Ticket description' => 'Ticket description',
    'Ticket fee' => 'Ticket fee',
    'Ticket fee (Online)' => 'Ticket fee (Online)',
    'Ticket fee (Point Of Sale)' => 'Ticket fee (Point Of Sale)',
    'Ticket fees' => 'Ticket fees',
    'Ticket name' => 'Ticket name',
    'Ticket price' => 'Ticket price',
    'Ticket price percentage cut (Online)' => 'Ticket price percentage cut (Online)',
    'Ticket price percentage cut (Point of sale)' => 'Ticket price percentage cut (Point of sale)',
    'Ticket style' => 'Ticket style',
    'Ticket type' => 'Ticket type',
    'Tickets' => 'Tickets',
    'Tickets left' => 'Tickets left',
    'Tickets per attendee' => 'Tickets per attendee',
    'Tickets sales' => 'Tickets sales',
    'Tickets sales by date' => 'Tickets sales by date',
    'Tickets sales this month' => 'Tickets sales this month',
    'Tickets sold' => 'Tickets sold',
    'Tickets sold Per Point of sale' => 'Tickets sold Per Point of sale',
    'Tickets sold by channel' => 'Tickets sold by channel',
    'Tickets types' => 'Tickets types',
    'Time\'s up' => 'Time\'s up',
    'Timeleft' => 'Timeleft',
    'Timezone' => 'Timezone',
    'Titel' => 'Titel',
    'Title' => 'Title',
    'Titre' => 'Titre',
    'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)' => 'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)',
    'To reset your password, click on the following button and follow the instructions' => 'To reset your password, click on the following button and follow the instructions',
    'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event' => 'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event',
    'Today' => 'Today',
    'Toggle display the event date details' => 'Toggle display the event date details',
    'Toggle display the search filters' => 'Toggle display the search filters',
    'Tomorrow' => 'Tomorrow',
    'Total' => 'Total',
    'Total attendees' => 'Total attendees',
    'Total attendees check-in' => 'Total attendees check-in',
    'Total gross sales' => 'Total gross sales',
    'Total orders' => 'Total orders',
    'Total sales' => 'Total sales',
    'Total tickets sales' => 'Total tickets sales',
    'Translation' => 'Translation',
    'Translations' => 'Translations',
    'Transport' => 'Transport',
    'Twitter' => 'Twitter',
    'Twitter url' => 'Twitter url',
    'Type' => 'Type',
    'Título' => 'Título',
    'Unfollow' => 'Unfollow',
    'Unknown' => 'Unknown',
    'Unstick' => 'Unstick',
    'Until date' => 'Until date',
    'Upcoming events' => 'Upcoming events',
    'Upcoming tickets' => 'Upcoming tickets',
    'Update cart' => 'Update cart',
    'Update date' => 'Update date',
    'Update the amenity' => 'Update the amenity',
    'Update the audience' => 'Update the audience',
    'Update the blog post' => 'Update the blog post',
    'Update the blog post category' => 'Update the blog post category',
    'Update the category' => 'Update the category',
    'Update the country' => 'Update the country',
    'Update the currency' => 'Update the currency',
    'Update the event' => 'Update the event',
    'Update the help center article' => 'Update the help center article',
    'Update the help center category' => 'Update the help center category',
    'Update the language' => 'Update the language',
    'Update the lapagenguage' => 'Update the page',
    'Update the payment gateway' => 'Update the payment gateway',
    'Update the point of sale' => 'Update the point of sale',
    'Update the scanner' => 'Update the scanner',
    'Update the venue' => 'Update the venue',
    'Update the venue type' => 'Update the venue type',
    'Update your %payoutMethodName% payout method' => 'Update your %payoutMethodName% payout method',
    'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string' => 'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string',
    'Useful Links' => 'Useful Links',
    'User information' => 'User information',
    'Username' => 'Username',
    'Users' => 'Users',
    'Users summary' => 'Users summary',
    'Uset' => 'Uset',
    'Validate' => 'Validate',
    'Venue' => 'Venue',
    'Venue / Location' => 'Venue / Location',
    'Venue image' => 'Venue image',
    'Venue name...' => 'Venue name...',
    'Venue page' => 'Venue page',
    'Venue page settings' => 'Venue page settings',
    'Venue type' => 'Venue type',
    'Venue types' => 'Venue types',
    'Venues' => 'Venues',
    'Venues Pages' => 'Venues Pages',
    'Venues count' => 'Venues count',
    'Venues page' => 'Venues page',
    'Video' => 'Video',
    'View cart' => 'View cart',
    'View detailed statistics' => 'View detailed statistics',
    'View details' => 'View details',
    'View event' => 'View event',
    'View organizer' => 'View organizer',
    'View stats' => 'View stats',
    'Views' => 'Views',
    'Visible' => 'Visible',
    'Visible only' => 'Visible only',
    'We recommend a 48x48 image' => 'We recommend a 48x48 image',
    'We recommend a 48x48 image size' => 'We recommend a 48x48 image size',
    'We will be back shortly.' => 'We will be back shortly.',
    'Website' => 'Website',
    'Website description' => 'Website description',
    'Website name' => 'Website name',
    'Website root url' => 'Website root url',
    'Website slug' => 'Website slug',
    'Website url' => 'Website url',
    'Welcome' => 'Welcome',
    'What to show in the homepage hero ?' => 'What to show in the homepage hero ?',
    'When' => 'When',
    'Where' => 'Where',
    'Will be show in the homepage, the explore menu item dropdown and in the footer' => 'Will be show in the homepage, the explore menu item dropdown and in the footer',
    'With sales only' => 'With sales only',
    'Without sales only' => 'Without sales only',
    'Year' => 'Year',
    'Yellow' => 'Yellow',
    'Yes' => 'Yes',
    'You are about to approve the payout request' => 'You are about to approve the payout request',
    'You are about to cancel this order (this action cannot be undone)' => 'You are about to cancel this order (this action cannot be undone)',
    'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked' => 'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked',
    'You are about to delete the amenity PERMANENTLY' => 'You are about to delete the amenity PERMANENTLY',
    'You are about to delete the article PERMANENTLY' => 'You are about to delete the article PERMANENTLY',
    'You are about to delete the audience PERMANENTLY' => 'You are about to delete the audience PERMANENTLY',
    'You are about to delete the blog post PERMANENTLY' => 'You are about to delete the blog post PERMANENTLY',
    'You are about to delete the blog post category PERMANENTLY' => 'You are about to delete the blog post category PERMANENTLY',
    'You are about to delete the category PERMANENTLY' => 'You are about to delete the category PERMANENTLY',
    'You are about to delete the country PERMANENTLY' => 'You are about to delete the country PERMANENTLY',
    'You are about to delete the currency PERMANENTLY' => 'You are about to delete the currency PERMANENTLY',
    'You are about to delete the event and all its related information PERMANENTLY' => 'You are about to delete the event and all its related information PERMANENTLY',
    'You are about to delete the language PERMANENTLY' => 'You are about to delete the language PERMANENTLY',
    'You are about to delete the order and all its related information (payment details, tickets...)' => 'You are about to delete the order and all its related information (payment details, tickets...)',
    'You are about to delete the page PERMANENTLY' => 'You are about to delete the page PERMANENTLY',
    'You are about to delete the payout request and all its related information' => 'You are about to delete the payout request and all its related information',
    'You are about to delete the point of sale' => 'You are about to delete the point of sale',
    'You are about to delete the point of sale PERMANENTLY' => 'You are about to delete the point of sale PERMANENTLY',
    'You are about to delete the review PERMANENTLY' => 'You are about to delete the review PERMANENTLY',
    'You are about to delete the scanner' => 'You are about to delete the scanner',
    'You are about to delete the scanner PERMANENTLY' => 'You are about to delete the scanner PERMANENTLY',
    'You are about to delete the user and all its related information (orders, events...) PERMANENTLY' => 'You are about to delete the user and all its related information (orders, events...) PERMANENTLY',
    'You are about to delete the venue PERMANENTLY' => 'You are about to delete the venue PERMANENTLY',
    'You are about to delete the venue type PERMANENTLY' => 'You are about to delete the venue type PERMANENTLY',
    'You are about to empty your cart' => 'You are about to empty your cart',
    'You are about to validate this order, generate the tickets and send a confirmation email to the attendee' => 'You are about to validate this order, generate the tickets and send a confirmation email to the attendee',
    'You are connected as "%username%' => 'You are connected as "%username%',
    'You are following this organizer' => 'You are following this organizer',
    'You are going to this event' => 'You are going to this event',
    'You are logged in as:' => 'You are logged in as:',
    'You are no longer following this organizer' => 'You are no longer following this organizer',
    'You are not following any organizer' => 'You are not following any organizer',
    'You can introduce the event details in multiple locales' => 'You can introduce the event details in multiple locales',
    'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help' => 'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help',
    'You don\'t have permission to access this resource' => 'You don\'t have permission to access this resource',
    'You have added %tickets% ticket(s) to your cart' => 'You have added %tickets% ticket(s) to your cart',
    'You have already bought %tickets% ticket(s)' => 'You have already bought %tickets% ticket(s)',
    'You have already requested a refund for this order' => 'You have already requested a refund for this order',
    'You have already requested a refund for this order and it was approved' => 'You have already requested a refund for this order and it was approved',
    'You have already requested a refund for this order and it was declined' => 'You have already requested a refund for this order and it was declined',
    'You have received a new quote request for the venue' => 'You have received a new quote request for the venue',
    'You have successfully subscribed to our newsletter' => 'You have successfully subscribed to our newsletter',
    'You must choose an event and set the status to paid in order to export attendees list to a PDF file' => 'You must choose an event and set the status to paid in order to export attendees list to a PDF file',
    'You must choose an event in order to export the attendees list' => 'You must choose an event in order to export the attendees list',
    'You must review your cart before proceeding to checkout' => 'You must review your cart before proceeding to checkout',
    'You must set the status to paid in order to export the attendees list' => 'You must set the status to paid in order to export the attendees list',
    'You must specify at least one language' => 'You must specify at least one language',
    'You order is empty' => 'You order is empty',
    'Your account settings have been updated' => 'Your account settings have been updated',
    'Your cart has been automatically updated because one or more event\'s quotas has changed' => 'Your cart has been automatically updated because one or more event\'s quotas has changed',
    'Your cart has been automatically updated because one or more events are no longer on sale' => 'Your cart has been automatically updated because one or more events are no longer on sale',
    'Your cart has been emptied' => 'Your cart has been emptied',
    'Your cart has been updated' => 'Your cart has been updated',
    'Your cart is empty' => 'Your cart is empty',
    'Your email' => 'Your email',
    'Your message has been successfully sent' => 'Your message has been successfully sent',
    'Your order has been automatically canceled because one or more event\'s quotas has changed' => 'Your order has been automatically canceled because one or more event\'s quotas has changed',
    'Your order has been automatically canceled because one or more events are no longer on sale' => 'Your order has been automatically canceled because one or more events are no longer on sale',
    'Your order has been automatically canceled because your ticket reservations has been released' => 'Your order has been automatically canceled because your ticket reservations has been released',
    'Your order has been successfully placed, please proceed to the payment as explained in the instructions' => 'Your order has been successfully placed, please proceed to the payment as explained in the instructions',
    'Your organizer profile has been successfully updated' => 'Your organizer profile has been successfully updated',
    'Your payment could not be processed at this time' => 'Your payment could not be processed at this time',
    'Your payment has been successfully processed' => 'Your payment has been successfully processed',
    'Your payment operation was canceled' => 'Your payment operation was canceled',
    'Your payout request has been processed' => 'Your payout request has been processed',
    'Your quote request has been successfully sent' => 'Your quote request has been successfully sent',
    'Your rating (out of 5 stars)' => 'Your rating (out of 5 stars)',
    'Your refund request has been successfully submitted to the organizer' => 'Your refund request has been successfully submitted to the organizer',
    'Your registration has been successfully processed' => 'Your registration has been successfully processed',
    'Your review has been successfully saved' => 'Your review has been successfully saved',
    'Your review headline' => 'Your review headline',
    'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away' => 'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away',
    'Your tickets bought from' => 'Your tickets bought from',
    'Youtube' => 'Youtube',
    'Youtube url' => 'Youtube url',
    'Youtube video' => 'Youtube video',
    'Youtube video url' => 'Youtube video url',
    'Zip / Postal code' => 'Zip / Postal code',
    'and' => 'and',
    'asc' => 'asc',
    'at' => 'at',
    'checked In' => 'checked In',
    'created at' => 'created at',
    'desc' => 'desc',
    'event to the next level ?' => 'event to the next level ?',
    'for' => 'for',
    'form.label.delete' => 'Delete',
    'form.password' => 'form.password',
    'form.password_confirmation' => 'form.password_confirmation',
    'image(s)' => 'image(s)',
    'left' => 'left',
    'left before tickets are released' => 'left before tickets are released',
    'min read' => 'min read',
    'my points of sale' => 'my points of sale',
    'my scanners' => 'my scanners',
    'my venues' => 'my venues',
    'orders summary' => 'orders summary',
    'out of 5 stars' => 'out of 5 stars',
    'placed on' => 'placed on',
    'return to the homepage' => 'return to the homepage',
    'review' => 'review',
    'right' => 'right',
    'ticket' => 'ticket',
    'ticket(s)' => 'ticket(s)',
    'ticket(s) sold' => 'ticket(s) sold',
    'tickets' => 'tickets',
    'tickets found in your cart' => 'tickets found in your cart',
    'tickets left' => 'tickets left',
    'tickets per attendee' => 'tickets per attendee',
    'title' => 'title',
    'to edit your profile' => 'to edit your profile',
    'to manage this event' => 'to manage this event',
    'to manage your event' => 'to manage your event',
    'to preview your profile' => 'to preview your profile',
    'to return to your dashboard' => 'to return to your dashboard',
    'user(s)' => 'user(s)',
    'view(s)' => 'view(s)',
    'views' => 'views',
    'your payout request has been processed' => 'your payout request has been processed',
    'your tickets are ready to go!' => 'your tickets are ready to go!',
    'اسم' => 'اسم',
    'اسم القائمة' => 'اسم القائمة',
    'التفاصيل' => 'التفاصيل',
    'العلامات' => 'العلامات',
    'الكلمات الرئيسية' => 'الكلمات الرئيسية',
    'تعليمات' => 'تعليمات',
    'عنوان' => 'عنوان',
    'فقرة' => 'فقرة',
    'محتوى' => 'محتوى',
    'نص الرابط' => 'نص الرابط',
    'نص العنوان' => 'نص العنوان',
    '关键字' => '关键字',
    '内容' => '内容',
    '名称' => '名称',
    '描述' => '描述',
    '标签' => '标签',
    '标题' => '标题',
    '段' => '段',
  ),
  'javascript' => 
  array (
    'Add' => 'Add',
    'Add a new event date' => 'Add a new event date',
    'Add a new ticket' => 'Add a new ticket',
    'An error has occured' => 'An error has occured',
    'April' => 'April',
    'August' => 'August',
    'Cancel' => 'Cancel',
    'Close' => 'Close',
    'Confirm' => 'Confirm',
    'Confirmation required' => 'Confirmation required',
    'Day' => 'Day',
    'December' => 'December',
    'Duplicate this event date' => 'Duplicate this event date',
    'Duplicate this ticket' => 'Duplicate this ticket',
    'Email address' => 'Email address',
    'February' => 'February',
    'Insert at least 3 characters' => 'Insert at least 3 characters',
    'January' => 'January',
    'July' => 'July',
    'June' => 'June',
    'Load more' => 'Load more',
    'Loading...' => 'Loading...',
    'Mail server test email' => 'Mail server test email',
    'Make sure to enter a valid email address' => 'Make sure to enter a valid email address',
    'March' => 'March',
    'May' => 'May',
    'Message' => 'Message',
    'Month' => 'Month',
    'Move down' => 'Move down',
    'Move up' => 'Move up',
    'No results found' => 'No results found',
    'Note' => 'Note',
    'November' => 'November',
    'October' => 'October',
    'Please select the tickets quantity for this order' => 'Please select the tickets quantity for this order',
    'Please select the tickets quantity you want to buy' => 'Please select the tickets quantity you want to buy',
    'Read more' => 'Read more',
    'Remove' => 'Remove',
    'Remove this event date' => 'Remove this event date',
    'Remove this ticket' => 'Remove this ticket',
    'Return to cart' => 'Return to cart',
    'Searching ...' => 'Searching ...',
    'Select an option' => 'Select an option',
    'Send' => 'Send',
    'September' => 'September',
    'Stick' => 'Stick',
    'The email address is not valid' => 'The email address is not valid',
    'The tickets have been released' => 'The tickets have been released',
    'This feature is disabled in demo mode' => 'This feature is disabled in demo mode',
    'Time\'s up' => 'Time\'s up',
    'Today' => 'Today',
    'Unstick' => 'Unstick',
    'Week' => 'Week',
    'days' => 'days',
    'days.Fri' => 'Fri',
    'days.Mon' => 'Mon',
    'days.Sat' => 'Sat',
    'days.Sun' => 'Sun',
    'days.Thu' => 'Thu',
    'days.Tue' => 'Tue',
    'days.Wed' => 'Wed',
    'hr' => 'hr',
    'javascript string translation' => 'javascript string translation',
    'min' => 'min',
    'sec' => 'sec',
    'weeks' => 'weeks',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
