<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('fr', array (
  'validators' => 
  array (
    'This value should be false.' => 'Cette valeur doit être fausse.',
    'This value should be true.' => 'Cette valeur doit être vraie.',
    'This value should be of type {{ type }}.' => 'Cette valeur doit être de type {{ type }}.',
    'This value should be blank.' => 'Cette valeur doit être vide.',
    'The value you selected is not a valid choice.' => 'Cette valeur doit être l\'un des choix proposés.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Vous devez sélectionner au moins {{ limit }} choix.|Vous devez sélectionner au moins {{ limit }} choix.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Vous devez sélectionner au maximum {{ limit }} choix.|Vous devez sélectionner au maximum {{ limit }} choix.',
    'One or more of the given values is invalid.' => 'Une ou plusieurs des valeurs soumises sont invalides.',
    'This field was not expected.' => 'Ce champ n\'a pas été prévu.',
    'This field is missing.' => 'Ce champ est manquant.',
    'This value is not a valid date.' => 'Cette valeur n\'est pas une date valide.',
    'This value is not a valid datetime.' => 'Cette valeur n\'est pas une date valide.',
    'This value is not a valid email address.' => 'Cette valeur n\'est pas une adresse email valide.',
    'The file could not be found.' => 'Le fichier n\'a pas été trouvé.',
    'The file is not readable.' => 'Le fichier n\'est pas lisible.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Le fichier est trop volumineux ({{ size }} {{ suffix }}). Sa taille ne doit pas dépasser {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Le type du fichier est invalide ({{ type }}). Les types autorisés sont {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Cette valeur doit être inférieure ou égale à {{ limit }}.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Cette chaîne est trop longue. Elle doit avoir au maximum {{ limit }} caractère.|Cette chaîne est trop longue. Elle doit avoir au maximum {{ limit }} caractères.',
    'This value should be {{ limit }} or more.' => 'Cette valeur doit être supérieure ou égale à {{ limit }}.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Cette chaîne est trop courte. Elle doit avoir au minimum {{ limit }} caractère.|Cette chaîne est trop courte. Elle doit avoir au minimum {{ limit }} caractères.',
    'This value should not be blank.' => 'Cette valeur ne doit pas être vide.',
    'This value should not be null.' => 'Cette valeur ne doit pas être nulle.',
    'This value should be null.' => 'Cette valeur doit être nulle.',
    'This value is not valid.' => 'Cette valeur n\'est pas valide.',
    'This value is not a valid time.' => 'Cette valeur n\'est pas une heure valide.',
    'This value is not a valid URL.' => 'Cette valeur n\'est pas une URL valide.',
    'The two values should be equal.' => 'Les deux valeurs doivent être identiques.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Le fichier est trop volumineux. Sa taille ne doit pas dépasser {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Le fichier est trop volumineux.',
    'The file could not be uploaded.' => 'Le téléchargement de ce fichier est impossible.',
    'This value should be a valid number.' => 'Cette valeur doit être un nombre.',
    'This file is not a valid image.' => 'Ce fichier n\'est pas une image valide.',
    'This is not a valid IP address.' => 'Cette adresse IP n\'est pas valide.',
    'This value is not a valid language.' => 'Cette langue n\'est pas valide.',
    'This value is not a valid locale.' => 'Ce paramètre régional n\'est pas valide.',
    'This value is not a valid country.' => 'Ce pays n\'est pas valide.',
    'This value is already used.' => 'Cette valeur est déjà utilisée.',
    'The size of the image could not be detected.' => 'La taille de l\'image n\'a pas pu être détectée.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'La largeur de l\'image est trop grande ({{ width }}px). La largeur maximale autorisée est de {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'La largeur de l\'image est trop petite ({{ width }}px). La largeur minimale attendue est de {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'La hauteur de l\'image est trop grande ({{ height }}px). La hauteur maximale autorisée est de {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'La hauteur de l\'image est trop petite ({{ height }}px). La hauteur minimale attendue est de {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Cette valeur doit être le mot de passe actuel de l\'utilisateur.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Cette chaîne doit avoir exactement {{ limit }} caractère.|Cette chaîne doit avoir exactement {{ limit }} caractères.',
    'The file was only partially uploaded.' => 'Le fichier a été partiellement transféré.',
    'No file was uploaded.' => 'Aucun fichier n\'a été transféré.',
    'No temporary folder was configured in php.ini.' => 'Aucun répertoire temporaire n\'a été configuré dans le php.ini.',
    'Cannot write temporary file to disk.' => 'Impossible d\'écrire le fichier temporaire sur le disque.',
    'A PHP extension caused the upload to fail.' => 'Une extension PHP a empêché le transfert du fichier.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Cette collection doit contenir {{ limit }} élément ou plus.|Cette collection doit contenir {{ limit }} éléments ou plus.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Cette collection doit contenir {{ limit }} élément ou moins.|Cette collection doit contenir {{ limit }} éléments ou moins.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Cette collection doit contenir exactement {{ limit }} élément.|Cette collection doit contenir exactement {{ limit }} éléments.',
    'Invalid card number.' => 'Numéro de carte invalide.',
    'Unsupported card type or invalid card number.' => 'Type de carte non supporté ou numéro invalide.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Le numéro IBAN (International Bank Account Number) saisi n\'est pas valide.',
    'This value is not a valid ISBN-10.' => 'Cette valeur n\'est pas un code ISBN-10 valide.',
    'This value is not a valid ISBN-13.' => 'Cette valeur n\'est pas un code ISBN-13 valide.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Cette valeur n\'est ni un code ISBN-10, ni un code ISBN-13 valide.',
    'This value is not a valid ISSN.' => 'Cette valeur n\'est pas un code ISSN valide.',
    'This value is not a valid currency.' => 'Cette valeur n\'est pas une devise valide.',
    'This value should be equal to {{ compared_value }}.' => 'Cette valeur doit être égale à {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Cette valeur doit être supérieure à {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Cette valeur doit être supérieure ou égale à {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Cette valeur doit être identique à {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Cette valeur doit être inférieure à {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Cette valeur doit être inférieure ou égale à {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Cette valeur ne doit pas être égale à {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Cette valeur ne doit pas être identique à {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Le rapport largeur/hauteur de l\'image est trop grand ({{ ratio }}). Le rapport maximal autorisé est {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Le rapport largeur/hauteur de l\'image est trop petit ({{ ratio }}). Le rapport minimal attendu est {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'L\'image est carrée ({{ width }}x{{ height }}px). Les images carrées ne sont pas autorisées.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'L\'image est au format paysage ({{ width }}x{{ height }}px). Les images au format paysage ne sont pas autorisées.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'L\'image est au format portrait ({{ width }}x{{ height }}px). Les images au format portrait ne sont pas autorisées.',
    'An empty file is not allowed.' => 'Un fichier vide n\'est pas autorisé.',
    'The host could not be resolved.' => 'Le nom de domaine n\'a pas pu être résolu.',
    'This value does not match the expected {{ charset }} charset.' => 'Cette valeur ne correspond pas au jeu de caractères {{ charset }} attendu.',
    'This is not a valid Business Identifier Code (BIC).' => 'Ce n\'est pas un code universel d\'identification des banques (BIC) valide.',
    'Error' => 'Erreur',
    'This is not a valid UUID.' => 'Ceci n\'est pas un UUID valide.',
    'This value should be a multiple of {{ compared_value }}.' => 'Cette valeur doit être un multiple de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Ce code d\'identification d\'entreprise (BIC) n\'est pas associé à l\'IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Cette valeur doit être un JSON valide.',
    'This collection should contain only unique elements.' => 'Cette collection ne doit pas comporter de doublons.',
    'This value should be positive.' => 'Cette valeur doit être strictement positive.',
    'This value should be either positive or zero.' => 'Cette valeur doit être supérieure ou égale à zéro.',
    'This value should be negative.' => 'Cette valeur doit être strictement négative.',
    'This value should be either negative or zero.' => 'Cette valeur doit être inférieure ou égale à zéro.',
    'This value is not a valid timezone.' => 'Cette valeur n\'est pas un fuseau horaire valide.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Ce mot de passe a été divulgué lors d\'une fuite de données, il ne doit plus être utilisé. Veuillez utiliser un autre mot de passe.',
    'This value should be between {{ min }} and {{ max }}.' => 'Cette valeur doit être comprise entre {{ min }} et {{ max }}.',
    'This value is not a valid hostname.' => 'Cette valeur n\'est pas un nom d\'hôte valide.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Le nombre d\'éléments de cette collection doit être un multiple de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Cette valeur doit satisfaire à au moins une des contraintes suivantes :',
    'Each element of this collection should satisfy its own set of constraints.' => 'Chaque élément de cette collection doit satisfaire à son propre jeu de contraintes.',
    'This form should not contain extra fields.' => 'Ce formulaire ne doit pas contenir des champs supplémentaires.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Le fichier téléchargé est trop volumineux. Merci d\'essayer d\'envoyer un fichier plus petit.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'Le jeton CSRF est invalide. Veuillez renvoyer le formulaire.',
    'fos_user.username.already_used' => 'Le nom d\'utilisateur est déjà utilisé.',
    'fos_user.username.blank' => 'Entrez un nom d\'utilisateur s\'il vous plait.',
    'fos_user.username.short' => 'Le nom d\'utilisateur est trop court.',
    'fos_user.username.long' => 'Le nom d\'utilisateur est trop long.',
    'fos_user.email.already_used' => 'L\'adresse e-mail est déjà utilisée.',
    'fos_user.email.blank' => 'Entrez une adresse e-mail s\'il vous plait.',
    'fos_user.email.short' => 'L\'adresse e-mail est trop courte.',
    'fos_user.email.long' => 'L\'adresse e-mail est trop longue.',
    'fos_user.email.invalid' => 'L\'adresse e-mail est invalide.',
    'fos_user.password.blank' => 'Entrez un mot de passe s\'il vous plait.',
    'fos_user.password.short' => 'Le mot de passe est trop court.',
    'fos_user.password.mismatch' => 'Les deux mots de passe ne sont pas identiques.',
    'fos_user.new_password.blank' => 'Entrez un nouveau mot de passe s\'il vous plait.',
    'fos_user.new_password.short' => 'Le nouveau mot de passe est trop court.',
    'fos_user.current_password.invalid' => 'Le mot de passe est invalide.',
    'fos_user.group.blank' => 'Entrez un nom s\'il vous plait.',
    'fos_user.group.short' => 'Le nom est trop court.',
    'fos_user.group.long' => 'Le nom est trop long.',
    'fos_group.name.already_used' => 'Le nom est déjà utilisé.',
    'This value is not a valid captcha.' => 'Vous devez cocher la case "Je ne suis pas un robot"',
    'The captcha was not resolved on the right domain.' => 'Le captcha est rempli sur un domaine inconnu.',
    'validator.credit_card.invalidDate' => 'La date n\'est pas valide.',
    'Please enter a message' => 'Veuillez saisir un message',
    'Please enter a permalink' => 'Veuillez entrer un lien',
    'Please enter an id' => 'Veuillez saisir un identifiant',
    'Please provide a valid url' => 'Veuillez fournir une URL valide',
    'The file should be an image' => 'Ce fichier doit être une image',
    'The message is too short|The message is too short' => 'Le message est trop court',
    'The password fields must match.' => 'Les mots de passe doivent correspondre.',
    'You must set the default locale at least for the translation fields' => 'Vous devez définir les translations pour au moins la langue par défaut pour les champs de traduction',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Une exception d\'authentification s\'est produite.',
    'Authentication credentials could not be found.' => 'Les identifiants d\'authentification n\'ont pas pu être trouvés.',
    'Authentication request could not be processed due to a system problem.' => 'La requête d\'authentification n\'a pas pu être executée à cause d\'un problème système.',
    'Invalid credentials.' => 'Identifiants invalides.',
    'Cookie has already been used by someone else.' => 'Le cookie a déjà été utilisé par quelqu\'un d\'autre.',
    'Not privileged to request the resource.' => 'Privilèges insuffisants pour accéder à la ressource.',
    'Invalid CSRF token.' => 'Jeton CSRF invalide.',
    'No authentication provider found to support the authentication token.' => 'Aucun fournisseur d\'authentification n\'a été trouvé pour supporter le jeton d\'authentification.',
    'No session available, it either timed out or cookies are not enabled.' => 'Aucune session disponible, celle-ci a expiré ou les cookies ne sont pas activés.',
    'No token could be found.' => 'Aucun jeton n\'a pu être trouvé.',
    'Username could not be found.' => 'Le nom d\'utilisateur n\'a pas pu être trouvé.',
    'Account has expired.' => 'Le compte a expiré.',
    'Credentials have expired.' => 'Les identifiants ont expiré.',
    'Account is disabled.' => 'Le compte est désactivé.',
    'Account is locked.' => 'Le compte est bloqué.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Précédent',
    'label_next' => 'Suivant',
  ),
  'VichUploaderBundle' => 
  array (
    'download' => 'Télécharger',
    'form.label.delete' => 'Supprimer ?',
  ),
  'FOSUserBundle' => 
  array (
    'group.edit.submit' => 'Mettre à jour le groupe',
    'group.show.name' => 'Nom du groupe',
    'group.new.submit' => 'Créer le groupe',
    'group.flash.updated' => 'Le groupe a été mis à jour.',
    'group.flash.created' => 'Le groupe a été créé.',
    'group.flash.deleted' => 'Le groupe a été supprimé.',
    'security.login.username' => 'Nom d\'utilisateur',
    'security.login.password' => 'Mot de passe',
    'security.login.remember_me' => 'Se souvenir de moi',
    'security.login.submit' => 'Connexion',
    'profile.show.username' => 'Nom d\'utilisateur',
    'profile.show.email' => 'Adresse e-mail',
    'profile.edit.submit' => 'Mettre à jour',
    'profile.flash.updated' => 'Le profil a été mis à jour.',
    'change_password.submit' => 'Modifier le mot de passe',
    'change_password.flash.success' => 'Le mot de passe a été modifié.',
    'registration.check_email' => 'Un e-mail a été envoyé à l\'adresse %email%. Il contient un lien d\'activation sur lequel il vous faudra cliquer afin d\'activer votre compte.',
    'registration.confirmed' => 'Félicitations %username%, votre compte est maintenant activé.',
    'registration.back' => 'Retour à la page d\'origine.',
    'registration.submit' => 'Créer un compte',
    'registration.flash.user_created' => 'L\'utilisateur a été créé avec succès.',
    'registration.email.subject' => 'Bienvenue %username% !',
    'registration.email.message' => 'Bonjour %username% !

Pour valider votre compte utilisateur, merci de vous rendre sur %confirmationUrl%

Ce lien ne peut être utilisé qu\'une seule fois pour valider votre compte.

Cordialement,
L\'équipe
',
    'resetting.check_email' => 'Un e-mail a été envoyé. Il contient un lien sur lequel il vous faudra cliquer pour réinitialiser votre mot de passe.
Remarque : Vous ne pouvez demander un nouveau mot de passe que toutes les %tokenLifetime% heures.

Si vous ne recevez pas un email, vérifiez votre dossier spam ou essayez à nouveau.
',
    'resetting.request.username' => 'Nom d\'utilisateur ou adresse e-mail',
    'resetting.request.submit' => 'Réinitialiser le mot de passe',
    'resetting.reset.submit' => 'Modifier le mot de passe',
    'resetting.flash.success' => 'Le mot de passe a été réinitialisé avec succès.',
    'resetting.email.subject' => 'Réinitialisation de votre mot de passe',
    'resetting.email.message' => 'Bonjour %username% !

Pour réinitialiser votre mot de passe, merci de vous rendre sur %confirmationUrl%

Cordialement,
L\'équipe
',
    'layout.logout' => 'Déconnexion',
    'layout.login' => 'Connexion',
    'layout.register' => 'Inscription',
    'layout.logged_in_as' => 'Connecté en tant que %username%',
    'form.group_name' => 'Nom du groupe',
    'form.username' => 'Nom d\'utilisateur',
    'form.email' => 'Adresse e-mail',
    'form.current_password' => 'Mot de passe actuel',
    'form.password' => 'Mot de passe',
    'form.password_confirmation' => 'Répéter le mot de passe',
    'form.new_password' => 'Nouveau mot de passe',
    'form.new_password_confirmation' => 'Répéter le nouveau mot de passe',
    'Password' => 'Mot de passe',
    'Privacy policy' => 'Politique de confidentialité',
    'Terms of service' => 'Conditions d\'utilisation',
    'Welcome' => 'Bienvenu',
  ),
  'HWIOAuthBundle' => 
  array (
    'header.connecting' => 'Connexion en cours',
    'header.success' => 'Connexion réussie avec le compte \'%name%\' !',
    'header.register' => 'S\'inscrire avec le compte \'%name%\'',
    'header.registration_success' => 'Enregistrement et connexion du compte \'%username%\' réussis !',
    'connect.confirm.cancel' => 'Annuler',
    'connect.confirm.submit' => 'Connecter le compte',
    'connect.confirm.text' => 'Êtes-vous sûr de vouloir connecter votre compte %service% avec votre compte \'%name%\' ?',
    'connect.registration.cancel' => 'Annuler',
    'connect.registration.submit' => 'Enregistrer le compte',
  ),
  'time' => 
  array (
    'diff.ago.year' => 'il y a 1 an|il y a %count% ans',
    'diff.ago.month' => 'il y a 1 mois|il y a %count% mois',
    'diff.ago.day' => 'il y a 1 jour|il y a %count% jours',
    'diff.ago.hour' => 'il y a 1 heure|il y a %count% heures',
    'diff.ago.minute' => 'il y a 1 minute|il y a %count% minutes',
    'diff.ago.second' => 'il y a 1 seconde|il y a %count% secondes',
    'diff.empty' => 'maintenant',
    'diff.in.second' => 'dans 1 seconde|dans %count% secondes',
    'diff.in.hour' => 'dans 1 heure|dans %count% heures',
    'diff.in.minute' => 'dans 1 minute|dans %count% minutes',
    'diff.in.day' => 'dans 1 jour|dans %count% jours',
    'diff.in.month' => 'dans 1 mois|dans %count% mois',
    'diff.in.year' => 'dans 1 an|dans %count% ans',
  ),
  'FOSCommentBundle' => 
  array (
    'fos_comment_comment_new_headline_first' => 'Vous êtes le premier à commenter!',
    'fos_comment_comment_new_headline' => 'Ajouter un nouveau commentaire',
    'fos_comment_comment_new_submit' => 'Sauvegarder',
    'fos_comment_comment_new_cancel' => 'Annuler',
    'fos_comment_comment_edit_submit' => 'Sauvegarder',
    'fos_comment_comment_edit_cancel' => 'Annuler',
    'fos_comment_comment_reply_reply_to' => 'Répondre',
    'fos_comment_comment_reply_cancel' => 'Annuler',
    'fos_comment_comment_show_by' => 'Par',
    'fos_comment_comment_show_voteup' => 'J\'aime',
    'fos_comment_comment_show_votedown' => 'Je n\'aime pas',
    'fos_comment_comment_show_reply' => 'Répondre',
    'fos_comment_comment_vote_score' => 'Vote',
    'fos_comment_comment_tree_load_more' => 'Afficher plus de réponses',
    'fos_comment_rss_feed' => 'Flux RSS',
    'fos_comment_thread_close' => 'Fermer le fil de discussion',
    'fos_comment_thread_open' => 'Ouvrir le fil de discussion',
    'fos_comment_thread_comment_count' => 'Commentaires',
    'fos_comment_comment_edit' => 'Éditer',
    'fos_comment_comment_delete' => 'Supprimer',
    'fos_comment_comment_undelete' => 'Commentaire restauré',
    'fos_comment_comment_deleted' => 'Commentaire supprimé',
  ),
  'PayumBundle' => 
  array (
    'form.credit_card.holder' => 'Nom du propriétaire',
    'form.credit_card.expire_at' => 'Date d\'expiration',
    'form.credit_card.number' => 'Numéro de carte',
    'form.credit_card.security_code' => 'Code de sécurité (CVV)',
  ),
  'messages' => 
  array (
    'coresphere_console.headline.index' => 'Console',
    'coresphere_console.working_directory' => 'Répertoire de travail',
    'coresphere_console.environment' => 'Environnement',
    'coresphere_console.welcome_message' => 'Tapez %command% pour obtenir la liste de toutes les commandes.',
    'coresphere_console.loading' => 'Chargement en cours...',
    'coresphere_console.suggestion_head' => 'Essayez plutôt :',
    'coresphere_console.empty_response' => 'Commande exécutée ! (Mais réponse vide)',
    '%cartElementsCount% event(s) currently in cart' => '%cartElementsCount% événement(s) actuellement dans le panier',
    '%mins% left before tickets are released' => '%mins% avant la libération des billets réservés',
    '%resultsCount% attendee(s) found' => '%resultsCount% participant(s) trouvé(s)',
    '%resultsCount% event date(s) found' => '%resultsCount% date(s) d\'événement trouvé(s)',
    '%resultsCount% event(s)' => '%resultsCount% événement(s)',
    '%resultsCount% event(s) currently on sale' => '%resultsCount% événement(s) actuellement en vente',
    '%resultsCount% event(s) found' => '%resultsCount% événement(s) trouvé(s)',
    '%resultsCount% post(s) found' => '%resultsCount% article(s) trouvé(s)',
    '%resultsCount% result(s) found' => '%resultsCount% résulat(s) trouvé(s)',
    '%resultsCount% results found' => '%resultsCount% résulat(s) trouvé(s',
    '%resultsCount% reviews(s) found' => '%resultsCount% avis trouvé(s)',
    '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets' => '%tickets% ticket(s) sont actuellement réservés pour vous, veuillez patientez jusqu\'à ce que ses billets seront libérés le %expirationDate% ',
    '%websiteName% is undergoing a scheduled maintenance.' => '%websiteName% subit une maintenance planifiée.',
    1 => '1',
    '1 star' => '1 étoile',
    10 => '10',
    11 => '11',
    12 => '12',
    13 => '13',
    14 => '14',
    15 => '15',
    2 => '2',
    '2 stars' => '2 étoiles',
    3 => '3',
    '3 stars' => '3 étoiles',
    4 => '4',
    '4 stars' => '4 étoiles',
    5 => '5',
    '5 stars' => '5 étoiles',
    6 => '6',
    7 => '7',
    8 => '8',
    9 => '9',
    'A payout can not be requested on a free event date' => 'Un paiement ne peut pas être demandé pour une date d\'événement gratuit',
    'A payout can only be requested after at least one online successful sale' => 'Un paiement ne peut être demandé qu\'après au moins une vente en ligne réussie',
    'A payout is already requested for this event date' => 'Un paiement est déjà demandé pour cette date d\'événement',
    'About the organizer' => 'À propos de l\'organisateur',
    'About us' => 'À propos de nous',
    'Absatz' => 'Absatz',
    'Access denied' => 'Accès refusé',
    'Access granted' => 'Accès autorisé',
    'Access is denied. You may not have the appropriate permissions to access this resource.' => 'L\'accès est refusé. Vous ne disposez peut-être pas des autorisations appropriées pour accéder à cette ressource.',
    'Account' => 'Compte',
    'Account information' => 'Information sur le compte',
    'Account settings' => 'Paramètres du compte',
    'Account status' => 'Statut du compte',
    'Actions' => 'Actions',
    'Active attendees' => 'Participants actifs',
    'Active organizers' => 'Organisateurs actifs',
    'Add a blog post' => 'Ajouter un article de blog',
    'Add a help center article' => 'Ajouter un article du centre d\'aide',
    'Add a new amenity' => 'Ajouter une nouvelle commodité',
    'Add a new audience' => 'Ajouter une nouvelle audience',
    'Add a new blog post' => 'Ajouter un nouveau article de blog',
    'Add a new blog post category' => 'Ajouter une nouvelle catégorie d\'articles de blog',
    'Add a new category' => 'Ajouter une nouvelle catégorie',
    'Add a new country' => 'Ajouter un nouveau pays',
    'Add a new currency' => 'Ajouter une nouvelle devise',
    'Add a new event' => 'Ajouter un nouvel événement',
    'Add a new help center article' => 'Ajouter un nouvel article dans le centre d\'aide',
    'Add a new help center category' => 'Ajouter une nouvelle catégorie de centre d\'aide',
    'Add a new language' => 'Ajouter une nouvelle langue',
    'Add a new page' => 'Ajouter une nouvelle page',
    'Add a new payment gateway' => 'Ajouter un nouveau moyen de paiement',
    'Add a new point of sale' => 'Ajouter un nouveau point de vente',
    'Add a new scanner' => 'Ajouter un nouveau scanneur',
    'Add a new venue' => 'Ajouter un nouveau lieu',
    'Add a new venue type' => 'Ajouter un nouveau type de lieu',
    'Add events to your favorites by clicking the heart button' => 'Ajoutez des événements à vos favoris en cliquant sur le bouton cœur',
    'Add other images that represent your event to be displayed as a gallery' => 'Ajoutez d\'autres images qui représentent votre événement à afficher sous forme de galerie',
    'Add to calendar' => 'Ajouter au calendrier',
    'Add to cart' => 'Ajouter au panier',
    'Add to favorites' => 'Ajouter aux Favoris',
    'Add your review' => 'Ajoutez votre avis',
    'Add your review for %eventname%' => 'Ajouter votre avis pour %eventname%',
    'Added to favorites by' => 'Ajouté aux favoris par',
    'Additional note' => 'Remarque additionnelle',
    'Address' => 'Adresse',
    'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'Après avoir modifié une traduction dans le domaine javascript, assurez-vous d\'exécuter la commande suivante pour mettre à jour les fichiers associés: bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'Après avoir modifié une traduction dans le domaine javascript, accédez à la page Console et exécutez la commande suivante pour mettre à jour les fichiers associés: console bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment' => 'Après avoir édité un message de traduction, accédez à la page Console et exécutez la commande suivante: cache: clear --env=prod afin d\'appliquer les modifications dans l\'environnement de production',
    'All' => 'Tous',
    'All categories' => 'Toutes catégories',
    'All event dates for an organizer' => 'Toutes les dates d\'événements pour un organisateur',
    'All orders for an organizer' => 'Toutes les commandes pour un organisateur',
    'All payout requests for an organizer' => 'Toutes les demandes de paiement pour un organisateur',
    'Allow Paypal as a payout method for the organizers to receive their revenue' => 'Autoriser Paypal comme méthode de paiement pour que les organisateurs reçoivent leurs revenus',
    'Allow Stripe as a payout method for the organizers to receive their revenue' => 'Autoriser Stripe comme méthode de paiement pour que les organisateurs reçoivent leurs revenus',
    'Allow attendees to leave reviews' => 'Autoriser les participants à laisser des avis',
    'Allow tap to check in on the scanner app' => 'Autoriser Taper pour enregistrer dans l\'application du scanneur',
    'Already have an account?' => 'Vous avez déjà un compte?',
    'Alternative date and time format' => 'Format de date et d\'heure alternatif',
    'Amenities' => 'Commodités',
    'Amount' => 'Montant',
    'An error has occured' => 'Une erreur est survenue',
    'An error has occured while processing your request' => 'Une erreur s\'est produite lors du traitement de votre requête',
    'An error might occur if the command execution time reaches your PHP max_execution_time directive' => 'Une erreur peut se produire si le temps d\'exécution de la commande atteint votre directive PHP max_execution_time',
    'Anweisungen' => 'Anweisungen',
    'Anything' => 'N\'importe quoi',
    'Anytime' => 'À tout moment',
    'Anywhere' => 'N\'importe où',
    'App Debugging' => 'Débogage de l\'application',
    'App Environment' => 'Environnement de l\'application',
    'App Secret' => 'App Secret',
    'Application layout' => 'Application layout',
    'Application theme' => 'Thème de l\'application',
    'Approve' => 'Approuver',
    'Approved' => 'Approuvé',
    'Are you ready to take your' => 'Êtes-vous prêt à prendre votre',
    'Article details' => 'Détails de l\'article',
    'Articles' => 'Articles',
    'Articles count' => 'Nombre d\'articles',
    'Artists' => 'Artistes',
    'Assigned events' => 'Événements assignés',
    'Attendance' => 'Participation',
    'Attendee' => 'Participant',
    'Attendee / POS' => 'Participant / Point de vente',
    'Attendee Name / Email' => 'Nom / e-mail du participant',
    'Attendee Registration' => 'Inscription des participants',
    'Attendee information' => 'Informations du participant',
    'Attendee name or email, ticket reference, order reference' => 'Nom ou e-mail du participant, référence du ticket, référence de la commande',
    'Attendee status' => 'Statut du participant',
    'Attendee tickets' => 'Billets des participants',
    'Attendees' => 'Participants',
    'Attendees Check In' => 'Enregistrement des participants',
    'Attendees check-in' => 'Enregistrement des participants',
    'Attendees list' => 'Liste des participants',
    'Attendees reviews' => 'Avis des participants',
    'Attendees summary' => 'Résumé des participants',
    'Audience' => 'Public',
    'Audiences' => 'Public',
    'Authentification Pages' => 'Pages d\'authentification',
    'Authorized' => 'Autorisé',
    'Automatically canceled before deletion' => 'Annulé automatiquement avant la suppression',
    'Availability' => 'Disponibilité',
    'Available languages' => 'Langues disponibles',
    'Availibility' => 'Disponibilité',
    'Avatar' => 'Avatar',
    'Awaiting payment' => 'En attente de paiement',
    'Beschreibung' => 'Beschreibung',
    'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button' => 'Outre la fonction de numérisation de code QR, le compte du scanner pourra enregistrer les participants à l\'aide d\'une liste et d\'un bouton',
    'Best regards, the %website_name% team' => 'Meilleures salutations, l\'équipe %website_name%',
    'Billing information' => 'Détails de facturation',
    'Birthdate' => 'Date de naissance',
    'Blog' => 'Blog',
    'Blog Pages' => 'Pages du blog',
    'Blog page' => 'Accueil du blog',
    'Blog post' => 'Article du blog',
    'Blog posts count' => 'Nombre d\'articles de blog',
    'Blog settings' => 'Paramètres du blog',
    'Bought on' => 'Acheté le',
    'Bought tickets' => 'Billets achetés',
    'Browse events' => 'Événements',
    'Buy more tickets' => 'Achetez plus de billets',
    'Buy tickets' => 'Acheter des billets',
    'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.' => 'En cliquant sur envoyer, un email va être envoyé à l\'adresse email choisie. Assurez-vous d\'enregistrer la configuration à tester avant de tester.',
    'By clicking the Sign Up button, I agree to' => 'En cliquant sur le bouton Inscription, j\'accepte de',
    'CCY' => 'CCY',
    'Cancel' => 'Annuler',
    'Canceled' => 'Annulé',
    'Captured' => 'Capturé',
    'Cart' => 'Panier',
    'Cart elements' => 'Éléments du panier',
    'Cash / Check / Bank Transfer / Other' => 'Espèces / Chèque / Virement Bancaire / Autre',
    'Cash / Check / Offline' => 'Cash / Chèque / Hors ligne',
    'Categories' => 'Catégories',
    'Categories page' => 'Page des catégories',
    'Category' => 'Catégorie',
    'Ccy' => 'Ccy',
    'Change password' => 'Changer le mot de passe',
    'Check In' => 'Enregistrement',
    'Check In Attendees for this event date' => 'Enregistrement des participants pour cette date d\'événement',
    'Check your email inbox' => 'Vérifiez votre boîte e-mail',
    'Checked In At' => 'Enregistré à',
    'Checked In Only' => 'Enregistré uniquement',
    'Checkout' => 'Paiement',
    'Checkout settings' => 'Paramètres de paiement',
    'Choose a new image to replace the old one' => 'Choisissez une nouvelle image pour remplacer l\'ancienne',
    'Choose a payment gateway' => 'Choisir un moyen de paiement',
    'Choose the link destination page' => 'Choisissez la page de destination du lien',
    'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )' => 'Choisissez la bonne image pour représenter votre événement (nous vous recommandons d\'utiliser au moins une image de 1200 x 600 pixels (rapport 2: 1))',
    'City' => 'Ville',
    'Clear the application cache for the development environment' => 'Effacer le cache de l\'application pour l\'environnement de développement',
    'Clear the application cache for the production environment' => 'Vider le cache de l\'application pour l\'environnement de production',
    'Click here' => 'Cliquez ici',
    'Click on a date to view tickets' => 'Cliquez sur une date pour voir les billets',
    'Close' => 'Fermer',
    'Compact' => 'Compact',
    'Configuration' => 'Configuration',
    'Confirm' => 'Confirmer',
    'Confirm account' => 'Confirmer le compte',
    'Confirm payment and place order' => 'Confirmer le paiement et passer la commande',
    'Confirm payout request' => 'Confirmer la demande de paiement',
    'Confirmation required' => 'Confirmation requise',
    'Console' => 'Console',
    'Contact' => 'Contact',
    'Contact & Social media' => 'Contact & Réseaux sociaux',
    'Contact Us' => 'Contacter nous',
    'Contact address' => 'Adresse de contact',
    'Contact email' => 'Email de contact',
    'Contact email address' => 'Adresse e-mail de contact',
    'Contact fax' => 'Fax de contact',
    'Contact information' => 'Informations de contact',
    'Contact phone' => 'Téléphone de contact',
    'Contact phone number' => 'Téléphone de contact',
    'Contact the attendee' => 'Contacter le participant',
    'Contact the organizer' => 'Contacter l\'organisateur',
    'Contact us' => 'Nous contacter',
    'Contenido' => 'Contenu',
    'Content' => 'Contenu',
    'Contente' => 'Contente',
    'Contenu' => 'Contenu',
    'Cookie policy' => 'Politique de cookies',
    'Cookie policy page slug' => 'Slug de la page de politique de cookie',
    'Copyright' => 'Copyright',
    'Count' => 'Nombre',
    'Countries' => 'Pays',
    'Country' => 'Pays',
    'Country code' => 'Code du pays',
    'Cover photo' => 'Photo de couverture',
    'Cover picture' => 'Photo de couverture',
    'Create Account' => 'Créer un compte',
    'Create an account' => 'Créer un compte',
    'Create event' => 'Créer un évènement',
    'Create my event' => 'Créer mon événement',
    'Created by organizer' => 'Créé par l\'organisateur',
    'Creation date' => 'Date de création',
    'Creation date / Last login' => 'Date de création / Dernière connexion',
    'Credit or debit card' => 'Carte de crédit ou de débit',
    'Currency' => 'Devise',
    'Currency symbol' => 'Symbole de la devise',
    'Currency symbol position' => 'Position du symbole monétaire',
    'Currently in cart' => 'Actuellement dans le panier',
    'Custom css' => 'CSS personnalisé',
    'Custom hero' => 'Contenu personnalisé',
    'Custom hero background image' => 'Image d\'arrière plan du contenu personnalisé',
    'Custom hero title and paragraph translation' => 'Translation du titre et du paragraphe du contenu personnalisé',
    'Custom link' => 'Lien personnalisé',
    'Dark' => 'Noir',
    'Dark blue' => 'Bleu foncé',
    'Dashboard' => 'Tableau de bord',
    'Dashboard Pages' => 'Pages du tableau de bord',
    'Date' => 'Date',
    'Date and time format' => 'Format de la date et de l\'heure',
    'Date only format' => 'Format de date uniquement',
    'Dates' => 'Dates',
    'Default language' => 'Langue par défaut',
    'Delete' => 'Supprimer',
    'Delete permanently' => 'Supprimer définitivement',
    'Deleted' => 'Supprimé',
    'Deletion date' => 'Date de suppression',
    'Descripción' => 'Description',
    'Description' => 'Description',
    'Descrição' => 'Descrição',
    'Details' => 'Détails',
    'Development' => 'Développement',
    'Development environment is used for development purposes only' => 'L\'environnement de développement est utilisé à des fins de développement uniquement',
    'Disable' => 'Désactiver',
    'Disabled' => 'Désactivé',
    'Disabled only' => 'Désactivé uniquement',
    'Display itinerary bicycling' => 'Afficher l\'itinéraire à vélo',
    'Display itinerary driving' => 'Afficher l\'itinéraire par voiture',
    'Display itinerary on public transportation' => 'Afficher l\'itinéraire sur les transports publics',
    'Display itinerary walking' => 'Afficher l\'itinéraire à pied',
    'Display top 4 featured categories (footer section menu only)' => 'Afficher les 4 principales catégories en vedette (menu de la section de pied de page uniquement)',
    'Disqus comments' => 'Commentaires Disqus',
    'Disqus subdomain' => 'Sous-domaine Disqus',
    'Draft' => 'Brouillon',
    'Draft only' => 'Brouillon uniquement',
    'Early bird, General admission, VIP...' => 'Admission générale, VIP ...',
    'Edit' => 'Éditer',
    'Edit the menu' => 'Modifier le menu',
    'Edit your organizer profile' => 'Modifier votre profil d\'organisateur',
    'Editing the title after the event is saved won\'t change the event url' => 'La modification du titre après l\'enregistrement de l\'événement ne changera pas l\'URL de l\'événement',
    'Elapsed only' => 'Écoulé seulement',
    'Elements' => 'Éléments',
    'Email' => 'Email',
    'Email address' => 'Adresse e-mail',
    'Empty cart' => 'Vider la panier',
    'En cabeza' => 'En cabeza',
    'En-tête' => 'En-tête',
    'Enable' => 'Activer',
    'Enable Facebook Social Login' => 'Activer l\'authentification avec Facebook',
    'Enable Google Repatcha' => 'Activer Google Repatcha',
    'Enable Google Social Login' => 'Activer l\'authentification avec Google',
    'Enable comments' => 'Activer les commentaires',
    'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file' => 'Activez le mode de maintenance pour afficher une page de maintenance pour tous les utilisateurs, à l\'exception des utilisateurs qui ont le rôle ROLE_ADMINISTRATOR, si vous avez perdu votre session, vous pouvez modifier le paramètre MAINTENANCE_MODE directement dans le fichier .env',
    'Enable newsletter' => 'Activer la newsletter',
    'Enable reviews' => 'Activer les avis',
    'Enable sales for this event date ?' => 'Activer les ventes pour cette date d\'événement?',
    'Enable sales for this ticket ?' => 'Activer les ventes pour ce billet?',
    'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request' => 'Activer pour afficher les traces de pile sur les pages d\'erreur ou si les fichiers de cache doivent être reconstruits dynamiquement à chaque requête',
    'Enabled' => 'Activé',
    'Enabled only' => 'Activé uniquement',
    'Enabling sales for an event date does not affect the tickets individual sale status' => 'L\'activation des ventes pour une date d\'événement n\'affecte pas le statut de vente individuelle des billets',
    'Encryption' => 'Chiffrement',
    'End date' => 'Date de fin',
    'Ends On' => 'Se termine le',
    'Enlarge' => 'Agrandir',
    'Enter the chosen primary color code (i.e #ffffff)' => 'Entrez le code de couleur primaire choisi (selon le format standard #ffffff)',
    'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)' => 'Entrez le nom du site choisit sans espaces ni caractères majuscules (pour des fins de référencement)',
    'Enter the email address to be reached for inquiries' => 'Entrez l\'adresse e-mail à joindre pour les demandes',
    'Enter the full website url' => 'Entrez l\'URL complète du site',
    'Enter the list of artists that will perform in your event (press Enter after each entry)' => 'Entrez la liste des artistes qui performeront dans votre événement (appuyez sur Entrée après chaque entrée)',
    'Enter the phone number to be called for inquiries' => 'Entrez le numéro de téléphone à appeler pour toute demande de renseignements',
    'Enter the website url without http nor https' => 'Entrez l\'URL du site sans http ou https',
    'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Entrez l\'url du site sans http ni https.Veuillez également vous assurer de modifier ce paramètre dans le fichier .env dans le dossier racine du projet, car il est requis dans certains bundles externes',
    'Error' => 'Erreur',
    'Etiquetas' => 'Étiquettes',
    'Event' => 'Événement',
    'Event / Ticket' => 'Événement / Billet',
    'Event Categories' => 'Catégories d\'événements',
    'Event already started' => 'L\'événement a déjà commencé',
    'Event categories' => 'Catégories d\'événements',
    'Event date' => 'Date de l\'événement',
    'Event date is disabled' => 'La date de l\'événement est désactivée',
    'Event date status' => 'Statut de la date de l\'événement',
    'Event dates' => 'Dates de l\'événement',
    'Event details' => 'Détails de l\'évènement',
    'Event is not published' => 'L\'événement n\'est pas publié',
    'Event list' => 'Liste des événements',
    'Event ticket' => 'Event ticket',
    'Event ticket is disabled' => 'Le billet est désactivé',
    'Event ticket status' => 'Statut du billet',
    'Event tickets' => 'Billets',
    'Event views' => 'Consultations de la page de l\'événement',
    'Events' => 'Événements',
    'Events Pages' => 'Pages d\'événements',
    'Events RSS feed' => 'Flux RSS des événements',
    'Events added' => 'Événements ajoutés',
    'Events count' => 'Nombre d\'événements',
    'Events in %countryname%' => 'Événements dans le pays %countryname%',
    'Events list' => 'Liste des événements',
    'Events list page' => 'Page de la liste des événements',
    'Events list page settings' => 'Paramètres de le page de la liste des événements',
    'Events on sale' => 'Événements en vente',
    'Events page' => 'Page des événements',
    'Events slider' => 'Slider d\'événements',
    'Events summary' => 'Résumé des événements',
    'Execute Symfony commands' => 'Exécuter des commandes Symfony',
    'Execute command' => 'Exécuter la commande',
    'Execute this command after editing a file in the application source code or after modifying a string in the translations files' => 'Exécutez cette commande après avoir édité un fichier dans le code source de l\'application ou après avoir modifié une chaîne dans les fichiers de traductions',
    'Execute this command if you are in the development mode and the modifications you applied in the application did take effect' => 'Exécutez cette commande si vous êtes en mode développement et que les modifications que vous avez appliquées dans l\'application ont pris effet',
    'Explore' => 'Explorer',
    'Explore events' => 'Explorer les événements',
    'Export attendees list to a PDF file' => 'Exporter la liste des participants dans un fichier PDF',
    'Export current orders to a CSV file' => 'Exporter les commandes en cours vers un fichier CSV',
    'Export current orders to an Excel file' => 'Exporter les commandes en cours vers un fichier Excel',
    'External link' => 'Lien externe',
    'FAQ' => 'FAQ',
    'Facebook' => 'Facebook',
    'Facebook Id' => 'Facebook Id',
    'Facebook Secret' => 'Facebook Secret',
    'Facebook app id' => 'Facebook app id',
    'Facebook comments' => 'Commentaires Facebook',
    'Facebook profile picture' => 'Photo de profil Facebook',
    'Facebook url' => 'Lien Facebook',
    'Failed' => 'Échoué',
    'Favicon' => 'Favicon',
    'Favorites' => 'Favoris',
    'Fax' => 'Fax',
    'Featured' => 'En vedette',
    'Featured categories' => 'Catégories vedettes',
    'Featured only' => 'En vedette seulement',
    'Featured order' => 'Ordre',
    'Fees' => 'Frais',
    'Fees & Taxes' => 'Frais',
    'First Name' => 'Prénom',
    'First name' => 'Prénom',
    'Flag' => 'Drapeau',
    'Fluid' => 'Fluid',
    'Follow' => 'Suivre',
    'Followed by' => 'Suivi par',
    'Followers' => 'Abonnés',
    'Following' => 'Abonnements',
    'Food and beverage' => 'Nourriture et boisson',
    'Food and beverage details' => 'Détails sur la nourriture et les boissons',
    'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it' => 'Pour \'Espèces / Chèque / Virement Bancaire / Autre\', la commande restera sur le statut \'En attente de paiement\' jusqu\'à ce que l\'organisateur ou l\'administrateur la valide',
    'Forbidden' => 'Interdit',
    'Forgot your password ?' => 'Mot de passe oublié ?',
    'Free' => 'Gratuit',
    'Free events only' => 'Événements gratuits uniquement',
    'From date' => 'A partir de la date',
    'Full name' => 'Nom complet',
    'GDPR compliance' => 'Conformité GDPR',
    'Gallery' => 'Galerie',
    'Gallery image' => 'Image de la galerie',
    'Gdpr compliance page slug' => 'Slug de la page de conformité Gdpr',
    'Gender' => 'Sexe',
    'General information' => 'Informations générales',
    'Generation date' => 'Date de génération',
    'Global payment settings' => 'Paramètres de paiement',
    'Gmail' => 'Gmail',
    'Go back' => 'Retourner',
    'Go to the Pages section in the settings to add a new page' => 'Accédez à la section Pages dans les paramètres pour ajouter une nouvelle page',
    'Go to the documentation to get help about getting a list id' => 'Accédez à la documentation pour obtenir de l\'aide sur l\'obtention d\'un identifiant de liste',
    'Go to the documentation to get help about getting an api key' => 'Accédez à la documentation pour obtenir de l\'aide sur l\'obtention d\'une clé API',
    'Go to the documentation to get help about getting an app ID' => 'Accédez à la documentation pour obtenir de l\'aide sur l\'obtention d\'un ID d\'application',
    'Go to the documentation to get help about setting up Disqus' => 'Accédez à la documentation pour obtenir de l\'aide sur la configuration de Disqus',
    'Google Id' => 'Google Id',
    'Google Maps' => 'Google Maps',
    'Google Maps Api Key' => 'Google Maps Api Key',
    'Google Maps settings' => 'Paramètres Google Maps',
    'Google Plus' => 'Google Plus',
    'Google Recaptcha' => 'Google Recaptcha',
    'Google Recaptcha settings' => 'Paramètres Google Recaptcha',
    'Google Secret' => 'Google Secret',
    'Google analytics Tracking ID' => 'Google analytics Tracking ID',
    'Google analytics code' => 'Code Google analytics',
    'Google plus' => 'Google plus',
    'Green' => 'Vert',
    'Gross Sales' => 'Ventes brutes',
    'Gross sales' => 'Ventes brutes',
    'Gross sales by channel' => 'Ventes brutes par canal',
    'Gross sales per Point of sale' => 'Ventes brutes par point de vente',
    'Guests' => 'Invités',
    'Header' => 'Entête',
    'Header text' => 'Texte de l\'en-tête',
    'Help Center Article' => 'Article du centre d\'aide',
    'Help Center Category' => 'Catégorie du centre d\'aide',
    'Help Center Pages' => 'Pages du centre d\'aide',
    'Help Center page' => 'Page du centre d\'aide',
    'Help center' => 'Centre d\'aide',
    'Here are the details' => 'Voici les détails',
    'Hey' => 'Bonjour',
    'Hidden' => 'Caché',
    'Hidden only' => 'Caché uniquement',
    'Hide' => 'Cacher',
    'Hide from public directory' => 'Masquer du répertoire publique',
    'Hide slider' => 'Cacher le slider',
    'Home' => 'Accueil',
    'Homepage' => 'Page d\'accueil',
    'Homepage content settings' => 'Paramètres de contenu de la page d\'accueil',
    'Homepage hero settings' => 'Paramètres du haut de la page d\'accueil',
    'Homepage settings' => 'Paramètres de la page d\'accueil',
    'Host' => 'Hôte',
    'How can we help?' => 'Besoin d\'aide?',
    'How it works' => 'Comment ça marche?',
    'Icon' => 'Icone',
    'If you have an Youtube video that represents your activities as an event organizer, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M' => 'Si vous avez une vidéo Youtube qui représente votre événement, ajoutez-la au format standard: https://www.youtube.com/watch?v=FzG4uDgje3M',
    'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M' => 'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M',
    'If you need to send the confirmation email to a different email address, you can change it before submitting' => 'Si vous devez envoyer l\'e-mail de confirmation à une autre adresse e-mail, vous pouvez le modifier avant de soumettre',
    'If your event has a dedicated website, enter its url here' => 'Si votre événement a un site dédié, entrez son URL ici',
    'If your event is a movie for example, select the available subtitles' => 'Si votre événement est un film par exemple, sélectionnez les sous-titres disponibles',
    'If your event is a movie for example, select the year of release' => 'Si votre événement est un film par exemple, sélectionnez l\'année de sortie',
    'Image' => 'Image',
    'Images' => 'Images',
    'Images gallery' => 'Galerie d\'images',
    'Impersonate' => 'Se connecter en tant que',
    'In' => 'À',
    'In deinen Gedanken' => 'In deinen Gedanken',
    'Information not provided' => 'Informations non fournies',
    'Information provided' => 'Informations fournies',
    'Inhalt' => 'Inhalt',
    'Insert at least 3 characters' => 'Insérez au moins 3 caractères',
    'Instagram' => 'Instagram',
    'Instagram url' => 'URL Instagram',
    'Instrucciones' => 'Instrucciones',
    'Instructions' => 'Instructions',
    'Instruções' => 'Instruções',
    'Invalid credentials' => 'Informations d\'identification invalides',
    'Is featured' => 'En vendette',
    'Is featured on the homepage slider?' => 'Est en vedette dans le slider de la page d\'accueil?',
    'Is this event date online ?' => 'Cette date de l\'événement est-elle en ligne?',
    'Is this ticket free ?' => 'Ce billet est-il gratuit?',
    'It wasn\'t possible to retrieve information about the provided IP' => 'Il n\'a pas été possible de récupérer des informations sur l\'IP fournie',
    'Keyword' => 'Mot-clé',
    'Language' => 'Langue',
    'Language code' => 'Code de langue',
    'Languages' => 'Langues',
    'Last Name' => 'Nom de famille',
    'Last login' => 'Dernière connexion',
    'Last name' => 'Nom de famille',
    'Last updated' => 'Dernière mise à jour',
    'Lastest blog posts' => 'Derniers articles de blog',
    'Layout settings' => 'Paramètres de mise en page',
    'Layout, parameters and SEO' => 'Présentation, paramètres et référencement',
    'Leave a review' => 'Laisser un avis',
    'Leave api key empty to disable google maps project wide' => 'Laissez la clé API vide pour désactiver Google Maps à l\'échelle du projet',
    'Leave the password empty to keep the old one' => 'Laissez le mot de passe vide pour conserver l\'ancien',
    'Left' => 'Gauche',
    'Let the other attendee know more details about your experience' => 'Faites savoir à d\'autres participants plus de détails sur votre expérience',
    'Light blue' => 'Bleu clair',
    'Link' => 'Lien',
    'Link Text' => 'Link Text',
    'Link text' => 'Texte du lien',
    'LinkedIn' => 'LinkedIn',
    'Linkedin' => 'Linkedin',
    'List on public directory' => 'Répertorier dans l\'annuaire',
    'Listed on directory' => 'Répertorié dans l\'annuaire',
    'Listed on the directory' => 'Répertorié dans l\'annuaire',
    'Load more' => 'Charger plus',
    'Loading...' => 'Chargement...',
    'Local events only' => 'Événements locaux uniquement',
    'Location' => 'Emplacement',
    'Locked (Payout request approved)' => 'Verrouillé (demande de paiement approuvée)',
    'Locked (Payout request pending)' => 'Verrouillé (demande de paiement en attente)',
    'Login' => 'S\'identifier',
    'Logo' => 'Logo',
    'Looking for' => 'À la recherche de',
    'Mail server' => 'Serveur e-mail',
    'Mail server settings' => 'Paramètres du serveur e-mail',
    'Mail server test email' => 'Email de test de la configuration du serveur d\'envoi des emails',
    'Mailchimp app id' => 'Mailchimp app id',
    'Mailchimp list id' => 'Mailchimp list id',
    'Main blog post image' => 'Image de l\'article de blog',
    'Main categories' => 'Catégories principales',
    'Main event image' => 'Image de l\'événement',
    'Main image' => 'Image de l\'événement',
    'Maintenance mode' => 'Mode de maintenance',
    'Maintenance mode custom message' => 'Message personnalisé du mode de maintenance',
    'Make sure that the added payment gateways are configured to support this currency' => 'Assurez-vous que les méthodes de paiement ajoutés sont configurés pour supporter cette devise',
    'Make sure that the currency setting of your payout method matches the one currently used which is %currency%' => 'Assurez-vous que le paramètre de devise de votre mode de paiement correspond à celui actuellement utilisé, qui est %currency%',
    'Make sure to enter a valid email address' => 'Assurez-vous de saisir une adresse e-mail valide',
    'Make sure to select organizers who have added a cover photo' => 'Assurez-vous de sélectionner les organisateurs qui ont ajouté une photo de couverture',
    'Make sure to select right category to let the users find it quickly' => 'Assurez-vous de sélectionner la bonne catégorie pour permettre aux utilisateurs de le trouver rapidement',
    'Manage amenities' => 'Gérer les commodités',
    'Manage articles' => 'Gérer les articles',
    'Manage attendees' => 'Gérer les participants',
    'Manage audiences' => 'Gérer les audiences',
    'Manage blog' => 'Gérer le blog',
    'Manage blog post categories' => 'Gérer les catégories du blog',
    'Manage blog posts' => 'Gérer les articles du blog',
    'Manage categories' => 'Gérer les catégories',
    'Manage countries' => 'Gérer les pays',
    'Manage currencies' => 'Gérer les devises',
    'Manage event' => 'Gérer l\'événement',
    'Manage events' => 'Gérer les événements',
    'Manage help center' => 'Gérer le centre d\'aide',
    'Manage help center articles' => 'Gérer les articles du centre d\'aide',
    'Manage help center categories' => 'Gérer les catégories du centre d\'aide',
    'Manage languages' => 'Gérer les langues',
    'Manage menus' => 'Gérer les menus',
    'Manage orders' => 'Gérer les commandes',
    'Manage pages' => 'Gérer les pages',
    'Manage posts' => 'Gérer les articles',
    'Manage reviews' => 'Gérer les avis',
    'Manage users' => 'Gérer les utilisateurs',
    'Manage venues' => 'Gérer les lieux',
    'Manage venues amenities' => 'Gérer les commodités des lieux',
    'Manage venues types' => 'Gérer les types de lieux',
    'Manage website translation' => 'Gérer la traduction',
    'Mark as featured' => 'Marquer comme En vedette',
    'Mark as not featured' => 'Retiré de En vedette',
    'Max' => 'Max',
    'Member since' => 'Membre depuis',
    'Menu elements' => 'Éléments du menu',
    'Menu name' => 'Menu name',
    'Menus' => 'Menus',
    'Menus settings' => 'Paramètres des menus',
    'Menüname' => 'Menüname',
    'Message' => 'Message',
    'Message from the attendee:' => 'Message du participant:',
    'Method Not Supported' => 'Méthode non supportée',
    'Min' => 'Min',
    'More details' => 'Plus de détails',
    'More information' => 'Plus d\'information',
    'Mots clés' => 'Mots clés',
    'My Account' => 'Mon compte',
    'My cart' => 'Mon panier',
    'My events' => 'Mes événements',
    'My favorites' => 'Mes favoris',
    'My orders' => 'Mes commandes',
    'My organizer profile' => 'Mon profil d\'organisateur',
    'My points of sale' => 'Mes points de vente',
    'My review' => 'Mon avis',
    'My reviews' => 'Mes avis',
    'My scanners' => 'Mes scanners',
    'My tickets' => 'Mes billets',
    'My venues' => 'Mes lieux',
    'N/A' => 'N/A',
    'Na sua mente' => 'Na sua mente',
    'Name' => 'Nom',
    'Name / Username' => 'Nom / nom d\'utilisateur',
    'Native comments' => 'Commentaires natifs',
    'Neighborhoods' => 'Quartiers',
    'Net sales' => 'Ventes nettes',
    'Net sales until' => 'Ventes nettes jusqu\'à',
    'New' => 'Nouveau',
    'New message regarding the order' => 'Nouveau message concernant la commande',
    'New payout request' => 'Nouvelle demande de paiement',
    'New quote request' => 'Nouvelle demande de devis',
    'Newsletter' => 'Newsletter',
    'Newsletter settings' => 'Paramètres de la newsletter',
    'Next month' => 'Mois prochain',
    'Next week' => 'Semaine prochaine',
    'No' => 'Non',
    'No amenites found' => 'Aucune commodité trouvée',
    'No articles found' => 'Aucun article trouvé',
    'No attendees found' => 'Aucun participant trouvé',
    'No audiences found' => 'Aucun public trouvé',
    'No blog post categories found' => 'Aucune catégorie d\'articles de blog trouvée',
    'No blog posts found' => 'Aucun article de blog trouvé',
    'No categories found' => 'Aucune catégorie trouvée',
    'No countries found' => 'Aucun pays trouvé',
    'No currencies found' => 'Aucune devise trouvée',
    'No event dates found' => 'Aucune date d\'événement trouvée',
    'No events found' => 'Aucun événement trouvé',
    'No events on sale' => 'Pas d\'événements en vente',
    'No events on sale for now' => 'Aucun événement en vente pour l\'instant',
    'No languages found' => 'Aucune langue trouvée',
    'No link, display featured categories dropdown on hover (header menu only)' => 'Pas de lien, afficher la liste déroulante des catégories en vedette au survol (menu d\'en-tête uniquement)',
    'No menus found' => 'Aucun menu trouvé',
    'No orders found' => 'Aucune commande trouvée',
    'No orders found to be included in the report' => 'Aucune commande à inclure dans le rapport',
    'No pages found' => 'Aucune page trouvée',
    'No past events found' => 'Aucun événement passé trouvé',
    'No payment gateways are currently enabled' => 'Aucun moyen de paiement n\'est actuellement activé',
    'No payment gateways found' => 'Aucun moyen de paiement trouvé',
    'No payout requests found' => 'Aucune demande de paiement trouvée',
    'No points of sale found' => 'Aucun point de vente trouvé',
    'No reply email address' => 'Adresse e-mail de réponse automatique',
    'No results found' => 'Aucun résultat trouvé',
    'No review found' => 'Aucun avis trouvé',
    'No reviews found' => 'Aucun avis trouvé',
    'No sales yet' => 'Pas encore de vente',
    'No scanners found' => 'Aucun scanner trouvé',
    'No ticket on sale' => 'Aucun billet en vente',
    'No tickets found' => 'Aucun billet trouvé',
    'No tickets selected to add to cart' => 'Aucun billet sélectionné à ajouter au panier',
    'No users found' => 'Aucun utilisateur trouvé',
    'No venue types found' => 'Aucun type de lieu trouvé',
    'No venues found' => 'Aucun lieu trouvé',
    'Nom' => 'Nom',
    'Nom du menu' => 'Nom du menu',
    'Nombre' => 'Nombre',
    'Nombre du menú' => 'Nombre du menú',
    'Nome' => 'Nome',
    'Nome do menu' => 'Nome do menu',
    'None' => 'Aucun',
    'Not Checked In Only' => 'Non enregistré uniquement',
    'Not a member yet ?' => 'Pas encore membre ?',
    'Not elapsed only' => 'Non écoulé seulement',
    'Not featured' => 'Pas en vedette',
    'Not listed on the directory' => 'Ne figure pas dans le répertoire',
    'Note' => 'Note',
    'Number of blog posts per page' => 'Nombre d\'articles de blog par page',
    'Number of blog posts to show' => 'Nombre d\'articles de blog à afficher',
    'Number of events per page' => 'Nombre d\'événements par page',
    'Number of events to show' => 'Nombre d\'événements à afficher',
    'Number of featured categories to show' => 'Nombre de catégories en vedette à afficher',
    'Number of guests' => 'Nombre d\'invités',
    'Number of seconds before the reserved tickets are released if the order is still awaiting payment' => 'Nombre de secondes avant la libération des billets réservés si la commande est toujours en attente de paiement',
    'Number of tickets' => 'Nombre de billets',
    'OR' => 'OU',
    'On sale' => 'En vente',
    'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed' => 'Une fois la demande de paiement soumise, la date de l\'événement sera verrouillée et les ventes seront suspendues pour la date de l\'événement spécifique. Si vous le souhaitez, vous pouvez attendre la date de début de l\'événement avant de demander le paiement. Vous pouvez annuler la demande de paiement à tout moment avant qu\'elle ne soit traitée',
    'Online' => 'En ligne',
    'Online events only' => 'Événements en ligne uniquement',
    'Optional attendee information' => 'Informations facultatives sur les participants',
    'Optionally add a cover photo to showcase your organizer activities' => 'Ajoutez éventuellement une photo de couverture pour présenter vos activités d\'organisateur',
    'Orange' => 'Orange',
    'Order' => 'Commande',
    'Order =' => 'Ordre',
    'Order = ' => 'Ordre = ',
    'Order Date' => 'Date de commande',
    'Order confirmation' => 'Confirmation de commande',
    'Order date' => 'Date de commande',
    'Order details' => 'Détails de la commande',
    'Order of appearance' => 'Ordre d\'affichage',
    'Order payment details' => 'Détails de paiement de la commande',
    'Order reference' => 'Référence de la commande',
    'Order status' => 'Statut de la commande',
    'Order summary' => 'Récapitulatif de la commande',
    'Order total' => 'Total de la commande',
    'Orders' => 'Commandes',
    'Orders placed' => 'Commandes passées',
    'Orders summary' => 'Récapitulatif des commandes',
    'Organizer' => 'Organisateur',
    'Organizer / Event / Date / Ticket' => 'Organisateur / Événement / Date / Ticket',
    'Organizer Profile' => 'Profil de l\'organisateur',
    'Organizer Registration' => 'Inscription de l\'organisateur',
    'Organizer information' => 'Informations sur l\'organisateur',
    'Organizer is disabled' => 'L\'organisateur est désactivé',
    'Organizer logo' => 'Logo de l\'organisateur',
    'Organizer name' => 'Nom de l\'organisateur',
    'Organizer profile' => 'Profil organisateur',
    'Organizer revenue from %website_name%' => 'Revenus de l\'organisateur de %website_name%',
    'Organizers' => 'Organisateurs',
    'Organizers Pages' => 'Pages des profils des organisateurs',
    'Organizers slider' => 'Slider des organisateurs',
    'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry' => 'Organisateurs, participants, ce centre d\'aide est destiné à répondre rapidement à vos questions, si vous ne trouvez toujours pas de réponses, contactez-nous, nous serons heureux de recevoir votre demande',
    'Other events by %organizername%' => 'Autres événements par %organizername%',
    'PERMANENTLY' => 'DÉFINITIVEMENT',
    'POS' => 'Point de vente',
    'Page content' => 'Contenu de la page',
    'Page not found' => 'Page non trouvée',
    'Pages' => 'Pages',
    'Paid' => 'Payé',
    'Paid orders' => 'Commandes payées',
    'Palabras clave' => 'Palabras clave',
    'Palavras-chave' => 'Palavras-chave',
    'Paragraph' => 'Paragraphe',
    'Paragraphe' => 'Paragraphe',
    'Parent' => 'Parent',
    'Parent category' => 'Catégorie parente',
    'Parágrafo' => 'Parágrafo',
    'Password' => 'Mot de passe',
    'Password Resetting' => 'Réinitialisation du mot de passe',
    'Past events' => 'Événements passés',
    'Past tickets' => 'Billets antérieurs',
    'Pay now' => 'Payer maintenant',
    'Payment' => 'Paiement',
    'Payment details' => 'Détails de paiement',
    'Payment gateways' => 'Moyens de paiement',
    'Payment method' => 'Méthode de paiement',
    'Payment of tickets purchased on %website_name%' => 'Paiement des billets achetés depuis %website_name%',
    'Payment settings' => 'Paramètres de paiement',
    'Payments and Fees' => 'Paiements et frais',
    'Payout already requested' => 'Paiement déjà demandé',
    'Payout method' => 'Méthode de paiement',
    'Payout methods' => 'Méthodes de paiement',
    'Payout request' => 'Demande de paiement',
    'Payout request details' => 'Détails de la demande de paiement',
    'Payout request notification' => 'Notification de demande de paiement',
    'Payout request payment details' => 'Détails du paiement de la demande de paiement',
    'Payout requests' => 'Demandes de paiement',
    'Payouts' => 'Paiements',
    'Paypal Client Id' => 'Paypal Client Id',
    'Paypal Client Secret' => 'Paypal Client Secret',
    'Paypal Express Checkout' => 'Paypal Express Checkout',
    'Pending' => 'En attente',
    'Pending payout requests' => 'Demandes de paiement en attente',
    'Percentage cut' => 'Pourcentage retiré',
    'Phone' => 'Téléphone',
    'Phone number' => 'Téléphone',
    'Photos' => 'Photos',
    'Pick a date' => 'Choisir une date',
    'Pink' => 'Rose',
    'Please choose a 200x200 minimum image size as it is required by Facebook' => 'Veuillez choisir une taille d\'image minimale de 200x200 car elle est requise par Facebook',
    'Please choose a 200x50 image size to ensure compatibility with the website design' => 'Veuillez choisir une image de taille 200x50 pour assurer la compatibilité avec la conception du site',
    'Please click on the following link to check the status of your request' => 'Veuillez cliquer sur le lien suivant pour vérifier l\'état de votre demande',
    'Please confirm your account by clicking the link below' => 'Veuillez confirmer votre compte en cliquant sur le lien ci-dessous',
    'Please enter the selected payment gateway details' => 'Veuillez saisir les détails de la méthode de paiement sélectionnée',
    'Please enter the subject carefully in order get the help you need' => 'Veuillez saisir le sujet avec soin afin d\'obtenir l\'aide dont vous avez besoin',
    'Please enter your payout method details' => 'Veuillez entrer les détails de votre méthode de paiement',
    'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Veuillez vous assurer de changer ce paramètre également dans le fichier .env dans le dossier racine du projet car il est requis dans certains bundles externes',
    'Please refer to this following list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217' => 'Veuillez vous référer à la liste suivante et utiliser la colonne Code: https://en.wikipedia.org/wiki/ISO_4217',
    'Please select the tickets quantity for this order' => 'Veuillez sélectionner la quantité de billets pour cette commande',
    'Please select the tickets quantity you want to buy' => 'Veuillez sélectionner la quantité de billets que vous souhaitez acheter',
    'Please set a payout method before submitting a payout request' => 'Veuillez définir une méthode de paiement avant de soumettre une demande de paiement',
    'Please wait a few seconds if the translation interface freezes at page load' => 'Veuillez patienter quelques secondes si l\'interface de traduction se bloque au chargement de la page',
    'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor' => 'Veuillez patienter quelques secondes si l\'interface de traduction se bloque au chargement de la page, ou éditez les fichiers dans le dossier translations/ à la racine du projet directement dans votre éditeur de texte préféré',
    'Point of sale' => 'Point de vente',
    'Point of sale information' => 'Informations du point de vente',
    'Point of sales' => 'Points de vente',
    'Points of sale' => 'Points de vente',
    'Popular' => 'Populaires',
    'Popularity' => 'Popularité',
    'Port' => 'Port',
    'Position' => 'Position',
    'Postal code' => 'Code postal',
    'Posts' => 'Articles',
    'Price' => 'Prix',
    'Pricing' => 'Tarifs',
    'Pricing and fees' => 'Tarifs et Frais',
    'Primary color code' => 'Code couleur primaire',
    'Print tickets' => 'Imprimer les billets',
    'Privacy policy' => 'Politique de confidentialité',
    'Privacy policy page slug' => 'Slug de la page de politique de confidentialité',
    'Processed' => 'Traité',
    'Processed at' => 'Traité à',
    'Processing date' => 'Date de traitement',
    'Production' => 'Production',
    'Profile picture' => 'Photo de profil',
    'Profile views' => 'Vues de profil',
    'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string' => 'Format de date et d\'heure à l\'échelle du projet, suivez ce lien pour une liste des caractères pris en charge: https://unicode-org.github.io/icu/userguide/format_parse/datetime/. Veuillez vous assurer de conserver les guillemets doubles "" autour de la chaîne de format',
    'Promotional price' => 'Prix promotionnel',
    'Publicly show attendees' => 'Afficher les participants',
    'Publish' => 'Publier',
    'Published events' => 'Événements publiés',
    'Published only' => 'Publiés uniquement',
    'Purple' => 'Violet',
    'Párrafo' => 'Párrafo',
    'Quantity' => 'Quantité',
    'Rating' => 'Évaluation',
    'Read more' => 'Lire la suite',
    'Read time in minutes' => 'Temps de lecture en minutes',
    'Recent orders' => 'Dernières commandes',
    'Red' => 'Rouge',
    'Reference' => 'Référence',
    'Refund' => 'Remboursement',
    'Refund requested' => 'Remboursement demandé',
    'Refunded' => 'Remboursé',
    'Register' => 'S\'inscrire',
    'Register attendees' => 'Enregistrer les participants',
    'Registered using Facebook' => 'Enregistré via Facebook',
    'Registered using Google' => 'Enregistré via Google',
    'Registration date' => 'Date d\'inscription',
    'Related posts' => 'Articles Similaires',
    'Remove' => 'Supprimer',
    'Remove from favorites' => 'Retirer des favoris',
    'Repeat password' => 'Répéter le mot de passe',
    'Reports' => 'Rapports',
    'Request a quote' => 'Demander un devis',
    'Request date' => 'Date de la demande',
    'Request payout' => 'Demande de paiement',
    'Requested at' => 'Demandé à',
    'Resend confirmation email' => 'Renvoyer un courriel de confirmation',
    'Reset' => 'Réinitialiser',
    'Reset your password' => 'Réinitialisez votre mot de passe',
    'Response' => 'Réponse',
    'Restore' => 'Restaurer',
    'Return to cart' => 'Retour au panier',
    'Review date' => 'Date de l\'évaluation',
    'Review(s)' => 'Évaluation(s)',
    'Reviews' => 'Évaluations',
    'Reviews for %eventname%' => 'Évaluation(s) pour %eventname%',
    'Right' => 'Droite',
    'Role' => 'Rôle',
    'SEO keywords' => 'Mots clés de référencement',
    'SMTP' => 'SMTP',
    'SSL' => 'SSL',
    'SSL must be activated on your hosting server in order to use Mailchimp' => 'SSL doit être activé sur votre serveur d\'hébergement pour pouvoir utiliser Mailchimp',
    'Sale didn\'t start yet' => 'La vente n\'a pas encore commencé',
    'Sale ended' => 'Fin de vente',
    'Sale ends On' => 'La vente se termine le',
    'Sale starts On' => 'La vente commence le',
    'Sales' => 'Ventes',
    'Sales channel' => 'Canal de vente',
    'Sales end' => 'Fin des ventes',
    'Sales end date' => 'Date de fin des ventes',
    'Sales end in' => 'Les ventes se terminent le',
    'Sales ended' => 'LEs ventes sont terminées',
    'Sales ended on' => 'Les ventes sont terminées le',
    'Sales start date' => 'Date de début des ventes',
    'Sales start in' => 'Les ventes commencent dans',
    'Sales started' => 'Les ventes ont commencé',
    'Sales started on' => 'Les ventes ont commencé le',
    'Sandbox' => 'Sandbox',
    'Save' => 'Sauvegarder',
    'Save order' => 'Sauvegarder la commande',
    'Scanned tickets' => 'Billets scannés',
    'Scanner' => 'Scanner',
    'Scanner App' => 'Application du Scanner',
    'Scanner App settings' => 'Paramètres de l\'application de Scanner',
    'Scanner information' => 'Informations du Scanner',
    'Scanners' => 'Scanners',
    'Schlüsselwörter' => 'Schlüsselwörter',
    'Search' => 'Rechercher',
    'Search blog' => 'Recherche sur le blog',
    'Search blog posts' => 'Rechercher des articles de blog',
    'Search for answers' => 'Rechercher des réponses',
    'Search for events' => 'Rechercher des événements',
    'Search help center' => 'Rechercher dans le centre d\'aide',
    'Search in reviews' => 'Rechercher dans les avis',
    'Searching ...' => 'Recherche ...',
    'Seated' => 'Assis',
    'Seated guests' => 'Invités assis',
    'Seated guests number' => 'Nombre d\'invités assis',
    'Secret key' => 'Secret key',
    'See all' => 'Voir tout',
    'See all %reviewscount% reviews' => 'Voir les %reviewscount% avis',
    'See all categories' => 'Voir toutes les categories',
    'See all events on sale' => 'Voir tous les événements en vente',
    'See more articles' => 'Voir plus d\'articles',
    'See more events' => 'Voir plus d\'événements',
    'Select a payout method' => 'Sélectionnez une méthode de paiement',
    'Select a specific event date' => 'Sélectionnez une date d\'événement spécifique',
    'Select a specific event ticket' => 'Sélectionnez un billet d\'événement spécifique',
    'Select an option' => 'Sélectionnez une option',
    'Select parent of \'Point of sale\' or \'Scanner\'' => 'Sélectionnez le parent de «Point de vente» ou «Scanner»',
    'Select the audience types that are targeted in your event' => 'Sélectionnez les types d\'audience ciblés dans votre événement',
    'Select the categories that represent your events types' => 'Sélectionnez les catégories qui représentent vos types d\'événements',
    'Select the country that your event represents (ie: A movie\'s country of production)' => 'Sélectionnez le pays que représente votre événement (ex: pays de production d\'un film)',
    'Select the languages that will be spoken in your event' => 'Sélectionnez les langues qui seront parlées lors de votre événement',
    'Select the parent category to add a sub category' => 'Sélectionnez la catégorie parente pour ajouter une sous-catégorie',
    'Sell tickets online' => 'Vendre des billets en ligne',
    'Send' => 'Envoyer',
    'Send us an email' => 'Envoyez-nous un e-mail',
    'Sendmail' => 'Sendmail',
    'Set' => 'Définir',
    'Set a new password' => 'Définissez un nouveau mot de passe',
    'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)' => 'Fixez un prix inférieur au prix d\'origine pour indiquer une promotion (ce prix sera le prix de VENTE)',
    'Set the display order for the featured categories' => 'Définissez l\'ordre d\'affichage des catégories en vedette',
    'Set the number of tickets that an attendee can buy for this ticket type' => 'Définir le nombre de billets qu\'un participant peut acheter pour ce type de billet',
    'Set the parent category to add a subcategory' => 'Définissez la catégorie parente pour ajouter une sous-catégorie',
    'Set your %payoutMethodName% payout method' => 'Définissez votre méthode de paiement %payoutMethodName%',
    'Settings' => 'Paramètres',
    'Share' => 'Partager',
    'Show' => 'Afficher',
    'Show RSS feed button' => 'Afficher le bouton de flux RSS',
    'Show a map at the bottom of your organizer profile page containing the venues you added' => 'Afficher une carte au bas de la page de votre profil organisateur contenant les lieux que vous avez ajoutés',
    'Show audience filter' => 'Afficher le filtre d\'audience',
    'Show calendar button' => 'Afficher le bouton du calendrier',
    'Show category filter' => 'Afficher le filtre de catégorie',
    'Show date filter' => 'Afficher le filtre de date',
    'Show event date stats on the scanner app' => 'Afficher les statistiques de date d\'événement sur l\'application du scanner',
    'Show event dates and tickets' => 'Afficher les dates des événements et les billets',
    'Show events calendar' => 'Afficher le calendrier des événements',
    'Show events on map' => 'Afficher les événements sur la carte',
    'Show followers' => 'Afficher les abonnés',
    'Show location filter' => 'Afficher le filtre de localisation',
    'Show map button' => 'Afficher le bouton de la carte',
    'Show reviews' => 'Afficher les avis',
    'Show the GDPR compliance page link' => 'Afficher le lien vers la page de conformité au GDPR',
    'Show the attendees number and list in the event page' => 'Afficher le nombre et la liste des participants dans la page de l\'événement',
    'Show the back to top button' => 'Afficher le bouton de retour en haut',
    'Show the call to action block' => 'Afficher le bloc d\'appel à l\'action',
    'Show the cookie policy bar at the bottom' => 'Afficher la barre de politique des cookies en bas',
    'Show the cookie policy page link' => 'Afficher le lien de la page de politique de cookies',
    'Show the homepage hero seach box' => 'Afficher le champ de recherche en haut de la page d\'accueil',
    'Show the map along with the address on the venue page and event page' => 'Afficher la carte avec l\'adresse sur la page du lieu et la page de l\'événement',
    'Show the number and list of people that follow you' => 'Afficher le nombre et la liste des personnes qui vous suivent',
    'Show the privacy policy page link' => 'Afficher le lien vers la page de la politique de confidentialité',
    'Show the quote form on the venue page' => 'Afficher le formulaire de demande de devis sur la page du lieu',
    'Show the reviews that you received for your events' => 'Afficher les avis que vous avez reçus pour vos événements',
    'Show the search box' => 'Afficher le champ de recherche',
    'Show the terms of service page link' => 'Afficher le lien de la page des conditions de service',
    'Show ticket price filter' => 'Afficher le filtre de prix des billets',
    'Show tickets left count on cart modal' => 'Afficher les billets restants dans le formulaire d\'ajout au panier',
    'Show venues map' => 'Afficher mes lieux sur la carte',
    'Sign in' => 'Se connecter',
    'Sign in via Facebook' => 'Connectez-vous via Facebook',
    'Sign in via Google' => 'Connectez-vous via Google',
    'Sign in via Twitter' => 'Connectez-vous via Twitter',
    'Sign out' => 'Déconnexion',
    'Sign up' => 'S\'inscrire',
    'Sign up via Facebook' => 'Inscrivez-vous via Facebook',
    'Sign up via Google' => 'Inscrivez-vous via Google',
    'Sign up via Twitter' => 'Inscrivez-vous via Twitter',
    'Similar events' => 'Événements similaires',
    'Site key' => 'Site key',
    'Sitemap' => 'Plan du site',
    'Slug' => 'Slug',
    'Social Login' => 'Social Login',
    'Social Login settings' => 'Paramètres du Social Login',
    'Social media share image' => 'Social media share image',
    'Sold out' => 'Épuisé',
    'Sort by' => 'Trier par',
    'Standing' => 'Debout',
    'Standing guests' => 'Invités debout',
    'Standing guests number' => 'Nombre d\'invités debout',
    'Start date' => 'Date de début',
    'Starts On' => 'Commence le',
    'State' => 'État',
    'State / City' => 'Département ou ville',
    'Static Pages' => 'Pages statiques',
    'Static pages settings' => 'Paramètres des pages statiques',
    'Statistics' => 'Statistiques',
    'Status' => 'Statut',
    'Stick' => 'Coller',
    'Still in cart' => 'Actuellement dans le panier',
    'Street' => 'Rue',
    'Street 2' => 'Rue 2',
    'Street address' => 'Adresse de rue',
    'Street address 2' => 'Adresse de rue 2',
    'Stripe Checkout' => 'Stripe Checkout',
    'Stripe Checkout (credit cards)' => 'Stripe Checkout (credit cards)',
    'Stripe payout' => 'Stripe payout',
    'Stripe publishable key' => 'Stripe publishable key',
    'Stripe secret key' => 'Stripe secret key',
    'Subject' => 'Objet',
    'Submit payment' => 'Soumettre le paiement',
    'Subscribe' => 'S\'abonner',
    'Subscribe to our newsletter' => 'Abonnez-vous à notre newsletter',
    'Subtitles' => 'Sous-titres',
    'Subtotal' => 'Sous-total',
    'Successfully executed the command' => 'Exécution réussie de la commande',
    'Support for' => 'Aide pour',
    'Suspended' => 'Suspendu',
    'Symbol' => 'Symbole',
    'TLS' => 'TLS',
    'TSL' => 'TSL',
    'Tags' => 'Mots clés',
    'Take your events to the next level' => 'Faites passer vos événements au niveau supérieur',
    'Tell your attendees more about this ticket type' => 'Dites-en plus à vos participants sur ce type de billet',
    'Terms of service' => 'Conditions d\'utilisation',
    'Terms of service page slug' => 'Slug de la page des conditions de service',
    'Test the mail server configuration' => 'Tester la configuration du serveur d\'envoi des emails',
    'Texte du lien' => 'Texte du lien',
    'Texto del enlace' => 'Texto del enlace',
    'Texto do link' => 'Texto do link',
    'The amenity can not be deleted because it is linked with one or more venues' => 'La commodité ne peut pas être supprimée car elle est liée à un ou plusieurs lieux',
    'The amenity can not be found' => 'La commodité ne peut être trouvée',
    'The amenity has been deleted' => 'La commodité a été supprimé',
    'The amenity has been disabled' => 'La commodité a été désactivé',
    'The amenity has been succesfully restored' => 'La commodité a été restauré avec succès',
    'The amenity has been successfully created' => 'La commodité a été créée avec succès',
    'The amenity has been successfully updated' => 'La commodité a été mis à jour avec succès',
    'The amenity is hidden' => 'La commodité est caché',
    'The amenity is visible' => 'La commodité est visible',
    'The article can not be found' => 'L\'article est introuvable',
    'The article has been deleted' => 'L\'article a été supprimé',
    'The article has been disabled' => 'L\'article a été désactivé',
    'The article has been succesfully restored' => 'L\'article a été restauré avec succès',
    'The article has been successfully created' => 'L\'article a été créé avec succès',
    'The article has been successfully updated' => 'L\'article a été mis à jour avec succès',
    'The article is featured' => 'L\'article est désormais en vendette',
    'The article is hidden' => 'L\'article est caché',
    'The article is not featured anymore' => 'L\'article n\'est plus en vedette',
    'The article is visible' => 'L\'article est visible',
    'The article not be found' => 'L\'article n\'a pas été trouvé',
    'The audience can not be deleted because it is linked with one or more events' => 'L\'audience ne peut pas être supprimée car elle est liée à un ou plusieurs événements',
    'The audience can not be found' => 'L\'audience est introuvable',
    'The audience has been deleted' => 'L\'audience a été supprimée',
    'The audience has been disabled' => 'L\'audience a été désactivé',
    'The audience has been succesfully restored' => 'L\'audience a été restaurée avec succès',
    'The audience has been successfully created' => 'L\'audience a été créée avec succès',
    'The audience has been successfully updated' => 'L\'audience a été mise à jour avec succès',
    'The audience is hidden' => 'L\'audience est caché',
    'The audience is visible' => 'L\'audience est visible',
    'The blog post can not be found' => 'L\'article de blog est introuvable',
    'The blog post category can not be deleted because it is linked with one or more blog posts' => 'La catégorie d\'articles de blog ne peut pas être supprimée car elle est liée à un ou plusieurs articles de blog',
    'The blog post category can not be found' => 'La catégorie des articles de blog est introuvable',
    'The blog post category has been deleted' => 'La catégorie des articles de blog a été supprimée',
    'The blog post category has been disabled' => 'La catégorie des articles de blog a été désactivée',
    'The blog post category has been succesfully restored' => 'La catégorie des articles de blog a été restaurée avec succès',
    'The blog post category has been successfully created' => 'La catégorie d\'articles de blog a été créée avec succès',
    'The blog post category has been successfully updated' => 'La catégorie des articles de blog a été mise à jour avec succès',
    'The blog post category is hidden' => 'La catégorie des articles de blog est masquée',
    'The blog post category is visible' => 'La catégorie des articles de blog est désormais visible',
    'The blog post has been deleted' => 'L\'article de blog a été supprimé',
    'The blog post has been disabled' => 'L\'article de blog a été désactivé',
    'The blog post has been succesfully restored' => 'L\'article de blog a été restauré avec succès',
    'The blog post has been successfully created' => 'L\'article de blog a été créé avec succès',
    'The blog post has been successfully updated' => 'L\'article de blog a été mis à jour avec succès',
    'The blog post is hidden' => 'L\'article de blog est masqué',
    'The blog post is visible' => 'L\'article de blog est désormais visible',
    'The blog post not be found' => 'L\'article de blog est introuvable',
    'The category can not be deleted because it is linked with one or more events' => 'La catégorie ne peut pas être supprimée car elle est liée à un ou plusieurs événements',
    'The category can not be deleted because it is linked with one or more help center articles' => 'La catégorie ne peut pas être supprimée car elle est liée à un ou plusieurs articles du centre d\'aide',
    'The category can not be found' => 'La catégorie est introuvable',
    'The category has been deleted' => 'La catégorie a été supprimée',
    'The category has been disabled' => 'La catégorie a été désactivée',
    'The category has been succesfully restored' => 'La catégorie a été restaurée avec succès',
    'The category has been successfully created' => 'La catégorie a été créée avec succès',
    'The category has been successfully updated' => 'La catégorie a été mise à jour avec succès',
    'The category is featured and is shown in the homepage categories' => 'La catégorie est en vedette et affichée dans les catégories de la page d\'accueil',
    'The category is hidden' => 'La catégorie est masquée',
    'The category is not featured anymore and is removed from the homepage categories' => 'La catégorie n\'est plus en vedette et est supprimée des catégories de la page d\'accueil',
    'The category is visible' => 'La catégorie est désormais visible',
    'The category not be found' => 'La catégorie est introuvable',
    'The category was not found' => 'La catégorie n\'a pas été trouvée',
    'The confirmation email has been resent to' => 'L\'e-mail de confirmation a été renvoyé à',
    'The country can not be deleted because it is linked with one or more events' => 'Le pays ne peut pas être supprimé car il est lié à un ou plusieurs événements',
    'The country can not be found' => 'Le pays est introuvable',
    'The country has been deleted' => 'Le pays a été supprimé',
    'The country has been disabled' => 'Le pays a été désactivé',
    'The country has been succesfully restored' => 'Le pays a été restauré avec succès',
    'The country has been successfully created' => 'Le pays a été créé avec succès',
    'The country has been successfully updated' => 'Le pays a été mis à jour avec succès',
    'The country is hidden' => 'Le pays est masqué',
    'The country is visible' => 'Le pays est désormais visible',
    'The currency can not be found' => 'La devise est introuvable',
    'The currency has been deleted' => 'La devise a été supprimée',
    'The currency has been successfully created' => 'La devise a été créée avec succès',
    'The currency has been successfully updated' => 'La devise a été mise à jour avec succès',
    'The default locale must be selected in the available languages' => 'La langue par défaut par défaut doivent être sélectionnés dans les langues disponibles',
    'The email address is not valid' => 'L\'adresse e-mail n\'est pas valide',
    'The email could not be sent' => 'L\'email n\'a pas pu être envoyé',
    'The event can not be deleted because it has one or more orders' => 'L\'événement ne peut pas être supprimé car il contient une ou plusieurs commandes',
    'The event can not be found' => 'L\'événement est introuvable',
    'The event date can not be found' => 'La date de l\'événement est introuvable',
    'The event date stats (sales and attendance) will be visible on the scanner app' => 'Les statistiques de la date de l\'événement (ventes et fréquentation) seront visibles sur l\'application du scanner',
    'The event has been added to your favorites' => 'L\'événement a été ajouté à vos favoris',
    'The event has been deleted' => 'L\'événement a été supprimé',
    'The event has been deleted permanently' => 'L\'événement a été définitivement supprimé',
    'The event has been published and will figure in the search results' => 'L\'événement a été publié et figurera dans les résultats de recherche',
    'The event has been removed from your favorites' => 'L\'événement a été retiré de vos favoris',
    'The event has been succesfully restored' => 'L\'événement a été restauré avec succès',
    'The event has been successfully created' => 'L\'événement a été créé avec succès',
    'The event has been successfully updated' => 'L\'événement a été mis à jour avec succès',
    'The event has been unpublished and will not be included in the search results' => 'L\'événement n\'est plus publié et ne sera pas inclus dans les résultats de recherche',
    'The event not be found' => 'L\'événement est introuvable',
    'The event ticket can not be found' => 'Le billet de l\'événement est introuvable',
    'The fields preceded with a red * are mandatory' => 'Les champs précédés d\'un * rouge sont obligatoires',
    'The form contains invalid data' => 'Le formulaire contient des données invalides',
    'The homepage settings can not be loaded' => 'Les paramètres de la page d\'accueil ne peuvent pas être chargés',
    'The homepage settings could not be loaded' => 'Les paramètres de la page d\'accueil ne peuvent pas être chargés',
    'The language can not be deleted because it is linked with one or more events' => 'La langue ne peut pas être supprimée car elle est liée à un ou plusieurs événements',
    'The language can not be found' => 'La langue est introuvable',
    'The language has been deleted' => 'La langue a été supprimée',
    'The language has been disabled' => 'La langue a été désactivée',
    'The language has been succesfully restored' => 'La langue a été restaurée avec succès',
    'The language has been successfully created' => 'La langue a été créée avec succès',
    'The language has been successfully updated' => 'La langue a été mise à jour avec succès',
    'The language is hidden' => 'La langue est masquée',
    'The language is visible' => 'La langue est désormais visible',
    'The layout settings could not be loaded' => 'Les paramètres de mise en page n\'ont pas pu être chargés',
    'The menu can not be found' => 'Le menu est introuvable',
    'The menu has been successfully updated' => 'Le menu a été mis à jour avec succès',
    'The order can not be found' => 'La commande est introuvable',
    'The order has been deleted' => 'La commande a été supprimée',
    'The order has been permanently canceled' => 'La commande a été définitivement annulée',
    'The order has been permanently deleted' => 'La commande a été définitivement supprimée',
    'The order has been soft deleted, restore it before canceling it' => 'La commande a été supprimée, restaurez-la avant de l\'annuler',
    'The order has been succesfully restored' => 'La commande a été restaurée avec succès',
    'The order has been successfully validated' => 'La commande a été validée avec succès',
    'The order status must be paid or awaiting payment' => 'Le statut de la commande doit être payé ou en attente de paiement',
    'The organizer can not be found' => 'L\'organisateur est introuvable',
    'The organizer not be found' => 'L\'organisateur est introuvable',
    'The organizer revenue from this event date is currently zero' => 'Les revenus de l\'organisateur pour cette date de l\'événement sont actuellement zéro',
    'The page can not be found' => 'La page est introuvable',
    'The page has been deleted' => 'La page a été supprimée',
    'The page has been successfully created' => 'La page a été créée avec succès',
    'The page has been successfully updated' => 'La page a été mise à jour avec succès',
    'The payment can not be found' => 'Le paiement est introuvable',
    'The payment gateway can not be found' => 'La méthode de paiement est introuvable',
    'The payment gateway has been successfully created' => 'La méthode de paiement a été créée avec succès',
    'The payment gateway has been successfully updated' => 'La méthode de paiement a été mise à jour avec succès',
    'The payout method can not be found' => 'La méthode de paiement est introuvable',
    'The payout method has been successfully created' => 'La méthode de paiement a été créée avec succès',
    'The payout method has been successfully updated' => 'La méthode de paiement a été mise à jour avec succès',
    'The payout method is unset' => 'La méthode de paiement n\'est pas définie',
    'The payout request can not be canceled because it is already processed' => 'La demande de paiement ne peut pas être annulée car elle est déjà traitée',
    'The payout request can not be found' => 'La demande de paiement est introuvable',
    'The payout request can not be processed at this moment' => 'La demande de paiement ne peut pas être traitée pour le moment',
    'The payout request has been already processed' => 'La demande de paiement a déjà été traitée',
    'The payout request has been deleted' => 'La demande de paiement a été supprimée',
    'The payout request has been permanently canceled' => 'La demande de paiement a été définitivement annulée',
    'The payout request has been permanently deleted' => 'La demande de paiement a été définitivement supprimée',
    'The payout request has been soft deleted, restore it before canceling it' => 'La demande de paiement a été supprimée de manière réversible, restaurez-la avant de l\'annuler',
    'The payout request has been soft deleted, restore it before viewing the details' => 'La demande de paiement a été supprimée, restaurez-la avant d\'afficher les détails',
    'The payout request has been succesfully restored' => 'La demande de paiement a été restaurée avec succès',
    'The payout request has been successfully processed' => 'La demande de paiement a été traitée avec succès',
    'The payout request has been successfully submitted, you will be notified by email once it is processed' => 'La demande de paiement a été soumise avec succès, vous serez averti par e-mail une fois qu\'elle sera traitée',
    'The point of sale can not be found' => 'Le point de vente est introuvable',
    'The point of sale has been deleted' => 'Le point de vente a été supprimé',
    'The point of sale has been disabled' => 'Le point de vente a été désactivé',
    'The point of sale has been enabled' => 'Le point de vente a été activé',
    'The point of sale has been permenently deleted' => 'Le point de vente a été définitivement supprimé',
    'The point of sale has been successfully created' => 'Le point de vente a été créé avec succès',
    'The point of sale has been successfully updated' => 'Le point de vente a été mis à jour avec succès',
    'The refund could not been processed at this moment' => 'Le remboursement n\'a pas pu être traité pour le moment',
    'The refund has already been reclined' => 'Le remboursement a déjà été refusé',
    'The refund has been declined' => 'Le remboursement a été refusé',
    'The refund has been successfully processed' => 'Le remboursement a été traité avec succès',
    'The refund request has already been processed or no refund has been requested' => 'La demande de remboursement a déjà été traitée ou aucun remboursement n\'a été demandé',
    'The request method is known by the server but is not supported by the target resource' => 'La méthode de requête est connue du serveur mais n\'est pas prise en charge par la ressource cible',
    'The requested page couldn\'t be located. Checkout for any URL misspelling or' => 'La page demandée n\'a pas pu être localisée. Vérifiez toute faute d\'orthographe URL ou',
    'The review can not be found' => 'L\'avis est introuvable',
    'The review has been deleted' => 'L\'avis a été supprimé',
    'The review has been deleted permanently' => 'L\'avis a été définitivement supprimé',
    'The review has been enabled' => 'L\'avis a été activé',
    'The review has been hidden' => 'L\'avis a été masqué',
    'The review has been succesfully restored' => 'L\'avis a été restauré avec succès',
    'The scanner account is disabled by the organizer' => 'Le compte du scanner est désactivé par l\'organisateur',
    'The scanner can not be found' => 'Le scanner est introuvable',
    'The scanner has been disabled' => 'Le scanner a été désactivé',
    'The scanner has been enabled' => 'Le scanner a été activé',
    'The scanner has been permenently deleted' => 'Le scanner a été définitivement supprimé',
    'The scanner has been successfully created' => 'Le scanner a été créé avec succès',
    'The scanner has been successfully updated' => 'Le scanner a été mis à jour avec succès',
    'The settings have been updated' => 'Les paramètres ont été mis à jour',
    'The space' => 'L\'espace',
    'The test email has been sent, please check the inbox of' => 'L\'email de test a été envoyé, veuillez vérifier la boite de réception de',
    'The ticket can not be found' => 'Le billet est introuvable',
    'The ticket has already been scanned' => 'Le billet a déjà été scanné',
    'The ticket has been successfully scanned' => 'Le billet a été scanné avec succès',
    'The ticket is not valid for this event date' => 'Le billet n\'est pas valable pour cette date d\'événement',
    'The ticket was already scanned at' => 'Le billet a déjà été scanné à',
    'The tickets has been successfully added to your cart' => 'Les billets ont bien été ajoutés à votre panier',
    'The tickets have been released' => 'Les billets ont été libérés',
    'The user can not be found' => 'L\'utilisateur est introuvable',
    'The user cart has been emptied' => 'Le panier de l\'utilisateur a été vidé',
    'The user has been deleted' => 'L\'utilisateur a été supprimé',
    'The user has been disabled' => 'L\'utilisateur a été désactivé',
    'The user has been enabled' => 'L\'utilisateur a été activé',
    'The user has been permanently deleted' => 'L\'utilisateur a été définitivement supprimé',
    'The user has been succesfully restored' => 'L\'utilisateur a été restauré avec succès',
    'The username already exists' => 'Le nom d\'utilisateur existe déjà',
    'The venue can not be deleted because it is linked with one or more events' => 'Le lieu ne peut pas être supprimé car il est lié à un ou plusieurs événements',
    'The venue can not be found' => 'Le lieu est introuvable',
    'The venue has been deleted' => 'Le lieu a été supprimé',
    'The venue has been disabled' => 'Le lieu a été désactivé',
    'The venue has been succesfully restored' => 'Le lieu a été restauré avec succès',
    'The venue has been successfully created' => 'Le lieu a été créé avec succès',
    'The venue has been successfully updated' => 'Le lieu a été mis à jour avec succès',
    'The venue is hidden' => 'Le lieu est masqué',
    'The venue is hidden from the public venues directory' => 'Le lieu est masqué du répertoire des lieux',
    'The venue is listed on the public venues directory' => 'Le lieu est inscrit dans le répertoire des lieux',
    'The venue is visible' => 'Le lieu est désormais visible',
    'The venue type can not be deleted because it is linked with one or more venues' => 'Le type de lieu ne peut pas être supprimé car il est lié à un ou plusieurs lieux',
    'The venue type can not be found' => 'Le type de lieu est introuvable',
    'The venue type has been deleted' => 'Le type de lieu a été supprimé',
    'The venue type has been disabled' => 'Le type de lieu a été désactivé',
    'The venue type has been succesfully restored' => 'Le type de lieu a été restauré avec succès',
    'The venue type has been successfully created' => 'Le type de lieu a été créé avec succès',
    'The venue type has been successfully updated' => 'Le type de lieu a été mis à jour avec succès',
    'The venue type is hidden' => 'Le type de lieu est masqué',
    'The venue type is visible' => 'Le type de lieu est désormais visible',
    'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above' => 'Cette adresse e-mail sera utilisée comme expéditeur de tous les e-mails envoyés par la plateforme, dans presque tous les cas, c\'est la même que le nom d\'utilisateur ci-dessus',
    'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form' => 'Cette adresse email sera utilisée pour recevoir les demandes de devis, assurez-vous de la mentionner si vous souhaitez afficher le formulaire de devis',
    'This email address will receive the contact form messages' => 'Cette adresse email recevra les messages du formulaire de contact',
    'This email is sent as a confirmation of your order' => 'Cet email est envoyé comme confirmation de votre commande',
    'This email is sent to test the configuration of the mail server settings.' => 'Cet e-mail est envoyé pour tester la configuration des paramètres du serveur de messagerie.',
    'This event date is locked because a payout request has been submitted' => 'Cette date d\'événement est verrouillée car une demande de paiement a été soumise',
    'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)' => 'Ces frais seront ajoutés au prix de vente des billets (laissez ce champ vide pour désactiver les frais de billets supplémentaires)',
    'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders' => 'Ces frais seront ajoutés au prix de vente des billets achetés dans un point de vente, mettez 0 pour désactiver les frais supplémentaires pour les billets achetés dans un point de vente, ne s\'appliquent pas aux billets gratuits, seront appliqués aux commandes futures',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders' => 'Ces frais seront ajoutés au prix de vente des billets achetés en ligne, mettez 0 pour désactiver les frais supplémentaires pour les billets achetés en ligne, ne s\'appliquent pas aux billets gratuits, seront appliqués aux commandes futures',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders' => 'Ces frais seront ajoutés au prix de vente des billets achetés en ligne, mettez 0 pour désactiver les frais supplémentaires pour les billets achetés en ligne, ne s\'appliquent pas aux billets gratuits, seront appliqués aux commandes futures',
    'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations' => 'Il s\'agit d\'une chaîne qui doit être unique à votre application et qui est couramment utilisée pour ajouter plus d\'entropie aux opérations liées à la sécurité',
    'This link can only be used once to validate your account' => 'Ce lien ne peut être utilisé qu\'une seule fois pour valider votre compte',
    'This month' => 'Ce mois-ci',
    'This order has already been refunded' => 'Cette commande a déjà été remboursée',
    'This order is not eligible for refund because it contains tickets from different organizers' => 'Cette commande n\'est pas éligible au remboursement car elle contient des billets de différents organisateurs',
    'This order is not eligible for refund because it is not paid' => 'Cette commande ne peut pas être remboursée car elle n\'est pas payée',
    'This payout method is currently disabled' => 'Cette méthode de paiement est actuellement désactivée',
    'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders' => 'Ce pourcentage sera déduit de chaque billet vendu sur un point de vente, sur demande de paiement de l\'organisateur, ce pourcentage sera prélevé sur chaque billet vendu sur un point de vente, sera appliqué aux commandes futures',
    'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders' => 'Ce pourcentage sera déduit de chaque billet vendu en ligne, sur demande de paiement de l\'organisateur, ce pourcentage sera prélevé sur chaque billet vendu en ligne, sera appliqué aux commandes futures',
    'This ticket was scanned at %scanDate%' => 'Ce billet a été scanné à %scanDate%',
    'This week' => 'Cette semaine',
    'This weekend' => 'Cette fin de semaine',
    'Ticket' => 'Billet',
    'Ticket description' => 'Description du billet',
    'Ticket fee' => 'Frais de billet',
    'Ticket fee (Online)' => 'Frais de billet (En ligne)',
    'Ticket fee (Point Of Sale)' => 'Frais de billet (Point de vente)',
    'Ticket fees' => 'Frais de billet',
    'Ticket name' => 'Désignation du billet',
    'Ticket price' => 'Prix du billet',
    'Ticket price percentage cut (Online)' => 'Pourcentage déduit du prix du billet (En ligne)',
    'Ticket price percentage cut (Point of sale)' => 'Pourcentage déduit du prix du billet (Point de vente)',
    'Ticket style' => 'Style du billet',
    'Ticket type' => 'Type du billet',
    'Tickets' => 'Billets',
    'Tickets left' => 'Billets restants',
    'Tickets per attendee' => 'Billets par participant',
    'Tickets sales' => 'Vente de billets',
    'Tickets sales by date' => 'Ventes de billets par date',
    'Tickets sales this month' => 'Vente de billets ce mois-ci',
    'Tickets sold' => 'Billets vendus',
    'Tickets sold Per Point of sale' => 'Billets vendus par point de vente',
    'Tickets sold by channel' => 'Billets vendus par canal',
    'Tickets types' => 'Types de billets',
    'Time\'s up' => 'Le temps est écoulé',
    'Timeleft' => 'Temps restant',
    'Timezone' => 'Fuseau horaire',
    'Titel' => 'Titel',
    'Title' => 'Titre',
    'Titre' => 'Titre',
    'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)' => 'Pour aider les participants à trouver rapidement votre événement, entrez des mots clés qui identifient votre événement (appuyez sur Entrée après chaque entrée)',
    'To reset your password, click on the following button and follow the instructions' => 'Pour réinitialiser votre mot de passe, cliquez sur le bouton suivant et suivez les instructions',
    'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event' => 'Pour soumettre une nouvelle demande de paiement pour une date d\'événement, accédez à la page Mes événements et cliquez sur le lien Demander un paiement à côté de l\'événement',
    'Today' => 'Aujourd\'hui',
    'Toggle display the event date details' => 'Afficher les détails de la date de l\'événement',
    'Toggle display the search filters' => 'Afficher les filtres de recherche',
    'Tomorrow' => 'Demain',
    'Total' => 'Total',
    'Total attendees' => 'Nombre total de participants',
    'Total attendees check-in' => 'Nombre de participants enregistrés',
    'Total gross sales' => 'Ventes brutes totales',
    'Total orders' => 'Total des commandes',
    'Total sales' => 'Ventes totales',
    'Total tickets sales' => 'Ventes totales de billets',
    'Translation' => 'Traduction',
    'Translations' => 'Traductions',
    'Transport' => 'Transport',
    'Twitter' => 'Twitter',
    'Twitter url' => 'Lien Twitter',
    'Type' => 'Type',
    'Título' => 'Título',
    'Unfollow' => 'Se désabonner',
    'Unknown' => 'Inconnu',
    'Unstick' => 'Décoller',
    'Until date' => 'Jusqu\'à la date',
    'Upcoming events' => 'Évènements à venir',
    'Upcoming tickets' => 'Billets à venir',
    'Update cart' => 'Mettre à jour le panier',
    'Update date' => 'Date de mise à jour',
    'Update the amenity' => 'Mettre à jour la commodité',
    'Update the audience' => 'Mettre à jour l\'audience',
    'Update the blog post' => 'Mettre à jour l\'article de blog',
    'Update the blog post category' => 'Mettre à jour la catégorie d\'articles de blog',
    'Update the category' => 'Mettre à jour la catégorie',
    'Update the country' => 'Mettre à jour le pays',
    'Update the currency' => 'Mettre à jour la devise',
    'Update the event' => 'Mettre à jour l\'événement',
    'Update the help center article' => 'Mettre à jour l\'article du centre d\'aide',
    'Update the help center category' => 'Mettre à jour la catégorie du centre d\'aide',
    'Update the language' => 'Mettre à jour la langue',
    'Update the lapagenguage' => 'Mettre à jour la page',
    'Update the payment gateway' => 'Mettre à jour la méthode de paiement',
    'Update the point of sale' => 'Mettre à jour le point de vente',
    'Update the scanner' => 'Mettre à jour le scanner',
    'Update the venue' => 'Mettre à jour le lieu',
    'Update the venue type' => 'Mettre à jour le type de lieu',
    'Update your %payoutMethodName% payout method' => 'Mettez à jour votre méthode de paiement %payoutMethodName%',
    'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string' => 'Utilisé dans certains cas spécifiques, suivez ce lien pour une liste des caractères pris en charge: https://www.php.net/manual/en/datetime.format.php. Veuillez vous assurer de conserver les guillemets doubles "" autour de la chaîne de format',
    'Useful Links' => 'Liens utiles',
    'User information' => 'Informations de l\'utilisateur',
    'Username' => 'Nom d\'utilisateur',
    'Users' => 'Utilisateurs',
    'Users summary' => 'Résumé des utilisateurs',
    'Uset' => 'Cancel',
    'Validate' => 'Valider',
    'Venue' => 'Lieu',
    'Venue / Location' => 'Lieu / Emplacement',
    'Venue image' => 'Image du lieu',
    'Venue name...' => 'Nom du lieu...',
    'Venue page' => 'Page du lieu',
    'Venue page settings' => 'Paramètres de la page du lieu',
    'Venue type' => 'Type du lieu',
    'Venue types' => 'Types de lieux',
    'Venues' => 'Lieux',
    'Venues Pages' => 'Pages des lieux',
    'Venues count' => 'Nombre de lieux',
    'Venues page' => 'Page des lieux',
    'Video' => 'Vidéo',
    'View cart' => 'Voir le panier',
    'View detailed statistics' => 'Afficher des statistiques détaillées',
    'View details' => 'Voir les détails',
    'View event' => 'Afficher l\'événement',
    'View organizer' => 'Afficher l\'organisateur',
    'View stats' => 'Afficher les statistiques',
    'Views' => 'Vues',
    'Visible' => 'Visible',
    'Visible only' => 'Visible uniquement',
    'We recommend a 48x48 image size' => 'Nous recommandons une image de taille 48x48',
    'We will be back shortly.' => 'Nous serons de retour très bientôt.',
    'Website' => 'Site',
    'Website description' => 'Description du site',
    'Website name' => 'Nom du site',
    'Website root url' => 'URL racine du site',
    'Website slug' => 'Slug du site',
    'Website url' => 'URL du site',
    'Welcome' => 'Bienvenu',
    'What to show in the homepage hero ?' => 'Que montrer dans le haut de la page d\'accueil?',
    'When' => 'Quand',
    'Where' => 'Où',
    'Will be show in the homepage, the explore menu item dropdown and in the footer' => 'Sera affiché dans la page d\'accueil, la liste déroulante de l\'élément de menu Explorer et dans le pied de page',
    'With sales only' => 'Avec ventes seulement',
    'Without sales only' => 'Sans vente seulement',
    'Year' => 'Année',
    'Yellow' => 'Jaune',
    'Yes' => 'Oui',
    'You are about to approve the payout request' => 'Vous êtes sur le point d\'approuver la demande de paiement',
    'You are about to cancel this order (this action cannot be undone)' => 'Vous êtes sur le point d\'annuler cette commande (cette action ne peut pas être annulée)',
    'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked' => 'Vous êtes sur le point d\'annuler cette demande de paiement (cette action ne peut pas être annulée), la date de l\'événement lié à cette demande de paiement sera déverrouillée',
    'You are about to delete the amenity PERMANENTLY' => 'Vous êtes sur le point de supprimer la commodité DÉFINITIVEMENT',
    'You are about to delete the article PERMANENTLY' => 'Vous êtes sur le point de supprimer l\'article DÉFINITIVEMENT',
    'You are about to delete the audience PERMANENTLY' => 'Vous êtes sur le point de supprimer l\'audience DÉFINITIVEMENT',
    'You are about to delete the blog post PERMANENTLY' => 'Vous êtes sur le point de supprimer le blog DÉFINITIVEMENT',
    'You are about to delete the blog post category PERMANENTLY' => 'Vous êtes sur le point de supprimer la catégorie d\'articles de blog DÉFINITIVEMENT',
    'You are about to delete the category PERMANENTLY' => 'Vous êtes sur le point de supprimer la catégorie DÉFINITIVEMENT',
    'You are about to delete the country PERMANENTLY' => 'Vous êtes sur le point de supprimer le pays DÉFINITIVEMENT',
    'You are about to delete the currency PERMANENTLY' => 'Vous êtes sur le point de supprimer la devise de manière permanente',
    'You are about to delete the event and all its related information PERMANENTLY' => 'Vous êtes sur le point de supprimer l\'événement et toutes ses informations connexes DÉFINITIVEMENT',
    'You are about to delete the language PERMANENTLY' => 'Vous êtes sur le point de supprimer la langue DÉFINITIVEMENT',
    'You are about to delete the order and all its related information (payment details, tickets...)' => 'Vous êtes sur le point de supprimer la commande et toutes ses informations associées (détails de paiement, billets ...)',
    'You are about to delete the page PERMANENTLY' => 'Vous êtes sur le point de supprimer la page DÉFINITIVEMENT',
    'You are about to delete the payout request and all its related information' => 'Vous êtes sur le point de supprimer la demande de paiement et toutes ses informations associées',
    'You are about to delete the point of sale' => 'You are about to delete the point of sale',
    'You are about to delete the point of sale PERMANENTLY' => 'Vous êtes sur le point de supprimer le point de vente DÉFINITIVEMENT',
    'You are about to delete the review PERMANENTLY' => 'Vous êtes sur le point de supprimer l\'avis DÉFINITIVEMENT',
    'You are about to delete the scanner' => 'You are about to delete the scanner',
    'You are about to delete the scanner PERMANENTLY' => 'Vous êtes sur le point de supprimer le scanner DÉFINITIVEMENT',
    'You are about to delete the user and all its related information (orders, events...) PERMANENTLY' => 'Vous êtes sur le point de supprimer l\'utilisateur et toutes ses informations associées (commandes, événements ...) DÉFINITIVEMENT',
    'You are about to delete the venue PERMANENTLY' => 'Vous êtes sur le point de supprimer le lieu DÉFINITIVEMENT',
    'You are about to delete the venue type PERMANENTLY' => 'Vous êtes sur le point de supprimer le type de lieu DÉFINITIVEMENT',
    'You are about to empty your cart' => 'Vous êtes sur le point de vider votre panier',
    'You are about to validate this order, generate the tickets and send a confirmation email to the attendee' => 'Vous êtes sur le point de valider cette commande, de générer les billets et d\'envoyer un email de confirmation au participant',
    'You are connected as "%username%' => 'Vous êtes connecté en tant que "%username%',
    'You are following this organizer' => 'Vous suivez cet organisateur',
    'You are going to this event' => 'Vous allez à cet événement',
    'You are logged in as:' => 'Vous êtes connecté en tant que:',
    'You are no longer following this organizer' => 'Vous ne suivez plus cet organisateur',
    'You are not following any organizer' => 'Vous ne suivez aucun organisateur',
    'You can introduce the event details in multiple locales' => 'Vous pouvez introduire les détails de l\'événement dans plusieurs langues',
    'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help' => 'Vous n\'avez pas trouvé de réponse à votre demande? Faites-nous savoir et nous serons heureux de vous aider',
    'You don\'t have permission to access this resource' => 'Vous n\'êtes pas autorisé à accéder à cette ressource',
    'You have added %tickets% ticket(s) to your cart' => 'Vous avez ajouté %tickets% billet(s) à votre panier',
    'You have already bought %tickets% ticket(s)' => 'Vous avez déjà acheté %tickets% billet(s)',
    'You have already requested a refund for this order' => 'Vous avez déjà demandé un remboursement pour cette commande',
    'You have already requested a refund for this order and it was approved' => 'Vous avez déjà demandé un remboursement pour cette commande et elle a été approuvée',
    'You have already requested a refund for this order and it was declined' => 'Vous avez déjà demandé un remboursement pour cette commande et elle a été refusée',
    'You have received a new quote request for the venue' => 'Vous avez reçu une nouvelle demande de devis pour le lieu',
    'You have successfully subscribed to our newsletter' => 'Vous avez souscrit avec succès à notre newsletter',
    'You must choose an event and set the status to paid in order to export attendees list to a PDF file' => 'Vous devez choisir un événement et définir le statut à Payé pour exporter la liste des participants vers un fichier PDF',
    'You must choose an event in order to export the attendees list' => 'Vous devez choisir un événement pour exporter la liste des participants',
    'You must review your cart before proceeding to checkout' => 'Vous devez revoir votre panier avant de passer au paiement',
    'You must set the status to paid in order to export the attendees list' => 'Vous devez définir le statut à Payé pour exporter la liste des participants',
    'You must specify at least one language' => 'Vous devez spécifier au moins une langue',
    'You order is empty' => 'Votre commande est vide',
    'Your account settings have been updated' => 'Les paramètres de votre compte ont été mis à jour',
    'Your cart has been automatically updated because one or more event\'s quotas has changed' => 'Votre panier a été automatiquement mis à jour car un ou plusieurs quotas d\'événement ont changé',
    'Your cart has been automatically updated because one or more events are no longer on sale' => 'Votre panier a été automatiquement mis à jour car un ou plusieurs événements ne sont plus en vente',
    'Your cart has been emptied' => 'Votre panier a été vidé',
    'Your cart has been updated' => 'Votre panier a été mis à jour',
    'Your cart is empty' => 'Votre panier est vide',
    'Your email' => 'Votre email',
    'Your message has been successfully sent' => 'Votre message a été bien envoyé',
    'Your order has been automatically canceled because one or more event\'s quotas has changed' => 'Votre commande a été automatiquement annulée car un ou plusieurs quotas d\'événement ont changé',
    'Your order has been automatically canceled because one or more events are no longer on sale' => 'Votre commande a été automatiquement annulée car un ou plusieurs événements ne sont plus en vente',
    'Your order has been automatically canceled because your ticket reservations has been released' => 'Votre commande a été automatiquement annulée car vos réservations de billets ont été libérées',
    'Your order has been successfully placed, please proceed to the payment as explained in the instructions' => 'Votre commande a été passée avec succès, veuillez procéder au paiement comme expliqué dans les instructions',
    'Your organizer profile has been successfully updated' => 'Votre profil d\'organisateur a été mis à jour avec succès',
    'Your payment could not be processed at this time' => 'Votre paiement n\'a pas pu être traité pour le moment',
    'Your payment has been successfully processed' => 'Votre paiement a été traité avec succès',
    'Your payment operation was canceled' => 'Votre opération de paiement a été annulée',
    'Your payout request has been processed' => 'Votre demande de paiement a été traitée',
    'Your quote request has been successfully sent' => 'Votre demande de devis a été envoyée avec succès',
    'Your rating (out of 5 stars)' => 'Votre note (sur 5 étoiles)',
    'Your refund request has been successfully submitted to the organizer' => 'Votre demande de remboursement a bien été soumise à l\'organisateur',
    'Your registration has been successfully processed' => 'Votre inscription a été traitée avec succès',
    'Your review has been successfully saved' => 'Votre avis a bien été enregistré',
    'Your review headline' => 'Titre de votre avis',
    'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away' => 'Vos billets ne sont pas réservés avant le paiement, la quantité que vous avez l\'intention d\'acheter pourrait ne pas être disponible si vous ne passez pas tout de suite au paiement',
    'Your tickets bought from' => 'Vos billets achetés de',
    'Youtube' => 'Youtube',
    'Youtube url' => 'Lien Youtube',
    'Youtube video' => 'Vidéo Youtube',
    'Youtube video url' => 'Lien de la vidéo Youtube',
    'Zip / Postal code' => 'Code postal',
    'and' => 'et',
    'asc' => 'asc',
    'at' => 'à',
    'checked In' => 'Enregistré',
    'created at' => 'Créé à',
    'desc' => 'desc',
    'event to the next level ?' => 'événement au niveau supérieur?',
    'for' => 'pour',
    'form.label.delete' => 'Supprimer',
    'form.password' => 'Mot de passe',
    'form.password_confirmation' => 'Confirmation du mot passe',
    'image(s)' => 'image(s)',
    'left' => 'Gauche',
    'left before tickets are released' => 'restant avant la libération des billets',
    'min read' => 'min de lecture',
    'my points of sale' => 'Mes points de vente',
    'my scanners' => 'Mes scanners',
    'my venues' => 'Mes lieux',
    'orders summary' => 'Résumé des commandes',
    'out of 5 stars' => 'sur 5 étoiles',
    'placed on' => 'faite le',
    'return to the homepage' => 'retour à la page d\'accueil',
    'review' => 'review',
    'right' => 'Droite',
    'ticket' => 'billet',
    'ticket(s)' => 'billet(s)',
    'ticket(s) sold' => 'billet(s) vendus',
    'tickets' => 'billets',
    'tickets found in your cart' => 'billets trouvés dans votre panier',
    'tickets left' => 'billets restants',
    'tickets per attendee' => 'billets par participant',
    'title' => 'titre',
    'to edit your profile' => 'pour modifier votre profil',
    'to manage this event' => 'pour gérer cet événement',
    'to manage your event' => 'pour gérer votre événement',
    'to preview your profile' => 'pour prévisualiser votre profil',
    'to return to your dashboard' => 'pour revenir à votre tableau de bord',
    'user(s)' => 'utilisateur(s)',
    'view(s)' => 'vue(s)',
    'views' => 'vues',
    'your payout request has been processed' => 'votre demande de paiement a été traitée',
    'your tickets are ready to go!' => 'vos billets sont prêts à partir!',
    'اسم' => 'اسم',
    'اسم القائمة' => 'اسم القائمة',
    'التفاصيل' => 'التفاصيل',
    'العلامات' => 'العلامات',
    'الكلمات الرئيسية' => 'الكلمات الرئيسية',
    'تعليمات' => 'تعليمات',
    'عنوان' => 'عنوان',
    'فقرة' => 'فقرة',
    'محتوى' => 'محتوى',
    'نص الرابط' => 'نص الرابط',
    'نص العنوان' => 'نص العنوان',
    '关键字' => '关键字',
    '内容' => '内容',
    '名称' => '名称',
    '描述' => '描述',
    '标签' => '标签',
    '标题' => '标题',
    '段' => '段',
  ),
  'javascript' => 
  array (
    'Add' => 'Ajouter',
    'Add a new event date' => 'Ajouter une nouvelle date d\'événement',
    'Add a new ticket' => 'Ajouter un nouveau billet',
    'An error has occured' => 'Une erreur est survenue',
    'April' => 'Avril',
    'August' => 'Août',
    'Cancel' => 'Annuler',
    'Close' => 'Fermer',
    'Confirm' => 'Confirmer',
    'Confirmation required' => 'Confirmation requise',
    'Day' => 'Jour',
    'December' => 'Décembre',
    'Duplicate this event date' => 'Dupliquer cette date d\'événement',
    'Duplicate this ticket' => 'Dupliquer ce billet',
    'Email address' => 'Adresse e-mail',
    'February' => 'Février',
    'Insert at least 3 characters' => 'Insérez au moins 3 caractères',
    'January' => 'Janvier',
    'July' => 'Juillet',
    'June' => 'Juin',
    'Load more' => 'Charger plus',
    'Loading...' => 'Chargement...',
    'Mail server test email' => 'Email de test de la configuration du serveur d\'envoi des emails',
    'Make sure to enter a valid email address' => 'Assurez-vous de saisir une adresse e-mail valide',
    'March' => 'Mars',
    'May' => 'Mai',
    'Message' => 'Message',
    'Month' => 'Mois',
    'Move down' => 'Déplacer vers le bas',
    'Move up' => 'Déplacer vers le haut',
    'No results found' => 'Aucun résultat trouvé',
    'Note' => 'Note',
    'November' => 'Novembre',
    'October' => 'Octobre',
    'Please select the tickets quantity for this order' => 'Veuillez sélectionner la quantité de billets pour cette commande',
    'Please select the tickets quantity you want to buy' => 'Veuillez sélectionner la quantité de billets que vous souhaitez acheter',
    'Read more' => 'Lire la suite',
    'Remove' => 'Supprimer',
    'Remove this event date' => 'Supprimer cette date d\'événement',
    'Remove this ticket' => 'Supprimer ce billet',
    'Return to cart' => 'Retour au panier',
    'Searching ...' => 'Recherche ...',
    'Select an option' => 'Sélectionnez une option',
    'Send' => 'Envoyer',
    'September' => 'Septembre',
    'Stick' => 'Persévérer',
    'The email address is not valid' => 'L\'adresse e-mail n\'est pas valide',
    'The tickets have been released' => 'Les billets ont été libérés',
    'This feature is disabled in demo mode' => 'Cette fonctionnalité est désactivée en mode démo',
    'Time\'s up' => 'Le temps est écoulé',
    'Today' => 'Aujourd\'hui',
    'Unstick' => 'Décoller',
    'Week' => 'Semaine',
    'days' => 'jours',
    'days.Fri' => 'Ven',
    'days.Mon' => 'Lun',
    'days.Sat' => 'Sam',
    'days.Sun' => 'Dim',
    'days.Thu' => 'Jeu',
    'days.Tue' => 'Mar',
    'days.Wed' => 'Mer',
    'hr' => 'heures',
    'javascript string translation' => 'javascript string translation',
    'min' => 'min',
    'sec' => 'sec',
    'weeks' => 'sem',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'fos_user.username.already_used' => 'The username is already used.',
    'fos_user.username.blank' => 'Please enter a username.',
    'fos_user.username.short' => 'The username is too short.',
    'fos_user.username.long' => 'The username is too long.',
    'fos_user.email.already_used' => 'The email is already used.',
    'fos_user.email.blank' => 'Please enter an email.',
    'fos_user.email.short' => 'The email is too short.',
    'fos_user.email.long' => 'The email is too long.',
    'fos_user.email.invalid' => 'The email is not valid.',
    'fos_user.password.blank' => 'Please enter a password.',
    'fos_user.password.short' => 'The password is too short.',
    'fos_user.password.mismatch' => 'The entered passwords don\'t match.',
    'fos_user.new_password.blank' => 'Please enter a new password.',
    'fos_user.new_password.short' => 'The new password is too short.',
    'fos_user.current_password.invalid' => 'The entered password is invalid.',
    'fos_user.group.blank' => 'Please enter a name.',
    'fos_user.group.short' => 'The name is too short.',
    'fos_user.group.long' => 'The name is too long.',
    'fos_group.name.already_used' => 'The name is already used.',
    'This value is not a valid captcha.' => 'This value is not a valid captcha.',
    'The captcha was not resolved on the right domain.' => 'The captcha was not resolved on the right domain.',
    'validator.credit_card.invalidDate' => 'This value should be a valid date.',
    'Please enter a message' => 'Please enter a message',
    'Please enter a permalink' => 'Please enter a permalink',
    'Please enter an id' => 'Please enter an id',
    'Please provide a valid url' => 'Please provide a valid url',
    'The file should be an image' => 'The file should be an image',
    'The message is too short|The message is too short' => 'The message is too short|The message is too short',
    'The password fields must match.' => 'The password fields must match.',
    'You must set the default locale at least for the translation fields' => 'You must set the default locale at least for the translation fields',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
  ),
  'VichUploaderBundle' => 
  array (
    'download' => 'Download',
    'form.label.delete' => 'Delete?',
  ),
  'FOSUserBundle' => 
  array (
    'group.edit.submit' => 'Update group',
    'group.show.name' => 'Group name',
    'group.new.submit' => 'Create group',
    'group.flash.updated' => 'The group has been updated.',
    'group.flash.created' => 'The group has been created.',
    'group.flash.deleted' => 'The group has been deleted.',
    'security.login.username' => 'Username',
    'security.login.password' => 'Password',
    'security.login.remember_me' => 'Remember me',
    'security.login.submit' => 'Log in',
    'profile.show.username' => 'Username',
    'profile.show.email' => 'Email',
    'profile.edit.submit' => 'Update',
    'profile.flash.updated' => 'The profile has been updated.',
    'change_password.submit' => 'Change password',
    'change_password.flash.success' => 'The password has been changed.',
    'registration.check_email' => 'An email has been sent to %email%. It contains an activation link you must click to activate your account.
',
    'registration.confirmed' => 'Congrats %username%, your account is now activated.',
    'registration.back' => 'Back to the originating page.',
    'registration.submit' => 'Register',
    'registration.flash.user_created' => 'The user has been created successfully.',
    'registration.email.subject' => 'Welcome %username%!',
    'registration.email.message' => 'Hello %username%!

To finish activating your account - please click on the following link %confirmationUrl%

This link can only be used once to validate your account.

Regards,
the Team.
',
    'resetting.check_email' => 'An email has been sent. It contains a link you must click to reset your password.
Note: You can only request a new password once within %tokenLifetime% hours.

If you don\'t get an email check your spam folder or try again.
',
    'resetting.request.username' => 'Username or email address',
    'resetting.request.submit' => 'Reset password',
    'resetting.reset.submit' => 'Change password',
    'resetting.flash.success' => 'The password has been reset successfully.',
    'resetting.email.subject' => 'Reset Password',
    'resetting.email.message' => 'Hello %username%!

To reset your password - please visit %confirmationUrl%

Regards,
the Team.
',
    'layout.logout' => 'Log out',
    'layout.login' => 'Log in',
    'layout.register' => 'Register',
    'layout.logged_in_as' => 'Logged in as %username%',
    'form.group_name' => 'Group name',
    'form.username' => 'Username',
    'form.email' => 'Email',
    'form.current_password' => 'Current password',
    'form.password' => 'Password',
    'form.password_confirmation' => 'Repeat password',
    'form.new_password' => 'New password',
    'form.new_password_confirmation' => 'Repeat new password',
    'Password' => 'Password',
    'Privacy policy' => 'Privacy policy',
    'Terms of service' => 'Terms of service',
    'Welcome' => 'Welcome',
  ),
  'HWIOAuthBundle' => 
  array (
    'header.connecting' => 'Connecting',
    'header.success' => 'Successfully connected the account "%name%"!',
    'header.register' => 'Register with the account "%name%"',
    'header.registration_success' => 'Successfully registered and connected the account "%username%"!',
    'connect.confirm.cancel' => 'Cancel',
    'connect.confirm.submit' => 'Connect account',
    'connect.confirm.text' => 'Are you sure that you want to connect your %service% account "%name%" to your current account?',
    'connect.registration.cancel' => 'Cancel',
    'connect.registration.submit' => 'Register account',
  ),
  'time' => 
  array (
    'diff.ago.year' => '1 year ago|%count% years ago',
    'diff.ago.month' => '1 month ago|%count% months ago',
    'diff.ago.day' => '1 day ago|%count% days ago',
    'diff.ago.hour' => '1 hour ago|%count% hours ago',
    'diff.ago.minute' => '1 minute ago|%count% minutes ago',
    'diff.ago.second' => '1 second ago|%count% seconds ago',
    'diff.empty' => 'now',
    'diff.in.second' => 'in 1 second|in %count% seconds',
    'diff.in.hour' => 'in 1 hour|in %count% hours',
    'diff.in.minute' => 'in 1 minute|in %count% minutes',
    'diff.in.day' => 'in 1 day|in %count% days',
    'diff.in.month' => 'in 1 month|in %count% months',
    'diff.in.year' => 'in 1 year|in %count% years',
  ),
  'FOSCommentBundle' => 
  array (
    'fos_comment_comment_new_headline_first' => 'You are the first to comment !',
    'fos_comment_comment_new_headline' => 'Add a new comment',
    'fos_comment_comment_new_submit' => 'Save',
    'fos_comment_comment_new_cancel' => 'Cancel',
    'fos_comment_comment_edit_submit' => 'Save',
    'fos_comment_comment_edit_cancel' => 'Cancel',
    'fos_comment_comment_reply_reply_to' => 'Reply',
    'fos_comment_comment_reply_cancel' => 'Cancel',
    'fos_comment_comment_show_by' => 'By',
    'fos_comment_comment_show_voteup' => 'Vote up',
    'fos_comment_comment_show_votedown' => 'Vote down',
    'fos_comment_comment_show_reply' => 'Reply',
    'fos_comment_comment_vote_score' => 'Vote',
    'fos_comment_comment_tree_load_more' => 'Load More Replies',
    'fos_comment_rss_feed' => 'RSS Feed',
    'fos_comment_thread_close' => 'Close thread',
    'fos_comment_thread_open' => 'Open thread',
    'fos_comment_thread_comment_count' => 'Comments',
    'fos_comment_comment_edit' => 'Edit',
    'fos_comment_comment_delete' => 'Delete',
    'fos_comment_comment_undelete' => 'Comment undeleted',
    'fos_comment_comment_deleted' => 'Comment deleted',
  ),
  'PayumBundle' => 
  array (
    'form.credit_card.holder' => 'Holder Name',
    'form.credit_card.expire_at' => 'Expiration Date',
    'form.credit_card.number' => 'Card Number',
    'form.credit_card.security_code' => 'Security (CVV) Code',
    'form.choice.paypal_express_checkout' => 'Paypal Express Checkout',
  ),
  'messages' => 
  array (
    'coresphere_console.headline.index' => 'Console',
    'coresphere_console.working_directory' => 'Working directory',
    'coresphere_console.environment' => 'Environment',
    'coresphere_console.welcome_message' => 'Type %command% to get a list of all commands.',
    'coresphere_console.loading' => 'Loading...',
    'coresphere_console.suggestion_head' => 'Did you mean:',
    'coresphere_console.empty_response' => 'Complete!',
    '%cartElementsCount% event(s) currently in cart' => '%cartElementsCount% event(s) currently in cart',
    '%mins% left before tickets are released' => '%mins% left before tickets are released',
    '%resultsCount% attendee(s) found' => '%resultsCount% attendee(s) found',
    '%resultsCount% event date(s) found' => '%resultsCount% event date(s) found',
    '%resultsCount% event(s)' => '%resultsCount% event(s)',
    '%resultsCount% event(s) currently on sale' => '%resultsCount% event(s) currently on sale',
    '%resultsCount% event(s) found' => '%resultsCount% event(s) found',
    '%resultsCount% post(s) found' => '%resultsCount% post(s) found',
    '%resultsCount% result(s) found' => '%resultsCount% result(s) found',
    '%resultsCount% results found' => '%resultsCount% results found',
    '%resultsCount% reviews(s) found' => '%resultsCount% reviews(s) found',
    '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets' => '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets',
    '%websiteName% is undergoing a scheduled maintenance.' => '%websiteName% is undergoing a scheduled maintenance.',
    1 => '1',
    '1 star' => '1 star',
    10 => '10',
    11 => '11',
    12 => '12',
    13 => '13',
    14 => '14',
    15 => '15',
    2 => '2',
    '2 stars' => '2 stars',
    3 => '3',
    '3 stars' => '3 stars',
    4 => '4',
    '4 stars' => '4 stars',
    5 => '5',
    '5 stars' => '5 stars',
    6 => '6',
    7 => '7',
    8 => '8',
    9 => '9',
    'A payout can not be requested on a free event date' => 'A payout can not be requested on a free event date',
    'A payout can only be requested after at least one online successful sale' => 'A payout can only be requested after at least one online successful sale',
    'A payout is already requested for this event date' => 'A payout is already requested for this event date',
    'About the organizer' => 'About the organizer',
    'About us' => 'About us',
    'Absatz' => 'Absatz',
    'Access denied' => 'Access denied',
    'Access granted' => 'Access granted',
    'Access is denied. You may not have the appropriate permissions to access this resource.' => 'Access is denied. You may not have the appropriate permissions to access this resource.',
    'Account' => 'Account',
    'Account information' => 'Account information',
    'Account settings' => 'Account settings',
    'Account status' => 'Account status',
    'Actions' => 'Actions',
    'Active attendees' => 'Active attendees',
    'Active organizers' => 'Active organizers',
    'Add a blog post' => 'Add a blog post',
    'Add a help center article' => 'Add a help center article',
    'Add a new amenity' => 'Add a new amenity',
    'Add a new audience' => 'Add a new audience',
    'Add a new blog post' => 'Add a new blog post',
    'Add a new blog post category' => 'Add a new blog post category',
    'Add a new category' => 'Add a new category',
    'Add a new country' => 'Add a new country',
    'Add a new currency' => 'Add a new currency',
    'Add a new event' => 'Add a new event',
    'Add a new help center article' => 'Add a new help center article',
    'Add a new help center category' => 'Add a new help center category',
    'Add a new language' => 'Add a new language',
    'Add a new page' => 'Add a new page',
    'Add a new payment gateway' => 'Add a new payment gateway',
    'Add a new point of sale' => 'Add a new point of sale',
    'Add a new scanner' => 'Add a new scanner',
    'Add a new venue' => 'Add a new venue',
    'Add a new venue type' => 'Add a new venue type',
    'Add events to your favorites by clicking the heart button' => 'Add events to your favorites by clicking the heart button',
    'Add other images that represent your event to be displayed as a gallery' => 'Add other images that represent your event to be displayed as a gallery',
    'Add to calendar' => 'Add to calendar',
    'Add to cart' => 'Add to cart',
    'Add to favorites' => 'Add to favorites',
    'Add your review' => 'Add your review',
    'Add your review for %eventname%' => 'Add your review for %eventname%',
    'Added to favorites by' => 'Added to favorites by',
    'Additional note' => 'Additional note',
    'Address' => 'Address',
    'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment' => 'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment',
    'All' => 'All',
    'All categories' => 'All categories',
    'All event dates for an organizer' => 'All event dates for an organizer',
    'All orders for an organizer' => 'All orders for an organizer',
    'All payout requests for an organizer' => 'All payout requests for an organizer',
    'Allow Paypal as a payout method for the organizers to receive their revenue' => 'Allow Paypal as a payout method for the organizers to receive their revenue',
    'Allow Stripe as a payout method for the organizers to receive their revenue' => 'Allow Stripe as a payout method for the organizers to receive their revenue',
    'Allow attendees to leave reviews' => 'Allow attendees to leave reviews',
    'Allow tap to check in on the scanner app' => 'Allow tap to check in on the scanner app',
    'Already have an account?' => 'Already have an account?',
    'Alternative date and time format' => 'Alternative date and time format',
    'Amenities' => 'Amenities',
    'Amount' => 'Amount',
    'An error has occured' => 'An error has occured',
    'An error has occured while processing your request' => 'An error has occured while processing your request',
    'An error might occur if the command execution time reaches your PHP max_execution_time directive' => 'An error might occur if the command execution time reaches your PHP max_execution_time directive',
    'Anweisungen' => 'Anweisungen',
    'Anything' => 'Anything',
    'Anytime' => 'Anytime',
    'Anywhere' => 'Anywhere',
    'App Debugging' => 'App Debugging',
    'App Environment' => 'App Environment',
    'App Secret' => 'App Secret',
    'Application layout' => 'Application layout',
    'Application theme' => 'Application theme',
    'Approve' => 'Approve',
    'Approved' => 'Approved',
    'Are you ready to take your' => 'Are you ready to take your',
    'Article details' => 'Article details',
    'Articles' => 'Articles',
    'Articles count' => 'Articles count',
    'Artists' => 'Artists',
    'Assigned events' => 'Assigned events',
    'Attendance' => 'Attendance',
    'Attendee' => 'Attendee',
    'Attendee / POS' => 'Attendee / POS',
    'Attendee Name / Email' => 'Attendee Name / Email',
    'Attendee Registration' => 'Attendee Registration',
    'Attendee information' => 'Attendee information',
    'Attendee name or email, ticket reference, order reference' => 'Attendee name or email, ticket reference, order reference',
    'Attendee status' => 'Attendee status',
    'Attendee tickets' => 'Attendee tickets',
    'Attendees' => 'Attendees',
    'Attendees Check In' => 'Attendees Check In',
    'Attendees check-in' => 'Attendees check-in',
    'Attendees list' => 'Attendees list',
    'Attendees reviews' => 'Attendees reviews',
    'Attendees summary' => 'Attendees summary',
    'Audience' => 'Audience',
    'Audiences' => 'Audiences',
    'Authentification Pages' => 'Authentication Pages',
    'Authorized' => 'Authorized',
    'Automatically canceled before deletion' => 'Automatically canceled before deletion',
    'Availability' => 'Availability',
    'Available languages' => 'Available languages',
    'Availibility' => 'Availibility',
    'Avatar' => 'Avatar',
    'Awaiting payment' => 'Awaiting payment',
    'Beschreibung' => 'Beschreibung',
    'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button' => 'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button',
    'Best regards, the %website_name% team' => 'Best regards, the %website_name% team',
    'Billing information' => 'Billing information',
    'Birthdate' => 'Birthdate',
    'Blog' => 'Blog',
    'Blog Pages' => 'Blog Pages',
    'Blog page' => 'Blog page',
    'Blog post' => 'Blog post',
    'Blog posts count' => 'Blog posts count',
    'Blog settings' => 'Blog settings',
    'Bought on' => 'Bought on',
    'Bought tickets' => 'Bought tickets',
    'Browse events' => 'Browse events',
    'Buy more tickets' => 'Buy more tickets',
    'Buy tickets' => 'Buy tickets',
    'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.' => 'By clicking on send, an email is going to be sent to the chosen email address. Make sure to save the configuration to be tested before testing.',
    'By clicking the Sign Up button, I agree to' => 'By clicking the Sign Up button, I agree to',
    'CCY' => 'CCY',
    'Cancel' => 'Cancel',
    'Canceled' => 'Canceled',
    'Captured' => 'Captured',
    'Cart' => 'Cart',
    'Cart elements' => 'Cart elements',
    'Cash / Check / Bank Transfer / Other' => 'Cash / Check / Bank Transfer / Other',
    'Cash / Check / Offline' => 'Cash / Check / Offline',
    'Categories' => 'Categories',
    'Categories page' => 'Categories page',
    'Category' => 'Category',
    'Ccy' => 'Ccy',
    'Change password' => 'Change password',
    'Check In' => 'Check In',
    'Check In Attendees for this event date' => 'Check In Attendees for this event date',
    'Check your email inbox' => 'Check your email inbox',
    'Checked In At' => 'Checked In At',
    'Checked In Only' => 'Checked In Only',
    'Checkout' => 'Checkout',
    'Checkout settings' => 'Checkout settings',
    'Choose a new image to replace the old one' => 'Choose a new image to replace the old one',
    'Choose a payment gateway' => 'Choose a payment gateway',
    'Choose the link destination page' => 'Choose the link destination page',
    'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )' => 'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )',
    'City' => 'City',
    'Clear the application cache for the development environment' => 'Clear the application cache for the development environment',
    'Clear the application cache for the production environment' => 'Clear the application cache for the production environment',
    'Click here' => 'Click here',
    'Click on a date to view tickets' => 'Click on a date to view tickets',
    'Close' => 'Close',
    'Compact' => 'Compact',
    'Configuration' => 'Configuration',
    'Confirm' => 'Confirm',
    'Confirm account' => 'Confirm account',
    'Confirm payment and place order' => 'Confirm payment and place order',
    'Confirm payout request' => 'Confirm payout request',
    'Confirmation required' => 'Confirmation required',
    'Console' => 'Console',
    'Contact' => 'Contact',
    'Contact & Social media' => 'Contact & Social media',
    'Contact Us' => 'Contact Us',
    'Contact address' => 'Contact address',
    'Contact email' => 'Contact email',
    'Contact email address' => 'Contact email address',
    'Contact fax' => 'Contact fax',
    'Contact information' => 'Contact information',
    'Contact phone' => 'Contact phone',
    'Contact phone number' => 'Contact phone number',
    'Contact the attendee' => 'Contact the attendee',
    'Contact the organizer' => 'Contact the organizer',
    'Contact us' => 'Contact us',
    'Contenido' => 'Contenido',
    'Content' => 'Content',
    'Contente' => 'Contente',
    'Contenu' => 'Contenu',
    'Cookie policy' => 'Cookie policy',
    'Cookie policy page slug' => 'Cookie policy page slug',
    'Copyright' => 'Copyright',
    'Count' => 'Count',
    'Countries' => 'Countries',
    'Country' => 'Country',
    'Country code' => 'Country code',
    'Cover photo' => 'Cover photo',
    'Cover picture' => 'Cover picture',
    'Create Account' => 'Create Account',
    'Create an account' => 'Create an account',
    'Create event' => 'Create event',
    'Create my event' => 'Create my event',
    'Created by organizer' => 'Created by organizer',
    'Creation date' => 'Creation date',
    'Creation date / Last login' => 'Creation date / Last login',
    'Credit or debit card' => 'Credit or debit card',
    'Currency' => 'Currency',
    'Currency symbol' => 'Currency symbol',
    'Currency symbol position' => 'Currency symbol position',
    'Currently in cart' => 'Currently in cart',
    'Custom css' => 'Custom css',
    'Custom hero' => 'Custom hero',
    'Custom hero background image' => 'Custom hero background image',
    'Custom hero title and paragraph translation' => 'Custom hero title and paragraph translation',
    'Custom link' => 'Custom link',
    'Dark' => 'Dark',
    'Dark blue' => 'Dark blue',
    'Dashboard' => 'Dashboard',
    'Dashboard Pages' => 'Dashboard Pages',
    'Date' => 'Date',
    'Date and time format' => 'Date and time format',
    'Date only format' => 'Date only format',
    'Dates' => 'Dates',
    'Default language' => 'Default language',
    'Delete' => 'Delete',
    'Delete permanently' => 'Delete permanently',
    'Deleted' => 'Deleted',
    'Deletion date' => 'Deletion date',
    'Descripción' => 'Descripción',
    'Description' => 'Description',
    'Descrição' => 'Descrição',
    'Details' => 'Details',
    'Development' => 'Development',
    'Development environment is used for development purposes only' => 'Development environment is used for development purposes only',
    'Disable' => 'Disable',
    'Disabled' => 'Disabled',
    'Disabled only' => 'Disabled only',
    'Display itinerary bicycling' => 'Display itinerary bicycling',
    'Display itinerary driving' => 'Display itinerary driving',
    'Display itinerary on public transportation' => 'Display itinerary on public transportation',
    'Display itinerary walking' => 'Display itinerary walking',
    'Display top 4 featured categories (footer section menu only)' => 'Display top 4 featured categories (footer section menu only)',
    'Disqus comments' => 'Disqus comments',
    'Disqus subdomain' => 'Disqus subdomain',
    'Draft' => 'Draft',
    'Draft only' => 'Draft only',
    'Early bird, General admission, VIP...' => 'Early bird, General admission, VIP...',
    'Edit' => 'Edit',
    'Edit the menu' => 'Edit the menu',
    'Edit your organizer profile' => 'Edit your organizer profile',
    'Editing the title after the event is saved won\'t change the event url' => 'Editing the title after the event is saved won\'t change the event url',
    'Elapsed only' => 'Elapsed only',
    'Elements' => 'Elements',
    'Email' => 'Email',
    'Email address' => 'Email address',
    'Empty cart' => 'Empty cart',
    'En cabeza' => 'En cabeza',
    'En-tête' => 'En-tête',
    'Enable' => 'Enable',
    'Enable Facebook Social Login' => 'Enable Facebook Social Login',
    'Enable Google Repatcha' => 'Enable Google Repatcha',
    'Enable Google Social Login' => 'Enable Google Social Login',
    'Enable comments' => 'Enable comments',
    'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file' => 'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file',
    'Enable newsletter' => 'Enable newsletter',
    'Enable reviews' => 'Enable reviews',
    'Enable sales for this event date ?' => 'Enable sales for this event date ?',
    'Enable sales for this ticket ?' => 'Enable sales for this ticket ?',
    'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request' => 'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request',
    'Enabled' => 'Enabled',
    'Enabled only' => 'Enabled only',
    'Enabling sales for an event date does not affect the tickets individual sale status' => 'Enabling sales for an event date does not affect the tickets individual sale status',
    'Encryption' => 'Encryption',
    'End date' => 'End date',
    'Ends On' => 'Ends On',
    'Enlarge' => 'Enlarge',
    'Enter the chosen primary color code (i.e #ffffff)' => 'Enter the chosen primary color code (i.e #ffffff)',
    'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)' => 'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)',
    'Enter the email address to be reached for inquiries' => 'Enter the email address to be reached for inquiries',
    'Enter the full website url' => 'Enter the full website url',
    'Enter the list of artists that will perform in your event (press Enter after each entry)' => 'Enter the list of artists that will perform in your event (press Enter after each entry)',
    'Enter the phone number to be called for inquiries' => 'Enter the phone number to be called for inquiries',
    'Enter the website url without http nor https' => 'Enter the website url without http nor https',
    'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle',
    'Error' => 'Error',
    'Etiquetas' => 'Etiquetas',
    'Event' => 'Event',
    'Event / Ticket' => 'Event / Ticket',
    'Event Categories' => 'Event Categories',
    'Event already started' => 'Event already started',
    'Event categories' => 'Event categories',
    'Event date' => 'Event date',
    'Event date is disabled' => 'Event date is disabled',
    'Event date status' => 'Event date status',
    'Event dates' => 'Event dates',
    'Event details' => 'Event details',
    'Event is not published' => 'Event is not published',
    'Event list' => 'Event list',
    'Event ticket' => 'Event ticket',
    'Event ticket is disabled' => 'Event ticket is disabled',
    'Event ticket status' => 'Event ticket status',
    'Event tickets' => 'Event tickets',
    'Event views' => 'Event views',
    'Events' => 'Events',
    'Events Pages' => 'Events Pages',
    'Events RSS feed' => 'Events RSS feed',
    'Events added' => 'Events added',
    'Events count' => 'Events count',
    'Events in %countryname%' => 'Events in %countryname%',
    'Events list' => 'Events list',
    'Events list page' => 'Events list page',
    'Events list page settings' => 'Events list page settings',
    'Events on sale' => 'Events on sale',
    'Events page' => 'Events page',
    'Events slider' => 'Events slider',
    'Events summary' => 'Events summary',
    'Execute Symfony commands' => 'Execute Symfony commands',
    'Execute command' => 'Execute command',
    'Execute this command after editing a file in the application source code or after modifying a string in the translations files' => 'Execute this command after editing a file in the application source code or after modifying a string in the translations files',
    'Execute this command if you are in the development mode and the modifications you applied in the application did take effect' => 'Execute this command if you are in the development mode and the modifications you applied in the application did take effect',
    'Explore' => 'Explore',
    'Explore events' => 'Explore events',
    'Export attendees list to a PDF file' => 'Export attendees list to a PDF file',
    'Export current orders to a CSV file' => 'Export current orders to a CSV file',
    'Export current orders to an Excel file' => 'Export current orders to an Excel file',
    'External link' => 'External link',
    'FAQ' => 'FAQ',
    'Facebook' => 'Facebook',
    'Facebook Id' => 'Facebook Id',
    'Facebook Secret' => 'Facebook Secret',
    'Facebook app id' => 'Facebook app id',
    'Facebook comments' => 'Facebook comments',
    'Facebook profile picture' => 'Facebook profile picture',
    'Facebook url' => 'Facebook url',
    'Failed' => 'Failed',
    'Favicon' => 'Favicon',
    'Favorites' => 'Favorites',
    'Fax' => 'Fax',
    'Featured' => 'Featured',
    'Featured categories' => 'Featured categories',
    'Featured only' => 'Featured only',
    'Featured order' => 'Featured order',
    'Fees' => 'Fees',
    'Fees & Taxes' => 'Fees & Taxes',
    'First Name' => 'First Name',
    'First name' => 'First name',
    'Flag' => 'Flag',
    'Fluid' => 'Fluid',
    'Follow' => 'Follow',
    'Followed by' => 'Followed by',
    'Followers' => 'Followers',
    'Following' => 'Following',
    'Food and beverage' => 'Food and beverage',
    'Food and beverage details' => 'Food and beverage details',
    'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it' => 'For \'Cash / Check / Bank Transfer / Other\', the order will remain on the \'Awaiting payment\' status until the organizer or the administrator approves it',
    'Forbidden' => 'Forbidden',
    'Forgot your password ?' => 'Forgot your password ?',
    'Free' => 'Free',
    'Free events only' => 'Free events only',
    'From date' => 'From date',
    'Full name' => 'Full name',
    'GDPR compliance' => 'GDPR compliance',
    'Gallery' => 'Gallery',
    'Gallery image' => 'Gallery image',
    'Gdpr compliance page slug' => 'Gdpr compliance page slug',
    'Gender' => 'Gender',
    'General information' => 'General information',
    'Generation date' => 'Generation date',
    'Global payment settings' => 'Global payment settings',
    'Gmail' => 'Gmail',
    'Go back' => 'Go back',
    'Go to the Pages section in the settings to add a new page' => 'Go to the Pages section in the settings to add a new page',
    'Go to the documentation to get help about getting a list id' => 'Go to the documentation to get help about getting a list id',
    'Go to the documentation to get help about getting an api key' => 'Go to the documentation to get help about getting an api key',
    'Go to the documentation to get help about getting an app ID' => 'Go to the documentation to get help about getting an app ID',
    'Go to the documentation to get help about setting up Disqus' => 'Go to the documentation to get help about setting up Disqus',
    'Google Id' => 'Google Id',
    'Google Maps' => 'Google Maps',
    'Google Maps Api Key' => 'Google Maps Api Key',
    'Google Maps settings' => 'Google Maps settings',
    'Google Plus' => 'Google Plus',
    'Google Recaptcha' => 'Google Recaptcha',
    'Google Recaptcha settings' => 'Google Recaptcha settings',
    'Google Secret' => 'Google Secret',
    'Google analytics Tracking ID' => 'Google analytics Tracking ID',
    'Google analytics code' => 'Google analytics code',
    'Google plus' => 'Google plus',
    'Green' => 'Green',
    'Gross Sales' => 'Gross Sales',
    'Gross sales' => 'Gross sales',
    'Gross sales by channel' => 'Gross sales by channel',
    'Gross sales per Point of sale' => 'Gross sales per Point of sale',
    'Guests' => 'Guests',
    'Header' => 'Header',
    'Header text' => 'Header text',
    'Help Center Article' => 'Help Center Article',
    'Help Center Category' => 'Help Center Category',
    'Help Center Pages' => 'Help Center Pages',
    'Help Center page' => 'Help Center page',
    'Help center' => 'Help center',
    'Here are the details' => 'Here are the details',
    'Hey' => 'Hey',
    'Hidden' => 'Hidden',
    'Hidden only' => 'Hidden only',
    'Hide' => 'Hide',
    'Hide from public directory' => 'Hide from public directory',
    'Hide slider' => 'Hide slider',
    'Home' => 'Home',
    'Homepage' => 'Homepage',
    'Homepage content settings' => 'Homepage content settings',
    'Homepage hero settings' => 'Homepage hero settings',
    'Homepage settings' => 'Homepage settings',
    'Host' => 'Host',
    'How can we help?' => 'How can we help?',
    'How it works' => 'How it works',
    'Icon' => 'Icon',
    'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M' => 'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M',
    'If you need to send the confirmation email to a different email address, you can change it before submitting' => 'If you need to send the confirmation email to a different email address, you can change it before submitting',
    'If your event has a dedicated website, enter its url here' => 'If your event has a dedicated website, enter its url here',
    'If your event is a movie for example, select the available subtitles' => 'If your event is a movie for example, select the available subtitles',
    'If your event is a movie for example, select the year of release' => 'If your event is a movie for example, select the year of release',
    'Image' => 'Image',
    'Images' => 'Images',
    'Images gallery' => 'Images gallery',
    'Impersonate' => 'Impersonate',
    'In' => 'In',
    'In deinen Gedanken' => 'In deinen Gedanken',
    'Information not provided' => 'Information not provided',
    'Information provided' => 'Information provided',
    'Inhalt' => 'Inhalt',
    'Insert at least 3 characters' => 'Insert at least 3 characters',
    'Instagram' => 'Instagram',
    'Instagram url' => 'Instagram url',
    'Instrucciones' => 'Instrucciones',
    'Instructions' => 'Instructions',
    'Instruções' => 'Instruções',
    'Invalid credentials' => 'Invalid credentials',
    'Is featured' => 'Is featured',
    'Is featured on the homepage slider?' => 'Is featured on the homepage slider?',
    'Is this event date online ?' => 'Is this event date online ?',
    'Is this ticket free ?' => 'Is this ticket free ?',
    'It wasn\'t possible to retrieve information about the provided IP' => 'It wasn\'t possible to retrieve information about the provided IP',
    'Keyword' => 'Keyword',
    'Language' => 'Language',
    'Language code' => 'Language code',
    'Languages' => 'Languages',
    'Last Name' => 'Last Name',
    'Last login' => 'Last login',
    'Last name' => 'Last name',
    'Last updated' => 'Last updated',
    'Lastest blog posts' => 'Lastest blog posts',
    'Layout settings' => 'Layout settings',
    'Layout, parameters and SEO' => 'Layout, parameters and SEO',
    'Leave a review' => 'Leave a review',
    'Leave api key empty to disable google maps project wide' => 'Leave api key empty to disable google maps project wide',
    'Leave the password empty to keep the old one' => 'Leave the password empty to keep the old one',
    'Left' => 'Left',
    'Let the other attendee know more details about your experience' => 'Let the other attendee know more details about your experience',
    'Light blue' => 'Light blue',
    'Link' => 'Link',
    'Link Text' => 'Link Text',
    'Link text' => 'Link text',
    'LinkedIn' => 'LinkedIn',
    'Linkedin' => 'Linkedin',
    'List on public directory' => 'List on public directory',
    'Listed on directory' => 'Listed on directory',
    'Listed on the directory' => 'Listed on the directory',
    'Load more' => 'Load more',
    'Loading...' => 'Loading...',
    'Local events only' => 'Local events only',
    'Location' => 'Location',
    'Locked (Payout request approved)' => 'Locked (Payout request approved)',
    'Locked (Payout request pending)' => 'Locked (Payout request pending)',
    'Login' => 'Login',
    'Logo' => 'Logo',
    'Looking for' => 'Looking for',
    'Mail server' => 'Mail server',
    'Mail server settings' => 'Mail server settings',
    'Mail server test email' => 'Mail server test email',
    'Mailchimp app id' => 'Mailchimp app id',
    'Mailchimp list id' => 'Mailchimp list id',
    'Main blog post image' => 'Main blog post image',
    'Main categories' => 'Main categories',
    'Main event image' => 'Main event image',
    'Main image' => 'Main image',
    'Maintenance mode' => 'Maintenance mode',
    'Maintenance mode custom message' => 'Maintenance mode custom message',
    'Make sure that the added payment gateways are configured to support this currency' => 'Make sure that the added payment gateways are configured to support this currency',
    'Make sure that the currency setting of your payout method matches the one currently used which is %currency%' => 'Make sure that the currency setting of your payout method matches the one currently used which is %currency%',
    'Make sure to enter a valid email address' => 'Make sure to enter a valid email address',
    'Make sure to select organizers who have added a cover photo' => 'Make sure to select organizers who have added a cover photo',
    'Make sure to select right category to let the users find it quickly' => 'Make sure to select right category to let the users find it quickly',
    'Manage amenities' => 'Manage amenities',
    'Manage articles' => 'Manage articles',
    'Manage attendees' => 'Manage attendees',
    'Manage audiences' => 'Manage audiences',
    'Manage blog' => 'Manage blog',
    'Manage blog post categories' => 'Manage blog post categories',
    'Manage blog posts' => 'Manage blog posts',
    'Manage categories' => 'Manage categories',
    'Manage countries' => 'Manage countries',
    'Manage currencies' => 'Manage currencies',
    'Manage event' => 'Manage event',
    'Manage events' => 'Manage events',
    'Manage help center' => 'Manage help center',
    'Manage help center articles' => 'Manage help center articles',
    'Manage help center categories' => 'Manage help center categories',
    'Manage languages' => 'Manage languages',
    'Manage menus' => 'Manage menus',
    'Manage orders' => 'Manage orders',
    'Manage pages' => 'Manage pages',
    'Manage posts' => 'Manage posts',
    'Manage reviews' => 'Manage reviews',
    'Manage users' => 'Manage users',
    'Manage venues' => 'Manage venues',
    'Manage venues amenities' => 'Manage venues amenities',
    'Manage venues types' => 'Manage venues types',
    'Manage website translation' => 'Manage website translation',
    'Mark as featured' => 'Mark as featured',
    'Mark as not featured' => 'Mark as not featured',
    'Max' => 'Max',
    'Member since' => 'Member since',
    'Menu elements' => 'Menu elements',
    'Menu name' => 'Menu name',
    'Menus' => 'Menus',
    'Menus settings' => 'Menus settings',
    'Menüname' => 'Menüname',
    'Message' => 'Message',
    'Message from the attendee:' => 'Message from the attendee:',
    'Method Not Supported' => 'Method Not Supported',
    'Min' => 'Min',
    'More details' => 'More details',
    'More information' => 'More information',
    'Mots clés' => 'Mots clés',
    'My Account' => 'My Account',
    'My cart' => 'My cart',
    'My events' => 'My events',
    'My favorites' => 'My favorites',
    'My orders' => 'My orders',
    'My organizer profile' => 'My organizer profile',
    'My points of sale' => 'My points of sale',
    'My review' => 'My review',
    'My reviews' => 'My reviews',
    'My scanners' => 'My scanners',
    'My tickets' => 'My tickets',
    'My venues' => 'My venues',
    'N/A' => 'N/A',
    'Na sua mente' => 'Na sua mente',
    'Name' => 'Name',
    'Name / Username' => 'Name / Username',
    'Native comments' => 'Native comments',
    'Neighborhoods' => 'Neighborhoods',
    'Net sales' => 'Net sales',
    'Net sales until' => 'Net sales until',
    'New' => 'New',
    'New message regarding the order' => 'New message regarding the order',
    'New payout request' => 'New payout request',
    'New quote request' => 'New quote request',
    'Newsletter' => 'Newsletter',
    'Newsletter settings' => 'Newsletter settings',
    'Next month' => 'Next month',
    'Next week' => 'Next week',
    'No' => 'No',
    'No amenites found' => 'No amenites found',
    'No articles found' => 'No articles found',
    'No attendees found' => 'No attendees found',
    'No audiences found' => 'No audiences found',
    'No blog post categories found' => 'No blog post categories found',
    'No blog posts found' => 'No blog posts found',
    'No categories found' => 'No categories found',
    'No countries found' => 'No countries found',
    'No currencies found' => 'No currencies found',
    'No event dates found' => 'No event dates found',
    'No events found' => 'No events found',
    'No events on sale' => 'No events on sale',
    'No events on sale for now' => 'No events on sale for now',
    'No languages found' => 'No languages found',
    'No link, display featured categories dropdown on hover (header menu only)' => 'No link, display featured categories dropdown on hover (header menu only)',
    'No menus found' => 'No menus found',
    'No orders found' => 'No orders found',
    'No orders found to be included in the report' => 'No orders found to be included in the report',
    'No pages found' => 'No pages found',
    'No past events found' => 'No past events found',
    'No payment gateways are currently enabled' => 'No payment gateways are currently enabled',
    'No payment gateways found' => 'No payment gateways found',
    'No payout requests found' => 'No payout requests found',
    'No points of sale found' => 'No points of sale found',
    'No reply email address' => 'No reply email address',
    'No results found' => 'No results found',
    'No review found' => 'No review found',
    'No reviews found' => 'No reviews found',
    'No sales yet' => 'No sales yet',
    'No scanners found' => 'No scanners found',
    'No ticket on sale' => 'No ticket on sale',
    'No tickets found' => 'No tickets found',
    'No tickets selected to add to cart' => 'No tickets selected to add to cart',
    'No users found' => 'No users found',
    'No venue types found' => 'No venue types found',
    'No venues found' => 'No venues found',
    'Nom' => 'Nom',
    'Nom du menu' => 'Nom du menu',
    'Nombre' => 'Nombre',
    'Nombre du menú' => 'Nombre du menú',
    'Nome' => 'Nome',
    'Nome do menu' => 'Nome do menu',
    'None' => 'None',
    'Not Checked In Only' => 'Not Checked In Only',
    'Not a member yet ?' => 'Not a member yet ?',
    'Not elapsed only' => 'Not elapsed only',
    'Not featured' => 'Not featured',
    'Not listed on the directory' => 'Not listed on the directory',
    'Note' => 'Note',
    'Number of blog posts per page' => 'Number of blog posts per page',
    'Number of blog posts to show' => 'Number of blog posts to show',
    'Number of events per page' => 'Number of events per page',
    'Number of events to show' => 'Number of events to show',
    'Number of featured categories to show' => 'Number of featured categories to show',
    'Number of guests' => 'Number of guests',
    'Number of seconds before the reserved tickets are released if the order is still awaiting payment' => 'Number of seconds before the reserved tickets are released if the order is still awaiting payment',
    'Number of tickets' => 'Number of tickets',
    'OR' => 'OR',
    'On sale' => 'On sale',
    'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed' => 'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed',
    'Online' => 'Online',
    'Online events only' => 'Online events only',
    'Optional attendee information' => 'Optional attendee information',
    'Optionally add a cover photo to showcase your organizer activities' => 'Optionally add a cover photo to showcase your organizer activities',
    'Orange' => 'Orange',
    'Order' => 'Order',
    'Order =' => 'Order',
    'Order = ' => 'Order = ',
    'Order Date' => 'Order Date',
    'Order confirmation' => 'Order confirmation',
    'Order date' => 'Order date',
    'Order details' => 'Order details',
    'Order of appearance' => 'Order of appearance',
    'Order payment details' => 'Order payment details',
    'Order reference' => 'Order reference',
    'Order status' => 'Order status',
    'Order summary' => 'Order summary',
    'Order total' => 'Order total',
    'Orders' => 'Orders',
    'Orders placed' => 'Orders placed',
    'Orders summary' => 'Orders summary',
    'Organizer' => 'Organizer',
    'Organizer / Event / Date / Ticket' => 'Organizer / Event / Date / Ticket',
    'Organizer Profile' => 'Organizer Profile',
    'Organizer Registration' => 'Organizer Registration',
    'Organizer information' => 'Organizer information',
    'Organizer is disabled' => 'Organizer is disabled',
    'Organizer logo' => 'Organizer logo',
    'Organizer name' => 'Organizer name',
    'Organizer profile' => 'Organizer profile',
    'Organizer revenue from %website_name%' => 'Organizer revenue from %website_name%',
    'Organizers' => 'Organizers',
    'Organizers Pages' => 'Organizers Pages',
    'Organizers slider' => 'Organizers slider',
    'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry' => 'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry',
    'Other events by %organizername%' => 'Other events by %organizername%',
    'PERMANENTLY' => 'PERMANENTLY',
    'POS' => 'POS',
    'Page content' => 'Page content',
    'Page not found' => 'Page not found',
    'Pages' => 'Pages',
    'Paid' => 'Paid',
    'Paid orders' => 'Paid orders',
    'Palabras clave' => 'Palabras clave',
    'Palavras-chave' => 'Palavras-chave',
    'Paragraph' => 'Paragraph',
    'Paragraphe' => 'Paragraphe',
    'Parent' => 'Parent',
    'Parent category' => 'Parent category',
    'Parágrafo' => 'Parágrafo',
    'Password' => 'Password',
    'Password Resetting' => 'Password Resetting',
    'Past events' => 'Past events',
    'Past tickets' => 'Past tickets',
    'Pay now' => 'Pay now',
    'Payment' => 'Payment',
    'Payment details' => 'Payment details',
    'Payment gateways' => 'Payment gateways',
    'Payment method' => 'Payment method',
    'Payment of tickets purchased on %website_name%' => 'Payment of tickets purchased on %website_name%',
    'Payment settings' => 'Payment settings',
    'Payments and Fees' => 'Payments and Fees',
    'Payout already requested' => 'Payout already requested',
    'Payout method' => 'Payout method',
    'Payout methods' => 'Payout methods',
    'Payout request' => 'Payout request',
    'Payout request details' => 'Payout request details',
    'Payout request notification' => 'Payout request notification',
    'Payout request payment details' => 'Payout request payment details',
    'Payout requests' => 'Payout requests',
    'Payouts' => 'Payouts',
    'Paypal Client Id' => 'Paypal Client Id',
    'Paypal Client Secret' => 'Paypal Client Secret',
    'Paypal Express Checkout' => 'Paypal Express Checkout',
    'Pending' => 'Pending',
    'Pending payout requests' => 'Pending payout requests',
    'Percentage cut' => 'Percentage cut',
    'Phone' => 'Phone',
    'Phone number' => 'Phone number',
    'Photos' => 'Photos',
    'Pick a date' => 'Pick a date',
    'Pink' => 'Pink',
    'Please choose a 200x200 minimum image size as it is required by Facebook' => 'Please choose a 200x200 minimum image size as it is required by Facebook',
    'Please choose a 200x50 image size to ensure compatibility with the website design' => 'Please choose a 200x50 image size to ensure compatibility with the website design',
    'Please choose a 200x50 image to ensure compatibility with the website design' => 'Please choose a 200x50 image to ensure compatibility with the website design',
    'Please click on the following link to check the status of your request' => 'Please click on the following link to check the status of your request',
    'Please confirm your account by clicking the link below' => 'Please confirm your account by clicking the link below',
    'Please enter the selected payment gateway details' => 'Please enter the selected payment gateway details',
    'Please enter the subject carefully in order get the help you need' => 'Please enter the subject carefully in order get the help you need',
    'Please enter your payout method details' => 'Please enter your payout method details',
    'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle',
    'Please refer to this following list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217' => 'Please refer to thefollowing list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217',
    'Please select the tickets quantity for this order' => 'Please select the tickets quantity for this order',
    'Please select the tickets quantity you want to buy' => 'Please select the tickets quantity you want to buy',
    'Please set a payout method before submitting a payout request' => 'Please set a payout method before submitting a payout request',
    'Please wait a few seconds if the translation interface freezes at page load' => 'Please wait a few seconds if the translation interface freezes at page load',
    'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor' => 'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor',
    'Point of sale' => 'Point of sale',
    'Point of sale information' => 'Point of sale information',
    'Point of sales' => 'Point of sales',
    'Points of sale' => 'Points of sale',
    'Popular' => 'Popular',
    'Popularity' => 'Popularity',
    'Port' => 'Port',
    'Position' => 'Position',
    'Postal code' => 'Postal code',
    'Posts' => 'Posts',
    'Price' => 'Price',
    'Pricing' => 'Pricing',
    'Pricing and fees' => 'Pricing and fees',
    'Primary color code' => 'Primary color code',
    'Print tickets' => 'Print tickets',
    'Privacy policy' => 'Privacy policy',
    'Privacy policy page slug' => 'Privacy policy page slug',
    'Processed' => 'Processed',
    'Processed at' => 'Processed at',
    'Processing date' => 'Processing date',
    'Production' => 'Production',
    'Profile picture' => 'Profile picture',
    'Profile views' => 'Profile views',
    'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string' => 'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string',
    'Promotional price' => 'Promotional price',
    'Publicly show attendees' => 'Publicly show attendees',
    'Publish' => 'Publish',
    'Published events' => 'Published events',
    'Published only' => 'Published only',
    'Purple' => 'Purple',
    'Párrafo' => 'Párrafo',
    'Quantity' => 'Quantity',
    'Rating' => 'Rating',
    'Read more' => 'Read more',
    'Read time in minutes' => 'Read time in minutes',
    'Recent orders' => 'Recent orders',
    'Red' => 'Red',
    'Reference' => 'Reference',
    'Refund' => 'Refund',
    'Refund requested' => 'Refund requested',
    'Refunded' => 'Refunded',
    'Register' => 'Register',
    'Register attendees' => 'Register attendees',
    'Registered using Facebook' => 'Registered using Facebook',
    'Registered using Google' => 'Registered using Google',
    'Registration date' => 'Registration date',
    'Related posts' => 'Related posts',
    'Remove' => 'Remove',
    'Remove from favorites' => 'Remove from favorites',
    'Repeat password' => 'Repeat password',
    'Reports' => 'Reports',
    'Request a quote' => 'Request a quote',
    'Request date' => 'Request date',
    'Request payout' => 'Request payout',
    'Requested at' => 'Requested at',
    'Resend confirmation email' => 'Resend confirmation email',
    'Reset' => 'Reset',
    'Reset your password' => 'Reset your password',
    'Response' => 'Response',
    'Restore' => 'Restore',
    'Return to cart' => 'Return to cart',
    'Review date' => 'Review date',
    'Review(s)' => 'Review(s)',
    'Reviews' => 'Reviews',
    'Reviews for %eventname%' => 'Reviews for %eventname%',
    'Right' => 'Right',
    'Role' => 'Role',
    'SEO keywords' => 'SEO keywords',
    'SMTP' => 'SMTP',
    'SSL' => 'SSL',
    'SSL must be activated on your hosting server in order to use Mailchimp' => 'SSL must be activated on your hosting server in order to use Mailchimp',
    'Sale didn\'t start yet' => 'Sale didn\'t start yet',
    'Sale ended' => 'Sale ended',
    'Sale ends On' => 'Sale ends On',
    'Sale starts On' => 'Sale starts On',
    'Sales' => 'Sales',
    'Sales channel' => 'Sales channel',
    'Sales end' => 'Sales end',
    'Sales end date' => 'Sales end date',
    'Sales end in' => 'Sales end in',
    'Sales ended' => 'Sales ended',
    'Sales ended on' => 'Sales ended on',
    'Sales start date' => 'Sales start date',
    'Sales start in' => 'Sales start in',
    'Sales started' => 'Sales started',
    'Sales started on' => 'Sales started on',
    'Sandbox' => 'Sandbox',
    'Save' => 'Save',
    'Save order' => 'Save order',
    'Scanned tickets' => 'Scanned tickets',
    'Scanner' => 'Scanner',
    'Scanner App' => 'Scanner App',
    'Scanner App settings' => 'Scanner App settings',
    'Scanner information' => 'Scanner information',
    'Scanners' => 'Scanners',
    'Schlüsselwörter' => 'Schlüsselwörter',
    'Search' => 'Search',
    'Search blog' => 'Search blog',
    'Search blog posts' => 'Search blog posts',
    'Search for answers' => 'Search for answers',
    'Search for events' => 'Search for events',
    'Search help center' => 'Search help center',
    'Search in reviews' => 'Search in reviews',
    'Searching ...' => 'Searching ...',
    'Seated' => 'Seated',
    'Seated guests' => 'Seated guests',
    'Seated guests number' => 'Seated guests number',
    'Secret key' => 'Secret key',
    'See all' => 'See all',
    'See all %reviewscount% reviews' => 'See all %reviewscount% reviews',
    'See all categories' => 'See all categories',
    'See all events on sale' => 'See all events on sale',
    'See more articles' => 'See more articles',
    'See more events' => 'See more events',
    'Select a payout method' => 'Select a payout method',
    'Select a specific event date' => 'Select a specific event date',
    'Select a specific event ticket' => 'Select a specific event ticket',
    'Select an option' => 'Select an option',
    'Select parent of \'Point of sale\' or \'Scanner\'' => 'Select parent of \'Point of sale\' or \'Scanner\'',
    'Select the audience types that are targeted in your event' => 'Select the audience types that are targeted in your event',
    'Select the categories that represent your events types' => 'Select the categories that represent your events types',
    'Select the country that your event represents (ie: A movie\'s country of production)' => 'Select the country that your event represents (ie: A movie\'s country of production)',
    'Select the languages that will be spoken in your event' => 'Select the languages that will be spoken in your event',
    'Select the parent category to add a sub category' => 'Select the parent category to add a sub category',
    'Sell tickets online' => 'Sell tickets online',
    'Send' => 'Send',
    'Send us an email' => 'Send us an email',
    'Sendmail' => 'Sendmail',
    'Set' => 'Set',
    'Set a new password' => 'Set a new password',
    'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)' => 'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)',
    'Set the display order for the featured categories' => 'Set the display order for the featured categories',
    'Set the number of tickets that an attendee can buy for this ticket type' => 'Set the number of tickets that an attendee can buy for this ticket type',
    'Set the parent category to add a subcategory' => 'Set the parent category to add a subcategory',
    'Set your %payoutMethodName% payout method' => 'Set your %payoutMethodName% payout method',
    'Settings' => 'Settings',
    'Share' => 'Share',
    'Show' => 'Show',
    'Show RSS feed button' => 'Show RSS feed button',
    'Show a map at the bottom of your organizer profile page containing the venues you added' => 'Show a map at the bottom of your organizer profile page containing the venues you added',
    'Show audience filter' => 'Show audience filter',
    'Show calendar button' => 'Show calendar button',
    'Show category filter' => 'Show category filter',
    'Show date filter' => 'Show date filter',
    'Show event date stats on the scanner app' => 'Show event date stats on the scanner app',
    'Show event dates and tickets' => 'Show event dates and tickets',
    'Show events calendar' => 'Show events calendar',
    'Show events on map' => 'Show events on map',
    'Show followers' => 'Show followers',
    'Show location filter' => 'Show location filter',
    'Show map button' => 'Show map button',
    'Show reviews' => 'Show reviews',
    'Show the GDPR compliance page link' => 'Show the GDPR compliance page link',
    'Show the attendees number and list in the event page' => 'Show the attendees number and list in the event page',
    'Show the back to top button' => 'Show the back to top button',
    'Show the call to action block' => 'Show the call to action block',
    'Show the cookie policy bar at the bottom' => 'Show the cookie policy bar at the bottom',
    'Show the cookie policy page link' => 'Show the cookie policy page link',
    'Show the homepage hero seach box' => 'Show the homepage hero seach box',
    'Show the map along with the address on the venue page and event page' => 'Show the map along with the address on the venue page and event page',
    'Show the number and list of people that follow you' => 'Show the number and list of people that follow you',
    'Show the privacy policy page link' => 'Show the privacy policy page link',
    'Show the quote form on the venue page' => 'Show the quote form on the venue page',
    'Show the reviews that you received for your events' => 'Show the reviews that you received for your events',
    'Show the search box' => 'Show the search box',
    'Show the terms of service page link' => 'Show the terms of service page link',
    'Show ticket price filter' => 'Show ticket price filter',
    'Show tickets left count on cart modal' => 'Show tickets left count on cart modal',
    'Show venues map' => 'Show venues map',
    'Sign in' => 'Sign in',
    'Sign in via Facebook' => 'Sign in via Facebook',
    'Sign in via Google' => 'Sign in via Google',
    'Sign in via Twitter' => 'Sign in via Twitter',
    'Sign out' => 'Sign out',
    'Sign up' => 'Sign up',
    'Sign up via Facebook' => 'Sign up via Facebook',
    'Sign up via Google' => 'Sign up via Google',
    'Sign up via Twitter' => 'Sign up via Twitter',
    'Similar events' => 'Similar events',
    'Site key' => 'Site key',
    'Sitemap' => 'Sitemap',
    'Slug' => 'Slug',
    'Social Login' => 'Social Login',
    'Social Login settings' => 'Social Login settings',
    'Social media share image' => 'Social media share image',
    'Sold out' => 'Sold out',
    'Sort by' => 'Sort by',
    'Standing' => 'Standing',
    'Standing guests' => 'Standing guests',
    'Standing guests number' => 'Standing guests number',
    'Start date' => 'Start date',
    'Starts On' => 'Starts On',
    'State' => 'State',
    'State / City' => 'State / City',
    'Static Pages' => 'Static Pages',
    'Static pages settings' => 'Static pages settings',
    'Statistics' => 'Statistics',
    'Status' => 'Status',
    'Stick' => 'Stick',
    'Still in cart' => 'Still in cart',
    'Street' => 'Street',
    'Street 2' => 'Street 2',
    'Street address' => 'Street address',
    'Street address 2' => 'Street address 2',
    'Stripe Checkout' => 'Stripe Checkout',
    'Stripe Checkout (credit cards)' => 'Stripe Checkout (credit cards)',
    'Stripe payout' => 'Stripe payout',
    'Stripe publishable key' => 'Stripe publishable key',
    'Stripe secret key' => 'Stripe secret key',
    'Subject' => 'Subject',
    'Submit payment' => 'Submit payment',
    'Subscribe' => 'Subscribe',
    'Subscribe to our newsletter' => 'Subscribe to our newsletter',
    'Subtitles' => 'Subtitles',
    'Subtotal' => 'Subtotal',
    'Successfully executed the command' => 'Successfully executed the command',
    'Support for' => 'Support for',
    'Suspended' => 'Suspended',
    'Symbol' => 'Symbol',
    'TLS' => 'TLS',
    'TSL' => 'TSL',
    'Tags' => 'Tags',
    'Take your events to the next level' => 'Take your events to the next level',
    'Tell your attendees more about this ticket type' => 'Tell your attendees more about this ticket type',
    'Terms of service' => 'Terms of service',
    'Terms of service page slug' => 'Terms of service page slug',
    'Test the mail server configuration' => 'Test the mail server configuration',
    'Texte du lien' => 'Texte du lien',
    'Texto del enlace' => 'Texto del enlace',
    'Texto do link' => 'Texto do link',
    'The amenity can not be deleted because it is linked with one or more venues' => 'The amenity can not be deleted because it is linked with one or more venues',
    'The amenity can not be found' => 'The amenity can not be found',
    'The amenity has been deleted' => 'The amenity has been deleted',
    'The amenity has been disabled' => 'The amenity has been disabled',
    'The amenity has been succesfully restored' => 'The amenity has been succesfully restored',
    'The amenity has been successfully created' => 'The amenity has been successfully created',
    'The amenity has been successfully updated' => 'The amenity has been successfully updated',
    'The amenity is hidden' => 'The amenity is hidden',
    'The amenity is visible' => 'The amenity is visible',
    'The article can not be found' => 'The article can not be found',
    'The article has been deleted' => 'The article has been deleted',
    'The article has been disabled' => 'The article has been disabled',
    'The article has been succesfully restored' => 'The article has been succesfully restored',
    'The article has been successfully created' => 'The article has been successfully created',
    'The article has been successfully updated' => 'The article has been successfully updated',
    'The article is featured' => 'The article is featured',
    'The article is hidden' => 'The article is hidden',
    'The article is not featured anymore' => 'The article is not featured anymore',
    'The article is visible' => 'The article is visible',
    'The article not be found' => 'The article not be found',
    'The audience can not be deleted because it is linked with one or more events' => 'The audience can not be deleted because it is linked with one or more events',
    'The audience can not be found' => 'The audience can not be found',
    'The audience has been deleted' => 'The audience has been deleted',
    'The audience has been disabled' => 'The audience has been disabled',
    'The audience has been succesfully restored' => 'The audience has been succesfully restored',
    'The audience has been successfully created' => 'The audience has been successfully created',
    'The audience has been successfully updated' => 'The audience has been successfully updated',
    'The audience is hidden' => 'The audience is hidden',
    'The audience is visible' => 'The audience is visible',
    'The blog post can not be found' => 'The blog post can not be found',
    'The blog post category can not be deleted because it is linked with one or more blog posts' => 'The blog post category can not be deleted because it is linked with one or more blog posts',
    'The blog post category can not be found' => 'The blog post category can not be found',
    'The blog post category has been deleted' => 'The blog post category has been deleted',
    'The blog post category has been disabled' => 'The blog post category has been disabled',
    'The blog post category has been succesfully restored' => 'The blog post category has been succesfully restored',
    'The blog post category has been successfully created' => 'The blog post category has been successfully created',
    'The blog post category has been successfully updated' => 'The blog post category has been successfully updated',
    'The blog post category is hidden' => 'The blog post category is hidden',
    'The blog post category is visible' => 'The blog post category is visible',
    'The blog post has been deleted' => 'The blog post has been deleted',
    'The blog post has been disabled' => 'The blog post has been disabled',
    'The blog post has been succesfully restored' => 'The blog post has been succesfully restored',
    'The blog post has been successfully created' => 'The blog post has been successfully created',
    'The blog post has been successfully updated' => 'The blog post has been successfully updated',
    'The blog post is hidden' => 'The blog post is hidden',
    'The blog post is visible' => 'The blog post is visible',
    'The blog post not be found' => 'The blog post not be found',
    'The category can not be deleted because it is linked with one or more events' => 'The category can not be deleted because it is linked with one or more events',
    'The category can not be deleted because it is linked with one or more help center articles' => 'The category can not be deleted because it is linked with one or more help center articles',
    'The category can not be found' => 'The category can not be found',
    'The category has been deleted' => 'The category has been deleted',
    'The category has been disabled' => 'The category has been disabled',
    'The category has been succesfully restored' => 'The category has been succesfully restored',
    'The category has been successfully created' => 'The category has been successfully created',
    'The category has been successfully updated' => 'The category has been successfully updated',
    'The category is featured and is shown in the homepage categories' => 'The category is featured and is shown in the homepage categories',
    'The category is hidden' => 'The category is hidden',
    'The category is not featured anymore and is removed from the homepage categories' => 'The category is not featured anymore and is removed from the homepage categories',
    'The category is visible' => 'The category is visible',
    'The category not be found' => 'The category not be found',
    'The category was not found' => 'The category was not found',
    'The confirmation email has been resent to' => 'The confirmation email has been resent to',
    'The country can not be deleted because it is linked with one or more events' => 'The country can not be deleted because it is linked with one or more events',
    'The country can not be found' => 'The country can not be found',
    'The country has been deleted' => 'The country has been deleted',
    'The country has been disabled' => 'The country has been disabled',
    'The country has been succesfully restored' => 'The country has been succesfully restored',
    'The country has been successfully created' => 'The country has been successfully created',
    'The country has been successfully updated' => 'The country has been successfully updated',
    'The country is hidden' => 'The country is hidden',
    'The country is visible' => 'The country is visible',
    'The currency can not be found' => 'The currency can not be found',
    'The currency has been deleted' => 'The currency has been deleted',
    'The currency has been successfully created' => 'The currency has been successfully created',
    'The currency has been successfully updated' => 'The currency has been successfully updated',
    'The default locale must be selected in the available languages' => 'The default locale must be selected in the available languages',
    'The email address is not valid' => 'The email address is not valid',
    'The email could not be sent' => 'The email could not be sent',
    'The event can not be deleted because it has one or more orders' => 'The event can not be deleted because it has one or more orders',
    'The event can not be found' => 'The event can not be found',
    'The event date can not be found' => 'The event date can not be found',
    'The event date stats (sales and attendance) will be visible on the scanner app' => 'The event date stats (sales and attendance) will be visible on the scanner app',
    'The event has been added to your favorites' => 'The event has been added to your favorites',
    'The event has been deleted' => 'The event has been deleted',
    'The event has been deleted permanently' => 'The event has been deleted permanently',
    'The event has been published and will figure in the search results' => 'The event has been published and will figure in the search results',
    'The event has been removed from your favorites' => 'The event has been removed from your favorites',
    'The event has been succesfully restored' => 'The event has been succesfully restored',
    'The event has been successfully created' => 'The event has been successfully created',
    'The event has been successfully updated' => 'The event has been successfully updated',
    'The event has been unpublished and will not be included in the search results' => 'The event has been unpublished and will not be included in the search results',
    'The event not be found' => 'The event not be found',
    'The event ticket can not be found' => 'The event ticket can not be found',
    'The fields preceded with a red * are mandatory' => 'The fields preceded with a red * are mandatory',
    'The form contains invalid data' => 'The form contains invalid data',
    'The homepage settings can not be loaded' => 'The homepage settings can not be loaded',
    'The homepage settings could not be loaded' => 'The homepage settings could not be loaded',
    'The language can not be deleted because it is linked with one or more events' => 'The language can not be deleted because it is linked with one or more events',
    'The language can not be found' => 'The language can not be found',
    'The language has been deleted' => 'The language has been deleted',
    'The language has been disabled' => 'The language has been disabled',
    'The language has been succesfully restored' => 'The language has been succesfully restored',
    'The language has been successfully created' => 'The language has been successfully created',
    'The language has been successfully updated' => 'The language has been successfully updated',
    'The language is hidden' => 'The language is hidden',
    'The language is visible' => 'The language is visible',
    'The layout settings could not be loaded' => 'The layout settings could not be loaded',
    'The menu can not be found' => 'The menu can not be found',
    'The menu has been successfully updated' => 'The menu has been successfully updated',
    'The order can not be found' => 'The order can not be found',
    'The order has been deleted' => 'The order has been deleted',
    'The order has been permanently canceled' => 'The order has been permanently canceled',
    'The order has been permanently deleted' => 'The order has been permanently deleted',
    'The order has been soft deleted, restore it before canceling it' => 'The order has been soft deleted, restore it before canceling it',
    'The order has been succesfully restored' => 'The order has been succesfully restored',
    'The order has been successfully validated' => 'The order has been successfully validated',
    'The order status must be paid or awaiting payment' => 'The order status must be paid or awaiting payment',
    'The organizer can not be found' => 'The organizer can not be found',
    'The organizer not be found' => 'The organizer not be found',
    'The organizer revenue from this event date is currently zero' => 'The organizer revenue from this event date is currently zero',
    'The page can not be found' => 'The page can not be found',
    'The page has been deleted' => 'The page has been deleted',
    'The page has been successfully created' => 'The page has been successfully created',
    'The page has been successfully updated' => 'The page has been successfully updated',
    'The payment can not be found' => 'The payment can not be found',
    'The payment gateway can not be found' => 'The payment gateway can not be found',
    'The payment gateway has been successfully created' => 'The payment gateway has been successfully created',
    'The payment gateway has been successfully updated' => 'The payment gateway has been successfully updated',
    'The payout method can not be found' => 'The payout method can not be found',
    'The payout method has been successfully created' => 'The payout method has been successfully created',
    'The payout method has been successfully updated' => 'The payout method has been successfully updated',
    'The payout method is unset' => 'The payout method is unset',
    'The payout request can not be canceled because it is already processed' => 'The payout request can not be canceled because it is already processed',
    'The payout request can not be found' => 'The payout request can not be found',
    'The payout request can not be processed at this moment' => 'The payout request can not be processed at this moment',
    'The payout request has been already processed' => 'The payout request has been already processed',
    'The payout request has been deleted' => 'The payout request has been deleted',
    'The payout request has been permanently canceled' => 'The payout request has been permanently canceled',
    'The payout request has been permanently deleted' => 'The payout request has been permanently deleted',
    'The payout request has been soft deleted, restore it before canceling it' => 'The payout request has been soft deleted, restore it before canceling it',
    'The payout request has been soft deleted, restore it before viewing the details' => 'The payout request has been soft deleted, restore it before viewing the details',
    'The payout request has been succesfully restored' => 'The payout request has been succesfully restored',
    'The payout request has been successfully processed' => 'The payout request has been successfully processed',
    'The payout request has been successfully submitted, you will be notified by email once it is processed' => 'The payout request has been successfully submitted, you will be notified by email once it is processed',
    'The point of sale can not be found' => 'The point of sale can not be found',
    'The point of sale has been deleted' => 'The point of sale has been deleted',
    'The point of sale has been disabled' => 'The point of sale has been disabled',
    'The point of sale has been enabled' => 'The point of sale has been enabled',
    'The point of sale has been permenently deleted' => 'The point of sale has been permenently deleted',
    'The point of sale has been successfully created' => 'The point of sale has been successfully created',
    'The point of sale has been successfully updated' => 'The point of sale has been successfully updated',
    'The refund could not been processed at this moment' => 'The refund could not been processed at this moment',
    'The refund has already been reclined' => 'The refund has already been reclined',
    'The refund has been declined' => 'The refund has been declined',
    'The refund has been successfully processed' => 'The refund has been successfully processed',
    'The refund request has already been processed or no refund has been requested' => 'The refund request has already been processed or no refund has been requested',
    'The request method is known by the server but is not supported by the target resource' => 'The request method is known by the server but is not supported by the target resource',
    'The requested page couldn\'t be located. Checkout for any URL misspelling or' => 'The requested page couldn\'t be located. Checkout for any URL misspelling or',
    'The review can not be found' => 'The review can not be found',
    'The review has been deleted' => 'The review has been deleted',
    'The review has been deleted permanently' => 'The review has been deleted permanently',
    'The review has been enabled' => 'The review has been enabled',
    'The review has been hidden' => 'The review has been hidden',
    'The review has been succesfully restored' => 'The review has been succesfully restored',
    'The scanner account is disabled by the organizer' => 'The scanner account is disabled by the organizer',
    'The scanner can not be found' => 'The scanner can not be found',
    'The scanner has been disabled' => 'The scanner has been disabled',
    'The scanner has been enabled' => 'The scanner has been enabled',
    'The scanner has been permenently deleted' => 'The scanner has been permenently deleted',
    'The scanner has been successfully created' => 'The scanner has been successfully created',
    'The scanner has been successfully updated' => 'The scanner has been successfully updated',
    'The settings have been updated' => 'The settings have been updated',
    'The space' => 'The space',
    'The test email has been sent, please check the inbox of' => 'The test email has been sent, please check the inbox of',
    'The ticket can not be found' => 'The ticket can not be found',
    'The ticket has already been scanned' => 'The ticket has already been scanned',
    'The ticket has been successfully scanned' => 'The ticket has been successfully scanned',
    'The ticket is not valid for this event date' => 'The ticket is not valid for this event date',
    'The ticket was already scanned at' => 'The ticket was already scanned at',
    'The tickets has been successfully added to your cart' => 'The tickets has been successfully added to your cart',
    'The tickets have been released' => 'The tickets have been released',
    'The user can not be found' => 'The user can not be found',
    'The user cart has been emptied' => 'The user cart has been emptied',
    'The user has been deleted' => 'The user has been deleted',
    'The user has been disabled' => 'The user has been disabled',
    'The user has been enabled' => 'The user has been enabled',
    'The user has been permanently deleted' => 'The user has been permanently deleted',
    'The user has been succesfully restored' => 'The user has been succesfully restored',
    'The username already exists' => 'The username already exists',
    'The venue can not be deleted because it is linked with one or more events' => 'The venue can not be deleted because it is linked with one or more events',
    'The venue can not be found' => 'The venue can not be found',
    'The venue has been deleted' => 'The venue has been deleted',
    'The venue has been disabled' => 'The venue has been disabled',
    'The venue has been succesfully restored' => 'The venue has been succesfully restored',
    'The venue has been successfully created' => 'The venue has been successfully created',
    'The venue has been successfully updated' => 'The venue has been successfully updated',
    'The venue is hidden' => 'The venue is hidden',
    'The venue is hidden from the public venues directory' => 'The venue is hidden from the public venues directory',
    'The venue is listed on the public venues directory' => 'The venue is listed on the public venues directory',
    'The venue is visible' => 'The venue is visible',
    'The venue type can not be deleted because it is linked with one or more venues' => 'The venue type can not be deleted because it is linked with one or more venues',
    'The venue type can not be found' => 'The venue type can not be found',
    'The venue type has been deleted' => 'The venue type has been deleted',
    'The venue type has been disabled' => 'The venue type has been disabled',
    'The venue type has been succesfully restored' => 'The venue type has been succesfully restored',
    'The venue type has been successfully created' => 'The venue type has been successfully created',
    'The venue type has been successfully updated' => 'The venue type has been successfully updated',
    'The venue type is hidden' => 'The venue type is hidden',
    'The venue type is visible' => 'The venue type is visible',
    'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above' => 'This email address will be used as the sender of all the emails sent by the platform, in almost all cases, it is the same as the username above',
    'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form' => 'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form',
    'This email address will receive the contact form messages' => 'This email address will receive the contact form messages',
    'This email is sent as a confirmation of your order' => 'This email is sent as a confirmation of your order',
    'This email is sent to test the configuration of the mail server settings.' => 'This email is sent to test the configuration of the mail server settings.',
    'This event date is locked because a payout request has been submitted' => 'This event date is locked because a payout request has been submitted',
    'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)' => 'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)',
    'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders',
    'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations' => 'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations',
    'This link can only be used once to validate your account' => 'This link can only be used once to validate your account',
    'This month' => 'This month',
    'This order has already been refunded' => 'This order has already been refunded',
    'This order is not eligible for refund because it contains tickets from different organizers' => 'This order is not eligible for refund because it contains tickets from different organizers',
    'This order is not eligible for refund because it is not paid' => 'This order is not eligible for refund because it is not paid',
    'This payout method is currently disabled' => 'This payout method is currently disabled',
    'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders' => 'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders',
    'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders' => 'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders',
    'This ticket was scanned at %scanDate%' => 'This ticket was scanned at %scanDate%',
    'This week' => 'This week',
    'This weekend' => 'This weekend',
    'Ticket' => 'Ticket',
    'Ticket description' => 'Ticket description',
    'Ticket fee' => 'Ticket fee',
    'Ticket fee (Online)' => 'Ticket fee (Online)',
    'Ticket fee (Point Of Sale)' => 'Ticket fee (Point Of Sale)',
    'Ticket fees' => 'Ticket fees',
    'Ticket name' => 'Ticket name',
    'Ticket price' => 'Ticket price',
    'Ticket price percentage cut (Online)' => 'Ticket price percentage cut (Online)',
    'Ticket price percentage cut (Point of sale)' => 'Ticket price percentage cut (Point of sale)',
    'Ticket style' => 'Ticket style',
    'Ticket type' => 'Ticket type',
    'Tickets' => 'Tickets',
    'Tickets left' => 'Tickets left',
    'Tickets per attendee' => 'Tickets per attendee',
    'Tickets sales' => 'Tickets sales',
    'Tickets sales by date' => 'Tickets sales by date',
    'Tickets sales this month' => 'Tickets sales this month',
    'Tickets sold' => 'Tickets sold',
    'Tickets sold Per Point of sale' => 'Tickets sold Per Point of sale',
    'Tickets sold by channel' => 'Tickets sold by channel',
    'Tickets types' => 'Tickets types',
    'Time\'s up' => 'Time\'s up',
    'Timeleft' => 'Timeleft',
    'Timezone' => 'Timezone',
    'Titel' => 'Titel',
    'Title' => 'Title',
    'Titre' => 'Titre',
    'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)' => 'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)',
    'To reset your password, click on the following button and follow the instructions' => 'To reset your password, click on the following button and follow the instructions',
    'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event' => 'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event',
    'Today' => 'Today',
    'Toggle display the event date details' => 'Toggle display the event date details',
    'Toggle display the search filters' => 'Toggle display the search filters',
    'Tomorrow' => 'Tomorrow',
    'Total' => 'Total',
    'Total attendees' => 'Total attendees',
    'Total attendees check-in' => 'Total attendees check-in',
    'Total gross sales' => 'Total gross sales',
    'Total orders' => 'Total orders',
    'Total sales' => 'Total sales',
    'Total tickets sales' => 'Total tickets sales',
    'Translation' => 'Translation',
    'Translations' => 'Translations',
    'Transport' => 'Transport',
    'Twitter' => 'Twitter',
    'Twitter url' => 'Twitter url',
    'Type' => 'Type',
    'Título' => 'Título',
    'Unfollow' => 'Unfollow',
    'Unknown' => 'Unknown',
    'Unstick' => 'Unstick',
    'Until date' => 'Until date',
    'Upcoming events' => 'Upcoming events',
    'Upcoming tickets' => 'Upcoming tickets',
    'Update cart' => 'Update cart',
    'Update date' => 'Update date',
    'Update the amenity' => 'Update the amenity',
    'Update the audience' => 'Update the audience',
    'Update the blog post' => 'Update the blog post',
    'Update the blog post category' => 'Update the blog post category',
    'Update the category' => 'Update the category',
    'Update the country' => 'Update the country',
    'Update the currency' => 'Update the currency',
    'Update the event' => 'Update the event',
    'Update the help center article' => 'Update the help center article',
    'Update the help center category' => 'Update the help center category',
    'Update the language' => 'Update the language',
    'Update the lapagenguage' => 'Update the page',
    'Update the payment gateway' => 'Update the payment gateway',
    'Update the point of sale' => 'Update the point of sale',
    'Update the scanner' => 'Update the scanner',
    'Update the venue' => 'Update the venue',
    'Update the venue type' => 'Update the venue type',
    'Update your %payoutMethodName% payout method' => 'Update your %payoutMethodName% payout method',
    'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string' => 'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string',
    'Useful Links' => 'Useful Links',
    'User information' => 'User information',
    'Username' => 'Username',
    'Users' => 'Users',
    'Users summary' => 'Users summary',
    'Uset' => 'Uset',
    'Validate' => 'Validate',
    'Venue' => 'Venue',
    'Venue / Location' => 'Venue / Location',
    'Venue image' => 'Venue image',
    'Venue name...' => 'Venue name...',
    'Venue page' => 'Venue page',
    'Venue page settings' => 'Venue page settings',
    'Venue type' => 'Venue type',
    'Venue types' => 'Venue types',
    'Venues' => 'Venues',
    'Venues Pages' => 'Venues Pages',
    'Venues count' => 'Venues count',
    'Venues page' => 'Venues page',
    'Video' => 'Video',
    'View cart' => 'View cart',
    'View detailed statistics' => 'View detailed statistics',
    'View details' => 'View details',
    'View event' => 'View event',
    'View organizer' => 'View organizer',
    'View stats' => 'View stats',
    'Views' => 'Views',
    'Visible' => 'Visible',
    'Visible only' => 'Visible only',
    'We recommend a 48x48 image' => 'We recommend a 48x48 image',
    'We recommend a 48x48 image size' => 'We recommend a 48x48 image size',
    'We will be back shortly.' => 'We will be back shortly.',
    'Website' => 'Website',
    'Website description' => 'Website description',
    'Website name' => 'Website name',
    'Website root url' => 'Website root url',
    'Website slug' => 'Website slug',
    'Website url' => 'Website url',
    'Welcome' => 'Welcome',
    'What to show in the homepage hero ?' => 'What to show in the homepage hero ?',
    'When' => 'When',
    'Where' => 'Where',
    'Will be show in the homepage, the explore menu item dropdown and in the footer' => 'Will be show in the homepage, the explore menu item dropdown and in the footer',
    'With sales only' => 'With sales only',
    'Without sales only' => 'Without sales only',
    'Year' => 'Year',
    'Yellow' => 'Yellow',
    'Yes' => 'Yes',
    'You are about to approve the payout request' => 'You are about to approve the payout request',
    'You are about to cancel this order (this action cannot be undone)' => 'You are about to cancel this order (this action cannot be undone)',
    'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked' => 'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked',
    'You are about to delete the amenity PERMANENTLY' => 'You are about to delete the amenity PERMANENTLY',
    'You are about to delete the article PERMANENTLY' => 'You are about to delete the article PERMANENTLY',
    'You are about to delete the audience PERMANENTLY' => 'You are about to delete the audience PERMANENTLY',
    'You are about to delete the blog post PERMANENTLY' => 'You are about to delete the blog post PERMANENTLY',
    'You are about to delete the blog post category PERMANENTLY' => 'You are about to delete the blog post category PERMANENTLY',
    'You are about to delete the category PERMANENTLY' => 'You are about to delete the category PERMANENTLY',
    'You are about to delete the country PERMANENTLY' => 'You are about to delete the country PERMANENTLY',
    'You are about to delete the currency PERMANENTLY' => 'You are about to delete the currency PERMANENTLY',
    'You are about to delete the event and all its related information PERMANENTLY' => 'You are about to delete the event and all its related information PERMANENTLY',
    'You are about to delete the language PERMANENTLY' => 'You are about to delete the language PERMANENTLY',
    'You are about to delete the order and all its related information (payment details, tickets...)' => 'You are about to delete the order and all its related information (payment details, tickets...)',
    'You are about to delete the page PERMANENTLY' => 'You are about to delete the page PERMANENTLY',
    'You are about to delete the payout request and all its related information' => 'You are about to delete the payout request and all its related information',
    'You are about to delete the point of sale' => 'You are about to delete the point of sale',
    'You are about to delete the point of sale PERMANENTLY' => 'You are about to delete the point of sale PERMANENTLY',
    'You are about to delete the review PERMANENTLY' => 'You are about to delete the review PERMANENTLY',
    'You are about to delete the scanner' => 'You are about to delete the scanner',
    'You are about to delete the scanner PERMANENTLY' => 'You are about to delete the scanner PERMANENTLY',
    'You are about to delete the user and all its related information (orders, events...) PERMANENTLY' => 'You are about to delete the user and all its related information (orders, events...) PERMANENTLY',
    'You are about to delete the venue PERMANENTLY' => 'You are about to delete the venue PERMANENTLY',
    'You are about to delete the venue type PERMANENTLY' => 'You are about to delete the venue type PERMANENTLY',
    'You are about to empty your cart' => 'You are about to empty your cart',
    'You are about to validate this order, generate the tickets and send a confirmation email to the attendee' => 'You are about to validate this order, generate the tickets and send a confirmation email to the attendee',
    'You are connected as "%username%' => 'You are connected as "%username%',
    'You are following this organizer' => 'You are following this organizer',
    'You are going to this event' => 'You are going to this event',
    'You are logged in as:' => 'You are logged in as:',
    'You are no longer following this organizer' => 'You are no longer following this organizer',
    'You are not following any organizer' => 'You are not following any organizer',
    'You can introduce the event details in multiple locales' => 'You can introduce the event details in multiple locales',
    'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help' => 'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help',
    'You don\'t have permission to access this resource' => 'You don\'t have permission to access this resource',
    'You have added %tickets% ticket(s) to your cart' => 'You have added %tickets% ticket(s) to your cart',
    'You have already bought %tickets% ticket(s)' => 'You have already bought %tickets% ticket(s)',
    'You have already requested a refund for this order' => 'You have already requested a refund for this order',
    'You have already requested a refund for this order and it was approved' => 'You have already requested a refund for this order and it was approved',
    'You have already requested a refund for this order and it was declined' => 'You have already requested a refund for this order and it was declined',
    'You have received a new quote request for the venue' => 'You have received a new quote request for the venue',
    'You have successfully subscribed to our newsletter' => 'You have successfully subscribed to our newsletter',
    'You must choose an event and set the status to paid in order to export attendees list to a PDF file' => 'You must choose an event and set the status to paid in order to export attendees list to a PDF file',
    'You must choose an event in order to export the attendees list' => 'You must choose an event in order to export the attendees list',
    'You must review your cart before proceeding to checkout' => 'You must review your cart before proceeding to checkout',
    'You must set the status to paid in order to export the attendees list' => 'You must set the status to paid in order to export the attendees list',
    'You must specify at least one language' => 'You must specify at least one language',
    'You order is empty' => 'You order is empty',
    'Your account settings have been updated' => 'Your account settings have been updated',
    'Your cart has been automatically updated because one or more event\'s quotas has changed' => 'Your cart has been automatically updated because one or more event\'s quotas has changed',
    'Your cart has been automatically updated because one or more events are no longer on sale' => 'Your cart has been automatically updated because one or more events are no longer on sale',
    'Your cart has been emptied' => 'Your cart has been emptied',
    'Your cart has been updated' => 'Your cart has been updated',
    'Your cart is empty' => 'Your cart is empty',
    'Your email' => 'Your email',
    'Your message has been successfully sent' => 'Your message has been successfully sent',
    'Your order has been automatically canceled because one or more event\'s quotas has changed' => 'Your order has been automatically canceled because one or more event\'s quotas has changed',
    'Your order has been automatically canceled because one or more events are no longer on sale' => 'Your order has been automatically canceled because one or more events are no longer on sale',
    'Your order has been automatically canceled because your ticket reservations has been released' => 'Your order has been automatically canceled because your ticket reservations has been released',
    'Your order has been successfully placed, please proceed to the payment as explained in the instructions' => 'Your order has been successfully placed, please proceed to the payment as explained in the instructions',
    'Your organizer profile has been successfully updated' => 'Your organizer profile has been successfully updated',
    'Your payment could not be processed at this time' => 'Your payment could not be processed at this time',
    'Your payment has been successfully processed' => 'Your payment has been successfully processed',
    'Your payment operation was canceled' => 'Your payment operation was canceled',
    'Your payout request has been processed' => 'Your payout request has been processed',
    'Your quote request has been successfully sent' => 'Your quote request has been successfully sent',
    'Your rating (out of 5 stars)' => 'Your rating (out of 5 stars)',
    'Your refund request has been successfully submitted to the organizer' => 'Your refund request has been successfully submitted to the organizer',
    'Your registration has been successfully processed' => 'Your registration has been successfully processed',
    'Your review has been successfully saved' => 'Your review has been successfully saved',
    'Your review headline' => 'Your review headline',
    'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away' => 'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away',
    'Your tickets bought from' => 'Your tickets bought from',
    'Youtube' => 'Youtube',
    'Youtube url' => 'Youtube url',
    'Youtube video' => 'Youtube video',
    'Youtube video url' => 'Youtube video url',
    'Zip / Postal code' => 'Zip / Postal code',
    'and' => 'and',
    'asc' => 'asc',
    'at' => 'at',
    'checked In' => 'checked In',
    'created at' => 'created at',
    'desc' => 'desc',
    'event to the next level ?' => 'event to the next level ?',
    'for' => 'for',
    'form.label.delete' => 'Delete',
    'form.password' => 'form.password',
    'form.password_confirmation' => 'form.password_confirmation',
    'image(s)' => 'image(s)',
    'left' => 'left',
    'left before tickets are released' => 'left before tickets are released',
    'min read' => 'min read',
    'my points of sale' => 'my points of sale',
    'my scanners' => 'my scanners',
    'my venues' => 'my venues',
    'orders summary' => 'orders summary',
    'out of 5 stars' => 'out of 5 stars',
    'placed on' => 'placed on',
    'return to the homepage' => 'return to the homepage',
    'review' => 'review',
    'right' => 'right',
    'ticket' => 'ticket',
    'ticket(s)' => 'ticket(s)',
    'ticket(s) sold' => 'ticket(s) sold',
    'tickets' => 'tickets',
    'tickets found in your cart' => 'tickets found in your cart',
    'tickets left' => 'tickets left',
    'tickets per attendee' => 'tickets per attendee',
    'title' => 'title',
    'to edit your profile' => 'to edit your profile',
    'to manage this event' => 'to manage this event',
    'to manage your event' => 'to manage your event',
    'to preview your profile' => 'to preview your profile',
    'to return to your dashboard' => 'to return to your dashboard',
    'user(s)' => 'user(s)',
    'view(s)' => 'view(s)',
    'views' => 'views',
    'your payout request has been processed' => 'your payout request has been processed',
    'your tickets are ready to go!' => 'your tickets are ready to go!',
    'اسم' => 'اسم',
    'اسم القائمة' => 'اسم القائمة',
    'التفاصيل' => 'التفاصيل',
    'العلامات' => 'العلامات',
    'الكلمات الرئيسية' => 'الكلمات الرئيسية',
    'تعليمات' => 'تعليمات',
    'عنوان' => 'عنوان',
    'فقرة' => 'فقرة',
    'محتوى' => 'محتوى',
    'نص الرابط' => 'نص الرابط',
    'نص العنوان' => 'نص العنوان',
    '关键字' => '关键字',
    '内容' => '内容',
    '名称' => '名称',
    '描述' => '描述',
    '标签' => '标签',
    '标题' => '标题',
    '段' => '段',
  ),
  'javascript' => 
  array (
    'Add' => 'Add',
    'Add a new event date' => 'Add a new event date',
    'Add a new ticket' => 'Add a new ticket',
    'An error has occured' => 'An error has occured',
    'April' => 'April',
    'August' => 'August',
    'Cancel' => 'Cancel',
    'Close' => 'Close',
    'Confirm' => 'Confirm',
    'Confirmation required' => 'Confirmation required',
    'Day' => 'Day',
    'December' => 'December',
    'Duplicate this event date' => 'Duplicate this event date',
    'Duplicate this ticket' => 'Duplicate this ticket',
    'Email address' => 'Email address',
    'February' => 'February',
    'Insert at least 3 characters' => 'Insert at least 3 characters',
    'January' => 'January',
    'July' => 'July',
    'June' => 'June',
    'Load more' => 'Load more',
    'Loading...' => 'Loading...',
    'Mail server test email' => 'Mail server test email',
    'Make sure to enter a valid email address' => 'Make sure to enter a valid email address',
    'March' => 'March',
    'May' => 'May',
    'Message' => 'Message',
    'Month' => 'Month',
    'Move down' => 'Move down',
    'Move up' => 'Move up',
    'No results found' => 'No results found',
    'Note' => 'Note',
    'November' => 'November',
    'October' => 'October',
    'Please select the tickets quantity for this order' => 'Please select the tickets quantity for this order',
    'Please select the tickets quantity you want to buy' => 'Please select the tickets quantity you want to buy',
    'Read more' => 'Read more',
    'Remove' => 'Remove',
    'Remove this event date' => 'Remove this event date',
    'Remove this ticket' => 'Remove this ticket',
    'Return to cart' => 'Return to cart',
    'Searching ...' => 'Searching ...',
    'Select an option' => 'Select an option',
    'Send' => 'Send',
    'September' => 'September',
    'Stick' => 'Stick',
    'The email address is not valid' => 'The email address is not valid',
    'The tickets have been released' => 'The tickets have been released',
    'This feature is disabled in demo mode' => 'This feature is disabled in demo mode',
    'Time\'s up' => 'Time\'s up',
    'Today' => 'Today',
    'Unstick' => 'Unstick',
    'Week' => 'Week',
    'days' => 'days',
    'days.Fri' => 'Fri',
    'days.Mon' => 'Mon',
    'days.Sat' => 'Sat',
    'days.Sun' => 'Sun',
    'days.Thu' => 'Thu',
    'days.Tue' => 'Tue',
    'days.Wed' => 'Wed',
    'hr' => 'hr',
    'javascript string translation' => 'javascript string translation',
    'min' => 'min',
    'sec' => 'sec',
    'weeks' => 'weeks',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
