<?php

namespace Welp\MailchimpBundle\Exception;

/**
 * Handle MailChimp API errors
 */
class MailchimpException extends \Exception
{
    /**
     * The HTTP status code (RFC2616, Section 6) generated by the origin server
     * for this occurrence of the problem.
     * @var int
     */
    private $status;

    /**
     * A human-readable explanation specific to this occurrence of the problem.
     * @var string
     */
    private $detail;

    /**
     * An absolute URI that identifies the problem type. When dereferenced,
     * it should provide human-readable documentation for the problem type.
     * @var string
     */
    private $type;

    /**
     * A short, human-readable summary of the problem type.
     * It shouldn’t change based on the occurrence of the problem,
     * except for purposes of localization.
     * @var string
     */
    private $title;

    /**
     * For field-specific details, see the 'errors' array.
     * @var array
     */
    private $errors;

    /**
     * A string that identifies this specific occurrence of the problem.
     * Please provide this ID when contacting support.
     * @var string
     */
    private $instance;

    /**
     * http://developer.mailchimp.com/documentation/mailchimp/guides/get-started-with-mailchimp-api-3/#errors
     * @param int    $status
     * @param string $detail
     * @param string $type
     * @param string $title
     * @param array  $errors
     * @param string $instance
     * @param \Throwable $previous
     */
    public function __construct($status=0, $detail, $type, $title, $errors=null, $instance=null, \Throwable $previous=null)
    {
        parent::__construct($detail, $status, $previous);

        $this->status = $status;
        $this->detail = $detail;
        $this->type = $type;
        $this->title = $title;
        $this->errors = $errors;
        $this->instance = $instance;
    }

    /**
     * @param string $type
     *
     * @return static
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @param string $title
     *
     * @return static
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @param array $errors
     *
     * @return static
     */
    public function setErrors(array $errors)
    {
        $this->errors = $errors;
        return $this;
    }

    /**
     * @param string $instance
     *
     * @return static
     */
    public function setInstance($instance)
    {
        $this->instance = $instance;
        return $this;
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getDetail()
    {
        return $this->detail;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getInstance()
    {
        return $this->instance;
    }

    /**
     * @return
     */
    public function getString()
    {
        return $this->string;
    }

    /**
     * @return array
     */
    public function getErrors()
    {
        return $this->errors;
    }
}
